/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.treeview.TVEntryPoint;
import merlin.treeview.Util;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class guiUtil
extends thunderheadeng.gui.guiUtil {
    public static final int ICON_HEIGHT = 16;
    private static final ErrorIconSet s_warningIcon = new ErrorIconSet("warn16.gif", "warn8.gif");
    private static final ErrorIconSet s_errorIcon = new ErrorIconSet("error16.gif", "error8.gif");

    public static guiFileChooser getChooser(TypedProp<String> lastDirPref, Optional<String> defaultFileName, String ... filters) {
        return guiUtil.getChooser(lastDirPref, defaultFileName, true, filters);
    }

    public static guiFileChooser getChooser(TypedProp<String> lastDirPref, Optional<String> defaultFileName, boolean open, String ... filters) {
        assert (filters.length % 2 == 0);
        ArrayList<ExampleFileFilter> fileFilters = new ArrayList<ExampleFileFilter>();
        if (open && filters.length > 2) {
            String[] extensions = new String[filters.length / 2];
            for (int m = 0; m < filters.length; m += 2) {
                extensions[m / 2] = filters[m];
            }
            ExampleFileFilter allTypesFilter = new ExampleFileFilter(extensions, Intl.intl("All Supported Types"));
            fileFilters.add(allTypesFilter);
        }
        for (int m = 0; m < filters.length; m += 2) {
            ExampleFileFilter filter = new ExampleFileFilter(filters[m], filters[m + 1]);
            fileFilters.add(filter);
        }
        return guiUtil.getChooser(lastDirPref, defaultFileName, theUtil.toArray(fileFilters, FileFilter.class));
    }

    public static guiFileChooser getChooser(TypedProp<String> lastDirPref, Optional<String> defaultFileName, FileFilter ... filters) {
        guiFileChooser chooser = MerlinApp.getApp().getFileChooser();
        for (FileFilter filter : filters) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(filters.length > 0 ? filters[0] : null);
        String oldDir = MerlinPrefs.get(lastDirPref);
        if (oldDir != null) {
            File dir = new File(oldDir);
            if (dir.exists()) {
                chooser.setCurrentDirectory(dir);
            }
            if (defaultFileName.isPresent()) {
                File f = new File(defaultFileName.get());
                if (f.isDirectory()) {
                    chooser.setCurrentDirectory(f);
                } else {
                    chooser.setSelectedFile(f);
                }
            }
        }
        return chooser;
    }

    public static File getOpenFile(Component parent, MerlinData md, TypedProp<String> lastDirPref, String ... filters) {
        return guiUtil.getOpenFile(parent, md, Optional.empty(), lastDirPref, filters);
    }

    public static File getOpenFile(MerlinApp app, MerlinData md, TypedProp<String> lastDirPref, String ... filters) {
        return guiUtil.getOpenFile((Component)app.getActiveFrame(), md, lastDirPref, filters);
    }

    public static File getOpenFile(Component parent, MerlinData md, Optional<String> defFilename, TypedProp<String> lastDirPref, String ... filters) {
        return md.ui(() -> guiUtil.getOpenFile(parent, defFilename, lastDirPref, filters));
    }

    public static File getOpenFile(MerlinApp app, MerlinData md, Optional<String> defFilename, TypedProp<String> lastDirPref, String ... filters) {
        return guiUtil.getOpenFile((Component)app.getActiveFrame(), md, defFilename, lastDirPref, filters);
    }

    public static File getOpenFile(Component parent, TypedProp<String> lastDirPref, String ... filters) {
        return guiUtil.getOpenFile(parent, Optional.empty(), lastDirPref, filters);
    }

    public static File getOpenFile(Component parent, Optional<String> defFilename, TypedProp<String> lastDirPref, String ... filters) {
        assert (EventQueue.isDispatchThread());
        guiFileChooser chooser = guiUtil.getChooser(lastDirPref, defFilename, filters);
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        MerlinPrefs.set(lastDirPref, chooser.getSelectedFile().getParentFile().getAbsolutePath());
        return chooser.getSelectedFile();
    }

    public static File getSaveFile(MerlinApp app, MerlinData md, TypedProp<String> lastDirPref, String defaultFileName, String ... filters) {
        return md.ui(() -> {
            guiFileChooser chooser = guiUtil.getChooser(lastDirPref, Optional.ofNullable(defaultFileName), filters);
            if (chooser.showSaveDialog(app.getActiveFrame()) != 0) {
                return null;
            }
            MerlinPrefs.set(lastDirPref, chooser.getSelectedFile().getParentFile().getAbsolutePath());
            return chooser.getSelectedFile();
        });
    }

    public static String getFileNameNoExt(String filename) {
        int extix = filename.lastIndexOf(46);
        if (extix < 0) {
            return filename;
        }
        return filename.substring(0, extix);
    }

    public static ImageIcon loadMerlinIcon(String name) {
        return guiUtil.loadMerlinIcon(name, -1);
    }

    public static ImageIcon loadMerlinIcon(String name, int maxDimension) {
        return guiUtil.loadIcon("merlin/icons/" + name, maxDimension);
    }

    public static Cursor createMerlinCursor(String key, String filename, int hotspotx, int hotspoty) {
        return guiUtil.createCursor(key, "merlin/icons/" + filename, hotspotx, hotspoty);
    }

    public static void addSelectableMenuItem(JMenu menu, SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.addItemListener(action);
        menu.add(item);
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction action) {
        JToggleButton button = new JToggleButton(action);
        guiUtil.initToolbarBtn(action, button);
        button.addItemListener(action);
        return button;
    }

    public static JButton createToolbarButton(Action action) {
        JButton btn = new JButton(action);
        guiUtil.initToolbarBtn(action, btn);
        return btn;
    }

    private static void initToolbarBtn(Action action, AbstractButton btn) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            btn.setText("");
            String ttt = (String)action.getValue("ShortDescription");
            if (ttt == null || ttt.trim().equals("")) {
                btn.setToolTipText((String)action.getValue("Name"));
            }
        }
    }

    public static void addMEMenuItems(JMenu menu, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            SelectableAction action = actions[m];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.addItemListener(action);
            menu.add(item);
            group.add(item);
        }
    }

    public static void addMEToolbarItems(JToolBar tb, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            JToggleButton item = guiUtil.createToolbarToggleButton(actions[m]);
            tb.add(item);
            group.add(item);
        }
    }

    public static Icon createDisabledIcon(Icon i, Component c) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)i).getImage()));
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        i.paintIcon(c, g, 0, 0);
        g.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bi));
    }

    public static Icon[] decorateIcons(MerlinData md, TVEntryPoint<Object> tvep, Runnable redecorate, Component comp, IMerlinObj obj, Collection<? extends SimError> errors) {
        Icon[] baseIcons = tvep.getIcons(md, comp, obj, redecorate);
        if (errors.isEmpty()) {
            return baseIcons;
        }
        ErrorIconSet icons = guiUtil.chooseErrorIcons(errors);
        return new Icon[]{baseIcons[0] != null ? new DecoratedIcon(baseIcons[0], icons.decorator, 3) : icons.icon, baseIcons[1] != null ? new DecoratedIcon(baseIcons[1], icons.decorator, 3) : icons.icon};
    }

    private static ErrorIconSet chooseErrorIcons(Collection<? extends SimError> errors) {
        SimError.Level maxLevel = SimError.Level.MODERATE;
        for (SimError simError : errors) {
            if (simError.level.severity <= maxLevel.severity) continue;
            maxLevel = simError.level;
        }
        return maxLevel == SimError.Level.MODERATE ? s_warningIcon : s_errorIcon;
    }

    public static boolean decorateComboRenderer(MerlinData data, JComboBox<?> cb, JList<?> list, Object value, JLabel c, boolean isSelected, boolean cellHasFocus) {
        Runnable redecorate = () -> {
            cb.repaint();
            list.repaint();
        };
        return guiUtil.decorateCellRenderer(data, redecorate, value, c, isSelected, cellHasFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decorateCellRenderer(MerlinData data, Runnable redecorate, Object value, JLabel c, boolean isSelected, boolean cellHasFocus) {
        data.beginRead();
        try {
            if (value instanceof IMerlinObj) {
                TVEntryPoint<Object> ep = Util.getEP(value);
                IMerlinObj obj = (IMerlinObj)value;
                c.setText(ep.getName(data, obj));
                c.setFont(ep.getFont(data, obj));
                c.setEnabled(ep.isVisible(data, obj));
                Collection<SimError> errors = ep.getErrors(data, obj);
                Icon[] decorators = guiUtil.decorateIcons(data, ep, redecorate, c, obj, errors);
                c.setIcon(decorators[0]);
                c.setDisabledIcon(decorators[1]);
                c.setToolTipText(guiUtil.formatErrors(errors));
                c.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            data.endRead();
        }
    }

    private static String formatErrors(Collection<? extends SimError> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        String msg = "";
        for (SimError simError : errors) {
            if (simError.cause.isEmpty()) continue;
            if (!msg.isEmpty()) {
                msg = msg + "<br>";
            }
            if (simError.level == SimError.Level.CRITICAL) {
                msg = msg + String.format("<b>%s %s</b>", Intl.intl("Error:"), simError.cause);
                continue;
            }
            msg = msg + String.format("%s %s", Intl.intl("Warning:"), simError.cause);
        }
        if (msg.isEmpty()) {
            return null;
        }
        return "<html>" + msg + "</html>";
    }

    public static String format(UnitDouble ud) {
        int type = UnitSystem.getType(ud.getUnit());
        return guiUtil.format(ud, type);
    }

    public static String format(UnitDouble ud, int unitType) {
        if (unitType == -1) {
            unitType = UnitSystem.getType(ud.getUnit());
        }
        if (unitType == -1) {
            return Global.format(ud);
        }
        UnitSystem us = MerlinApp.getApp().getUnitSystem();
        Unit unit = us.getUnit(unitType);
        return Global.format(ud.convert(unit));
    }

    public static void setLongTooltip(JComponent component, String text) {
        text = text.replace("\n", "<br>");
        text = "<html>" + text + "</html>";
        component.setToolTipText(text);
    }

    public static int getWrappedLines(JTextComponent component) {
        int lines = 0;
        View view = component.getUI().getRootView(component).getView(0);
        int paragraphs = view.getViewCount();
        for (int i = 0; i < paragraphs; ++i) {
            lines += view.getView(i).getViewCount();
        }
        return lines;
    }

    public static String shorten(String str, int maxPixelWidth, FontMetrics fm) {
        if (fm.stringWidth(str) <= maxPixelWidth) {
            return str;
        }
        String prevBestStr = "";
        for (int m = 1; m < str.length(); ++m) {
            String testStr = str.substring(0, m) + "...";
            int width = fm.stringWidth(testStr);
            if (width > maxPixelWidth) {
                return prevBestStr;
            }
            prevBestStr = testStr;
        }
        return prevBestStr;
    }

    public static JEditorPane newHTMLLabel() {
        JEditorPane editor = new JEditorPane("text/html", "");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = String.format("body { font-family: %s; font-size: %dpt; }", font.getFamily(), font.getSize());
        ((HTMLDocument)editor.getDocument()).getStyleSheet().addRule(bodyRule);
        editor.setOpaque(false);
        editor.setEditable(false);
        return editor;
    }

    public static String encodeToHtmlLabel(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return "<html>" + str.replace("\n", "<br>");
    }

    public static Pair<String, String> encodeToHtmlLabel(String v1, String v2) {
        return new Pair<String, String>(guiUtil.encodeToHtmlLabel(v1), guiUtil.encodeToHtmlLabel(v2));
    }

    public static Pair<String, String> encodeToHtmlLabels(String str1, String str2) {
        return new Pair<String, String>(guiUtil.encodeToHtmlLabel(str1), guiUtil.encodeToHtmlLabel(str2));
    }

    public static Window getWindow(Component c) {
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static <T> guiComboBox<T> newCombo(T item1, String label1, Object ... args) {
        assert (args.length % 2 == 0);
        ArrayList items = new ArrayList();
        final HashMap labels = new HashMap();
        BiConsumer<Object, String> add = (item, label) -> {
            items.add(item);
            labels.put(item, label);
        };
        add.accept(item1, label1);
        int m = 0;
        while (m < args.length) {
            Object item2 = args[m++];
            String label2 = (String)args[m++];
            add.accept(item2, label2);
        }
        guiComboBox<Object> result = new guiComboBox<Object>(items);
        result.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText((String)labels.get(value));
                return this;
            }
        });
        return result;
    }

    public static Pair<guiRadioButton, guiRadioButton> createPlacementButtons() {
        guiRadioButton d_uniformRB = new guiRadioButton(Intl.intl("Uniform (hex grid)"), false);
        d_uniformRB.setToolTipText(Intl.intl("Places occupants uniformly in a hexagonal grid pattern."));
        guiRadioButton d_randomRB = new guiRadioButton(Intl.intl("Random"), true);
        d_randomRB.setToolTipText(Intl.intl("Places occupants randomly in the space."));
        guiUtil.group(new AbstractButton[]{d_uniformRB, d_randomRB});
        return new Pair<guiRadioButton, guiRadioButton>(d_uniformRB, d_randomRB);
    }

    private static class ErrorIconSet {
        public final Icon icon;
        public final Icon decorator;

        public ErrorIconSet(String iconName16, String iconName8) {
            this.icon = guiUtil.loadMerlinIcon(iconName16);
            this.decorator = guiUtil.loadMerlinIcon(iconName8);
        }
    }
}

