/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.Occupancy;
import merlin.data.egress.agents.OccupancySpec;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.DistributionEditor;
import merlin.gui.MerlinUDF;
import merlin.gui.OccTypeCB;
import merlin.gui.guiUtil;
import merlin.unitsystem.SIUS;
import merlin.util.OccAreaListCellRenderer;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;

public class OccupancyPanel
extends guiPanel {
    private static final long serialVersionUID = -4547773031638606074L;
    private static OccupancyPanel d_panel;
    private final guiRadioButton d_constOccCountRB = new guiRadioButton(Intl.intl("By Number:"));
    private final guiRadioButton d_predefOccAreaRB = new guiRadioButton(Intl.intl("By Room Type:"));
    private final guiRadioButton d_customOccAreaRB = new guiRadioButton(Intl.intl("By Density:"));
    private final guiIntField d_constOccCountFld = new guiIntField(50, IntVR.above(0, true));
    private final OccTypeCB d_occAreaCB;
    private final guiLabel d_exitsLbl;
    private final MerlinUDF d_densityFld;
    private final DistributionEditor<OccProfile> d_profileDistEd;
    private final DistributionEditor<Behavior> d_behaviorDistEd;
    private final guiRadioButton d_spacingUniform;
    private final guiRadioButton d_spacingRandom;
    private final guiPanel d_countPnl;

    public OccupancyPanel(MerlinApp merApp, MerlinData md) {
        super(new GridBagLayout());
        this.d_occAreaCB = new OccTypeCB(md.occAreas);
        this.d_exitsLbl = new guiLabel(Intl.intl("Exits:"));
        this.d_densityFld = new MerlinUDF(2);
        UnitDoubleVR vr = UnitDoubleVR.above(new UnitDouble(0.0, SIUS.unit(2)), false);
        this.d_densityFld.setValueRange(vr);
        this.d_densityFld.setHorizontalAlignment(4);
        Pair<guiRadioButton, guiRadioButton> placementBtns = guiUtil.createPlacementButtons();
        this.d_spacingUniform = (guiRadioButton)placementBtns.v1;
        this.d_spacingRandom = (guiRadioButton)placementBtns.v2;
        new guiButtonGroup(this.d_constOccCountRB, this.d_predefOccAreaRB, this.d_customOccAreaRB);
        this.d_profileDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
        this.d_behaviorDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
        TitleSeparator tSepCount = new TitleSeparator(Intl.intl("Occupant Count"));
        this.d_countPnl = this.createCountPanel(merApp);
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Profile:"), this.d_profileDistEd, GridBagHelper.REMAINING, 1.0);
        gb.addRow(Intl.intl("Behavior:"), this.d_behaviorDistEd, GridBagHelper.REMAINING, 1.0);
        gb.addRow(Intl.intl("Placement:"), this.d_spacingUniform, this.d_spacingRandom);
        gb.addFilledRow(tSepCount);
        gb.addIdentRow(this.d_countPnl, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gb.finalizeRows();
        OccupancySpec defOcc = md.getDefaultOccupancySpec();
        defOcc.setOccCount(new ConstOccCount(50));
        this.set(defOcc, md);
    }

    public static OccupancyPanel getOccupancyPanel(MerlinApp app, MerlinData md) {
        if (d_panel == null) {
            d_panel = new OccupancyPanel(app, md);
        }
        return d_panel;
    }

    private guiPanel createCountPanel(MerlinApp merApp) {
        guiPanel p = new guiPanel(new GridBagLayout());
        OccAreaListCellRenderer.RendWithPreview rend = new OccAreaListCellRenderer.RendWithPreview(merApp);
        this.d_occAreaCB.setRenderer(rend);
        guiLabel occLbl = new guiLabel(Intl.intl("pers"));
        int row = 0;
        GridBagUtil.add(p, this.d_constOccCountRB, 0, ++row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_constOccCountFld, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, occLbl, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_customOccAreaRB, 0, ++row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_densityFld, 1, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_predefOccAreaRB, 0, ++row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_occAreaCB, 1, row, 3, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        LinkStatus.link((AbstractButton)this.d_constOccCountRB, this.d_constOccCountFld, occLbl);
        LinkStatus.link((AbstractButton)this.d_predefOccAreaRB, this.d_occAreaCB);
        LinkStatus.link((AbstractButton)this.d_customOccAreaRB, this.d_densityFld);
        return p;
    }

    public guiPanel getCountPanel() {
        return this.d_countPnl;
    }

    public void loadFrom(Occupancy occ, MerlinData md) {
        IOccArea type = occ.getOccDensity(md.occAreas);
        this.d_occAreaCB.add(type);
        this.d_occAreaCB.setSelectedItem(type);
        this.d_densityFld.setValue(type.getArea());
        int count = occ.getNumOccupants();
        this.d_constOccCountFld.setValue(count);
        this.set(occ.getSpacing());
    }

    public void set(OccupancySpec occ, MerlinData md) {
        this.set(occ.getSpacing());
        this.set(occ.getOccCount(), md);
    }

    public OccupancySpec get() {
        OccupancySpec occ = new OccupancySpec();
        occ.setOccCount(this.getCount());
        occ.setSpacing(this.getSpacing());
        return occ;
    }

    public IUrn<OccProfile> getProfileDist() {
        return (IUrn)this.d_profileDistEd.getValue();
    }

    public void setProfileDist(IUrn<OccProfile> dist) {
        this.d_profileDistEd.setValue((OccProfile)((Object)dist));
    }

    public IUrn<Behavior> getBehaviorDist() {
        return (IUrn)this.d_behaviorDistEd.getValue();
    }

    public void setBehaviorDist(IUrn<Behavior> dist) {
        this.d_behaviorDistEd.setValue((Behavior)((Object)dist));
    }

    private void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return super.validateData(showWarn, allowModify);
    }

    public void set(IOccCount type, int spacing, MerlinData md) {
        this.set(spacing);
        this.set(type, md);
    }

    public void set(Integer spacing) {
        if (spacing == null || spacing == -1) {
            this.d_spacingRandom.setSelected(false);
            this.d_spacingUniform.setSelected(false);
        } else if (spacing == 0) {
            this.d_spacingUniform.setSelected(true);
        } else {
            this.d_spacingRandom.setSelected(true);
        }
    }

    public void set(IOccCount count, MerlinData md) {
        if (count == null) {
            this.d_constOccCountRB.setSelected(false);
            this.d_customOccAreaRB.setSelected(false);
            this.d_predefOccAreaRB.setSelected(false);
        } else if (count instanceof ConstOccCount) {
            this.d_constOccCountRB.setSelected(true);
            this.d_constOccCountFld.setValue(((ConstOccCount)count).count);
        } else if (count instanceof IOccArea) {
            IOccArea type = (IOccArea)count;
            if (md.occAreas.isCustom(type)) {
                this.d_customOccAreaRB.setSelected(true);
                this.d_densityFld.setValue(type.getArea());
            } else {
                this.d_predefOccAreaRB.setSelected(true);
                this.d_occAreaCB.setSelectedItem(type);
            }
        }
    }

    public IOccCount getCount() {
        if (this.d_constOccCountRB.isSelected()) {
            return new ConstOccCount((Integer)this.d_constOccCountFld.getValue());
        }
        if (this.d_predefOccAreaRB.isSelected()) {
            return (IOccCount)this.d_occAreaCB.getSelectedItem();
        }
        if (this.d_customOccAreaRB.isSelected()) {
            return new OccArea((UnitDouble)this.d_densityFld.getValue());
        }
        return null;
    }

    public Integer getSpacing() {
        if (this.d_spacingRandom.isSelected()) {
            return 1;
        }
        if (this.d_spacingUniform.isSelected()) {
            return 0;
        }
        return null;
    }
}

