/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.elevators.ITimingModel;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.Geometry;
import merlin.gui.BasicFloorComboBox;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;

public class NewElevatorDlg
extends guiDialog {
    private static final long serialVersionUID = 2901230551278915163L;
    private final guiTextField d_name = new guiTextField(Intl.intl("Elevator"));
    private final MerlinComboBox<EgressRoom> d_roomCB;
    private final guiDoubleField d_x;
    private final guiDoubleField d_y;
    private final guiDoubleField d_z;
    private final guiUnitDoubleField d_nominalLoad;
    private final guiUnitDoubleField d_callDistance;
    private final MerlinComboBox<Floor> d_topFloorCB;
    private final MerlinComboBox<Floor> d_bottomFloorCB;
    private final TimingPnl d_timingPnl;
    private final guiCheckBox d_doubleDeck;

    public NewElevatorDlg(Window owner, MerlinData md) {
        super(owner, Intl.intl("New Elevator"), 9);
        Predicate<EgressRoom> roomFilter = new Predicate<EgressRoom>(){

            @Override
            public boolean test(EgressRoom o) {
                return !(o instanceof ElevatorRoom);
            }
        };
        this.d_roomCB = new MerlinComboBox<EgressRoom>(md, EgressRoom.class, (Predicate)roomFilter, new EgressRoom[0]){
            private static final long serialVersionUID = 2755109651234524097L;

            @Override
            protected String getName(MerlinData md, Object o) {
                if (o instanceof EgressRoom) {
                    Floor floor = ElevatorUtil.getFloor(md, (EgressRoom)o);
                    return floor.getName() + "->" + super.getName(md, o);
                }
                return super.getName(md, o);
            }
        };
        this.d_x = new guiDoubleField(0.0);
        this.d_y = new guiDoubleField(0.0);
        this.d_z = new guiDoubleField(1.0);
        this.d_x.setColumns(7);
        this.d_y.setColumns(7);
        this.d_z.setColumns(7);
        this.d_nominalLoad = new guiUnitDoubleField(SIUS.unit(9));
        this.d_topFloorCB = new BasicFloorComboBox(md, Intl.intl("[highest]"));
        this.d_bottomFloorCB = new BasicFloorComboBox(md, Intl.intl("[lowest]"));
        this.d_timingPnl = new TimingPnl();
        this.d_callDistance = new MerlinUDF(0, DoubleVR.above(0.0, true));
        this.d_doubleDeck = new guiCheckBox(Intl.intl("Double-Deck"), false);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Name:"), this.d_name, 1.0, 0);
        gb.addRow(Intl.intl("Nominal Load:"), this.d_nominalLoad, 0);
        gb.addRow(Intl.intl("Elevator Geometry:"), this.d_roomCB, 0);
        gb.addRow(Intl.intl("Travel Direction:"), Intl.intl("X:"), this.d_x, Intl.intl("Y:"), this.d_y, Intl.intl("Z:"), this.d_z);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Bounds")));
        gb.indent();
        gb.addRow(Intl.intl("Bottom Floor:"), this.d_bottomFloorCB, 0);
        gb.addRow(Intl.intl("Top Floor:"), this.d_topFloorCB, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Timing")));
        gb.indent();
        this.d_timingPnl.addToLayout(gb);
        gb.addRow(Intl.intl("Call Distance:"), this.d_callDistance, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Type")));
        gb.addIdentRow(this.d_doubleDeck, 1.0, 0);
        gb.finalizeRows();
        this.init(md);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (((EgressRoom)this.d_roomCB.getSelectedItem()).getDoors().isEmpty()) {
            if (showWarn) {
                String msg = Intl.intl("The base room must contain doors that will connect with each floor.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        UnitDouble bottom = this.getLoc(this.d_bottomFloorCB);
        UnitDouble top = this.getLoc(this.d_topFloorCB);
        if (bottom != null && top != null && bottom.compareTo(top) >= 0) {
            if (showWarn) {
                String msg = Intl.intl("The top floor must be above the bottom floor.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if (this.isSelFloorEmpty(this.d_bottomFloorCB)) {
            if (showWarn) {
                String msg = Intl.intl("The bottom floor must not be empty.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if (this.isSelFloorEmpty(this.d_topFloorCB)) {
            if (showWarn) {
                String msg = Intl.intl("The top floor must not be empty.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if ((Double)this.d_x.getValue() == 0.0 && (Double)this.d_y.getValue() == 0.0 && (Double)this.d_z.getValue() == 0.0) {
            if (showWarn) {
                String msg = Intl.intl("The travel direction must be non-zero.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        return true;
    }

    private boolean isSelFloorEmpty(MerlinComboBox<Floor> floorcb) {
        Floor selFloor = (Floor)floorcb.getSelectedItem();
        return selFloor == null ? false : selFloor.getDeepMembers().isEmpty();
    }

    private UnitDouble getLoc(MerlinComboBox<Floor> floorcb) {
        Floor floor = (Floor)floorcb.getSelectedItem();
        return floor != null ? floor.getWorkingZ() : null;
    }

    private void init(MerlinData md) {
        this.d_bottomFloorCB.setSelectedItem(null);
        this.d_topFloorCB.setSelectedItem(null);
        this.d_timingPnl.load(ITimingModel.DEF_MODEL);
        this.setCallDistance(new UnitDouble(Elevator.DEFAULT_ELEVATOR_CALL_DIST.getRawValue(), Elevator.DEFAULT_ELEVATOR_CALL_DIST.getUnit()));
    }

    public void load(MerlinData md, String name, EgressRoom baseRoom) {
        this.d_name.setText(name);
        this.d_roomCB.setSelectedItem(baseRoom);
        Floor dischargeFloor = ElevatorUtil.getFloor(md, baseRoom);
        UnitDouble discharge = dischargeFloor.getWorkingZ();
        UnitDouble top = this.getLoc(this.d_topFloorCB);
        UnitDouble bottom = this.getLoc(this.d_bottomFloorCB);
        if (top != null && discharge.compareTo(top) > 0) {
            this.d_topFloorCB.setSelectedItem(dischargeFloor);
        }
        if (bottom != null && discharge.compareTo(bottom) < 0) {
            this.d_bottomFloorCB.setSelectedItem(dischargeFloor);
        }
        UnitDouble elevArea = baseRoom.getArea();
        double rawDefNomLoad = Elevator.getNominalLoad(elevArea, 1.0);
        double adjDefNomLoad = (int)((double)Math.round(rawDefNomLoad * 100.0) / 100.0);
        UnitDouble nomLoad = new UnitDouble(adjDefNomLoad, SIUS.unit(9));
        this.setNominalLoad(nomLoad);
    }

    public Floor[] getFloorBounds() {
        return new Floor[]{(Floor)this.d_bottomFloorCB.getSelectedItem(), (Floor)this.d_topFloorCB.getSelectedItem()};
    }

    public EgressRoom getBaseRoom() {
        return (EgressRoom)this.d_roomCB.getSelectedItem();
    }

    public ITimingModel getTimingModel() {
        return this.d_timingPnl.save();
    }

    @Override
    public String getName() {
        return this.d_name.getText();
    }

    public Vector3d getTravelDir() {
        Vector3d dir = new Vector3d((Double)this.d_x.getValue(), (Double)this.d_y.getValue(), (Double)this.d_z.getValue());
        dir.normalize();
        return dir;
    }

    public UnitDouble getNominalLoad() {
        return (UnitDouble)this.d_nominalLoad.getValue();
    }

    public void setNominalLoad(UnitDouble nominalLoad) {
        this.d_nominalLoad.setValue(nominalLoad);
    }

    public UnitDouble getCallDistance() {
        return (UnitDouble)this.d_callDistance.getValue();
    }

    public void setCallDistance(UnitDouble callDistance) {
        this.d_callDistance.setValue(callDistance);
    }

    public boolean isDoubleDeck() {
        return this.d_doubleDeck.isSelected();
    }

    public static class TimingPnl
    extends guiPanel {
        private static final long serialVersionUID = -4081032343494838159L;
        private final guiCheckBox d_accelCB = new guiCheckBox(Intl.intl("Acceleration:"));
        private final MerlinUDF d_accel = new MerlinUDF(8, DoubleVR.above(0.0, false));
        private final MerlinUDF d_vel = new MerlinUDF(5, DoubleVR.above(0.0, false));
        private final MerlinUDF d_openCloseTime = new MerlinUDF(1, DoubleVR.above(0.0, true));

        public TimingPnl() {
            LinkStatus.link((AbstractButton)this.d_accelCB, this.d_accel);
            GridBagHelper gb = new GridBagHelper(this);
            this.addToLayout(gb);
            gb.finalizeRows();
        }

        public void addToLayout(GridBagHelper gb) {
            gb.addRow(this.d_accelCB, this.d_accel, 0);
            gb.addRow(Intl.intl("Max Velocity:"), this.d_vel, 0);
            gb.addRow(Intl.intl("Open+Close Time:"), this.d_openCloseTime, 0);
        }

        public void load(ITimingModel model) {
            ITimingModel.AModel am;
            if (model instanceof ITimingModel.AModel) {
                am = (ITimingModel.AModel)model;
                this.d_openCloseTime.setValue(new UnitDouble(am.openDoorTime + am.closeDoorTime, SI.SECOND));
            }
            if (model instanceof ITimingModel.AccelModel) {
                am = (ITimingModel.AccelModel)model;
                this.d_accelCB.setSelected(true);
                this.d_accel.setValue(new UnitDouble(((ITimingModel.AccelModel)am).accel, Geometry.ACCEL_UNIT));
                this.d_vel.setValue(new UnitDouble(((ITimingModel.AccelModel)am).maxVel, Geometry.VEL_UNIT));
            } else if (model instanceof ITimingModel.VelModel) {
                ITimingModel.VelModel vm = (ITimingModel.VelModel)model;
                this.d_accelCB.setSelected(false);
                this.d_vel.setValue(new UnitDouble(vm.vel, Geometry.VEL_UNIT));
            }
        }

        public ITimingModel save() {
            double openClose = ((UnitDouble)this.d_openCloseTime.getValue()).getValue(SI.SECOND);
            if (this.d_accelCB.isSelected()) {
                return new ITimingModel.AccelModel(((UnitDouble)this.d_accel.getValue()).getValue(Geometry.ACCEL_UNIT), ((UnitDouble)this.d_vel.getValue()).getValue(Geometry.VEL_UNIT), openClose * 0.5, openClose * 0.5);
            }
            return new ITimingModel.VelModel(((UnitDouble)this.d_vel.getValue()).getValue(Geometry.VEL_UNIT), openClose * 0.5, openClose * 0.5);
        }
    }
}

