/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.JsonObj;
import merlin.data.MerlinData;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiPanel;

public class JsonPnl
extends guiPanel
implements IEditor<JsonObj> {
    private static final long serialVersionUID = -4322263766736040157L;
    private final JTextArea d_textArea = new JTextArea();
    private boolean d_modified;

    public JsonPnl() {
        this.d_textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                JsonPnl.this.setModified(true);
            }
        });
        JScrollPane sp = new JScrollPane(this.d_textArea);
        sp.setPreferredSize(new Dimension(300, 200));
        this.add((Component)sp, "Center");
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this.d_modified = modified;
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public JsonObj preview(JsonObj previewObj) {
        return previewObj;
    }

    @Override
    public void init(JsonObj dataObj) {
        if (dataObj == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.d_textArea.setText(dataObj.getJson());
            this.setModified(false);
        }
    }

    @Override
    public JsonObj commit(final JsonObj dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Undo.begin(Intl.intl("Edit JSON Object"));
                    md.beginWrite();
                    try {
                        Undo.insertUndoEntry_restore(md, dataObj);
                        dataObj.setJson(JsonPnl.this.d_textArea.getText());
                    }
                    finally {
                        Undo.end(MerlinApp.getApp().getData());
                        md.endWrite();
                    }
                }
            };
            UIHook.run(this, "JsonPnl.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }
}

