/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.PathfinderLM;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import merlin.Intl;
import merlin.Version;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiURLLabel;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class AboutDlg
extends guiDialog {
    private static final long serialVersionUID = -6241127823308207924L;

    public AboutDlg(JFrame parent, PathfinderLM licenseMgr, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo) {
        super((Window)parent, Version.FULL_NAME, 1);
        guiPanel overlay = AboutDlg.newCanvas(false);
        guiPanel inside = new guiPanel();
        inside.setBackground(new Color(0, 0, 0, 0));
        overlay.add(inside);
        GridBagHelper overlaygb = new GridBagHelper(inside, true);
        overlaygb.rowSpace = 0;
        overlaygb.addRow(String.format("%s: %s %s", Intl.intl("Revision"), "2022.3.1207", Version.BITS), 0);
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.addRow(new guiLabel(guiUtil.loadMerlinIcon("pathfinder_logo_title_48.png")));
        AboutDlg.addEmptyRow(overlaygb);
        String company = Intl.intl("Developed by Thunderhead Engineering Consultants, Inc.");
        guiURLLabel address = AboutDlg.init(new guiURLLabel("http://www.thunderheadeng.com"));
        int thisYear = Calendar.getInstance().get(1);
        String copyright = String.format(Intl.intl("Copyright (c) 2008-%d All Rights Reserved."), thisYear);
        String localizationCredit = Intl.intl("Localization Credit");
        String license = licenseMgr.getDescription();
        Runtime rt = Runtime.getRuntime();
        String rtLbl = String.format(Intl.intl("Free Java Memory:  %d MB\nJava Memory Limit:  %d MB\nJava Max Memory:  %d MB"), rt.freeMemory() / 1024L / 1024L, rt.totalMemory() / 1024L / 1024L, rt.maxMemory() / 1024L / 1024L);
        overlaygb.addFilledRow(company);
        overlaygb.addFilledRow(address);
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.addFilledRow(copyright);
        if (!localizationCredit.equals("Localization Credit")) {
            overlaygb.addFilledRow(localizationCredit);
        }
        overlaygb.addFilledRow(AboutDlg.lbl(license));
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.addFilledRow(AboutDlg.lbl(rtLbl));
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.addTitle(Intl.intl("GPU Information"));
        AboutDlg.addEmptyRow(overlaygb);
        GPUInfoPnl gpuPnl = new GPUInfoPnl(getRenderInfo, true);
        overlaygb.addIdentRow(gpuPnl, 0, 1.0);
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.addRow(new guiLabel(thunderheadeng.gui.guiUtil.loadTeciIcon("teci_logo.png")), 0);
        AboutDlg.addEmptyRow(overlaygb);
        overlaygb.finalizeRows();
        this.getDialogPane().add((Component)overlay, "Center");
        JButton ok = this.getButton(1);
        JButton legal = new JButton(Intl.intl("Disclaimer"));
        legal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDlg.this.showDisclaimer();
            }
        });
        JButton credits = new JButton(Intl.intl("Credits"));
        credits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDlg.this.showCredits();
            }
        });
        this.setButtons(legal, credits, ok);
        this.getRootPane().setDefaultButton(ok);
    }

    private void showCredits() {
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Credits"), 1);
        guiPanel canvas = AboutDlg.newCanvas(true);
        GridBagHelper gb = new GridBagHelper(canvas, false);
        gb.rowSpace = 0;
        String[] libs = new String[]{"FreeImage v3.18.0", "FreeType v2.2.1", "FTGL v2.15", "VTK v6.3.0"};
        StringBuilder libStr = new StringBuilder(Intl.intl("Pathfinder uses the following open source libraries:\n"));
        for (String lib : libs) {
            libStr.append('\n');
            libStr.append("        ");
            libStr.append(lib);
        }
        gb.addFilledRow(AboutDlg.lbl(libStr.toString()));
        AboutDlg.addEmptyRow(gb);
        String ack = Intl.intl("Pathfinder includes textures, 3D models, and animations from the following:");
        gb.addFilledRow(ack);
        gb.addRow("        ", new guiLabel(guiUtil.loadMerlinIcon("axyz_logo32.png")), "(aXYZ design)", 0);
        gb.addRow("        ", "GameTextures.com");
        gb.finalizeRows();
        dlg.getDialogPane().add((Component)canvas, "Center");
        dlg.doModal();
    }

    private void showDisclaimer() {
        String msg = "Thunderhead Engineering makes no warranty, expressed or implied, to \nusers of Pathfinder, and accepts no responsibility for its use. Users of Pathfinder\nassume sole responsibility under Federal law for determining the appropriateness\nof its use in any particular application, for any conclusions drawn from the\nresults of its use, and for any actions taken or not taken as a result of\nanalyses performed using these tools.";
        JOptionPane.showMessageDialog(this, "Thunderhead Engineering makes no warranty, expressed or implied, to \nusers of Pathfinder, and accepts no responsibility for its use. Users of Pathfinder\nassume sole responsibility under Federal law for determining the appropriateness\nof its use in any particular application, for any conclusions drawn from the\nresults of its use, and for any actions taken or not taken as a result of\nanalyses performed using these tools.", Intl.intl("Disclaimer"), 1);
    }

    private static void addEmptyRow(GridBagHelper gb) {
        gb.addRow(Box.createVerticalStrut(12), 0);
    }

    private static JComponent lbl(String msg) {
        msg = "<html>" + msg.replaceAll("[\n]", "<br>");
        return new guiLabel(msg);
    }

    private static <T extends Component> T init(T comp) {
        comp.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        return comp;
    }

    private static guiPanel newCanvas(boolean indentBorder) {
        guiPanel overlay = new guiPanel();
        overlay.setBackground(Color.WHITE);
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        if (indentBorder) {
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(6, 6, 6, 6));
        }
        overlay.setBorder(border);
        return overlay;
    }
}

