/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;

public class PointGeomFinder<T extends IDisplayableGeomSrc> {
    public final ITest<AABox> test;
    public final IResult<IDisplayableGeomSrc> result;

    public PointGeomFinder(Point3d loc, double tol, Class<T> type) {
        this(loc, tol, type, Filters.acceptAll(type));
    }

    public PointGeomFinder(final Point3d loc, final double tol, Class<T> type, Predicate<T> filter) {
        this.test = new ITest<AABox>(){

            @Override
            public Containment test(AABox bounds) {
                return Inter3D.testSphereAABB(loc, tol, bounds.getMin(), bounds.getMax());
            }
        };
        this.result = new Result<T>(loc, type, filter);
    }

    public Map<T, IsectInfo> getResults() {
        return ((Result)this.result).d_isects;
    }

    private static class Result<T extends IDisplayableGeomSrc>
    implements IResult<IDisplayableGeomSrc> {
        private final Map<T, IsectInfo> d_isects = new LinkedIdentityHashMap<T, IsectInfo>();
        private final Point3d loc;
        private final Class<T> type;
        private final Predicate<T> filter;

        public Result(Point3d loc, Class<T> type, Predicate<T> filter) {
            this.loc = loc;
            this.type = type;
            this.filter = filter;
        }

        @Override
        public void mark(IDisplayableGeomSrc geom, Containment ctmt) {
            if (this.type.isInstance(geom) && this.filter.test(this.type.cast(geom))) {
                this.d_isects.put(this.type.cast(geom), new IsectInfo(GeomType.VERTEX, geom, this.loc, () -> new Point(this.loc), null, IPrimProps.DEF, null));
            }
        }
    }
}

