/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.objs.LineSeg;

public class Geometry {
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit ANGLE_UNIT = SI.RADIAN;
    public static final Unit AREA_UNIT = SI.METER.pow(2);
    public static final Unit ACCEL_UNIT = SI.METER.divide(SI.SECOND.pow(2));
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final double SHORTEST_ARC_EPSILON = 1.0E-5;
    private static Matrix4d s_scaleMat1 = Util.scaleMat(-0.34, 34.5, -24.4);
    private static Matrix4d s_scaleMat2 = Util.scaleMat(-0.34, 34.5, -0.244);
    private static Matrix4d s_scaleMat3 = Util.scaleMat(-0.34, 34.5, 0.244);
    private static Matrix4d s_scaleMat4 = Util.scaleMat(-0.34, 34.5, 24.4);

    public static Path2D.Double pointsToPath(Collection<Point2d> points) {
        Path2D.Double path = new Path2D.Double();
        Geometry.pointsToPath(path, points);
        return path;
    }

    public static void pointsToPath(Path2D.Double path, Collection<Point2d> points) {
        path.reset();
        if (!points.isEmpty()) {
            Iterator<Point2d> it = points.iterator();
            Point2d firstPoint = it.next();
            path.moveTo(firstPoint.x, firstPoint.y);
            while (it.hasNext()) {
                Point2d next = it.next();
                path.lineTo(next.x, next.y);
            }
        }
    }

    private static int addPoint(Point2d p, Map<Point2d, Integer> pointLookup, Mesh dmesh, double eqtol) {
        Point2d rounded = Util2D.round(p, eqtol);
        Integer result = pointLookup.get(rounded);
        if (result == null) {
            result = pointLookup.size();
            dmesh.addPoint(rounded.x, rounded.y);
            pointLookup.put(rounded, result);
        }
        return result;
    }

    public static double triArea(Point2d p1, Point2d p2, Point2d p3) {
        double area = 0.5 * Math.abs(Geometry.cross(p1, p2, p3));
        return area;
    }

    public static double cross(Point2d origin, Point2d p1, Point2d p2) {
        double area = p1.x * origin.y - origin.x * p1.y + (p2.x * p1.y - p1.x * p2.y) + (origin.x * p2.y - p2.x * origin.y);
        return area;
    }

    public static Vector3d cross(Vector3d v1, Vector3d v2) {
        Vector3d result = new Vector3d();
        result.cross(v1, v2);
        return result;
    }

    public static Vector3d crossN(Vector3d v1, Vector3d v2) {
        Vector3d result = new Vector3d();
        result.cross(v1, v2);
        result.normalize();
        return result;
    }

    private static boolean lequal(double v1, double v2, double tol) {
        return v1 - v2 <= tol;
    }

    private static boolean gequal(double v1, double v2, double tol) {
        return v1 - v2 >= -tol;
    }

    public static Vector3d getPlaneVec(Vector3d planeNormal) {
        if (planeNormal.x == 0.0 && (planeNormal.y == 0.0 || planeNormal.z == 0.0)) {
            return new Vector3d(1.0, 0.0, 0.0);
        }
        if (planeNormal.y == 0.0 && planeNormal.z == 0.0) {
            return new Vector3d(0.0, 1.0, 0.0);
        }
        assert (planeNormal.x != 0.0 || planeNormal.y != 0.0);
        double y = planeNormal.x / Math.sqrt(planeNormal.y * planeNormal.y + planeNormal.x * planeNormal.x);
        double x = Math.sqrt(1.0 - y * y);
        return new Vector3d(x, y, 0.0);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2, Vector3d fallbackAxis) {
        return Geometry.shortestArc(v1, v2, fallbackAxis, 1.0E-5);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2) {
        return Geometry.shortestArc(v1, v2, null, 1.0E-5);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2, double epsilon) {
        return Geometry.shortestArc(v1, v2, null, epsilon);
    }

    public static Quat4d shortestArc(Vector3d v1n, Vector3d v2n, Vector3d fallbackAxisN, double epsilon) {
        Vector3d uv1 = v1n;
        Vector3d uv2 = v2n;
        double d = uv1.dot(uv2);
        if (Geometry.lequal(d, -1.0, epsilon)) {
            if (fallbackAxisN == null) {
                fallbackAxisN = Geometry.getPlaneVec(v1n);
            }
            return new Quat4d(fallbackAxisN.x, fallbackAxisN.y, fallbackAxisN.z, 0.0);
        }
        if (Geometry.gequal(d, 1.0, epsilon)) {
            return new Quat4d(0.0, 0.0, 0.0, 1.0);
        }
        Vector3d cross = new Vector3d();
        cross.cross(uv1, uv2);
        double s = Math.sqrt((1.0 + d) * 2.0);
        double invs = 1.0 / s;
        return new Quat4d(cross.x * invs, cross.y * invs, cross.z * invs, s * 0.5);
    }

    public static Matrix4d getPlaneToPlaneXform(Plane3d plane1, Plane3d plane2) {
        Vector3d normal1 = new Vector3d(plane1.x, plane1.y, plane1.z);
        Vector3d normal2 = new Vector3d(plane2.x, plane2.y, plane2.z);
        Quat4d shortestRot = Geometry.shortestArc(normal1, normal2);
        double planeDist1 = -plane1.w;
        double planeDist2 = -plane2.w;
        normal2.scale(planeDist2 - planeDist1);
        Matrix4d mat = new Matrix4d();
        mat.set(shortestRot);
        mat.m03 = normal2.x;
        mat.m13 = normal2.y;
        mat.m23 = normal2.z;
        return mat;
    }

    public static Matrix4d getWorldToLocalXform(Plane3d localPlane) {
        return Util.getWorldToLocalXform(localPlane);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d localPlane) {
        return Util.getLocalToWorldXform(localPlane);
    }

    public static Plane3d getPlane(Matrix4d localToWorldXform) {
        return Util.getPlane(localToWorldXform);
    }

    private void testPlane(Vector3d normalDir, double dist) {
        normalDir.normalize();
        this.testPlane(new Plane3d(normalDir.x, normalDir.y, normalDir.z, -dist));
    }

    private void testPlane(double x, double y, double z, double w) {
        this.testPlane(new Plane3d(x, y, z, w));
    }

    private void testPlane(Plane3d plane) {
        System.out.println("*****normal test*******");
        this.testPlane1(plane);
        System.out.println("*****random test*******");
        for (int m = 0; m < 1; ++m) {
            this.testPlane1(this.randomlyTransformPlane(plane));
        }
    }

    private void testPlane1(Plane3d plane) {
        System.out.println("plane1: " + plane);
        Matrix4d xform = Geometry.getLocalToWorldXform(plane);
        Plane3d plane2 = Geometry.getPlane(xform);
        System.out.println("plane2: " + plane2);
    }

    private Plane3d randomlyTransformPlane(Plane3d plane) {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        for (int m = 0; m < 10; ++m) {
            int tType = (int)Math.round(Math.random() * 3.0);
            if (tType == 0) {
                xform.mul(Util.translateMat(Math.random() * 50.0 - 25.0, Math.random() * 50.0 - 25.0, Math.random() * 50.0 - 25.0));
                continue;
            }
            if (tType == 1) {
                xform.mul(Util.scaleMat(Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5, Math.random() * 3.0 - 1.5));
                continue;
            }
            xform.mul(Util.rotMat(Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0, Math.random() * 2.0 * Math.PI - Math.PI));
        }
        return plane.transformBy(xform);
    }

    public static double[] getEdgeSegment(LineSeg edge, double loc1, double loc2, double minEdgeT, double maxEdgeT, double minWidth, boolean slide) {
        double[] t = Util.rectify(loc1, loc2);
        loc1 = t[0];
        loc2 = t[1];
        double edgelen = edge.length();
        double minWidthT = minWidth / edgelen;
        if (loc2 <= minEdgeT || loc1 >= maxEdgeT) {
            return null;
        }
        if (slide) {
            double widtht = loc2 - loc1;
            double maxEdgeWidthT = maxEdgeT - minEdgeT;
            if (widtht > maxEdgeWidthT) {
                widtht = maxEdgeWidthT;
            }
            if (widtht < 1.0E-6 || widtht < minWidthT) {
                return null;
            }
            if (loc2 > maxEdgeT) {
                loc2 = maxEdgeT;
                loc1 = loc2 - widtht;
            } else if (loc1 < minEdgeT) {
                loc1 = minEdgeT;
                loc2 = loc1 + widtht;
            }
            return new double[]{loc1, loc2};
        }
        if ((loc1 = Util.clampT(loc1, minEdgeT, maxEdgeT)) == (loc2 = Util.clampT(loc2, minEdgeT, maxEdgeT))) {
            return null;
        }
        double widtht = loc2 - loc1;
        if (widtht < 1.0E-6 || widtht < minWidthT) {
            return null;
        }
        return new double[]{loc1, loc2};
    }
}

