/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import common.geom.Trig;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.ICompElement;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.Opacity;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.material.TexMappers;
import merlin.geom.Geometry;
import merlin.geom.Inter2D;
import merlin.geom.PointGeomFinder;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RayAABoxTest;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public class GeomUtil {
    public static final Set<Object> CAD_GEOM_PROPS = Sets.fromArrayHS(MerlinData.MATERIAL, MerlinData.COLOR, MerlinData.OPACITY);
    public static final IElemSource<Point2d> DEFUV = TexMappers.newPlanarCoordMapper(new Point3d(0.0, 0.0, 0.0));

    public static double dist(Tuple3d a, Tuple3d b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double dist(Tuple3f a, Tuple3f b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean samePt(Tuple3d pt1, Tuple3d pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static boolean samePt(Tuple3f pt1, Tuple3f pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static Vector2d randomVec(Random rand) {
        double x = 0.0;
        double y = 0.0;
        while (x == 0.0 && y == 0.0) {
            x = rand.nextDouble() - 0.5;
            y = rand.nextDouble() - 0.5;
        }
        return new Vector2d(x, y);
    }

    public static Point2d findPointInPoly(List<? extends IParametric2D> poly, double tol) {
        if (poly.isEmpty()) {
            return null;
        }
        Point2d startPoint = poly.get(0).get(0.5);
        Random rand = new Random(0L);
        for (int m = 0; m < 10; ++m) {
            Vector2d rvec = GeomUtil.randomVec(rand);
            List<double[]> trimmed = Inter2D.trimLineToPoly(poly, startPoint, rvec, tol);
            for (double[] seg : trimmed) {
                if (theUtil.eq(seg[0], seg[1], tol)) continue;
                double midt = (seg[0] + seg[1]) * 0.5;
                return Util2D.linePoint(startPoint, rvec, midt);
            }
        }
        return startPoint;
    }

    public static boolean addToModel(Model model, int groupid, Mesh mesh) {
        boolean result = true;
        switch (mesh.primtype) {
            case 1: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    model.addEdge(groupid, new LineSeg3D(p1, p2));
                }
                break;
            }
            case 2: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                }
                break;
            }
            case 3: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    Point3d p4 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3, p4), p1, p2, p3, p4);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    public static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        return model.addFace(groupid, plane, boundary);
    }

    public static boolean addFaceToModel(IFace face, Model model, int groupid, double edgeError, double faceError) {
        return GeomUtil.addFaceToModel(face, true, model, groupid, edgeError, faceError);
    }

    public static boolean addFaceToModel(IFace face, boolean ccw, Model model, int groupid, double edgeError, double faceError) {
        if (face instanceof Triangle) {
            Triangle tri = (Triangle)face;
            Plane3d plane = new Plane3d(ccw, tri.p1, tri.p2, tri.p3);
            if (ccw) {
                return model.addPolygonFace(groupid, plane, tri.p1, tri.p2, tri.p3);
            }
            return model.addPolygonFace(groupid, plane, tri.p3, tri.p2, tri.p1);
        }
        if (face instanceof IPlanarFace) {
            IPolygon poly = ((IPlanarFace)face).toPoly(edgeError);
            Plane3d plane = poly.getPlane(ccw);
            Point3d[][] loops = PolyUtil.getLoops(poly, false);
            ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
            for (Point3d[] loop : loops) {
                Point3d p22;
                if (loop.length == 0) continue;
                if (ccw) {
                    for (int m = 0; m < loop.length; ++m) {
                        Point3d p12 = loop[m];
                        p22 = loop[(m + 1) % loop.length];
                        if (p12.equals(p22)) continue;
                        curves.add(new LineSeg3D(p12, p22));
                    }
                    continue;
                }
                Point3d p13 = loop[0];
                for (int m = loop.length - 1; m >= 0; --m) {
                    p22 = loop[m];
                    if (!p13.equals(p22)) {
                        curves.add(new LineSeg3D(p13, p22));
                    }
                    p13 = p22;
                }
            }
            return model.addFace(groupid, plane, curves);
        }
        boolean result = true;
        Pair<Mesh, Boolean> triResult = face.triangulate(faceError, ccw);
        Mesh triangles = (Mesh)triResult.v1;
        boolean tccw = (Boolean)triResult.v2;
        TriFunction<Point3d, Point3d, Point3d, Boolean> addTri = tccw ? (p1, p2, p3) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        } : (p3, p2, p1) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        };
        int m = 0;
        while (m < triangles.indices.length) {
            Point3d p14 = triangles.vertices[triangles.indices[m++]];
            Point3d p23 = triangles.vertices[triangles.indices[m++]];
            Point3d p32 = triangles.vertices[triangles.indices[m++]];
            result &= addTri.apply(p14, p23, p32).booleanValue();
        }
        return result;
    }

    public static void addCurveToModel(ICurve curve, Model model, int groupid, double edgeError) {
        if (curve instanceof LineSeg) {
            LineSeg ls = (LineSeg)curve;
            model.addEdge(groupid, new LineSeg3D(ls.p1, ls.p2));
        } else {
            Mesh mesh = curve.getSegments(edgeError);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                model.addEdge(groupid, new LineSeg3D(p1, p2));
            }
        }
    }

    public static List<IFace> extractFaces(Model model, Integer groupid) {
        ArrayList<IFace> faces = new ArrayList<IFace>();
        for (Face face : model.getFaces()) {
            IFace gface;
            if (groupid != null && !face.partOfGroup(groupid) || (gface = GeomUtil.toGeomFace(face)) == null) continue;
            faces.add(gface);
        }
        return faces;
    }

    public static IFace toGeomFace(Face face) {
        ArrayList<Point3d[]> loops = new ArrayList<Point3d[]>(face.edgeLoops.size());
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.edges.size() < 3) continue;
            Point3d[] points = new Point3d[loop.edges.size()];
            for (int m = 0; m < loop.edges.size(); ++m) {
                EdgeUse eu = loop.edges.get(m);
                points[m] = eu.v1().loc;
            }
            loops.add(points);
        }
        if (loops.isEmpty()) {
            return null;
        }
        return PolyUtil.newPoly((Point3d[][])loops.toArray((T[])new Point3d[loops.size()][]));
    }

    public static ICurve toGeomCurve(EdgeUse eu) {
        return GeomUtil.toGeomCurve(eu.curve());
    }

    public static ICurve toGeomCurve(IParametric3D curve) {
        if (curve.isLinear()) {
            return new LineSeg(curve.get(0.0), curve.get(1.0));
        }
        assert (false);
        return null;
    }

    public static Model transform(Model model, ITransform xform, Matrix4d matrix) {
        Model mclone = model.clone();
        mclone.transform(xform, matrix);
        RoomUtil.ensureProperFaceOrient(mclone);
        return mclone;
    }

    public static List<? extends IPolygon> toPolys(IFace face, double error) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(error, face);
    }

    public static Area toArea(Face face) {
        return GeomUtil.toArea(face, face.plane);
    }

    public static Area toArea(Face face, Plane3d projPlane) {
        Matrix4d wlXform = Util.getWorldToLocalXform(projPlane);
        Path2D.Double path = new Path2D.Double(0);
        for (FaceLoop loop : face.edgeLoops) {
            ArrayList<IParametric2D> subPath = new ArrayList<IParametric2D>();
            for (EdgeUse eu : loop.edges) {
                subPath.add(eu.curve().projectToPlane(projPlane, wlXform));
            }
            ShapeUtil.appendAsSubPath(path, subPath);
        }
        return new Area(path);
    }

    public static Vector3d to3d(Vector2d v, boolean normalize) {
        double lsq;
        Vector3d result = new Vector3d(v.x, v.y, 0.0);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static Vector2d to2d(Vector3d v, boolean normalize) {
        double lsq;
        Vector2d result = new Vector2d(v.x, v.y);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static FindResult findRoom(MerlinData md, Point3d loc, int options) {
        FindResult closestResult = null;
        double closestDistSq = Double.MAX_VALUE;
        PointGeomFinder<IEgressOccupiable> test = new PointGeomFinder<IEgressOccupiable>(loc, 1.0E-6, IEgressOccupiable.class);
        md.geomLocation.getLocator().find(test.test, test.result, options);
        for (Map.Entry<IEgressOccupiable, IsectInfo> entry : test.getResults().entrySet()) {
            IGeom geom = entry.getKey().getGeom().flatten().getLocalGeom();
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                for (IPolygon iPolygon : GeomUtil.getPolys(face, 0.0)) {
                    Point3d nearp = iPolygon.project(loc);
                    double distsq = nearp.distanceSquared(loc);
                    if (!(distsq < closestDistSq) || !iPolygon.classify((Point3d)nearp, (double)1.0E-6).positive) continue;
                    closestDistSq = distsq;
                    closestResult = new FindResult(entry.getKey(), iPolygon.getNormal(true), nearp);
                }
            }
        }
        return closestResult;
    }

    public static FindResult findRoom(MerlinData md, Point3d rayBegin, Point3d rayEnd, int options) {
        return GeomUtil.findRoom(md, () -> {}, rayBegin, rayEnd, options);
    }

    public static FindResult findRoom(MerlinData md, Runnable validateProgress, Point3d rayBegin, Point3d rayEnd, int options) {
        Collection<FindResult> result = GeomUtil.findRooms(md, validateProgress, rayBegin, rayEnd, options);
        return result.isEmpty() ? null : result.iterator().next();
    }

    public static Collection<FindResult> findRooms(MerlinData md, Runnable validateProgress, Point3d rayBegin, Point3d rayEnd, int options) {
        Vector3d dir = Util3D.vector(rayBegin, rayEnd);
        return GeomUtil.findRooms(md, validateProgress, rayBegin, dir, 1.0, options);
    }

    public static Collection<FindResult> findRooms(MerlinData md, final Runnable validateProgress, Point3d rayBegin, Vector3d rayDir, double maxT, int options) {
        ITest<AABox> test;
        if (rayDir.lengthSquared() == 0.0 || maxT == 0.0) {
            test = new AABoxTest(new AABox(rayBegin), 1.0E-6);
            double tol = 1.0E-6;
            rayBegin = new Point3d(rayBegin);
            rayBegin.z += tol;
            rayDir = GeomConstants.VEC3D_ZNEG;
            maxT = 2.0 * tol;
        } else {
            test = new RayAABoxTest(rayBegin, rayDir, maxT, 1.0E-6);
            rayDir = new Vector3d(rayDir);
            double rayLen = Util3D.safeNormalize(rayDir, 0.0);
            maxT *= rayLen;
        }
        Collection<IEgressOccupiable> rooms = md.geomLocation.getLocator().find(test, IEgressOccupiable.class, options);
        if (rooms.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<FindResult> closestResult = new ArrayList<FindResult>();
        final double[] closestDistSq = new double[]{Double.MAX_VALUE};
        final Point3d rayOrigin = rayBegin;
        IIsectCollector isectCollector = new IIsectCollector(){

            @Override
            public void validate() throws CancellationException {
                validateProgress.run();
            }

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type) {
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            }

            @Override
            public void addFace(Object obj, Point3d p, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimProps faceProps) {
                if (getNormal == null) {
                    return;
                }
                validateProgress.run();
                double distSq = p.distanceSquared(rayOrigin);
                int compare = theUtil.compare(distSq, closestDistSq[0], 1.0E-12);
                if (compare < 0) {
                    closestResult.clear();
                    closestDistSq[0] = distSq;
                }
                if (compare <= 0) {
                    closestResult.add(new FindResult((IEgressOccupiable)obj, getNormal.get(), p));
                }
            }
        };
        DefaultFilter isectFilter = new DefaultFilter(IEgressOccupiable.class, GeomType.FACE);
        for (IEgressOccupiable room : rooms) {
            validateProgress.run();
            room.pickPoints(isectCollector, isectFilter, rayBegin, rayDir, maxT, test);
        }
        return closestResult;
    }

    private static Collection<? extends IPolygon> getPolys(IFace face, double faceError) {
        if (face instanceof IPolygon) {
            return Collections.singleton((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.getTriangles(faceError, face);
    }

    public static UnitDouble getOccOrient(Point3d loc, Point3d target) {
        Vector3d towardsTarget = new Vector3d(target.x - loc.x, target.y - loc.y, 0.0);
        double angle = Trig.angle(OccProfile.INIT_ORIENT_REF, towardsTarget);
        return new UnitDouble(angle, Geometry.ANGLE_UNIT);
    }

    public static Object getCadGeomProp(IGeomNode geom, IPropsSrc propsSrc, Object property) {
        if (property == MerlinData.MATERIAL) {
            int ucount;
            int numPrims = geom.getNumPrims(7);
            Object[] mats = new IMaterial[numPrims];
            for (int offset = 0; offset < numPrims; offset += ucount) {
                IMaterial pmat = propsSrc.get(offset).getMaterial();
                ucount = propsSrc.getUniformCount(offset, numPrims - offset);
                Arrays.fill(mats, offset, offset + ucount, pmat);
            }
            return mats;
        }
        if (property == MerlinData.COLOR) {
            int numPrims = geom.getNumPrims(7);
            if (numPrims == 0) {
                return Color.WHITE;
            }
            Color c = null;
            for (int offset = 0; offset < numPrims; offset += propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color pc = propsSrc.get(offset).getColor();
                pc = new Color(pc.getRed(), pc.getGreen(), pc.getBlue(), 255);
                if (c == null) {
                    c = pc;
                    continue;
                }
                if (c.equals(pc)) continue;
                return new NonUniformColor(c, propsSrc);
            }
            return c;
        }
        if (property == MerlinData.OPACITY) {
            int numPrims = geom.getNumPrims(7);
            if (numPrims == 0) {
                return new Opacity(0.0f);
            }
            Float alpha = null;
            for (int offset = 0; offset < numPrims; offset += propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color c = propsSrc.get(offset).getColor();
                float pAlpha = (float)c.getAlpha() / 255.0f;
                if (alpha == null) {
                    alpha = Float.valueOf(pAlpha);
                    continue;
                }
                if (theUtil.eq(alpha.floatValue(), pAlpha, 0.0)) continue;
                return new NonUniformOpacity(propsSrc);
            }
            return new Opacity(alpha.floatValue());
        }
        return ICompElement.NOT_SUPPORTED;
    }

    public static DisplayGeom setCadGeomProp(IGeomNode geom, IPropsSrc propsSrc, Object property, Object value) {
        if (property == MerlinData.MATERIAL) {
            int ucount;
            int numPrims;
            IMaterial[] mats = (IMaterial[])value;
            PropsBuilder propsBuilder = new PropsBuilder();
            int n = numPrims = mats.length != 1 ? mats.length : geom.getNumPrims(7);
            assert (numPrims == geom.getNumPrims(7));
            for (int offset = 0; offset < numPrims; offset += ucount) {
                IPrimProps pprops = propsSrc.get(offset);
                ucount = propsSrc.getUniformCount(offset, numPrims - offset);
                if (mats.length == 1) {
                    if (pprops.getMaterial() != mats[0]) {
                        pprops = pprops.setMaterial(mats[0]);
                    }
                    propsBuilder.add(pprops, ucount);
                    continue;
                }
                int end = offset + ucount;
                for (int m = offset; m < end; ++m) {
                    IPrimProps newPProps = pprops.getMaterial() != mats[m] ? pprops.setMaterial(mats[m]) : pprops;
                    propsBuilder.add(newPProps);
                }
            }
            assert (propsBuilder.size() == numPrims);
            return new DisplayGeom(geom, propsBuilder.finalizeProps());
        }
        if (property == MerlinData.COLOR) {
            int uniformCount;
            Color c = (Color)value;
            if (c instanceof NonUniformColor) {
                return new DisplayGeom(geom, ((NonUniformColor)c).originalProps);
            }
            PropsBuilder props = new PropsBuilder();
            int numPrims = geom.getNumPrims(7);
            for (int offset = 0; offset < numPrims; offset += uniformCount) {
                Color newColor;
                IPrimProps pprops = propsSrc.get(offset);
                uniformCount = propsSrc.getUniformCount(offset, numPrims - offset);
                Color oldColor = pprops.getColor();
                int alpha = oldColor.getAlpha();
                Color color = newColor = c == null ? new Color(255, 255, 255, alpha) : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                if (!newColor.equals(oldColor)) {
                    pprops = pprops.setColor(ColorPool.get(newColor));
                }
                props.add(pprops, uniformCount);
            }
            return new DisplayGeom(geom, props.finalizeProps());
        }
        if (property == MerlinData.OPACITY) {
            int uniformCount;
            if (value instanceof NonUniformOpacity) {
                return new DisplayGeom(geom, ((NonUniformOpacity)value).originalProps);
            }
            float val = ((IOpacity)value).getValue();
            int alpha = (int)(val * 255.0f);
            PropsBuilder props = new PropsBuilder();
            int numPrims = geom.getNumPrims(7);
            for (int offset = 0; offset < numPrims; offset += uniformCount) {
                IPrimProps pprops = propsSrc.get(offset);
                uniformCount = propsSrc.getUniformCount(offset, numPrims - offset);
                Color c = pprops.getColor();
                if (alpha != c.getAlpha()) {
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                    pprops = pprops.setColor(ColorPool.get(c));
                }
                props.add(pprops, uniformCount);
            }
            return new DisplayGeom(geom, props.finalizeProps());
        }
        return null;
    }

    public static void takeDepSnapshotCadGeom(DepList deps, IGeomNode node, IPropsSrc props) {
        IMaterial[] mats = (IMaterial[])GeomUtil.getCadGeomProp(node, props, MerlinData.MATERIAL);
        deps.add(DLink.WEAK, Arrays.asList(mats));
    }

    public static DisplayGeom replaceDependency(MerlinData md, Object old, Object replacement, IGeomNode node, IPropsSrc props) {
        if (old instanceof IMaterial) {
            IMaterial[] mats = (IMaterial[])GeomUtil.getCadGeomProp(node, props, MerlinData.MATERIAL);
            mats = Arrays.copyOf(mats, mats.length);
            IMaterial replMat = (IMaterial)replacement;
            Arrays.asList(mats).replaceAll(m -> m == old ? replMat : m);
            return GeomUtil.setCadGeomProp(node, props, MerlinData.MATERIAL, mats);
        }
        return null;
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, IPropsSrc props) {
        int numPrims = geom.getNumPrims(7);
        boolean needsTexCoords = IntStream.range(0, numPrims).mapToObj(i -> props.get(i).getMaterial()).filter(m -> m != null).anyMatch(m -> m.getAttributes().hasTexture());
        return GeomUtil.finalizeTexCoords(geom, needsTexCoords);
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, IMaterial mat) {
        return GeomUtil.finalizeTexCoords(geom, mat != null && mat.getAttributes().hasTexture());
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, boolean needsTexCoords) {
        if (!needsTexCoords) {
            return geom;
        }
        geom = geom.applyUVElements((uvset, ix, oldEl) -> oldEl == Elements.NO_UV ? DEFUV : oldEl);
        geom = geom.applyDefaultUVElements(DEFUV);
        return geom;
    }

    public static Model toNmtModel(MerlinData md, IGeomNode node, int groupId) {
        double edgeErr = 1.0E-6;
        double faceErr = 1.0E-6;
        if (md != null) {
            edgeErr = md.simParams.edgeError;
            faceErr = md.simParams.faceError;
        }
        return GeomUtil.toNmtModel(node, groupId, edgeErr, faceErr);
    }

    public static Model toNmtModel(IGeomNode node, int groupId, double edgeErr, double faceErr) {
        Model result = new Model();
        IGeomNode fgeom = node.flatten();
        assert (fgeom.getNumPrims(7) == fgeom.getNumPrims(1));
        IElemSource<Elements.Orient> orients = fgeom.getElements(Elements.ORIENT);
        Iterator<Elements.Orient> orientIt = orients.getPerPrimIterator();
        List<IFace> faces = thunderheadeng.geometry.objs.GeomUtil.explode(fgeom.getLocalGeom(), IFace.class);
        for (IFace face : faces) {
            boolean ccw = orientIt.next().isCCW();
            GeomUtil.addFaceToModel(face, ccw, result, groupId, edgeErr, faceErr);
        }
        return result;
    }

    public static Set<Face> findTouchingFaces(Face seed, Predicate<Edge> boundaryEdgeTest, Predicate<Face> boundaryTriTest) {
        LinkedIdentityHashSet<Face> closed = new LinkedIdentityHashSet<Face>();
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.addLast(seed);
        closed.add(seed);
        while (!open.isEmpty()) {
            Face face = (Face)open.pollLast();
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (boundaryEdgeTest.test(eu.edge)) continue;
                    for (Face adjFace : eu.edge.faces) {
                        if (boundaryTriTest.test(adjFace) || !closed.add(adjFace)) continue;
                        open.addLast(adjFace);
                    }
                }
            }
        }
        return closed;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> RoomObjectIsectInfo<T> isectRoomWithObjects(Model model, Collection<? extends T> objects, Function<T, Model> getObjectModel) {
        if (objects.isEmpty()) {
            return new RoomObjectIsectInfo(Collections.emptyMap(), model);
        }
        LinkedIdentityHashMap<Object, Integer> blockageIds = new LinkedIdentityHashMap<Object, Integer>();
        Object[] blkgArr = theUtil.toArray(objects);
        Model[] blkgModels = theUtil.toArray(theUtil.map(objects, obj -> (Model)getObjectModel.apply(obj)));
        int idBlkgBoundary = 100;
        int idOffset = idBlkgBoundary + 1;
        IntPredicate isBlkgId = id -> id == idBlkgBoundary;
        IntUnaryOperator getBlkgId = blkgIx -> idOffset + blkgIx;
        IntFunction<Object> getBlkg = blkgId -> blkgArr[blkgId - idOffset];
        for (int m = 0; m < blkgArr.length; ++m) {
            Model blkgModel = blkgModels[m].clone();
            int[] id2 = new int[]{getBlkgId.applyAsInt(m), idBlkgBoundary};
            for (Face face3 : blkgModel.getFaces()) {
                face3.groups = id2;
            }
            for (Edge edge2 : blkgModel.getEdges()) {
                edge2.groups = id2;
            }
            for (Vertex vertex : blkgModel.getVerts()) {
                vertex.groups = id2;
            }
            model.merge(blkgModel);
            ArrayList<Face> delFaces = new ArrayList<Face>(model.getFaces(face -> NmtUtil.equal(face.groups, id2)));
            for (Face face3 : delFaces) {
                model.deleteFace(face3, true, true);
            }
        }
        LinkedIdentityHashSet closedFaces = new LinkedIdentityHashSet();
        for (Face seedFace : model.getFaces()) {
            void var15_26;
            if (closedFaces.contains(seedFace)) continue;
            Predicate<Edge> boundaryEdges = Predicates.alwaysFalse();
            Predicate predicate = Predicates.alwaysFalse();
            if (seedFace.testGroups(isBlkgId)) {
                Predicate<Face> predicate2 = face2 -> !NmtUtil.equal(face.groups, face2.groups);
            } else {
                boundaryEdges = edge -> edge.partOfGroup(idBlkgBoundary);
            }
            Set<Face> touching = GeomUtil.findTouchingFaces(seedFace, boundaryEdges, (Predicate<Face>)var15_26);
            closedFaces.addAll(touching);
            Optional<Point3d> testPoint = touching.stream().map(f -> model.findPointInFace((Face)f)).filter(p -> p != null).findFirst();
            if (!testPoint.isPresent()) continue;
            Point3d facePoint = testPoint.get();
            ArrayList<Integer> faceBlockages = new ArrayList<Integer>();
            for (int m = 0; m < blkgArr.length; ++m) {
                Model blkgModel = blkgModels[m];
                int blkgId2 = getBlkgId.applyAsInt(m);
                if (!NmtUtil.findGroup(seedFace.groups, blkgId2) && !blkgModel.contains(facePoint)) continue;
                faceBlockages.add(blkgId2);
            }
            if (faceBlockages.isEmpty()) continue;
            int[] faceBlkgIds = theUtil.toIntArray(faceBlockages);
            for (Face face4 : touching) {
                face4.addGroups(faceBlkgIds);
            }
            for (Object blkgId3 : (Object)faceBlkgIds) {
                blockageIds.put(getBlkg.apply((int)blkgId3), (int)blkgId3);
            }
        }
        if (blockageIds.isEmpty()) {
            return new RoomObjectIsectInfo(Collections.emptyMap(), model);
        }
        Consumer<Collection> remBlkgBoundaryId = coll -> {
            for (AModelObj obj : coll) {
                obj.removeGroup(idBlkgBoundary);
            }
        };
        remBlkgBoundaryId.accept(model.getFaces(idBlkgBoundary));
        remBlkgBoundaryId.accept(model.getEdges(idBlkgBoundary));
        remBlkgBoundaryId.accept(model.getVerts(idBlkgBoundary));
        return new RoomObjectIsectInfo(blockageIds, model);
    }

    public static class RoomObjectIsectInfo<T> {
        public final Model model;
        public final Map<T, Integer> objIdMap;

        public RoomObjectIsectInfo(Map<T, Integer> idBlkgMap, Model model) {
            this.objIdMap = idBlkgMap;
            this.model = model;
        }

        public int getFaceId(T obj) {
            return this.objIdMap.getOrDefault(obj, -1);
        }

        public Collection<Face> getFaces(T obj) {
            Integer id = this.objIdMap.get(obj);
            if (id == null) {
                return Collections.emptyList();
            }
            return this.model.getFaces(id);
        }

        public boolean isEmpty() {
            return this.objIdMap.isEmpty();
        }
    }

    private static class NonUniformOpacity
    implements IOpacity {
        public final IPropsSrc originalProps;

        public NonUniformOpacity(IPropsSrc originalProps) {
            this.originalProps = originalProps;
        }

        @Override
        public float getValue() {
            return (float)this.originalProps.get(0).getColor().getAlpha() / 255.0f;
        }
    }

    private static class NonUniformColor
    extends Color {
        private static final long serialVersionUID = -4143879041991746149L;
        public final IPropsSrc originalProps;

        public NonUniformColor(Color subColor, IPropsSrc originalProps) {
            super(subColor.getRed(), subColor.getGreen(), subColor.getBlue(), subColor.getAlpha());
            this.originalProps = originalProps;
        }
    }

    public static class LocationHandle
    implements IHandle {
        private ACircleGeometry d_geom;
        private GEOM_TYPE d_geomType;

        public LocationHandle(ACircleGeometry geom) {
            this(geom, GEOM_TYPE.POINT);
        }

        public LocationHandle(ACircleGeometry geom, GEOM_TYPE type) {
            this.d_geom = geom;
            this.d_geomType = type;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof LocationHandle;
        }

        @Override
        public IGeomNode getGeom() {
            if (this.d_geomType.equals((Object)GEOM_TYPE.POINT)) {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location));
            }
            if (this.d_geomType.equals((Object)GEOM_TYPE.AREA)) {
                return GeomNodeUtil.newNode(this.d_geom);
            }
            assert (false);
            return null;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ACircleGeometry modify(Point3d newLoc) throws ManipException {
            MerlinData md = MerlinApp.getApp().getData();
            try (MerlinData.ReadLock lock = md.lockRead();){
                FindResult result = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 0);
                if (result == null) {
                    throw new ManipException();
                }
                ACircleGeometry aCircleGeometry = this.d_geom = this.d_geom.getConstructedTransform(result.room, result.faceNormal, result.p, this.d_geom.radius);
                return aCircleGeometry;
            }
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }

        public static enum GEOM_TYPE {
            POINT,
            AREA;

        }
    }

    public static class RadiusHandle
    implements IHandle {
        private ACircleGeometry d_geom;

        public RadiusHandle(ACircleGeometry geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof RadiusHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(ACircleGeometry.generateCircle(this.d_geom.location, this.d_geom.radius, this.d_geom.normal));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ACircleGeometry modify(Point3d newLoc) throws ManipException {
            double newRadius = newLoc.distance(this.d_geom.location);
            this.d_geom = this.d_geom.getConstructedTransform(this.d_geom.room, this.d_geom.normal, this.d_geom.location, newRadius);
            return this.d_geom;
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }
    }

    public static abstract class ACircleGeometry
    extends GeomGroup {
        private static final long serialVersionUID = 6462995199370786383L;
        public final IEgressOccupiable room;
        public final Vector3d normal;
        public final Point3d location;
        public final double radius;

        public ACircleGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double radius, IGeom ... additionalGeoms) {
            this(room, normal, location, radius, true, additionalGeoms);
        }

        public ACircleGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double radius, boolean solid, IGeom ... additionalGeoms) {
            super(ACircleGeometry.generateGeoms(location, radius, normal, solid, additionalGeoms));
            this.room = room;
            this.location = location;
            this.normal = normal;
            this.radius = radius;
        }

        private static List<IGeom> generateGeoms(Point3d location, double radius, Vector3d normal, boolean solid, IGeom ... additionalGeom) {
            ArrayList<IGeom> geoms = new ArrayList<IGeom>();
            ShapeGeom cgeom = ACircleGeometry.generateCircle(location, radius, normal);
            geoms.add(cgeom);
            if (solid) {
                Area area = new Area(cgeom.shape);
                ShapeGeom ageom = new ShapeGeom((Shape)area, cgeom.lwXform);
                geoms.add(ageom);
            }
            Point pgeom = new Point(location);
            geoms.add(pgeom);
            geoms.addAll(Arrays.asList(additionalGeom));
            return geoms;
        }

        public static ShapeGeom generateCircle(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Ellipse2D.Double circle = ShapeUtil.newCircle(arriveRadius);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        public static ShapeGeom generateOutline(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Arc2D.Double circle = ShapeUtil.newCircularArc(0.0, 0.0, arriveRadius, 0.0, Math.PI * 2, true);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Vector3d scaleVec = Util3D.xform(xform, new Vector3d(this.radius, 0.0, 0.0));
            double newRadius = scaleVec.length();
            Point3d newLoc = Util3D.xform(xform, this.location);
            FindResult result = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 1);
            return this.constructTransformedGeom(result, newLoc, newRadius);
        }

        protected abstract IGeom constructTransformedGeom(FindResult var1, Point3d var2, double var3);

        @Override
        public abstract void generateManipHandles(Consumer<? super IHandle> var1);

        public abstract ACircleGeometry getConstructedTransform(IEgressOccupiable var1, Vector3d var2, Point3d var3, double var4);
    }

    public static class FindResult {
        public final IEgressOccupiable room;
        public final Vector3d faceNormal;
        public final Point3d p;

        public FindResult(IEgressOccupiable room, Vector3d faceNormal, Point3d p) {
            this.room = room;
            this.faceNormal = faceNormal;
            this.p = p;
        }

        public Plane3d getPlane() {
            return new Plane3d(this.faceNormal, this.p);
        }
    }
}

