/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import common.data.WaitMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.AssistedEvacTeam;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.AWaitAction;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;

public class WaitForAssistance
extends AWaitAction
implements IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Set<AssistedEvacTeam>> TEAMS = new IPropertySet.Prop("WaitForAssistance.TEAMS", Collections.emptySet());
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(AWaitAction.PROP_TYPES, TEAMS);

    public WaitForAssistance(Set<AssistedEvacTeam> teams) {
        this.set(TEAMS, teams instanceof Set ? teams : new LinkedIdentityHashSet(teams));
        this.set(MODE, WaitMode.WAIT_IN_PLACE_COLLISIONS);
    }

    public Predicate<AssistedEvacTeam> getTeamFilter() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        return teams.isEmpty() ? Predicates.alwaysTrue() : Filters.accept(teams);
    }

    @Override
    public WaitForAssistance clone() {
        return (WaitForAssistance)super.clone();
    }

    @Override
    public WaitForAssistance getRestoreObj() {
        return (WaitForAssistance)super.getRestoreObj();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        if (teams.size() == 1) {
            return String.format(Intl.intl("Wait for assistance <%s>"), teams.iterator().next().getName());
        }
        if (teams.isEmpty()) {
            return Intl.intl("Wait for assistance <any team>");
        }
        return Intl.intl("Wait for assistance");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet newTeams = new LinkedIdentityHashSet((Collection)this.get(TEAMS));
        newTeams.remove(old);
        if (replacement != null && replacement instanceof AssistedEvacTeam) {
            newTeams.add((AssistedEvacTeam)replacement);
        }
        this.set(TEAMS, newTeams);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        for (AssistedEvacTeam team : this.get(TEAMS)) {
            deps.add(DLink.WEAK, team);
        }
    }
}

