/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import merlin.data.stat.CurveUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public interface IWaitUntilSrc {
    public static SimpleWaitUntilSrc convertToSimple(IWaitUntilSrc oldSrc) {
        if (oldSrc instanceof CycledWaitUntilSrc) {
            return new SimpleWaitUntilSrc(((CycledWaitUntilSrc)oldSrc).d_initialTime);
        }
        if (oldSrc instanceof ListedWaitUntilSrc) {
            ICurve waitTime = ((ListedWaitUntilSrc)oldSrc).d_goTimes.stream().findFirst().orElse(new ConstantCurve(new UnitDouble(0.0, SI.SECOND)));
            return new SimpleWaitUntilSrc(waitTime);
        }
        if (oldSrc instanceof SimpleWaitUntilSrc) {
            return (SimpleWaitUntilSrc)oldSrc;
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static ListedWaitUntilSrc convertToList(IWaitUntilSrc oldSrc) {
        if (oldSrc instanceof CycledWaitUntilSrc) {
            return new ListedWaitUntilSrc(Arrays.asList(CurveUtil.toConstantCurve(((CycledWaitUntilSrc)oldSrc).d_initialTime, 1)));
        }
        if (oldSrc instanceof ListedWaitUntilSrc) {
            return (ListedWaitUntilSrc)oldSrc;
        }
        if (oldSrc instanceof SimpleWaitUntilSrc) {
            return new ListedWaitUntilSrc(Arrays.asList(CurveUtil.toConstantCurve(((SimpleWaitUntilSrc)oldSrc).d_waitTime, 1)));
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static CycledWaitUntilSrc convertToIntervals(IWaitUntilSrc oldSrc) {
        if (oldSrc instanceof ListedWaitUntilSrc) {
            ICurve time = ((ListedWaitUntilSrc)oldSrc).d_goTimes.stream().findFirst().orElse(new ConstantCurve(new UnitDouble(0.0, SI.SECOND)));
            return new CycledWaitUntilSrc(time, new ConstantCurve(new UnitDouble(5.0, SI.SECOND)));
        }
        if (oldSrc instanceof CycledWaitUntilSrc) {
            return (CycledWaitUntilSrc)oldSrc;
        }
        if (oldSrc instanceof SimpleWaitUntilSrc) {
            return new CycledWaitUntilSrc(((SimpleWaitUntilSrc)oldSrc).d_waitTime, new ConstantCurve(new UnitDouble(5.0, SI.SECOND)));
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ListedWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1L;
        public final List<ICurve> d_goTimes;

        public ListedWaitUntilSrc(List<ICurve> goTimes) {
            this.d_goTimes = Collections.unmodifiableList(goTimes);
        }

        public int hashCode() {
            int hash = 7;
            return 31 * hash + theUtil.hashCode(this.d_goTimes);
        }

        public boolean equals(Object comparable) {
            return comparable != null && this.getClass() == comparable.getClass() && this.d_goTimes.equals(((ListedWaitUntilSrc)comparable).d_goTimes);
        }
    }

    public static class CycledWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ICurve d_initialTime;
        public final ICurve d_intervalTime;

        public CycledWaitUntilSrc(ICurve initTime, ICurve intervalTime) {
            this.d_initialTime = initTime;
            this.d_intervalTime = intervalTime;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_intervalTime);
            hash = 31 * hash + theUtil.hashCode(this.d_initialTime);
            return hash;
        }

        public boolean equals(Object comparable) {
            return comparable != null && this.getClass() == comparable.getClass() && this.d_initialTime.equals(((CycledWaitUntilSrc)comparable).d_initialTime) && this.d_intervalTime.equals(((CycledWaitUntilSrc)comparable).d_intervalTime);
        }
    }

    public static class SimpleWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1059401209432914162L;
        public final ICurve d_waitTime;

        public SimpleWaitUntilSrc(ICurve waitTime) {
            this.d_waitTime = waitTime;
        }

        public int hashCode() {
            int hash = 7;
            return 31 * hash + theUtil.hashCode(this.d_waitTime);
        }

        public boolean equals(Object comparable) {
            return comparable != null && this.getClass() == comparable.getClass() && this.d_waitTime.equals(((SimpleWaitUntilSrc)comparable).d_waitTime);
        }
    }
}

