/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.egress.geom.RoomUtil;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Ray3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.FlattenIterator;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.scene3d.picking.PointConstraint;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class EgressModelGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public static final int OPT_SNAP_TO_CREASES = 1;
    public static final int OPT_MANIP = 2;
    public static final int OPT_OPTIMIZE_FOR_DISPLAY = 4;
    public final Model model;
    public final Predicate<Edge> inUseEdgeFilter;
    public final Predicate<Edge> edgeFilter;
    public final Predicate<Face> faceFilter;
    public final int options;
    private final int d_numEdges;

    public EgressModelGeom(Model geometry) {
        this(geometry, Filters.rejectAll(Edge.class), Filters.acceptAll(Face.class), Filters.acceptAll(Edge.class), 0);
    }

    public EgressModelGeom(Model geometry, Predicate<Edge> inUseEdgeFilter, Predicate<Face> faceFilter, Predicate<Edge> edgeFilter, int options) {
        this.model = geometry;
        this.inUseEdgeFilter = inUseEdgeFilter;
        this.faceFilter = faceFilter;
        this.edgeFilter = edgeFilter;
        this.options = options;
        this.d_numEdges = EgressModelGeom.countEdges(geometry, edgeFilter);
    }

    protected boolean opt(int option) {
        return (this.options & option) == option;
    }

    protected static boolean test(int options, int option) {
        return (options & option) == option;
    }

    private static int countEdges(Model model, Predicate<Edge> eFilter) {
        int count = 0;
        for (Face face : model.getFaces()) {
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (!eFilter.test(eu.edge)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public IGeom optimize(IPointOptimizer pointOptimizer) {
        Model mclone = EgressModelGeom.optimize(pointOptimizer, this.model);
        return new EgressModelGeom(mclone, this.inUseEdgeFilter, this.faceFilter, this.edgeFilter, this.options);
    }

    protected Collection<Face> getFaces() {
        return theUtil.filter(this.model.getFaces(), this.faceFilter);
    }

    protected Collection<Face> findFaces(ITest<AABox> test) {
        return theUtil.filter(this.model.findFaces(test), this.faceFilter);
    }

    protected Collection<Edge> getEdges() {
        return theUtil.filter(this.model.getEdges(), this.edgeFilter);
    }

    protected Collection<Edge> findEdges(ITest<AABox> test) {
        return theUtil.filter(this.model.findEdge(test), this.edgeFilter);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.model.getBoundingBox());
        return aabb;
    }

    @Override
    public int getNumPrims(int types) {
        int count = 0;
        if ((types & 1) != 0) {
            count = this.opt(4) ? ++count : (count += this.getFaces().size());
        }
        if ((types & 2) != 0) {
            count += this.d_numEdges;
        }
        return count;
    }

    @Override
    public Iterator<Byte> iteratePrimTypes(int offset) {
        int numFaces = this.getNumPrims(1);
        if (offset < numFaces) {
            int numCurves = this.getNumPrims(2);
            return new FlattenIterator<Byte>(Collections.singleton(theUtil.iterate((byte)2, numCurves)).iterator(), theUtil.iterate((byte)1, offset));
        }
        return theUtil.iterate((byte)2, offset - numFaces);
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    public void getFaceGeom(Consumer<IGeom> prims) {
        if (this.opt(4)) {
            prims.accept(this.getSingleFace());
        } else {
            for (Face face : this.getFaces()) {
                IFace iface = GeomUtil.toGeomFace(face);
                if (iface == null) continue;
                prims.accept(iface);
            }
        }
    }

    public void getEdgeGeom(Consumer<IGeom> prims) {
        EgressModelGeom.getEdgeGeom(this.model, this.edgeFilter, prims);
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        this.getFaceGeom(prims::add);
        this.getEdgeGeom(prims::add);
        return prims;
    }

    private static Collection<IGeom> getEdgeGeom(Model model, Predicate<Edge> eFilter, Collection<IGeom> geom) {
        EgressModelGeom.getEdgeGeom(model, eFilter, geom::add);
        return geom;
    }

    private static void getEdgeGeom(Model model, Predicate<Edge> eFilter, Consumer<IGeom> geom) {
        LinkedIdentityHashMap<Point3d, Integer> vertIxMap = new LinkedIdentityHashMap<Point3d, Integer>();
        ArrayList<Integer> vertLocs = new ArrayList<Integer>();
        for (Face face : model.getFaces()) {
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (!eFilter.test(eu.edge)) continue;
                    IParametric3D curve = eu.curve();
                    if (curve.isLinear()) {
                        Point3d p1 = curve.get(0.0);
                        Point3d p2 = curve.get(1.0);
                        int i1 = EgressModelGeom.indexOf(p1, vertIxMap);
                        int i2 = EgressModelGeom.indexOf(p2, vertIxMap);
                        vertLocs.add(i1);
                        vertLocs.add(i2);
                        continue;
                    }
                    geom.accept(GeomUtil.toGeomCurve(curve));
                }
            }
        }
        if (!vertLocs.isEmpty()) {
            geom.accept(new Mesh(vertIxMap.keySet().toArray(new Point3d[vertIxMap.size()]), theUtil.toIntArray(vertLocs), 1));
        }
    }

    private static void getEdges(Model model, Predicate<Edge> edgeFilter, Collection<? super ICurve> curves) {
        for (IGeom geom : EgressModelGeom.getEdgeGeom(model, edgeFilter, new ArrayList<IGeom>())) {
            curves.addAll(thunderheadeng.geometry.objs.GeomUtil.explode(geom, ICurve.class));
        }
    }

    private static int indexOf(Point3d p, Map<Point3d, Integer> vertIxMap) {
        Integer ix = vertIxMap.get(p);
        if (ix == null) {
            ix = vertIxMap.size();
            vertIxMap.put(p, ix);
        }
        return ix;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.INVERTIBLE;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Model mclone = GeomUtil.transform(this.model, ti.xform, ti.getMatrix());
        return new EgressModelGeom(mclone, this.inUseEdgeFilter, this.faceFilter, this.edgeFilter, options);
    }

    @Override
    public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
        this.getSingleFace().pickBox(source, visFaceEdges, filter, region, isects);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        this.getSingleFace().pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        if (this.opt(4)) {
            result.mark(this.getSingleFace(), Containment.INTERSECTS);
        } else {
            for (Face face : this.findFaces(test)) {
                IFace iface = GeomUtil.toGeomFace(face);
                if (iface == null) continue;
                result.mark(iface, Containment.INTERSECTS);
            }
        }
        for (IGeom geom : EgressModelGeom.getEdgeGeom(this.model, this.edgeFilter, new ArrayList<IGeom>())) {
            geom.find(test, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom geom : this.explode(new ArrayList<IGeom>())) {
            geom.getAll(result);
        }
    }

    private EgressModelFace getSingleFace() {
        return new EgressModelFace(this.model, this.faceFilter, this.edgeFilter, this.options);
    }

    private static Model optimize(IPointOptimizer pointOptimizer, Model model) {
        Model mclone = model.clone();
        mclone.optimize();
        for (Vertex v : mclone.getVerts()) {
            v.loc = pointOptimizer.getExisting(v.loc);
        }
        return mclone;
    }

    @Override
    public void generateManipHandles(Consumer<? super IHandle> handles) {
        if (!this.opt(2)) {
            return;
        }
        for (Vertex vert : this.model.getVerts()) {
            handles.accept(new VertHandle(this, vert));
        }
    }

    private static class VertHandle
    implements IHandle {
        private EgressModelGeom d_geom;
        private Model d_origGeom;
        private Vertex d_origVert;
        private Model d_modGeom;
        private Vertex d_modVert;
        private ISnapConstraint d_constraint;

        public VertHandle(EgressModelGeom origGeom, Vertex origVert) {
            this.d_geom = origGeom;
            this.d_origGeom = origGeom.model;
            this.d_origVert = origVert;
            this.d_modGeom = null;
            this.d_modVert = null;
            this.d_constraint = null;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && ((VertHandle)obj).getVertGeom().loc.epsilonEquals(this.getVertGeom().loc, 1.0E-6);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.getVertGeom());
        }

        public Point getVertGeom() {
            Point3d loc = this.d_modVert != null ? this.d_modVert.loc : this.d_origVert.loc;
            return new Point(loc);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            if (this.d_constraint == null) {
                this.d_constraint = this.generateConstraint(this.d_origVert);
            }
            return this.d_constraint;
        }

        private ISnapConstraint generateConstraint(Vertex vert) {
            Vector3d constrainedDir = null;
            block0: for (Edge edge : vert.edges) {
                if (edge.faces.size() < 2) continue;
                Plane3d plane1 = edge.faces.get((int)0).plane;
                Plane3d plane1n = plane1.negate();
                for (int m = 1; m < edge.faces.size(); ++m) {
                    Plane3d plane2 = edge.faces.get((int)m).plane;
                    if (plane1.epsilonEquals(plane2, 1.0E-6) || plane1n.epsilonEquals(plane2, 1.0E-6)) continue;
                    Vector3d dir = edge.curve.getTangent(0.0);
                    dir.normalize();
                    if (constrainedDir == null) {
                        constrainedDir = dir;
                        continue block0;
                    }
                    double dot = constrainedDir.dot(dir);
                    if (theUtil.eq(Math.abs(dot), 1.0, 1.0E-6)) continue block0;
                    return new PointConstraint(vert.loc);
                }
            }
            if (constrainedDir != null) {
                return new LineConstraint(vert.loc, constrainedDir);
            }
            if (!vert.edges.isEmpty()) {
                assert (!vert.edges.get((int)0).faces.isEmpty());
                return new PlanarConstraint(vert.edges.get((int)0).faces.get((int)0).plane);
            }
            assert (vert.face != null);
            return new PlanarConstraint(vert.face.plane);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.d_modGeom = this.d_origGeom.clone();
            for (Vertex vert : this.d_modGeom.getVerts()) {
                if (!vert.loc.equals(this.d_origVert.loc)) continue;
                this.d_modVert = vert;
                break;
            }
        }

        @Override
        public EgressModelGeom modify(Point3d newLoc) throws ManipException {
            this.d_modVert.loc = newLoc;
            Model model = new Model();
            for (Face face : this.d_modGeom.getFaces()) {
                ArrayList<LineSeg3D> faceCurves = new ArrayList<LineSeg3D>();
                ArrayList<int[]> edgeGroups = new ArrayList<int[]>();
                for (FaceLoop loop : face.edgeLoops) {
                    if (loop.edges.isEmpty()) continue;
                    Vertex prev = loop.edges.get(loop.edges.size() - 1).v2();
                    for (EdgeUse eu : loop.edges) {
                        LineSeg3D curve = new LineSeg3D(prev.loc, eu.v2().loc);
                        faceCurves.add(curve);
                        edgeGroups.add(eu.edge.groups);
                        prev = eu.v2();
                    }
                }
                model.addFace(face.plane, faceCurves, face.groups, edgeGroups, Collections.emptyList());
            }
            int[] boundGroup = new int[]{1};
            for (Edge edge : model.getEdges()) {
                if (VertHandle.isInternal(edge)) continue;
                edge.groups = boundGroup;
            }
            this.d_geom = new EgressModelGeom(model, this.d_geom.inUseEdgeFilter, this.d_geom.faceFilter, this.d_geom.edgeFilter, this.d_geom.options);
            return this.d_geom;
        }

        @Override
        public EgressModelGeom end() {
            this.d_modGeom = null;
            this.d_modVert = null;
            this.d_constraint = null;
            this.d_geom = new EgressModelGeom(RoomUtil.cleanup(this.d_geom.model, 31, this.d_geom.inUseEdgeFilter), this.d_geom.inUseEdgeFilter, this.d_geom.faceFilter, this.d_geom.edgeFilter, this.d_geom.options);
            return this.d_geom;
        }

        private static boolean isInternal(Edge edge) {
            if (edge.faces.size() > 1) {
                return true;
            }
            if (edge.faces.isEmpty()) {
                return false;
            }
            Face face = edge.faces.get(0);
            return face.isInternalEdge(edge);
        }
    }

    public static class EgressModelFace
    extends AFace {
        private static final long serialVersionUID = 1L;
        public final Model model;
        public final Predicate<Face> faceFilter;
        public final Predicate<Edge> edgeFilter;
        public final int options;

        public EgressModelFace(Model geometry, Predicate<Face> faceFilter, Predicate<Edge> edgeFilter, int options) {
            this.model = geometry;
            this.faceFilter = faceFilter;
            this.edgeFilter = edgeFilter;
            this.options = options;
        }

        @Override
        public Point3d project(Point3d p) {
            return null;
        }

        @Override
        public EgressModelFace flipOrient() {
            return this;
        }

        @Override
        public void getBoundary(List<ICurve> boundary) {
            EgressModelGeom.getEdges(this.model, this.edgeFilter, boundary);
        }

        @Override
        public IFace optimize(IPointOptimizer pointOptimizer) {
            Model mclone = EgressModelGeom.optimize(pointOptimizer, this.model);
            return new EgressModelFace(mclone, this.faceFilter, this.edgeFilter, this.options);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.FREE;
        }

        @Override
        public IFace transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Model mclone = GeomUtil.transform(this.model, ti.xform, ti.getMatrix());
            return new EgressModelFace(mclone, this.faceFilter, this.edgeFilter, options);
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            aabb.add(this.model.getBoundingBox());
            return aabb;
        }

        protected Collection<Face> getFaces() {
            return theUtil.filter(this.model.getFaces(), this.faceFilter);
        }

        protected Collection<Face> findFaces(ITest<AABox> test) {
            return theUtil.filter(this.model.findFaces(test), this.faceFilter);
        }

        protected Collection<Edge> getEdges() {
            return theUtil.filter(this.model.getEdges(), this.edgeFilter);
        }

        protected Collection<Edge> findEdges(ITest<AABox> test) {
            return theUtil.filter(this.model.findEdge(test), this.edgeFilter);
        }

        @Override
        public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
            LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
            ArrayList<Integer> resultTris = new ArrayList<Integer>();
            for (Face face : this.getFaces()) {
                face.triangulate(Face.NO_REFINEMENT, pointIxMap, resultTris);
            }
            return new Pair<Mesh, Boolean>(new Mesh(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), theUtil.toIntArray(resultTris), 2), true);
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull box, IBoxCollector isects) throws CancelObjectPicking {
            if (filter.acceptGeomType(source, GeomType.FACE)) {
                for (Face face : this.findFaces(box)) {
                    IFace oface = face.toGeomFace();
                    oface.pickBox(source, visFaceEdges, filter, box, isects);
                }
            }
            if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                for (Edge edge : this.model.findEdge(box)) {
                    boolean testEdge = this.edgeFilter.test(edge) || EgressModelGeom.test(this.options, 1) && EgressModelFace.isCrease(edge);
                    if (!testEdge) continue;
                    LineSeg ls = new LineSeg(edge.v1.loc, edge.v2.loc);
                    ls.pickBox(source, visFaceEdges, filter, box, isects);
                }
            }
            if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                for (Vertex vert : this.model.findVerts(box)) {
                    for (Edge edge : vert.edges) {
                        if (!this.edgeFilter.test(edge) || !box.contains(vert.loc)) continue;
                        isects.addNonFace(source);
                    }
                }
            }
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            if (filter.acceptGeomType(source, GeomType.FACE)) {
                Ray3d testCurve = new Ray3d(rayBegin, rayDirN, maxDist);
                double closestIsect = Double.MAX_VALUE;
                ArrayList<Plane3d> closestFacePlanes = new ArrayList<Plane3d>();
                int closestFaceIndex = 0;
                for (Face face : this.findFaces(tester)) {
                    Pair<Double, Model.FaceClassify>[] isect = this.model.isect(testCurve, face, NmtUtil.acceptPointsOnFace(), 1.0E-6);
                    if (isect.length == 0) continue;
                    int compare = theUtil.compare((Double)isect[0].v1, closestIsect, 1.0E-9);
                    if (compare < 0) {
                        closestIsect = (Double)isect[0].v1;
                        closestFacePlanes.clear();
                        closestFacePlanes.add(face.plane);
                        continue;
                    }
                    if (compare != 0) continue;
                    closestFacePlanes.add(face.plane);
                }
                for (Plane3d closestFacePlane : closestFacePlanes) {
                    Vector3d normal = closestFacePlane.getNormal();
                    isects.addFace(source, testCurve.get(closestIsect), closestFaceIndex, () -> this, () -> normal);
                }
            }
            if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                for (Edge edge : this.model.findEdge(tester)) {
                    double[] isect;
                    boolean testEdge = this.edgeFilter.test(edge) || EgressModelGeom.test(this.options, 1) && EgressModelFace.isCrease(edge);
                    if (!testEdge || (isect = Inter3D.rayLineSegProximityT(rayBegin, rayDirN, maxDist, edge.v1.loc, edge.v2.loc, 1.0E-6)) == null) continue;
                    Point3d closest = Util3D.linesegPoint(edge.v1.loc, edge.v2.loc, isect[1]);
                    isects.addNonFace(source, closest, GeomType.FACE_EDGE);
                }
            }
            if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                block3: for (Vertex vert : this.model.findVerts(tester)) {
                    for (Edge edge : vert.edges) {
                        if (!this.edgeFilter.test(edge)) continue;
                        isects.addNonFace(source, vert.loc, GeomType.FACE_VERTEX);
                        continue block3;
                    }
                }
            }
        }

        private static boolean isCrease(Edge edge) {
            if (edge.faces.size() == 0) {
                return false;
            }
            Plane3d p1 = edge.faces.get((int)0).plane;
            for (int m = 1; m < edge.faces.size(); ++m) {
                Plane3d p2 = edge.faces.get((int)m).plane;
                if (p1.epsilonEquals(p2, 1.0E-6) && p1.epsilonEquals(p2.negate(), 1.0E-6)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IFace.PointClassify classify(Point3d p, double tol) {
            Pair<Face, Model.FaceClassify> face = this.model.findFace(p, NmtUtil.acceptPointsOnFace());
            if (face == null || !this.faceFilter.test((Face)face.v1)) {
                return IFace.PointClassify.OUTSIDE;
            }
            switch ((Model.FaceClassify)((Object)face.v2)) {
                case INSIDE: {
                    return IFace.PointClassify.INSIDE;
                }
                case ON_EDGE: {
                    return IFace.PointClassify.ON_BOUNDARY;
                }
            }
            return IFace.PointClassify.OUTSIDE;
        }
    }
}

