/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import merlin.Intl;
import merlin.data.egress.agents.IAvatar;
import thunderheadeng.gui.Application;
import thunderheadeng.io.FilenameManager;

public class ResourceAvatar
implements IAvatar,
Serializable {
    static final long serialVersionUID = 1L;
    public static Image EMPTY_PREVIEW_IMAGE = new BufferedImage(100, 200, 2);
    private static File s_avatarDir = null;
    private static File s_localAvatarDir = null;
    private static File s_pgmDataAvatarDir = null;
    public final String path;
    private transient String cachedName;
    private transient File d_canonicalFile;
    private static Map<String, Image> PREVIEW_CACHE = new Hashtable<String, Image>();
    private static String[] AVATAR_EXTENSIONS = new String[]{".bea"};

    private static synchronized File getAppAvatarDir() {
        if (s_avatarDir == null) {
            String idir = Application.getApp().getInstallDir();
            FileSystem fs = FileSystems.getDefault();
            PathMatcher matcher = fs.getPathMatcher("glob:**.bea");
            for (String libDir : Application.getApp().getResourcePaths().getDirs()) {
                Path p = fs.getPath(idir, libDir, "models");
                try {
                    Optional<Path> model = Files.find(p, Integer.MAX_VALUE, (path, attr) -> matcher.matches((Path)path), FileVisitOption.FOLLOW_LINKS).findAny();
                    if (!model.isPresent()) continue;
                    s_avatarDir = p.toAbsolutePath().toFile();
                    break;
                }
                catch (NoSuchFileException model) {
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            if (s_avatarDir == null) {
                s_avatarDir = new File(Application.getApp().getInstallDir(), "lib/models/");
            }
        }
        return s_avatarDir;
    }

    private static synchronized File getUserAvatarDir() {
        if (s_localAvatarDir == null) {
            s_localAvatarDir = new File(Application.getApp().getAppDataDir(), "models");
        }
        return s_localAvatarDir;
    }

    private static synchronized File getGlobalAvatarDir() {
        if (s_pgmDataAvatarDir == null) {
            s_pgmDataAvatarDir = new File(Application.getApp().getProgramDataDir(), "models");
        }
        return s_pgmDataAvatarDir;
    }

    public static List<File> getAvatarDirs(boolean writeOnly, Type type) {
        ArrayList<File> dirs = new ArrayList<File>(writeOnly ? Arrays.asList(ResourceAvatar.getUserAvatarDir(), ResourceAvatar.getGlobalAvatarDir()) : Arrays.asList(ResourceAvatar.getAppAvatarDir(), ResourceAvatar.getUserAvatarDir(), ResourceAvatar.getGlobalAvatarDir()));
        if (type != null) {
            for (int m = 0; m < dirs.size(); ++m) {
                dirs.set(m, new File((File)dirs.get(m), type.dir));
            }
        }
        return dirs;
    }

    public ResourceAvatar(String path) {
        path = path.replace('\\', '/');
        while (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAvatar comparableAvatar = (ResourceAvatar)obj;
        return this.path.equals(comparableAvatar.path) && this.getName().equals(comparableAvatar.getName());
    }

    public int hashCode() {
        return 0xE342AB ^ Objects.hash(this.path, this.getName());
    }

    private synchronized File getCanonicalFile() {
        if (this.d_canonicalFile == null) {
            Supplier<File> get = () -> {
                File firstExisting = null;
                for (File root : ResourceAvatar.getAvatarDirs(false, null)) {
                    File f = FilenameManager.resolveFile(root, this.path, false);
                    if (!f.exists()) continue;
                    if (firstExisting == null) {
                        firstExisting = f;
                    }
                    try {
                        f = f.getCanonicalFile();
                        return f;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (firstExisting != null) {
                    return firstExisting;
                }
                return FilenameManager.resolveFile(ResourceAvatar.getAppAvatarDir(), this.path, false);
            };
            this.d_canonicalFile = get.get();
        }
        return this.d_canonicalFile;
    }

    @Override
    public synchronized String getName() {
        if (this.cachedName == null) {
            this.cachedName = FilenameManager.splitFilename(new File(this.path).getName())[0];
        }
        return this.cachedName;
    }

    @Override
    public Image getPreviewImage() {
        File cfile = this.getCanonicalFile();
        return ResourceAvatar.get3dModelPreviewImage(cfile.getAbsolutePath());
    }

    public String toString() {
        return String.format("ResourceAvatar: %s", this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image get3dModelPreviewImage(String avatarPath) {
        Map<String, Image> map = PREVIEW_CACHE;
        synchronized (map) {
            if (!PREVIEW_CACHE.containsKey(avatarPath)) {
                Supplier<Image> get = () -> {
                    try {
                        File avatarFile = new File(avatarPath);
                        BufferedImage img = ImageIO.read(ResourceAvatar.getPreviewFile(avatarFile));
                        return img != null ? img : EMPTY_PREVIEW_IMAGE;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return EMPTY_PREVIEW_IMAGE;
                    }
                };
                Image img = get.get();
                PREVIEW_CACHE.put(avatarPath, img);
            }
            return PREVIEW_CACHE.get(avatarPath);
        }
    }

    private static File getPreviewFile(File avatarFile) {
        return new File(avatarFile.getParentFile(), "preview.png");
    }

    private static ResourceAvatar getValidAvatar(File avatarDir) {
        String baseName = new File(avatarDir, avatarDir.getName()).getAbsolutePath();
        Function<File, File> getRootFolder = f -> {
            for (File dir : ResourceAvatar.getAvatarDirs(false, null)) {
                if (!FilenameManager.isAncestor(dir, f)) continue;
                return dir;
            }
            return ResourceAvatar.getAppAvatarDir();
        };
        for (String ext : AVATAR_EXTENSIONS) {
            File previewFile;
            File f2 = new File(baseName + ext);
            if (!f2.exists() || !(previewFile = ResourceAvatar.getPreviewFile(f2)).exists()) continue;
            File rootDir = getRootFolder.apply(f2);
            return new ResourceAvatar(FilenameManager.getRelativeFilename(rootDir, f2, false));
        }
        return null;
    }

    public static Collection<ResourceAvatar> getValidAvatars(Collection<File> dirs) {
        ArrayList<ResourceAvatar> validAvatars = new ArrayList<ResourceAvatar>();
        for (File dir : dirs) {
            validAvatars.addAll(ResourceAvatar.getValidAvatars(dir));
        }
        return validAvatars;
    }

    public static Collection<ResourceAvatar> getValidAvatars(File dir) {
        try {
            ArrayList<File> modelDirs = new ArrayList<File>();
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (!f.isDirectory()) continue;
                    modelDirs.add(f);
                }
            }
            ArrayList<ResourceAvatar> validAvatars = new ArrayList<ResourceAvatar>();
            for (File modelDir : modelDirs) {
                ResourceAvatar avatar = ResourceAvatar.getValidAvatar(modelDir);
                if (avatar == null) continue;
                validAvatars.add(avatar);
            }
            return validAvatars;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static enum Type {
        VEHICLE("props", "wagon_wheel_silhouette.png", "fbx", "FBX", "obj", "OBJ", "dae", "DAE"),
        OCCUPANT("md5", "silhouette.png", "fbx", "FBX", "dae", "DAE", "gltf", Intl.intl("Graphics Language Transmission Format"), "glb", Intl.intl("Graphics Language Transmission Format - Binary"));

        String dir;
        File defPreviewImg;
        String[] fileFilters;

        private Type(String name, String previewImg, String ... fileFilters) {
            this.dir = name;
            this.fileFilters = fileFilters;
            File preview = new File(ResourceAvatar.getAppAvatarDir(), "images");
            this.defPreviewImg = preview = new File(preview, previewImg);
        }
    }
}

