/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import common.data.EscalatorPreference;
import common.data.SpeedInSmoke;
import inferno.sim.VehicleBody;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.Function1dProp;
import merlin.data.property.INamedProp;
import merlin.data.stat.DisabledCurve;
import merlin.data.value.IFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.legacy.v0118.data.egress.agents.OccProfile;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class OccProfile
extends AMerlinObj
implements Serializable,
ICompElement,
IRestorable,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    public static final IFunction1d SFPE_STAIR_FUNCTION = PiecewiseFunction1d.newFunction(Unit.ONE, Unit.ONE, 0.0, 1.0, 0.5, 0.8785714285714287, 0.541, 0.8285714285714285, 0.638, 0.7714285714285716, 0.748, 0.7142857142857143, 1.8, 0.02428571428571429);
    public static final IFunction1d SFPE_RAMP_FUNCTION = PiecewiseFunction1d.newFunction(Unit.ONE, Unit.ONE, 0.0, 1.0, 1.0, 1.0);
    public static final Object PROP_PROF_PARENT = new Object();
    public static final Prop<String> PROP_NAME = new Prop<String>("OccProfile.NAME", "", false, Intl.intl("Name"));
    public static final Prop<String> PROP_DESC = new Prop<String>("OccProfile.DESC", "", false, Intl.intl("Description"));
    public static final Prop<ICurve> PROP_MAXVEL = new Prop<ConstantCurve>("OccProfile.MAXVEL", 160705858904975L, OccProfile.cc(1.19, SI.METER.divide(SI.SECOND)), false, Intl.intl("Speed"));
    public static final Function1dProp PROP_FUNDAMENTAL = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL", Intl.intl("Speed-Density Profile"), Intl.intl("Modifies an occupant's maximum speed as a function of local occupant density."), Intl.intl("Speed-Density Profile"), OccProfile.getSFPEFundamentalCurve(0.15));
    public static final Function1dProp PROP_STAIR_SPEED_UP = OccProfile.newSlopeProp("OccProfile.SPEED_STAIR_UP", Intl.intl("Speed Fraction Up"), "<html>" + Intl.intl("Modifies an occupant's maximum speed up stairs as a function<br>of stair slope (tread rise/tread run)."), Intl.intl("Stair Speed Fraction Up"), SFPE_STAIR_FUNCTION);
    public static final ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_UP = new ProfileFunctionProp(OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_UP", Intl.intl("Speed-Density Up"), Intl.intl("The speed-density function to use when the occupant travels up stairs."), Intl.intl("Stair Speed-Density Up"), null));
    public static final Function1dProp PROP_STAIR_SPEED_DOWN = OccProfile.newSlopeProp("OccProfile.SPEED_STAIR_DOWN", Intl.intl("Speed Fraction Down"), "<html>" + Intl.intl("Modifies an occupant's maximum speed down stairs as a function<br>of stair slope (tread rise/tread run)."), Intl.intl("Stair Speed Fraction Down"), SFPE_STAIR_FUNCTION);
    public static final ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_DOWN = new ProfileFunctionProp(OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_DOWN", Intl.intl("Speed-Density Down"), Intl.intl("The speed-density function to use when the occupant travels down stairs."), Intl.intl("Stair Speed-Density Down"), null));
    public static final Function1dProp PROP_RAMP_SPEED_UP = OccProfile.newSlopeProp("OccProfile.SPEED_RAMP_UP", Intl.intl("Speed Fraction Up"), "<html>" + Intl.intl("Modifies an occupant's maximum speed up ramps as a function<br>of ramp slope."), Intl.intl("Ramp Speed Fraction Up"), SFPE_RAMP_FUNCTION);
    public static final ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_UP = new ProfileFunctionProp(OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_UP", Intl.intl("Speed-Density Up"), Intl.intl("The speed-density function to use when the occupant travels up ramps."), Intl.intl("Ramp Speed-Density Up"), null));
    public static final Function1dProp PROP_RAMP_SPEED_DOWN = OccProfile.newSlopeProp("OccProfile.SPEED_RAMP_DOWN", Intl.intl("Speed Fraction Down"), "<html>" + Intl.intl("Modifies an occupant's maximum speed down ramps as a function<br>of ramp slope."), Intl.intl("Ramp Speed Fraction Down"), SFPE_RAMP_FUNCTION);
    public static final ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_DOWN = new ProfileFunctionProp(OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_DOWN", Intl.intl("Speed-Density Down"), Intl.intl("The speed-density function to use when the occupant travels down ramps."), Intl.intl("Ramp Speed-Density Down"), null));
    public static final Prop<SpeedInSmokeConfig> PROP_SPEED_IN_SMOKE = new Prop<SpeedInSmokeConfig>("speedInSmoke", 0L, new SpeedInSmokeConfig(SpeedInSmoke.Data.DEFAULT), false, Intl.intl("Speed in Smoke:"), false);
    public static final UnitDouble DEFAULT_COMFORT_DISTANCE = new UnitDouble(0.08, SI.METER);
    public static final Prop<ICurve> PROP_ACCEL_TIME = new Prop<ConstantCurve>("OccProfile.ACCEL_TIME", 3772195293760533400L, OccProfile.cc(1.1, SI.SECOND), false, Intl.intl("Acceleration Time"));
    public static final Prop<ICurve> PROP_DIAMETER = new Prop<ConstantCurve>("OccProfile.DIAMETER", 70367L, OccProfile.cc(0.4558, SI.METER), true, Intl.intl("Shoulder Width"));
    public static final Prop<UnitDouble> PROP_GEOM_DIAMETER = new Prop<Object>("OccProfile.GEOM_DIAMETER", 1122783L, null, true, Intl.intl("Geometry Shoulder Width"));
    @Deprecated
    public static final Prop<ICurve> PROP_MIN_SQUEEZE_FACTOR = new Prop<ConstantCurve>("OccProfile.MIN_SQUEEZE_FACTOR", 9424230529087L, OccProfile.cc(0.7, Unit.ONE), false, Intl.intl("Reduction Factor"));
    public static final Prop<Double> PROP_MIN_SQUEEZE_FACTOR_CONST = new Prop<Double>("OccProfile.MIN_SQUEEZE_FACTOR_CONST", 9424230529086L, 0.7, false, Intl.intl("Reduction Factor"));
    public static final Prop<Point3f> PROP_COLOR = new Prop<Point3f>("OccProfile.COLOR", new Point3f(0.4f, 0.4f, 1.0f), false, Intl.intl("Color"));
    public static final Prop<IUrn<IAvatar>> PROP_OCCMODEL = new Prop<Urn<IAvatar>>("OccProfile.OCCMODEL", 59846346733L, new Urn<IAvatar>(OccProfile.getDefaultAvatars()), false, Intl.intl("3D Model"));
    public static final Prop<IUrn<Integer>> PROP_PRIORITY_LEVEL = new Prop<Urn<Integer>>("OccProfile.PRIORITY_LEVEL", 691837209914168L, new Urn<Integer>(0), false, Intl.intl("Priority Level"));
    public static final Prop<ICurve> PROP_PERSIST_TIME = new Prop<ConstantCurve>("OccProfile.PERSIST_TIME", 4501553410181778L, OccProfile.cc(1.0, SI.SECOND), false, Intl.intl("Persist Time"));
    public static final Prop<ICurve> PROP_COLLISION_RESPONSE_TIME = new Prop<ConstantCurve>("OccProfile.COLLISION_RESPONSE_TIME", 2872109906997839L, OccProfile.cc(1.5, SI.SECOND), false, Intl.intl("Collision Response Time"));
    public static final Prop<ICurve> PROP_COMFORT_DIST = new Prop<ConstantCurve>("OccProfile.COMFORT_DIST", 29593671191177727L, new ConstantCurve(DEFAULT_COMFORT_DISTANCE), false, Intl.intl("Comfort Distance"));
    public static final Prop<Spacing> PROP_SPACING = new Prop<Spacing>("OccProfile.PROP_SPACING", 685236812626031156L, new Spacing(SpacingType.COMFORT_DIST, new ConstantCurve(DEFAULT_COMFORT_DISTANCE)), false, Intl.intl("Comfort Distance"));
    public static final Prop<ICurve> PROP_SOCIAL_DIST = new Prop<DisabledCurve>("OccProfile.PROP_SOCIAL_DIST", 756474136765175587L, new DisabledCurve(SI.METER), false, Intl.intl("Social Distance"), true);
    public static final Prop<ICurve> PROP_SLOW_FACTOR = new Prop<ConstantCurve>("OccProfile.SLOW_FACTOR", 41361678648555699L, OccProfile.cc(0.1), false, Intl.intl("Slow Factor"));
    public static final Prop<ICurve> PROP_HEIGHT = new Prop<ConstantCurve>("OccProfile.HEIGHT", 4823856332702527L, OccProfile.cc(1.8288, SI.METER), true, Intl.intl("Height"));
    public static final Prop<ICurve> PROP_BOUNDARY_LAYER = new Prop<ConstantCurve>("OccProfile.BOUNDARY_LAYER", 265469670362069667L, OccProfile.cc(15.0, SI.CENTI(SI.METER)), false, Intl.intl("Wall Boundary Layer"));
    public static final Prop<IUrn<Boolean>> PROP_ASSIST = new Prop<Urn<Boolean>>("OccProfile.ASSIST", 9435912272635L, new Urn<Boolean>(false), false, Intl.intl("Requires Assistance to Move"));
    @Deprecated
    public static final Prop<IUrn<Boolean>> PROP_CAN_USE_STAIRS = new Prop<Urn<Boolean>>("OccProfile.CAN_USE_STAIRS", 339744713286479L, new Urn<Boolean>(true), true, Intl.intl("Use Stairs"));
    public static final Prop<IUrn<Boolean>> PROP_OBEY_ONEWAY_DOORS = new Prop<Urn<Boolean>>("OccProfile.OBEY_ONEWAY_DOORS", 1527562427425878947L, new Urn<Boolean>(true), false, Intl.intl("Ignore One-way Door Restrictions"));
    @Deprecated
    public static final Prop<IUrn<Boolean>> PROP_WALK_ON_ESCALATORS = new Prop<Urn<Boolean>>("OccProfile.WALK_ON_ESCALATORS", -8844344359005193422L, new Urn<Boolean>(false), false, Intl.intl("Walk on Escalators"));
    public static final Prop<IUrn<EscalatorPreference>> PROP_ESCALATOR_PREF = new Prop<Urn<EscalatorPreference>>("OccProfile.ESCALATOR_PREF", -6968375068520378298L, new Urn<EscalatorPreference>(EscalatorPreference.STAND_ANYWHERE), false, Intl.intl("Escalator movement preference"));
    public static final Prop<ICurve> PROP_LOCAL_QUEUE_TIME_FACTOR = new Prop<ConstantCurve>("OccProfile.LOCAL_QUEUE_TIME_FACTOR", 725907575970042L, OccProfile.cc(1.0), false, Intl.intl("Current Room Queue Time"));
    public static final Prop<ICurve> PROP_LOCAL_TRAVEL_TIME_FACTOR = new Prop<ConstantCurve>("OccProfile.LOCAL_TRAVEL_TIME_FACTOR", 625208248450526L, OccProfile.cc(1.0), false, Intl.intl("Current Room Travel Time"));
    public static final Prop<ICurve> PROP_TAIL_TIME_FACTOR = new Prop<ConstantCurve>("OccProfile.TAIL_TIME_FACTOR", 686610875145200458L, OccProfile.cc(1.0), false, Intl.intl("Global Travel Time"));
    public static final Prop<ICurve> PROP_CURR_DOOR_PREF = new Prop<ConstantCurve>("OccProfile.CURR_DOOR_PREF", 9478288431L, OccProfile.cc(35.0, NonSI.PERCENT), false, Intl.intl("Current Door Preference"));
    public static final Prop<ICurve> PROP_CURRENT_ROOM_DIST_PENALTY = new Prop<ConstantCurve>("OccProfile.DIST_TRAVELLED_DOUBLE_DIST", 18843351117539L, OccProfile.cc(35.0, SI.METER), false, Intl.intl("Current Room Distance Penalty"));
    public static final Prop<IUrn<Boolean>> PROP_PRINT_EXTRA_OUTPUT = new Prop<Urn<Boolean>>("OccProfile.PRINT_EXTRA_OUTPUT", 14614216L, new Urn<Boolean>(false), false, Intl.intl("Print CSV Data"));
    public static final Prop<VehicleShape> PROP_VEHICLE_SHAPE = new Prop<VehicleShape>("OccProfile.VEHICLE_SHAPE", VehicleShape.NONE, true, Intl.intl("Vehicle Shape"));
    public static final Prop<OccShape> PROP_SHAPE = new Prop<OccShape>("OccProfile.SHAPE", new OccShape(VehicleShape.NONE, OccProfile.cc(0.4558, SI.METER), null, OccProfile.cc(1.8288, SI.METER), 0.7), true, Intl.intl("Shape"));
    public static final Prop<OccProfile.AssistedEvacRole> PROP_ASSISTED_EVAC_ROLE = new Prop<OccProfile.AssistedEvacRole>("OccProfile.ASSISTED_EVAC_ROLE", OccProfile.AssistedEvacRole.NONE, true, Intl.intl("Assisted Evacuation Role"));
    public static final Prop<IUrn<Boolean>> PROP_REQUIRES_ASSISTANCE = new Prop<Urn<Boolean>>("OccProfile.REQUIRES_ASSISTANCE", 281103528794162L, new Urn<Boolean>(false), true, Intl.intl("Requires Assistance to Move"));
    public static final Vector3d INIT_ORIENT_REF = GeomConstants.VEC3D_XPOS;
    public static final Prop<ICurve> PROP_INIT_ORIENT = new Prop<UniformCurve>("OccProfile.INIT_ORIENT", new UniformCurve(new UnitDouble(0.0, SI.RADIAN), new UnitDouble(Math.PI * 2, SI.RADIAN)), true, Intl.intl("Initial Orientation"));
    public static final Prop<CompRestrictions> PROP_RESTRICTED_COMPONENTS = new Prop<CompRestrictions>("OccProfile.RESTRICTED_COMPONENTS", new CompRestrictions(), true, Intl.intl("Component Restrictions"));
    public static final Prop<ICurve> PROP_ELEVATOR_WAIT_TIME = new Prop<ConstantCurve>("OccProfile.ELEVATOR_WAIT_TIME", OccProfile.cc(0.0, SI.SECOND), false, Intl.intl("Elevator Wait Time"));
    public static final Prop<Boolean> PROP_NO_CHANGE = new Prop<Boolean>("OccProfile.NO_CHANGE", false, false, Intl.intl("No Change"));
    public static final Prop<ICurve> PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK = new Prop<ConstantCurve>("OccProfile.ATTRACTOR_SUSCEPTIBILITY", 574529506091934536L, OccProfile.cc(1.0, NonSI.PERCENT), false, Intl.intl("Attractor Susceptibility (Seeking)"), Intl.intl("Defines how susceptible an occupant is to attractor objects when seeking. This\nvalue is multiplied by an attractor's influence to determine the probability\nthat an occupant will be influenced by an attractor."), false);
    public static final Prop<ICurve> PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE = new Prop<ConstantCurve>("OccProfile.ATTRACTOR_SUSCEPTIBILITY_IDLE", 574529506091934536L, OccProfile.cc(5.0, NonSI.PERCENT), false, Intl.intl("Attractor Susceptibility (Waiting)"), Intl.intl("Defines how susceptible an occupant is to attractor objects when waiting. This\nvalue is multiplied by an attractor's influence to determine the probability\nthat an occupant will be influenced by an attractor."), false);
    public static final Prop<AttractorRestrictions> PROP_ATTRACTOR_RESTRICTIONS = new Prop<AttractorRestrictions>("OccProfile.ATTRACTOR_RESTRICTIONS", new AttractorRestrictions(AttractorRestrictions.Mode.ALL, false, Collections.emptySet()), false, Intl.intl("Allowed Attractors"));
    public static final Set<Object> PROP_TYPES;
    public static final List<IPropertySet.Prop<?>> ALL_PROPS;
    private static final int CROSSOVER_SIZE = 5;
    private OccProfile d_parent;
    private Map<Object, Object> d_data;

    private static Function1dProp newFundamentalProp(String name, String desc, String longDesc, String displayName, IFunction1d defVal) {
        Function<Component, IFunction1d> f = comp -> OccProfile.getSFPEFundamentalCurve(0.15);
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("SFPE"), Intl.intl("Load SFPE profile..."), f)};
        return new Function1dProp((Object)name, defVal, desc, longDesc, displayName, null, new Function1dProp.Var(Intl.intl("Density"), 3, UnitDoubleVR.above(SIUS.newud(0.0, 3), true)), new Function1dProp.Var(Intl.intl("Fraction of Max. Speed"), 11, UnitDoubleVR.between(0.0, 1.0, Unit.ONE, true, true)), new UnitDouble[]{SIUS.newud(0.0, 3), new UnitDouble(0.0, Unit.ONE), null, null}, predef);
    }

    private static Function1dProp newSlopeProp(String name, String desc, String longDesc, String displayName, IFunction1d defFunction) {
        Function<Component, IFunction1d> f = comp -> defFunction;
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("SFPE"), Intl.intl("Load SFPE profile..."), f)};
        return new Function1dProp((Object)name, defFunction, desc, longDesc, displayName, null, new Function1dProp.Var(Intl.intl("Slope"), 11, UnitDoubleVR.above(0.0, Unit.ONE, true)), new Function1dProp.Var(Intl.intl("Fraction of Max. Speed"), 11, UnitDoubleVR.above(0.0, Unit.ONE, true)), new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), null, new UnitDouble(0.0, Unit.ONE), null}, predef);
    }

    private static final ConstantCurve cc(double val) {
        return OccProfile.cc(val, Unit.ONE);
    }

    private static final ConstantCurve cc(double val, Unit unit) {
        return new ConstantCurve(new UnitDouble(val, unit));
    }

    public OccProfile() {
        this(null);
    }

    public OccProfile(OccProfile parent) {
        this.d_parent = parent;
        this.d_data = new ListMap<Object, Object>();
    }

    @Override
    public OccProfile clone() {
        OccProfile clone = (OccProfile)super.clone();
        Map<Object, Object> map = clone.d_data = this.d_data instanceof HashMap ? new HashMap<Object, Object>(this.d_data) : new ListMap<Object, Object>(this.d_data);
        if (this.isDefinedLocally(PROP_RESTRICTED_COMPONENTS)) {
            CompRestrictions cr = this.getProperty(PROP_RESTRICTED_COMPONENTS);
            clone.setIfNotDefault(PROP_RESTRICTED_COMPONENTS, cr.clone());
        }
        if (this.isDefinedLocally(PROP_ATTRACTOR_RESTRICTIONS)) {
            clone.setIfNotDefault(PROP_ATTRACTOR_RESTRICTIONS, this.getProperty(PROP_ATTRACTOR_RESTRICTIONS).clone());
        }
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof OccProfile)) {
            return;
        }
        OccProfile prof = (OccProfile)obj;
        this.d_data = prof.d_data;
        this.d_parent = prof.d_parent;
        this.changedEvt(new Object[0]);
    }

    public void setProfParent(OccProfile parent) {
        if (this.d_parent != parent) {
            this.d_parent = parent;
            this.changedEvt(new Object[0]);
        }
    }

    public OccProfile getProfParent() {
        return this.d_parent;
    }

    private void clearDefaults() {
        for (IPropertySet.Prop<?> prop : OccProfile.getAllPropTypes()) {
            if (!this.d_data.containsKey(prop.key) || !Objects.equals(this.d_data.get(prop.key), prop.defVal)) continue;
            this.remove(prop);
        }
    }

    private static List<IPropertySet.Prop<?>> getAllPropTypes() {
        return IPropertySet.getAllDeclaredPublicStaticProps(OccProfile.class);
    }

    public static List<IsLocalProp<?>> getIsLocalTypes() {
        List<IPropertySet.Prop<?>> types = ALL_PROPS;
        ArrayList local = new ArrayList(types.size());
        for (IPropertySet.Prop<?> prop : types) {
            local.add(new IsLocalProp(prop));
        }
        return local;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        IUrn iUrn;
        IUrn<IAvatar> avatars;
        Object[] checkProps;
        ICurve curve;
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0028) && this.isDefinedLocally(PROP_CURR_DOOR_PREF) && (curve = this.getProperty(PROP_CURR_DOOR_PREF)) instanceof ConstantCurve) {
            ConstantCurve constantCurve = (ConstantCurve)curve;
            double val = constantCurve.getMax().getValue(Unit.ONE);
            ConstantCurve constantCurve2 = new ConstantCurve(new UnitDouble((1.0 - val) * 100.0, NonSI.PERCENT));
            if (this.d_parent == null) {
                this.setProperty(PROP_CURR_DOOR_PREF, constantCurve2);
            } else {
                this.setIfNotDefault(PROP_CURR_DOOR_PREF, constantCurve2);
            }
        }
        if (this.d_parent == null && MerlinOIS.isPrior(in, MerlinIO.Version.VER_0107)) {
            this.clearDefaults();
        }
        for (Object checkProp : checkProps = new Object[]{OccProfile.PROP_CAN_USE_STAIRS.key, OccProfile.PROP_ASSIST.key}) {
            InfiniteUrn<Boolean> val = this.d_data.get(checkProp);
            if (!(val instanceof Boolean)) continue;
            val = new InfiniteUrn<Boolean>((Boolean)((Object)val));
            this.d_data.put(checkProp, val);
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0104) && this.isDefinedLocally(PROP_COMFORT_DIST)) {
            ICurve iCurve = this.remove(PROP_COMFORT_DIST);
            Spacing sval = new Spacing(SpacingType.COMFORT_DIST, iCurve);
            if (this.d_parent != null) {
                this.setProperty(PROP_SPACING, sval);
            } else {
                this.setIfNotDefault(PROP_SPACING, sval);
            }
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0116) && (avatars = OccProfile.legacyConvertAvatars(iUrn = (IUrn)this.d_data.get(OccProfile.PROP_OCCMODEL.key))) != null) {
            this.d_data.put(OccProfile.PROP_OCCMODEL.key, avatars);
        }
        if (this.d_parent == null && MerlinOIS.isPrior(in, MerlinIO.Version.VER_0109) && !this.isDefinedLocally(PROP_OCCMODEL)) {
            List<IAvatar> list = Arrays.asList(OccProfile.bea("BMan0001"), OccProfile.bea("BMan0002"), OccProfile.bea("BMan0003"), OccProfile.bea("BWom0001"), OccProfile.bea("BWom0002"), OccProfile.bea("CMan0001"), OccProfile.bea("CMan0002"), OccProfile.bea("CMan0003"), OccProfile.bea("CMan0012"), OccProfile.bea("CWom0001"), OccProfile.bea("CWom0018"), OccProfile.bea("CWom0019"));
            this.setProperty(PROP_OCCMODEL, new Urn<IAvatar>((Collection<IAvatar>)list));
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0124)) {
            CompRestrictions compRestrictions = this.getProperty(PROP_RESTRICTED_COMPONENTS).clone();
            boolean setProp = false;
            if (this.isDefinedLocally(PROP_CAN_USE_STAIRS)) {
                setProp = true;
                boolean useStairs = UrnUtil.getDominant(this.getProperty(PROP_CAN_USE_STAIRS));
                if (!useStairs) {
                    compRestrictions.setTypeAccepted(compRestrictions.stairInfo, true);
                    compRestrictions.setTypeMode(compRestrictions.stairInfo, CompRestrictions.Mode.NONE);
                } else if (compRestrictions.getTypeMode(compRestrictions.stairInfo) == CompRestrictions.Mode.NONE) {
                    compRestrictions.removeAll(EgressStair.class);
                    compRestrictions.setTypeAccepted(compRestrictions.stairInfo, false);
                    compRestrictions.setTypeMode(compRestrictions.stairInfo, CompRestrictions.Mode.ALL);
                }
            }
            if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0140)) {
                boolean walkOnEscalator = UrnUtil.getDominant(this.getProperty(PROP_WALK_ON_ESCALATORS));
                this.setProperty(PROP_ESCALATOR_PREF, walkOnEscalator ? new Urn<Object>(new Object[]{EscalatorPreference.WALK}) : new Urn<Object>(new Object[]{EscalatorPreference.STAND_ANYWHERE}));
            }
            if (this.getProfParent() == null) {
                setProp = true;
                compRestrictions.setTypeInfo(compRestrictions.elevatorInfo, CompRestrictions.Mode.FROM_BEHAVIOR, false);
            }
            if (setProp) {
                this.setProperty(PROP_RESTRICTED_COMPONENTS, compRestrictions);
            }
        }
    }

    public static IUrn<IAvatar> legacyConvertAvatars(IUrn<String> names) {
        if (names instanceof Urn) {
            ArrayList nameList = new ArrayList();
            names.getUnique(nameList);
            ArrayList<IAvatar> avatarList = new ArrayList<IAvatar>(nameList.size());
            for (String name : nameList) {
                avatarList.add(OccProfile.bea(name));
            }
            return new Urn<IAvatar>((Collection<IAvatar>)avatarList);
        }
        if (names != null) {
            Map<String, Double> nameWeights = names.getWeights();
            HashMap<IAvatar, Double> avatarWeights = new HashMap<IAvatar, Double>(nameWeights.size());
            for (Map.Entry<String, Double> entry : nameWeights.entrySet()) {
                avatarWeights.put(OccProfile.bea(entry.getKey()), entry.getValue());
            }
            return UrnUtil.newUrn(avatarWeights);
        }
        return null;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == PROP_PROF_PARENT) {
            return this.getProfParent();
        }
        if (prop instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)prop);
        }
        if (prop instanceof IsLocalProp) {
            IPropertySet.Prop propToTest = ((IsLocalProp)prop).prop;
            return this.isDefinedLocally(propToTest);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        if (prop == PROP_SHAPE) {
            return (T)new OccShape(this.getProperty(PROP_VEHICLE_SHAPE), this.getProperty(PROP_DIAMETER), this.getProperty(PROP_GEOM_DIAMETER), this.getProperty(PROP_HEIGHT), this.getProperty(PROP_MIN_SQUEEZE_FACTOR_CONST));
        }
        OccProfile prof = this;
        while (prof != null) {
            if (prof.d_data.containsKey(prop.key)) {
                return (T)prof.d_data.get(prop.key);
            }
            prof = prof.d_parent;
        }
        return prop.defVal;
    }

    public boolean isDefinedLocally(IPropertySet.Prop<?> prop) {
        if (prop == PROP_SHAPE) {
            return this.isDefinedLocally(PROP_VEHICLE_SHAPE) || this.isDefinedLocally(PROP_DIAMETER) || this.isDefinedLocally(PROP_GEOM_DIAMETER) || this.isDefinedLocally(PROP_HEIGHT) || this.isDefinedLocally(PROP_MIN_SQUEEZE_FACTOR_CONST);
        }
        return this.d_data.containsKey(prop.key);
    }

    public <T> T remove(IPropertySet.Prop<T> prop) {
        if (prop == PROP_SHAPE) {
            T old = this.getProperty(prop);
            this.pauseUpdates();
            this.remove(PROP_VEHICLE_SHAPE);
            this.remove(PROP_DIAMETER);
            this.remove(PROP_GEOM_DIAMETER);
            this.remove(PROP_HEIGHT);
            this.remove(PROP_MIN_SQUEEZE_FACTOR_CONST);
            this.resumeUpdates();
            return old;
        }
        if (this.d_data.containsKey(prop.key)) {
            Object result = this.d_data.remove(prop.key);
            if (this.d_data.size() < 5 && this.d_data instanceof HashMap) {
                this.d_data = new ListMap<Object, Object>(this.d_data);
            }
            this.changedEvt(new Object[0]);
            return (T)result;
        }
        return null;
    }

    public void removeAll() {
        if (!this.d_data.isEmpty()) {
            if (this.d_data instanceof HashMap) {
                this.d_data = new ListMap<Object, Object>();
            } else {
                this.d_data.clear();
            }
            this.changedEvt(new Object[0]);
        }
    }

    @Deprecated
    public UnitDouble getCurveVal(Prop<ICurve> prop, Random rand, long baseSeed) {
        return (UnitDouble)this.getDistVal(prop, rand, baseSeed);
    }

    @Deprecated
    public <T> T getBagVal(Prop<Urn<T>> prop, Random rand, long baseSeed) {
        return this.getDistVal(prop, rand, baseSeed);
    }

    public <T> T getDistVal(Prop<? extends IDistributedVal<T>> prop, Random rand, long baseSeed) {
        return OccProfile.getDistVal(this.getProperty(prop), prop.seed, rand, baseSeed);
    }

    public static <T> T getDistVal(IDistributedVal<T> distVal, long propSeed, Random rand, long baseSeed) {
        assert (distVal != null);
        long newSeed = baseSeed ^ propSeed;
        rand.setSeed(newSeed);
        return distVal.getValue(rand);
    }

    public UnitDouble getSpacingVal(Random rand, long baseSeed) {
        Spacing spacing = this.getProperty(PROP_SPACING);
        assert (spacing != null);
        long newSeed = baseSeed ^ OccProfile.PROP_SPACING.seed;
        rand.setSeed(newSeed);
        return spacing.val.getValue(rand);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == PROP_PROF_PARENT) {
            this.setProfParent((OccProfile)value);
        } else if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
    }

    public <T> void setIfNotDefault(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(prop.defVal, value)) {
            this.remove(prop);
            return;
        }
        this.setProperty(prop, value);
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        if (prop.key.equals(OccProfile.PROP_SHAPE.key)) {
            OccShape shape = (OccShape)value;
            if (shape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
                this.setProperty(PROP_DIAMETER, shape.shoulderWidth);
                this.setProperty(PROP_GEOM_DIAMETER, shape.geomShoulderWidth);
                this.setProperty(PROP_HEIGHT, shape.height);
                this.setProperty(PROP_VEHICLE_SHAPE, null);
            } else {
                this.setProperty(PROP_VEHICLE_SHAPE, shape.vehicleShape);
                this.remove(PROP_DIAMETER);
                this.remove(PROP_GEOM_DIAMETER);
                this.remove(PROP_HEIGHT);
            }
            this.setProperty(PROP_MIN_SQUEEZE_FACTOR_CONST, shape.minSqueezeFactor);
        } else {
            this.d_data.put(prop.key, value);
        }
        this.changedEvt(prop);
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    public String toString() {
        return "OccProfile[name=" + this.getName() + "]";
    }

    public int getNumLocal() {
        return this.d_data.size();
    }

    private static IAvatar bea(String name) {
        return new ResourceAvatar(String.format("md5/%1$s/%1$s.bea", name));
    }

    public static Collection<IAvatar> getDefaultAvatars() {
        return Arrays.asList(OccProfile.bea("BMan0001"), OccProfile.bea("BMan0002"), OccProfile.bea("BMan0003"), OccProfile.bea("BMan0012"), OccProfile.bea("BWom0001"), OccProfile.bea("BWom0002"), OccProfile.bea("BWom0011"), OccProfile.bea("CMan0001"), OccProfile.bea("CMan0002"), OccProfile.bea("CMan0003"), OccProfile.bea("CMan0012"), OccProfile.bea("CWom0001"), OccProfile.bea("CWom0018"), OccProfile.bea("CWom0019"));
    }

    public static double getComfortDistanceFromDensity(double d, double r) {
        return Math.max(2.0 / (Math.sqrt(d) * Math.pow(12.0, 0.25)) - 2.0 * r, 0.0);
    }

    public static <T> Optional<Prop<T>> toProfProp(IPropertySet.Prop<T> prop) {
        return prop instanceof Prop ? Optional.of((Prop)prop) : Optional.empty();
    }

    public static IFunction1d getSFPEFundamentalCurve(double ymin) {
        double a = 0.266;
        double m = -0.31158486587794304;
        double b = 1.0 - m * 0.55;
        double xmin = (ymin - b) / m;
        double[] x = new double[]{0.55, xmin};
        double[] y = new double[]{1.0, ymin};
        PiecewiseFunction1d.Entry[] entries = new PiecewiseFunction1d.Entry[]{new PiecewiseFunction1d.Entry(SIUS.newud(x[0], 3), new UnitDouble(y[0], Unit.ONE)), new PiecewiseFunction1d.Entry(SIUS.newud(x[1], 3), new UnitDouble(y[1], Unit.ONE))};
        return new PiecewiseFunction1d(entries);
    }

    public PropHasher getHasher() {
        return this.getHasher(Predicates.alwaysTrue());
    }

    public PropHasher getHasher(Predicate<IPropertySet.Prop> propFilter) {
        return new PropHasher(this, propFilter);
    }

    private static <T extends IMerlinObj> String formatObjNames(Set<T> objs, String emptyName) {
        return objs.isEmpty() ? emptyName : String.join((CharSequence)", ", theUtil.map(objs, o -> MerlinUtil.getName(o)));
    }

    public static void removeCompsFromProfReferences(MerlinData md, IFilteredCollection<IMerlinObj> compsToDel) {
        Collection<IMerlinObj> allToDel = MerlinUtil.flatten(compsToDel, IMerlinObj.class);
        LinkedIdentityHashMap compsToObjs = new LinkedIdentityHashMap();
        Consumer<AMerlinObj> collect = obj -> {
            OccProfile prof = obj instanceof OccProfile ? (OccProfile)obj : ((EgressAgent)obj).getProfile();
            CompRestrictions compRestrictions = prof.getProperty(PROP_RESTRICTED_COMPONENTS);
            if (compRestrictions.comps.stream().noneMatch(allToDel::contains)) {
                return;
            }
            compsToObjs.compute(compRestrictions, (key, list) -> {
                if (list == null) {
                    list = new ArrayList<AMerlinObj>();
                }
                list.add(obj);
                return list;
            });
        };
        for (OccProfile profile : md.profiles.flatten(OccProfile.class)) {
            collect.accept(profile);
        }
        for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
            if (!agent.getProfile().isDefinedLocally(PROP_RESTRICTED_COMPONENTS)) continue;
            collect.accept(agent);
        }
        for (CompRestrictions compRestrictions : compsToObjs.keySet()) {
            List list = (List)compsToObjs.get(compRestrictions);
            CompRestrictions newRests = compRestrictions.clone();
            Set<IMerlinObj> restrictedComps = newRests.comps;
            restrictedComps.removeAll(allToDel);
            for (AMerlinObj obj2 : list) {
                assert (obj2 instanceof IRestorable);
                Undo.insertUndoEntry_restore(md, (IRestorable)((Object)obj2));
                if (obj2 instanceof OccProfile) {
                    ((OccProfile)obj2).setProperty(PROP_RESTRICTED_COMPONENTS, newRests);
                    continue;
                }
                if (obj2 instanceof EgressAgent) {
                    ((EgressAgent)obj2).setProperty(PROP_RESTRICTED_COMPONENTS, newRests);
                    continue;
                }
                assert (false);
            }
        }
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        if (old instanceof VehicleShape && this.isDefinedLocally(PROP_VEHICLE_SHAPE)) {
            OccShape shape = this.getProperty(PROP_SHAPE);
            if (old == shape.vehicleShape) {
                shape.vehicleShape = (VehicleShape)replacement;
                this.setProperty(PROP_SHAPE, shape);
            }
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getProperty(PROP_VEHICLE_SHAPE));
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (IPropertySet.Prop<?> prop : OccProfile.getAllPropTypes()) {
            hash = 31 * hash + theUtil.hashCode(this.getProperty((Object)prop));
        }
        return hash;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (!(comparable instanceof OccProfile)) {
            return false;
        }
        OccProfile comparableProfile = (OccProfile)comparable;
        if (this.getNumLocal() != comparableProfile.getNumLocal()) {
            return false;
        }
        if (!theUtil.equal(this.d_parent, comparableProfile.getProfParent(), comparedSet)) {
            return false;
        }
        return this.d_data.entrySet().stream().allMatch(entry -> occProfile.d_data.containsKey(entry.getKey()) && theUtil.equal(entry.getValue(), occProfile.d_data.get(entry.getKey()), comparedSet));
    }

    static {
        ALL_PROPS = OccProfile.getAllPropTypes();
        PROP_TYPES = new LinkedHashSet(ALL_PROPS);
        PROP_TYPES.addAll(OccProfile.getIsLocalTypes());
        PROP_TYPES.add(PROP_PROF_PARENT);
    }

    public static class CompRestrictions
    implements Serializable,
    Cloneable,
    IDirectDependent<MerlinData>,
    ISurrogate {
        static final long serialVersionUID = 1L;
        private static final Predicate<EgressStair> isEscalator = stair -> stair.isEscalator();
        private static final Predicate<EgressCorridor> isMovingWalkway = ramp -> ramp.isMovingWalkway();
        public final Set<IMerlinObj> comps;
        public CompRestrictionsInfo roomInfo;
        public CompRestrictionsInfo doorInfo;
        public CompRestrictionsInfo stairInfo;
        public CompRestrictionsInfo escalatorInfo;
        public CompRestrictionsInfo rampInfo;
        public CompRestrictionsInfo movingWalkwayInfo;
        public CompRestrictionsInfo elevatorInfo;

        public CompRestrictions() {
            this(new HashSet<IMerlinObj>(), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL), new CompRestrictionsInfo(true, Mode.ALL));
        }

        public CompRestrictions(Set<IMerlinObj> comps, CompRestrictionsInfo doorInfo, CompRestrictionsInfo roomInfo, CompRestrictionsInfo stairInfo, CompRestrictionsInfo escalatorInfo, CompRestrictionsInfo rampInfo, CompRestrictionsInfo movingWalkwayInfo, CompRestrictionsInfo elevatorInfo) {
            this.comps = comps;
            this.doorInfo = doorInfo;
            this.roomInfo = roomInfo;
            this.stairInfo = stairInfo;
            this.escalatorInfo = escalatorInfo;
            this.rampInfo = rampInfo;
            this.movingWalkwayInfo = movingWalkwayInfo;
            this.elevatorInfo = elevatorInfo;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.escalatorInfo == null) {
                this.escalatorInfo = new CompRestrictionsInfo(this.stairInfo.rejected, this.stairInfo.mode);
            }
            if (this.movingWalkwayInfo == null) {
                this.movingWalkwayInfo = new CompRestrictionsInfo(this.rampInfo.rejected, this.rampInfo.mode);
            }
        }

        public boolean isAccepted(IMerlinObj obj) {
            CompRestrictionsInfo info = this.getTypeInfo(obj);
            boolean typeAccepted = this.isTypeAccepted(info);
            if (obj instanceof EgressStair && ((EgressStair)obj).isEscalator() && (this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY)) {
                if (this.escalatorInfo.mode == Mode.UP_ONLY) {
                    typeAccepted ^= ((EgressStair)obj).isOrientedUp();
                }
                if (this.escalatorInfo.mode == Mode.DOWN_ONLY) {
                    typeAccepted ^= ((EgressStair)obj).isOrientedDown();
                }
                if (!((EgressStair)obj).isOrientedDown() && !((EgressStair)obj).isOrientedUp()) {
                    typeAccepted = !typeAccepted;
                }
            }
            return typeAccepted && this.comps.contains(obj) || !typeAccepted && !this.comps.contains(obj);
        }

        public void accept(IMerlinObj obj) {
            this.add(obj, true);
        }

        public void reject(IMerlinObj obj) {
            this.add(obj, false);
        }

        private void add(IMerlinObj obj, boolean accept) {
            if (accept == this.isAccepted(obj)) {
                return;
            }
            CompRestrictionsInfo info = this.getTypeInfo(obj);
            boolean typeAccepted = this.isTypeAccepted(info);
            if (accept == typeAccepted) {
                this.comps.add(obj);
                this.setTypeMode(info, Mode.FROM_LIST);
            } else {
                this.comps.remove(obj);
            }
        }

        public void setTypeAccepted(CompRestrictionsInfo info, boolean accepting) {
            info.rejected = !accepting;
        }

        public void setTypeMode(CompRestrictionsInfo info, Mode mode) {
            info.mode = mode;
        }

        public void setTypeInfo(CompRestrictionsInfo info, Mode mode, boolean rejected) {
            info.mode = mode;
            info.rejected = rejected;
        }

        public boolean isTypeAccepted(CompRestrictionsInfo info) {
            return !info.rejected;
        }

        public Mode getTypeMode(CompRestrictionsInfo info) {
            return info.mode;
        }

        public CompRestrictionsInfo getTypeInfo(IMerlinObj obj) {
            if (obj.getClass() == EgressDoor.class) {
                return this.doorInfo;
            }
            if (obj.getClass() == EgressRoom.class) {
                return this.roomInfo;
            }
            if (obj.getClass() == EgressStair.class) {
                if (isEscalator.test((EgressStair)obj)) {
                    return this.escalatorInfo;
                }
                return this.stairInfo;
            }
            if (obj.getClass() == EgressCorridor.class) {
                if (isMovingWalkway.test((EgressCorridor)obj)) {
                    return this.movingWalkwayInfo;
                }
                return this.rampInfo;
            }
            if (obj.getClass() == Elevator.class) {
                return this.elevatorInfo;
            }
            assert (false);
            return null;
        }

        public CompRestrictions clone() {
            return new CompRestrictions(new HashSet<IMerlinObj>(this.comps), this.doorInfo.clone(), this.roomInfo.clone(), this.stairInfo.clone(), this.escalatorInfo.clone(), this.rampInfo.clone(), this.movingWalkwayInfo.clone(), this.elevatorInfo.clone());
        }

        public <T extends IMerlinObj> Set<T> getObjs(Class<T> clazz) {
            HashSet<IMerlinObj> objs = new HashSet<IMerlinObj>();
            for (IMerlinObj obj : this.comps) {
                if (!clazz.isInstance(obj)) continue;
                objs.add(obj);
            }
            return objs;
        }

        public void addAll(Set<? extends IMerlinObj> objs) {
            this.comps.addAll(objs);
        }

        public void removeAll(Class clazz) {
            HashSet<IMerlinObj> toRemove = new HashSet<IMerlinObj>();
            for (IMerlinObj acomp : this.comps) {
                if (!clazz.isInstance(acomp)) continue;
                toRemove.add(acomp);
            }
            this.comps.removeAll(toRemove);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CompRestrictions otherRest = (CompRestrictions)other;
            return this.comps.equals(otherRest.comps) && this.compareRestrictions(otherRest);
        }

        @Override
        public boolean surrogateEquals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CompRestrictions otherRest = (CompRestrictions)other;
            return theUtil.surrogateSetsEqual(this.comps, otherRest.comps) && this.compareRestrictions(otherRest);
        }

        private boolean compareRestrictions(CompRestrictions otherRest) {
            return otherRest.roomInfo.equals(this.roomInfo) && otherRest.doorInfo.equals(this.doorInfo) && otherRest.stairInfo.equals(this.stairInfo) && otherRest.rampInfo.equals(this.rampInfo) && otherRest.movingWalkwayInfo.equals(this.movingWalkwayInfo) && otherRest.escalatorInfo.equals(this.escalatorInfo) && otherRest.elevatorInfo.equals(this.elevatorInfo);
        }

        public <T extends IMerlinObj> Set<T> getRejected(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr) {
            return this.getRejected(clazz, root, cr, Predicates.alwaysTrue(), false);
        }

        public <T extends IMerlinObj> Set<T> getRejected(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr, Predicate<IMerlinObj> filter, boolean alwaysAddToList) {
            return this.get(clazz, root, filter, false, cr, alwaysAddToList);
        }

        public <T extends IMerlinObj> Set<T> getAccepted(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr) {
            return this.getAccepted(clazz, root, cr, Predicates.alwaysTrue(), false);
        }

        public <T extends IMerlinObj> Set<T> getAccepted(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr, Predicate<IMerlinObj> filter, boolean alwaysAddToList) {
            return this.get(clazz, root, filter, true, cr, alwaysAddToList);
        }

        private <T extends IMerlinObj> Set<T> get(Class<T> clazz, Composite<? extends IMerlinObj> root, Predicate<IMerlinObj> filter, boolean accept, CompRestrictionsInfo cr, boolean alwaysAddToList) {
            ArrayList<IMerlinObj> list;
            Set<T> objs = this.getObjs(clazz);
            if (this.isTypeAccepted(cr) == accept && !alwaysAddToList) {
                return theUtil.filter(objs, filter);
            }
            HashSet<T> allObjs = new HashSet<T>(root.flatten(clazz));
            if (clazz == EgressStair.class && cr == this.stairInfo && allObjs.size() > 0) {
                list = new ArrayList<IMerlinObj>();
                for (IMerlinObj obj : allObjs) {
                    if (!isEscalator.test((EgressStair)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressStair.class && cr == this.escalatorInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (isEscalator.test((EgressStair)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressCorridor.class && cr == this.rampInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (!isMovingWalkway.test((EgressCorridor)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressCorridor.class && cr == this.movingWalkwayInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (isMovingWalkway.test((EgressCorridor)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            allObjs.removeAll(objs);
            return theUtil.filter(allObjs, filter);
        }

        public Set<IMerlinObj> getAllRejected(MerlinData md) {
            HashSet<IMerlinObj> allRejected = new HashSet<IMerlinObj>();
            CompRestrictions cr = this;
            boolean alwaysAddEscalatorsToList = this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY;
            allRejected.addAll(this.getRejected(EgressRoom.class, md.floors, cr.roomInfo));
            allRejected.addAll(this.getRejected(EgressDoor.class, md.floors, cr.doorInfo));
            allRejected.addAll(this.getRejected(EgressStair.class, md.floors, cr.stairInfo, stair -> !((EgressStair)stair).isEscalator(), false));
            allRejected.addAll(this.getRejected(EgressStair.class, md.floors, cr.escalatorInfo, stair -> ((EgressStair)stair).isEscalator(), alwaysAddEscalatorsToList));
            allRejected.addAll(this.getRejected(EgressCorridor.class, md.floors, cr.rampInfo, comp -> !(comp instanceof EgressStair) && !((EgressCorridor)comp).isMovingWalkway(), false));
            allRejected.addAll(this.getRejected(EgressCorridor.class, md.floors, cr.movingWalkwayInfo, comp -> !(comp instanceof EgressStair) && ((EgressCorridor)comp).isMovingWalkway(), false));
            allRejected.addAll(this.getRejected(Elevator.class, md.elevators, cr.elevatorInfo));
            if (this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY) {
                HashSet<IMerlinObj> finalRejected = new HashSet<IMerlinObj>();
                for (IMerlinObj comp2 : allRejected) {
                    if (comp2 instanceof EgressStair && ((EgressStair)comp2).isEscalator()) {
                        if (!((EgressStair)comp2).isOrientedUp() && !((EgressStair)comp2).isOrientedDown()) {
                            finalRejected.add(comp2);
                        }
                        if (this.escalatorInfo.mode == Mode.UP_ONLY && ((EgressStair)comp2).isOrientedDown()) {
                            finalRejected.add(comp2);
                        }
                        if (this.escalatorInfo.mode != Mode.DOWN_ONLY || !((EgressStair)comp2).isOrientedUp()) continue;
                        finalRejected.add(comp2);
                        continue;
                    }
                    finalRejected.add(comp2);
                }
                return finalRejected;
            }
            return allRejected;
        }

        public Set<IMerlinObj> getAllAccepted(MerlinData md) {
            HashSet<IMerlinObj> allAccepted = new HashSet<IMerlinObj>();
            CompRestrictions cr = this;
            boolean alwaysAddToList = this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY;
            allAccepted.addAll(this.getAccepted(EgressRoom.class, md.floors, cr.roomInfo));
            allAccepted.addAll(this.getAccepted(EgressDoor.class, md.floors, cr.doorInfo));
            allAccepted.addAll(this.getAccepted(EgressStair.class, md.floors, cr.stairInfo, stair -> !((EgressStair)stair).isEscalator(), false));
            allAccepted.addAll(this.getAccepted(EgressStair.class, md.floors, cr.escalatorInfo, stair -> ((EgressStair)stair).isEscalator(), alwaysAddToList));
            allAccepted.addAll(this.getAccepted(EgressCorridor.class, md.floors, cr.rampInfo, comp -> !(comp instanceof EgressStair) && !((EgressCorridor)comp).isMovingWalkway(), false));
            allAccepted.addAll(this.getAccepted(EgressCorridor.class, md.floors, cr.movingWalkwayInfo, comp -> !(comp instanceof EgressStair) && ((EgressCorridor)comp).isMovingWalkway(), false));
            allAccepted.addAll(this.getAccepted(Elevator.class, md.elevators, cr.elevatorInfo));
            if (this.escalatorInfo.mode == Mode.DOWN_ONLY || this.escalatorInfo.mode == Mode.UP_ONLY) {
                HashSet<IMerlinObj> finalAccepted = new HashSet<IMerlinObj>();
                for (IMerlinObj comp2 : allAccepted) {
                    if (comp2 instanceof EgressStair && ((EgressStair)comp2).isEscalator()) {
                        if (this.escalatorInfo.mode == Mode.UP_ONLY && ((EgressStair)comp2).isOrientedUp()) {
                            finalAccepted.add(comp2);
                        }
                        if (this.escalatorInfo.mode != Mode.DOWN_ONLY || !((EgressStair)comp2).isOrientedDown()) continue;
                        finalAccepted.add(comp2);
                        continue;
                    }
                    finalAccepted.add(comp2);
                }
                return finalAccepted;
            }
            return allAccepted;
        }

        public static boolean isAcceptableType(Class<? extends ICompElement> clazz) {
            List<Class<?>> allowedClasses = Arrays.asList(CompRestrictions.getAllowedClasses());
            return allowedClasses.contains(clazz);
        }

        public static Class<?>[] getAllowedClasses() {
            return new Class[]{EgressDoor.class, EgressRoom.class, EgressStair.class, EgressCorridor.class, Elevator.class};
        }

        public static boolean allAcceptableTypes(MerlinSelectionModel sel) {
            List<Class<?>> allowedClasses = Arrays.asList(CompRestrictions.getAllowedClasses());
            for (IMerlinObj obj : sel.flatten(IMerlinObj.class)) {
                if (allowedClasses.contains(obj.getClass())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.comps.hashCode() + this.doorInfo.hashCode() + this.roomInfo.hashCode() + this.stairInfo.hashCode() + this.rampInfo.hashCode() + this.elevatorInfo.hashCode();
        }

        @Override
        public void replaceDependency(MerlinData md, Object old, Object replacement) {
            assert (old != null);
            this.comps.remove(old);
            if (replacement != null) {
                assert (replacement instanceof IMerlinObj);
                this.comps.add((IMerlinObj)replacement);
            }
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            deps.add(DLink.WEAK, this.comps);
        }

        public static class CompRestrictionsInfo
        implements Serializable,
        Cloneable {
            static final long serialVersionUID = 1L;
            public boolean rejected;
            public Mode mode;

            public CompRestrictionsInfo(boolean rejected, Mode mode) {
                this.rejected = rejected;
                this.mode = mode;
            }

            public CompRestrictionsInfo() {
                this(true, Mode.ALL);
            }

            public CompRestrictionsInfo clone() {
                return new CompRestrictionsInfo(this.rejected, this.mode);
            }

            public boolean equals(Object other) {
                if (!(other instanceof CompRestrictionsInfo)) {
                    return false;
                }
                return this.rejected == ((CompRestrictionsInfo)other).rejected && this.mode == ((CompRestrictionsInfo)other).mode;
            }

            public int hashCode() {
                return this.mode.hashCode() + (this.rejected ? 1 : 0);
            }
        }

        public static enum Mode {
            ALL(Intl.intl("All"), Intl.intl("Allow all components to be used.")),
            NONE(Intl.intl("None"), Intl.intl("Allow no components to be used.")),
            FROM_LIST(Intl.intl("From List..."), Intl.intl("Choose allowed components from a list.")),
            UP_ONLY(Intl.intl("Up Only"), Intl.intl("Only allow components that move occupants up.")),
            DOWN_ONLY(Intl.intl("Down Only"), Intl.intl("Only allow components that move occupants down.")),
            FROM_BEHAVIOR(Intl.intl("Based on Behavior"), Intl.intl("Only use elevators if part of a \"Goto Elevator\" behavior action."));

            public final String name;
            public final String desc;

            private Mode(String name, String desc) {
                this.name = name;
                this.desc = desc;
            }
        }
    }

    public static class AttractorRestrictions
    implements Serializable,
    Cloneable,
    IDirectDependent<MerlinData>,
    ICyclicSurrogate {
        static final long serialVersionUID = 1L;
        public Mode mode;
        public final boolean rejected;
        public Set<Attractor> attractors;

        public AttractorRestrictions(Mode mode, boolean rejected, Set<Attractor> attractors) {
            this.mode = mode;
            this.rejected = rejected;
            this.attractors = attractors;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AttractorRestrictions ar = (AttractorRestrictions)obj;
            return ar.mode == this.mode && ar.rejected == this.rejected && ar.attractors.equals(this.attractors);
        }

        @Override
        public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AttractorRestrictions ar = (AttractorRestrictions)obj;
            return ar.mode == this.mode && ar.rejected == this.rejected && theUtil.surrogateSetsEqual(ar.attractors, this.attractors, comparedSet);
        }

        public int hashCode() {
            return 0x9AF73832 ^ Objects.hash(new Object[]{this.mode, this.rejected, this.attractors});
        }

        public AttractorRestrictions clone() {
            try {
                return (AttractorRestrictions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public Predicate<Attractor> getFilter() {
            return this.mode.getFilter.apply(this);
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            deps.add(DLink.WEAK, this.attractors);
        }

        @Override
        public void replaceDependency(MerlinData md, Object old, Object replacement) {
            if (this.attractors.contains(old)) {
                this.attractors = new LinkedIdentityHashSet<Attractor>((Collection<Attractor>)this.attractors);
                this.attractors.remove(old);
                if (replacement != null) {
                    this.attractors.add((Attractor)replacement);
                }
                if (this.attractors.isEmpty()) {
                    this.mode = this.rejected ? Mode.ALL : Mode.NONE;
                }
            }
        }

        public String toString() {
            return this.mode.format.apply(this);
        }

        public static enum Mode {
            ALL(Intl.intl("All"), Intl.intl("Allow all components to be used."), ar -> Filters.acceptAll()),
            NONE(Intl.intl("None"), Intl.intl("Allow no components to be used."), ar -> Filters.rejectAll()),
            FROM_LIST(Intl.intl("From List..."), Intl.intl("Choose allowed components from a list."), ar -> ar.rejected ? Filters.reject(ar.attractors) : Filters.accept(ar.attractors), ar -> ar.rejected ? String.format(Intl.intl("Reject: %s"), OccProfile.formatObjNames(ar.attractors, Intl.intl("None"))) : String.format(Intl.intl("Accept: %s"), OccProfile.formatObjNames(ar.attractors, Intl.intl("None"))));

            public final String name;
            public final String desc;
            public final Function<AttractorRestrictions, Predicate<Attractor>> getFilter;
            public final Function<AttractorRestrictions, String> format;

            private Mode(String name, String desc, Function<AttractorRestrictions, Predicate<Attractor>> getFilter) {
                this(name, desc, getFilter, ar -> name);
            }

            private Mode(String name, String desc, Function<AttractorRestrictions, Predicate<Attractor>> getFilter, Function<AttractorRestrictions, String> format) {
                this.name = name;
                this.desc = desc;
                this.getFilter = getFilter;
                this.format = format;
            }
        }
    }

    public static class PropHasher {
        public final OccProfile profile;
        public final Predicate<IPropertySet.Prop> propFilter;

        public PropHasher(OccProfile profile, Predicate<IPropertySet.Prop> propFilter) {
            this.profile = profile;
            this.propFilter = propFilter;
        }

        public int hashCode() {
            List<IPropertySet.Prop<?>> allPropTypes = ALL_PROPS;
            ArrayList values = new ArrayList(allPropTypes.size());
            for (int m = 0; m < allPropTypes.size(); ++m) {
                IPropertySet.Prop<?> prop = allPropTypes.get(m);
                if (!this.propFilter.test(prop)) continue;
                values.add(this.profile.getProperty(prop));
            }
            return 0x437FA3 ^ values.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropHasher)) {
                return false;
            }
            PropHasher hasher = (PropHasher)obj;
            if (hasher.profile == this.profile) {
                return true;
            }
            for (IPropertySet.Prop prop : OccProfile.getAllPropTypes()) {
                Object v2;
                Object v1;
                if (!this.propFilter.test(prop) || Objects.deepEquals(v1 = this.profile.getProperty(prop), v2 = this.profile.getProperty(prop))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ProfileFunctionProp
    extends IPropertySet.Prop<IProfileFunction>
    implements INamedProp {
        public final Function1dProp fprop;

        public ProfileFunctionProp(Function1dProp fprop) {
            super(fprop.key, FromLevelFundamental.INSTANCE);
            this.fprop = fprop;
        }

        @Override
        public String getDisplayName() {
            return this.fprop.getDisplayName();
        }
    }

    public static class ConstProfileFunction
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IFunction1d function;

        public ConstProfileFunction(IFunction1d fund) {
            this.function = fund;
        }

        @Override
        public IFunction1d apply(OccProfile profile) {
            return this.function;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ConstProfileFunction && ((ConstProfileFunction)obj).function.equals(this.function);
        }

        public int hashCode() {
            return 0x1908F3E ^ this.function.hashCode();
        }
    }

    public static class FromLevelFundamental
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final FromLevelFundamental INSTANCE = new FromLevelFundamental();

        private FromLevelFundamental() {
        }

        @Override
        public IFunction1d apply(OccProfile profile) {
            return profile.getProperty(PROP_FUNDAMENTAL);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    public static interface IProfileFunction
    extends Function<OccProfile, IFunction1d> {
    }

    public static class OccShape
    implements Serializable,
    IRestorable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public VehicleShape vehicleShape;
        public ICurve shoulderWidth;
        public UnitDouble geomShoulderWidth;
        public Double minSqueezeFactor;
        public ICurve height;
        public final VehicleShape.ShapeType type;

        public OccShape(VehicleShape vehicleShape, ICurve shoulderWidth, UnitDouble geomShoulderWidth, ICurve height, Double minSqueezeFactor) {
            this.vehicleShape = vehicleShape;
            this.shoulderWidth = shoulderWidth;
            this.geomShoulderWidth = geomShoulderWidth;
            this.height = height;
            this.minSqueezeFactor = minSqueezeFactor;
            this.type = vehicleShape == null ? VehicleShape.ShapeType.CYLINDER : VehicleShape.ShapeType.POLYGON;
        }

        public int hashCode() {
            int hash = 1018420;
            switch (this.type) {
                case CYLINDER: {
                    hash += Objects.hash(this.shoulderWidth, this.geomShoulderWidth, this.height, this.minSqueezeFactor);
                    break;
                }
                case POLYGON: {
                    hash += Objects.hash(this.vehicleShape, this.minSqueezeFactor);
                }
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof OccShape)) {
                return false;
            }
            OccShape otherShape = (OccShape)other;
            if (this.type != otherShape.type) {
                return false;
            }
            if (!Objects.equals(this.minSqueezeFactor, otherShape.minSqueezeFactor)) {
                return false;
            }
            switch (this.type) {
                case CYLINDER: {
                    return this.shoulderWidth.equals(otherShape.shoulderWidth) && Objects.equals(this.geomShoulderWidth, otherShape.geomShoulderWidth) && this.height.equals(otherShape.height);
                }
                case POLYGON: {
                    return Objects.equals(this.vehicleShape, otherShape.vehicleShape);
                }
            }
            return false;
        }

        @Override
        public void restoreFrom(Object obj) {
            if (!(obj instanceof OccShape)) {
                return;
            }
            OccShape vs = (OccShape)obj;
            this.vehicleShape = vs.vehicleShape;
            this.shoulderWidth = vs.shoulderWidth;
            this.geomShoulderWidth = vs.geomShoulderWidth;
            this.height = vs.height;
            this.minSqueezeFactor = vs.minSqueezeFactor;
        }

        @Override
        public Object getRestoreObj() {
            return this.clone();
        }

        public OccShape clone() {
            VehicleShape newVS = this.vehicleShape != null ? this.vehicleShape.clone() : null;
            OccShape clone = new OccShape(newVS, this.shoulderWidth, this.geomShoulderWidth, this.height, this.minSqueezeFactor);
            return clone;
        }

        public UnitDouble getWidth() {
            if (this.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
                return this.shoulderWidth.getMax();
            }
            if (this.type.equals((Object)VehicleShape.ShapeType.POLYGON)) {
                double w = VehicleBody.computeRadius(this.vehicleShape.getProperty(VehicleShape.PROP_PIVOT), this.vehicleShape.getBodyPoints());
                return new UnitDouble(w, SI.METER);
            }
            return null;
        }
    }

    public static final class SpeedInSmokeConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final SpeedInSmoke.Mode mode;
        public final UnitDouble customFuncVisThreshold;
        public final SpeedInSmoke.FuncType customFuncVisType;
        public final IFunction1d customFuncVis;

        public SpeedInSmokeConfig(SpeedInSmoke.Mode mode, UnitDouble customFuncVisThreshold, SpeedInSmoke.FuncType customFuncVisType, IFunction1d customFuncVis) {
            this.mode = mode;
            this.customFuncVisThreshold = customFuncVisThreshold;
            this.customFuncVisType = customFuncVisType;
            this.customFuncVis = customFuncVis;
        }

        public SpeedInSmokeConfig(SpeedInSmoke.Data interop) {
            this.mode = interop.mode;
            this.customFuncVisThreshold = interop.customFuncVisThreshold;
            this.customFuncVisType = interop.customFuncVisType;
            this.customFuncVis = interop.customFuncVis != null ? PiecewiseFunction1d.newFunction(interop.customFuncVis) : null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.customFuncVis, this.customFuncVisThreshold, this.customFuncVisType, this.mode});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpeedInSmokeConfig other = (SpeedInSmokeConfig)obj;
            return Objects.equals(this.customFuncVis, other.customFuncVis) && Objects.equals(this.customFuncVisThreshold, other.customFuncVisThreshold) && this.customFuncVisType == other.customFuncVisType && this.mode == other.mode;
        }

        public String toString() {
            return "SpeedInSmokeConfig [mode=" + (Object)((Object)this.mode) + ", customFuncVisThreshold=" + this.customFuncVisThreshold + ", customFuncVisType=" + (Object)((Object)this.customFuncVisType) + ", customFuncVis=" + this.customFuncVis + "]";
        }
    }

    public static class Spacing
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final SpacingType type;
        public final ICurve val;

        public Spacing(SpacingType type, ICurve val) {
            this.type = type;
            this.val = val;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Spacing && ((Spacing)o).type == this.type && ((Spacing)o).val.equals(this.val);
        }

        public int hashCode() {
            return 0xA234FF3E ^ Objects.hash(new Object[]{this.type, this.val});
        }

        public String toString() {
            String desc = this.type.desc;
            return String.format("%s=%s", desc, this.val.toString());
        }
    }

    public static enum SpacingType {
        COMFORT_DIST(Intl.intl("Comfort Distance"), (agent, rnd) -> agent.getProfile().getSpacingVal((Random)rnd, agent.getProfileSeed())),
        DENSITY(Intl.intl("From Queue Density"), (agent, rnd) -> {
            UnitDouble radius = ((UnitDouble)agent.calcDistributedProfileVal(PROP_DIAMETER, (Random)rnd)).scale(0.5);
            UnitDouble density = agent.getProfile().getSpacingVal((Random)rnd, agent.getProfileSeed());
            double cd = OccProfile.getComfortDistanceFromDensity(density.getValue(Unit.ONE.divide(SI.METER.pow(2))), radius.getValue(SI.METER));
            return new UnitDouble(cd, SI.METER);
        }),
        AREA(Intl.intl("From Queue Area"), (agent, rnd) -> {
            UnitDouble radius = ((UnitDouble)agent.calcDistributedProfileVal(PROP_DIAMETER, (Random)rnd)).scale(0.5);
            UnitDouble area = agent.getProfile().getSpacingVal((Random)rnd, agent.getProfileSeed());
            double cd = OccProfile.getComfortDistanceFromDensity(1.0 / area.getValue(SI.METER.pow(2)), radius.getValue(SI.METER));
            return new UnitDouble(cd, SI.METER);
        });

        public final String desc;
        public final BiFunction<EgressAgent, Random, UnitDouble> getComfortDist;

        private SpacingType(String desc, BiFunction<EgressAgent, Random, UnitDouble> gcd) {
            this.desc = desc;
            this.getComfortDist = gcd;
        }
    }

    public static class IsLocalProp<T> {
        public final IPropertySet.Prop<T> prop;

        public IsLocalProp(IPropertySet.Prop<T> prop) {
            this.prop = prop;
        }

        public boolean equals(Object obj) {
            return obj instanceof IsLocalProp && ((IsLocalProp)obj).prop.equals(this.prop);
        }

        public int hashCode() {
            return 157782591 + this.prop.hashCode();
        }

        public String toString() {
            return "[OccProfile.IsLocalProp:" + this.prop.key + "]";
        }
    }

    public static class Prop<T>
    extends IPropertySet.Prop<T>
    implements INamedProp {
        public final long seed;
        public final boolean geometric;
        public final boolean canBeDisabled;
        public final String displayName;
        public final String description;

        public Prop(String name, T defVal, boolean geometric, String displayName) {
            this(name, 0L, defVal, geometric, displayName);
        }

        public Prop(String name, long seed, T defVal, boolean geometric, String displayName) {
            this(name, seed, defVal, geometric, displayName, false);
        }

        public Prop(String name, long seed, T defVal, boolean geometric, String displayName, boolean canBeDisabled) {
            this(name, seed, defVal, geometric, displayName, "", canBeDisabled);
        }

        public Prop(String name, long seed, T defVal, boolean geometric, String displayName, String description, boolean canBeDisabled) {
            super(name, defVal);
            this.seed = seed;
            this.geometric = geometric;
            this.displayName = displayName;
            this.description = description;
            this.canBeDisabled = canBeDisabled;
        }

        public boolean isDistributed() {
            return this.defVal instanceof IDistributedVal;
        }

        public <T2> IDistributedVal<T2> newDistConstant(T2 val) {
            if (this.defVal instanceof IUrn) {
                return new Urn<T2>(Collections.singleton(val));
            }
            if (this.defVal instanceof ICurve) {
                assert (this.defVal instanceof ICurve && val instanceof UnitDouble);
                UnitDouble ud = (UnitDouble)val;
                return this.canBeDisabled && Double.isNaN(ud.getRawValue()) ? new DisabledCurve(ud.getUnit()) : new ConstantCurve((UnitDouble)val);
            }
            return null;
        }

        public String toString() {
            return "[OccProfile.Prop:" + this.key + "]";
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        public String getHtmlDescr() {
            return guiUtil.encodeToHtmlLabel(this.description);
        }
    }
}

