/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupObj;
import merlin.data.Proxy;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.Inter2D;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class EgressAgent
extends AMerlinObj
implements Serializable,
IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate,
IOrientable {
    static final long serialVersionUID = 1L;
    public static final UnitDouble AVG_SHOULDER_WIDTH = new UnitDouble(0.4558, SI.METER);
    public static final Object NAME = NamedMerlinObj.NAME;
    public static final Object LOC = "Agent.LOC";
    public static final Object ORIENT = "Agent.ORIENT";
    public static final Object PROFILE = "Agent.Profile";
    public static final Object BEHAVIOR = "Agent.Behavior";
    public static final Object MOVEMENT_GROUP = "Agent.MovementGroup";
    public static final IPropertySet.Prop<Long> PROFILE_SEED = MerlinData.SEED;
    private static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>(Arrays.asList(NAME, LOC, ORIENT, PROFILE, BEHAVIOR, MOVEMENT_GROUP, PROFILE_SEED));
    private static final Set<Object> s_propTypes = Sets.appendLHS(Sets.appendLHS(OccProfile.PROP_TYPES, PROP_TYPES.toArray()), MerlinData.VISIBILITY, MerlinData.ENABLED);
    private String d_name;
    @SkipDep
    private OccProfile d_profile;
    private long d_profileSeed;
    private long d_orientSeed;
    private OccLocation d_location = new OccLocation(new Point3d());
    private Behavior d_behavior;
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Object d_exit = null;
    private static final double PI2 = Math.PI * 2;

    public EgressAgent(OccProfile prof, Behavior behavior) {
        this(prof, behavior, MerlinUtil.newSeed());
    }

    public EgressAgent(OccProfile prof, Behavior behavior, long profileSeed) {
        assert (prof.getProfParent() != null);
        this.d_profile = prof;
        this.d_behavior = behavior;
        this.d_profileSeed = profileSeed;
        this.d_orientSeed = profileSeed;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.d_profile == null) {
            this.d_profile = new OccProfile();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0004)) {
            this.d_profileSeed = MerlinUtil.newSeed();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0123)) {
            this.d_orientSeed = this.d_profileSeed;
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        this.d_location.writeTopology(oos);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_location.readTopology(ois);
    }

    @Override
    public EgressAgent clone() {
        EgressAgent agent = (EgressAgent)super.clone();
        agent.d_profile = this.d_profile.clone();
        return agent;
    }

    public Predicate<IEgressOccupiable> getRoomFilter() {
        return EgressAgent.getRoomFilter(this.d_profile);
    }

    public static Predicate<IEgressOccupiable> getRoomFilter(OccProfile profile) {
        Predicate<IEgressOccupiable> filter = Filters.acceptAll(IEgressOccupiable.class);
        MerlinData md = (MerlinData)profile.getDomain();
        if (md == null) {
            return filter;
        }
        OccProfile.CompRestrictions compRestrictions = profile.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
        return Predicates.and(filter, o -> compRestrictions.isAccepted((IMerlinObj)o));
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        assert (obj instanceof EgressAgent);
        EgressAgent agent = (EgressAgent)obj;
        this.pauseUpdates();
        this.d_name = agent.d_name;
        this.setProfile(agent.d_profile);
        this.d_behavior = agent.d_behavior;
        this.d_profileSeed = agent.d_profileSeed;
        this.d_orientSeed = agent.d_orientSeed;
        this.d_visible = agent.d_visible;
        this.d_enabled = agent.d_enabled;
        this.setLocation(agent.d_location);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public boolean getAssistanceOffered() {
        return !this.getBehavior().flatten(AssistOccupants.class).isEmpty();
    }

    public boolean getAssistanceDesired() {
        VehicleShape shape = this.getProfile().getProperty(OccProfile.PROP_VEHICLE_SHAPE);
        if (shape == VehicleShape.NONE) {
            return false;
        }
        if (this.calcDistributedProfileVal(OccProfile.PROP_REQUIRES_ASSISTANCE, new Random()).booleanValue()) {
            return true;
        }
        return !this.getBehavior().flatten(WaitForAssistance.class).isEmpty();
    }

    @Override
    public boolean updateTopo() {
        OccLocation loc;
        this.d_location = loc = ((MerlinData)this.getDomain()).findValidOccLocation(this.getProfile(), this.getProfileSeed(), this.d_location.point, this.getAngle().getValue(Geometry.ANGLE_UNIT), 0, Filters.accept(this));
        this.changedEvt(new Object[0]);
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.getRoom() == null;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class, EgressAgent.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        ArrayList<IEgressObj> conns = new ArrayList<IEgressObj>(this.d_location.getOverlappingAgents().size() + 1);
        if (this.d_location.room != null) {
            conns.add(this.d_location.room);
        }
        conns.addAll(this.d_location.getOverlappingAgents());
        return conns;
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (obj instanceof EgressAgent && this.d_location.add((EgressAgent)obj)) {
            this.changedEvt(MerlinData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (obj instanceof IEgressOccupiable) {
            if (this.d_location.room == obj) {
                this.d_location = new OccLocation(null, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, this.d_location.point);
                this.changedEvt(MerlinData.CONNECTION);
            }
        } else if (obj instanceof EgressAgent && this.d_location.remove((EgressAgent)obj)) {
            this.changedEvt(MerlinData.CONNECTION);
        }
    }

    @Override
    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.agentOverlapDetector.add(this);
        this.d_profile.setDomain(domain);
    }

    @Override
    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        this.d_profile.setDomain(null);
        domain.agentOverlapDetector.remove(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location.point;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location.point;
    }

    private void markOverlapDirty() {
        if (this.getDomain() != null) {
            ((MerlinData)this.getDomain()).agentOverlapDetector.update(this);
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.d_visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public void setName(String name) {
        this.d_name = name;
        this.changedEvt(NAME);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    public static UnitDouble getShoulderWidth(OccProfile profile, long profileSeed) {
        return (UnitDouble)EgressAgent.calcDistributedProfileVal(profile, OccProfile.PROP_DIAMETER, new Random(), 0L, profileSeed);
    }

    public UnitDouble getShoulderWidth() {
        return (UnitDouble)this.calcDistributedProfileVal(OccProfile.PROP_DIAMETER, new Random());
    }

    public UnitDouble getMaxShoulderWidth() {
        ICurve diam = this.d_profile.getProperty(OccProfile.PROP_DIAMETER);
        return diam.getMax();
    }

    public UnitDouble getGeomShoulderWidth(boolean nullAllowed) {
        UnitDouble geomDiameter = this.getProfile().getProperty(OccProfile.PROP_GEOM_DIAMETER);
        if (geomDiameter == null) {
            return nullAllowed ? null : this.getShoulderWidth();
        }
        return geomDiameter;
    }

    public OccGroupObj getMovementGroup() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return null;
        }
        for (Proxy<? extends ICompElement> proxy : md.proxies.getProxies(this)) {
            Object parent = md.hierarchy.getParent(proxy);
            if (!(parent instanceof OccGroupObj)) continue;
            return (OccGroupObj)parent;
        }
        return null;
    }

    public UnitDouble getAngle() {
        return (UnitDouble)this.calcDistributedProfileVal(OccProfile.PROP_INIT_ORIENT, new Random());
    }

    public UnitDouble getMaxSpeed() {
        ICurve vel = this.d_profile.getProperty(OccProfile.PROP_MAXVEL);
        return vel.getMax();
    }

    public IAvatar getAvatar() {
        return this.d_profile.getDistVal(OccProfile.PROP_OCCMODEL, new Random(), this.d_profileSeed);
    }

    public long getProfileSeed() {
        return this.d_profileSeed;
    }

    public void setProfileSeed(long seed) {
        if (this.d_profileSeed == seed) {
            return;
        }
        this.d_profileSeed = seed;
        this.updateProps();
    }

    public long getOrientSeed() {
        return this.d_orientSeed;
    }

    public void setOrientSeed(long seed) {
        if (this.d_orientSeed == seed) {
            return;
        }
        this.d_orientSeed = seed;
        this.updateProps();
    }

    public void setLocation(OccLocation loc) {
        if (this.d_location.equals(loc)) {
            return;
        }
        this.d_location = new OccLocation(this.d_location.room, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, loc.point);
        this.markTopoDirty();
        this.markOverlapDirty();
        this.changedEvt(LOC);
    }

    public void setOrient(double angle) {
        UnitDouble newAngle;
        UnitDouble oldAngle = (UnitDouble)this.getProfileProp(OccProfile.PROP_INIT_ORIENT);
        if (!EgressAgent.equalAngles(oldAngle, newAngle = new UnitDouble(angle, Geometry.ANGLE_UNIT), 1.0E-9)) {
            this.setConstantProfileProp(OccProfile.PROP_INIT_ORIENT, new ConstantCurve(newAngle));
            this.markTopoDirty();
            this.markOverlapDirty();
            this.changedEvt(ORIENT);
        }
    }

    @Override
    public void setOrientTarget(Point3d target) {
        UnitDouble angle = GeomUtil.getOccOrient(this.getLocation(), target);
        this.setOrient(angle);
    }

    @Override
    public void setOrient(UnitDouble angle) {
        this.setOrient(angle.get(Geometry.ANGLE_UNIT));
    }

    private static double toCompareAngle(UnitDouble angle) {
        double arad = angle.get(SI.RADIAN);
        double div = arad / (Math.PI * 2);
        double frac = (div - Math.floor(div)) * (Math.PI * 2);
        return frac;
    }

    private static boolean equalAngles(UnitDouble a1, UnitDouble a2, double tol) {
        double a1r = EgressAgent.toCompareAngle(a1);
        double a2r = EgressAgent.toCompareAngle(a2);
        return theUtil.eq(a1r, a2r, tol);
    }

    public IEgressOccupiable getRoom() {
        return this.d_location.room;
    }

    public Point3d getLocation() {
        return this.d_location.point;
    }

    public OccLocation getLocInfo() {
        return this.d_location;
    }

    @Override
    public IGeomNode getGeom() {
        boolean checkAttachedPositions = true;
        AgentGeom geom = new AgentGeom(this.getProfile().getProperty(OccProfile.PROP_SHAPE), this.d_location, this.getShoulderWidth().getValue(Geometry.LENGTH_UNIT) * 0.5, this.getAngle().getValue(Geometry.ANGLE_UNIT), this.getRoomFilter(), checkAttachedPositions);
        return GeomNodeUtil.newNode(geom);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (geom instanceof AgentGeom) {
            AgentGeom ag = (AgentGeom)geom;
            this.setLocation(ag.location);
            this.setOrient(ag.angle);
        } else if (geom instanceof Point) {
            this.setLocation(new OccLocation(((Point)geom).loc));
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box, IDisplayProps dprops) {
    }

    @Override
    public void pickPoints(thunderheadeng.scene3d.picking.IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
    }

    public String toString() {
        return "name=" + this.d_name + " loc=" + this.getLocation();
    }

    public OccProfile getProfile() {
        return this.d_profile;
    }

    public void setProfile(OccProfile profile) {
        this.d_profile = profile;
        this.d_profile.setDomain(this.getDomain());
        this.pauseUpdates();
        this.markTopoDirty();
        this.changedEvt(PROFILE);
        this.resumeUpdates();
    }

    public void setProfileParent(OccProfile parent) {
        this.pauseUpdates();
        this.d_profile.setProfParent(parent);
        this.markTopoDirty();
        this.changedEvt(PROFILE);
        this.resumeUpdates();
    }

    public Object getAndClearPre9ExitObj() {
        Object exit = this.d_exit;
        this.d_exit = null;
        return exit;
    }

    public Set<EgressDoor> getAndClearPre17Exits() {
        try {
            if (this.d_exit == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            if (this.d_exit instanceof EgressDoor) {
                IdentityHashSet<EgressDoor> identityHashSet = Sets.fromArrayIHS((EgressDoor)this.d_exit);
                return identityHashSet;
            }
            Set set = (Set)this.d_exit;
            return set;
        }
        finally {
            this.d_exit = null;
        }
    }

    public Behavior getBehavior() {
        return this.d_behavior;
    }

    public void setBehavior(Behavior behavior) {
        this.d_behavior = behavior;
        this.pauseUpdates();
        this.markOverlapDirty();
        this.markTopoDirty();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return s_propTypes;
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (prop == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        if (prop == LOC) {
            return this.getLocation();
        }
        if (prop == NAME) {
            return this.d_name;
        }
        if (prop == PROFILE) {
            return this.d_profile;
        }
        if (prop == BEHAVIOR) {
            return this.getBehavior();
        }
        if (prop == MOVEMENT_GROUP) {
            return this.getMovementGroup();
        }
        if (prop == PROFILE_SEED) {
            return this.getProfileSeed();
        }
        if (prop instanceof IPropertySet.Prop) {
            return this.getProfileProp((IPropertySet.Prop)prop);
        }
        if (prop instanceof OccProfile.IsLocalProp) {
            return this.getProfile().getProperty(prop);
        }
        if (prop == OccProfile.PROP_PROF_PARENT) {
            return this.getProfile().getProfParent();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object prop, T value) {
        if (prop == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (prop == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else if (prop == NAME) {
            this.d_name = (String)value;
            this.changedEvt(prop);
        } else if (prop == PROFILE) {
            this.setProfile((OccProfile)value);
        } else if (prop == BEHAVIOR) {
            this.setBehavior((Behavior)value);
        } else if (prop == PROFILE_SEED) {
            this.setProfileSeed((Long)value);
        } else if (prop instanceof IPropertySet.Prop) {
            this.setProfileProp((IPropertySet.Prop)prop, value);
        } else if (prop instanceof OccProfile.IsLocalProp) {
            OccProfile.IsLocalProp ilp = (OccProfile.IsLocalProp)prop;
            Boolean val = (Boolean)value;
            if (!val.booleanValue()) {
                this.removeProfileProp(ilp.prop);
            } else {
                Object distVal = this.getProfileProp(ilp.prop);
                this.setProfileProp(ilp.prop, distVal);
            }
        } else if (prop == OccProfile.PROP_PROF_PARENT) {
            this.setProfileParent((OccProfile)value);
        } else assert (false) : "Unsupported Operation: <EgressAgent>.setProperty(" + prop + ")";
    }

    public Object getProfileProp(IPropertySet.Prop<?> oprop) {
        if (oprop == OccProfile.PROP_SPACING) {
            OccProfile.Spacing spacing = this.getProfile().getProperty(OccProfile.PROP_SPACING);
            UnitDouble val = this.getProfile().getSpacingVal(new Random(), this.getProfileSeed());
            return new OccProfile.Spacing(spacing.type, new ConstantCurve(val));
        }
        if (oprop == OccProfile.PROP_SHAPE) {
            UnitDouble shoulderWidth = (UnitDouble)this.calcDistributedProfileVal(OccProfile.PROP_DIAMETER, new Random());
            UnitDouble geomShoulderWidth = this.getProfile().getProperty(OccProfile.PROP_GEOM_DIAMETER);
            UnitDouble height = (UnitDouble)this.calcDistributedProfileVal(OccProfile.PROP_HEIGHT, new Random());
            VehicleShape vehicleShape = this.getProfile().getProperty(OccProfile.PROP_VEHICLE_SHAPE);
            Double minSqueezeFactor = this.getProfile().getProperty(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST);
            return new OccProfile.OccShape(vehicleShape, new ConstantCurve(shoulderWidth), geomShoulderWidth, new ConstantCurve(height), minSqueezeFactor);
        }
        if (oprop instanceof OccProfile.Prop && ((OccProfile.Prop)oprop).isDistributed()) {
            return this.calcDistributedProfileVal((OccProfile.Prop)oprop, new Random());
        }
        return this.getProfile().getProperty(oprop);
    }

    public <T> T calcDistributedProfileVal(OccProfile.Prop<? extends IDistributedVal<T>> oprop, Random rnd) {
        return EgressAgent.calcDistributedProfileVal(this.getProfile(), oprop, rnd, this.getOrientSeed(), this.getProfileSeed());
    }

    public static <T> T calcDistributedProfileVal(OccProfile profile, OccProfile.Prop<? extends IDistributedVal<T>> oprop, Random rnd, long orientSeed, long profileSeed) {
        assert (oprop.isDistributed());
        long seed = oprop == OccProfile.PROP_INIT_ORIENT ? orientSeed : profileSeed;
        return profile.getDistVal(oprop, rnd, seed);
    }

    public <T> T calcDistributedVal(IDistributedVal<T> dval, long propSeed, Random rnd) {
        return OccProfile.getDistVal(dval, propSeed, rnd, this.getProfileSeed());
    }

    public void setProfileProp(IPropertySet.Prop oprop, Object value) {
        if (oprop instanceof OccProfile.Prop && ((OccProfile.Prop)oprop).isDistributed()) {
            this.setDistributedProfileProp((OccProfile.Prop)oprop, value);
        } else {
            this.setConstantProfileProp(oprop, value);
        }
    }

    private <T> void setConstantProfileProp(IPropertySet.Prop<T> oprop, T value) {
        this.pauseUpdates();
        this.getProfile().setProperty(oprop, value);
        this.propChanged(oprop);
        this.resumeUpdates();
    }

    public <T> void setDistributedProfileProp(OccProfile.Prop<? extends IDistributedVal<T>> oprop, T value) {
        assert (oprop.isDistributed());
        this.setConstantProfileProp(oprop, oprop.newDistConstant(value));
    }

    public void removeProfileProp(IPropertySet.Prop<?> prop) {
        this.pauseUpdates();
        this.getProfile().remove(prop);
        this.propChanged(prop);
        this.resumeUpdates();
    }

    protected void propChanged(IPropertySet.Prop<?> prop) {
        if (prop instanceof OccProfile.Prop && ((OccProfile.Prop)prop).geometric) {
            this.markTopoDirty();
        }
        if (prop == OccProfile.PROP_DIAMETER || prop == OccProfile.PROP_SHAPE) {
            this.markOverlapDirty();
        }
        this.changedEvt(PROFILE);
    }

    public void updateProps() {
        this.markTopoDirty();
        this.markOverlapDirty();
        this.changedEvt(PROFILE);
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        assert (old != this.d_profile);
        if (old == this.d_profile.getProfParent()) {
            replacement = replacement != null ? replacement : md.profiles.DEFAULT;
            this.setProfileParent((OccProfile)replacement);
        } else if (old == this.getBehavior()) {
            replacement = replacement != null ? replacement : md.behaviors.DEFAULT;
            this.setBehavior((Behavior)replacement);
        }
        this.d_profile.replaceDependency(md, old, replacement);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getProperty(OccProfile.PROP_PROF_PARENT));
        deps.add(DLink.WEAK, this.getProperty(BEHAVIOR));
        for (IPropertySet.Prop<?> prop : OccProfile.ALL_PROPS) {
            if (!this.d_profile.isDefinedLocally(prop)) continue;
            deps.add(DLink.WEAK, this.d_profile.getProperty(prop));
        }
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Object prop : PROP_TYPES) {
            hash = 31 * hash + theUtil.hashCode(this.getProperty(prop));
        }
        return hash;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        EgressAgent comparableAgent = (EgressAgent)comparable;
        for (Object prop : PROP_TYPES) {
            if (theUtil.equal(this.getProperty(prop), comparableAgent.getProperty(prop), comparedSet)) continue;
            return false;
        }
        return true;
    }

    protected static class AgentGeom
    implements IGeom,
    IManipulatable {
        private static final long serialVersionUID = -5824877637848085033L;
        private final OccLocation location;
        private final double radius;
        private final Predicate<IEgressOccupiable> roomFilter;
        private final OccProfile.OccShape shape;
        private final double angle;
        private final boolean includeAttachedPositions;

        public AgentGeom(OccProfile.OccShape shape, OccLocation loc, double radius, double angle, Predicate<IEgressOccupiable> roomFilter, boolean includesAttachedPositions) {
            this.shape = shape;
            this.location = loc;
            this.radius = radius;
            this.angle = angle;
            this.roomFilter = roomFilter;
            this.includeAttachedPositions = includesAttachedPositions;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            return this;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            AABox aabox;
            Point3d loc = this.location.point;
            switch (this.shape.type) {
                case POLYGON: {
                    Point3d[] points = this.includeAttachedPositions ? this.shape.vehicleShape.getOuterPoints(loc, this.angle) : this.shape.vehicleShape.getBodyPoints(loc, this.angle);
                    aabox = new AABox(points);
                    break;
                }
                default: {
                    Point3d min = new Point3d(loc.x - this.radius, loc.y - this.radius, loc.z - this.radius);
                    Point3d max = new Point3d(loc.x + this.radius, loc.y + this.radius, loc.z + this.radius);
                    aabox = new AABox(min, max);
                }
            }
            aabb.add(aabox);
            return aabb;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Point3d newLoc = Util3D.xform(xform, this.location.point);
            Vector3d ref = new Vector3d(1.0, 0.0, 0.0);
            Inter.rotateTuple2D(ref, this.angle, GeomConstants.VEC3D_ZPOS);
            xform.transform(ref);
            double newAngle = Util3D.angle0To2PI(GeomConstants.VEC3D_XPOS, new Vector3d(ref.x, ref.y, 0.0), GeomConstants.VEC3D_ZPOS);
            OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.shape, newLoc, new UnitDouble(this.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.roomFilter);
            return new AgentGeom(this.shape, loc, this.radius, newAngle, this.roomFilter, this.includeAttachedPositions);
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public boolean isShell() {
            return false;
        }

        @Override
        public int getNumPrims(int types) {
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean canExplode() {
            return false;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            return prims;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, thunderheadeng.geometry.objs.IBoxCollector isects) throws CancelObjectPicking {
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new LocHandle(this));
            handles.accept(new OrientHandle(this));
        }

        protected static class OrientHandle
        implements IHandle {
            private final double handleLength;
            private AgentGeom d_geom;

            public OrientHandle(AgentGeom geom) {
                double handleLength;
                this.d_geom = geom;
                if (((AgentGeom)geom).shape.type == VehicleShape.ShapeType.POLYGON && ((AgentGeom)geom).shape.vehicleShape != null) {
                    Point3d[] shape = ((AgentGeom)geom).shape.vehicleShape.getBodyPoints();
                    Point3d centroid = Util3D.simplePolygonCentroid(shape);
                    double minDistSq = Double.MAX_VALUE;
                    for (int m = 0; m < shape.length; ++m) {
                        Point3d p1 = shape[m];
                        Point3d p2 = shape[(m + 1) % shape.length];
                        double distsq = Inter3D.distSqToNearestPtOnLineSeg(p1, p2, centroid);
                        if (!(distsq < minDistSq)) continue;
                        minDistSq = distsq;
                    }
                    handleLength = minDistSq == Double.MAX_VALUE ? 1.0 : Math.sqrt(minDistSq);
                } else {
                    handleLength = geom.radius;
                }
                this.handleLength = Math.max(handleLength, 0.5);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof OrientHandle;
            }

            @Override
            public IGeomNode getGeom() {
                Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
                Inter.rotateTuple2D(orient, this.d_geom.angle, new Point3d(0.0, 0.0, 0.0));
                orient.scale(this.handleLength);
                orient.add(((AgentGeom)this.d_geom).location.point);
                Point3d orientPoint = new Point3d(orient);
                return GeomNodeUtil.newNode(new LineSeg(((AgentGeom)this.d_geom).location.point, orientPoint));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(Point3d newLoc) throws ManipException {
                Point3d agentLoc = ((AgentGeom)this.d_geom).location.point;
                Point3d agentOrient = new Point3d(agentLoc);
                agentOrient.add(new Point3d(1.0, 0.0, 0.0));
                double newAngle = Inter2D.getAngle(agentLoc, agentOrient, newLoc);
                OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.d_geom.shape, ((AgentGeom)this.d_geom).location.point, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.d_geom.roomFilter);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, newAngle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new PlanarConstraint(new Plane3d(GeomConstants.VEC3D_ZPOS, ((AgentGeom)this.d_geom).location.point));
            }
        }

        protected static class LocHandle
        implements IHandle {
            protected AgentGeom d_geom;

            public LocHandle(AgentGeom geom) {
                this.d_geom = geom;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof LocHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(((AgentGeom)this.d_geom).location.point));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                DefaultFilter filter = new DefaultFilter(IEgressOccupiable.class, GeomType.FACE){

                    @Override
                    public boolean acceptPickObject(Object obj) {
                        return super.acceptPickObject(obj) && ((IEgressOccupiable)obj).getOccupantsAllowed();
                    }
                };
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, filter);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(Point3d newLoc) throws ManipException {
                OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.d_geom.shape, newLoc, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), this.d_geom.angle, 0, this.d_geom.roomFilter);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, this.d_geom.angle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public AgentGeom end() {
                return this.d_geom;
            }
        }
    }
}

