/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.property.Function1dProp;
import merlin.data.stat.AutoCurve;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.MerlinUDF;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class OccSourceObj
extends NamedMerlinObj
implements ICompElement,
Cloneable,
IRestorable,
IMerlinGeomSrc,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final Unit FLOWRATE_UNIT = Unit.ONE.alternate("pers").divide(SI.SECOND);
    public static final Function1dProp PROP_FLOW_RATE = OccSourceObj.newFlowrateProp("OccSource.Flowrate", Intl.intl("Flow Rate"), Intl.intl("Modifies flow rate as a function of time."), new ConstFunction1d(new UnitDouble(1.0, FLOWRATE_UNIT)));
    public static final IPropertySet.Prop<IUrn<OccProfile>> PROP_PROFILE_DIST = new IPropertySet.Prop<Urn<OccProfile>>("OccSource.PROFILE_DIST", new Urn<OccProfile>(new OccProfile[0]));
    public static final IPropertySet.Prop<IUrn<Behavior>> PROP_BEHAVIOR_DIST = new IPropertySet.Prop<Urn<Behavior>>("OccSource.BEHAVIOR_DIST", new Urn<Behavior>(new Behavior[0]));
    public static final IPropertySet.Prop<IUrn<OccGroupTypeObj>> PROP_GROUP_TEMPLATE_DIST = new IPropertySet.Prop<Urn<OccGroupTypeObj>>("OccSource.GROUP_TEMPLATE_DIST", new Urn<OccGroupTypeObj>(new OccGroupTypeObj[0]));
    public static final OccProfile.Prop<IUrn<Boolean>> PROP_ENFORCE_FLOWRATE = new OccProfile.Prop<Urn<Boolean>>("OccSource.ENFORCE_FLOWRATE", 0L, new Urn<Boolean>(false), false, Intl.intl("Enforce Flow Rate"));
    public static final OccProfile.Prop<List<Point3d>> PROP_SPAWN_LOCS = new OccProfile.Prop("OccSource.SPAWN_LOCS", 0L, Collections.emptyList(), false, Intl.intl("Occupant Locations"));
    public static final OccProfile.Prop<IUrn<Boolean>> PROP_EMIT_AT_MAX_VEL = new OccProfile.Prop<Urn<Boolean>>("OccSource.EMIT_AT_MAX_VEL", 0L, new Urn<Boolean>(true), false, Intl.intl("Emit at Maximum Velocity"));
    public static final OccProfile.Prop<IEgressComp> PROP_COMPONENT = new OccProfile.Prop<Object>("OccSource.COMPONENT", 0L, null, false, Intl.intl("Component"));
    @Deprecated
    public static final IPropertySet.Prop<UnitDouble> PROP_GROUP_PROPORTION = new IPropertySet.Prop<UnitDouble>("OccGroupObj.SLOWDOWN_TIME", new UnitDouble(0.0, NonSI.PERCENT));
    public static final IPropertySet.Prop<Long> PROP_SEED = MerlinData.SEED;
    public static final IPropertySet.Prop<ICurve> PROP_INIT_ORIENT = OccProfile.PROP_INIT_ORIENT;
    private static final Set<IPropertySet.Prop<?>> SUPPORTED_OCC_PROFILE_PROPS = Sets.fromArrayHS(PROP_INIT_ORIENT);
    public static final Set<Object> PROP_TYPES = new HashSet<Object>();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private AABox d_box;
    private Map<Object, Object> d_data;
    private OccSourceType type;

    public static final Predicate<IEgressComp> occsAllowedFilter() {
        return r -> r instanceof IEgressOccupiable && ((IEgressOccupiable)r).getOccupantsAllowed() && !(r instanceof ElevatorRoom);
    }

    public OccSourceObj(String name, AABox box) {
        super(name);
        this.d_box = box;
        this.type = OccSourceType.REGION;
        this.init();
    }

    public OccSourceObj(String name, IEgressComp component) {
        super(name);
        this.type = OccSourceType.EGRESS_COMPONENT;
        this.init();
        this.set(PROP_COMPONENT, component);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.type == null) {
            this.type = OccSourceType.REGION;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0154)) {
            this.set(PROP_EMIT_AT_MAX_VEL, new Urn<Boolean>(false));
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0155)) {
            this.set(PROP_SEED, MerlinOIS.nextPre155OccSourceSeed(in));
        }
    }

    public boolean isGrouped(MerlinData md) {
        return this.get(PROP_GROUP_TEMPLATE_DIST).stream().anyMatch(gt -> gt != merlinData.occGroupTypes.NO_GROUP_TYPE);
    }

    public void init() {
        this.d_data = new ListMap<Object, Object>();
        this.set(PROP_SEED, MerlinUtil.newSeed());
        this.set(new ProfileOverride<ICurve>(PROP_INIT_ORIENT), true);
        this.set(PROP_INIT_ORIENT, new AutoCurve(SI.RADIAN));
    }

    public long getSeed() {
        return this.get(PROP_SEED);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.changedEvt(new Object[0]);
    }

    @Override
    public void restoreFrom(Object obj) {
        OccSourceObj c = (OccSourceObj)obj;
        this.d_box = c.d_box;
        this.d_data = c.d_data;
        this.d_visible = c.d_visible;
        this.d_enabled = c.d_enabled;
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public OccSourceObj clone() {
        OccSourceObj clone = (OccSourceObj)super.clone();
        clone.d_data = new ListMap<Object, Object>(this.d_data);
        return clone;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object prop, T value) {
        if (prop instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)prop, value);
            return;
        }
        if (prop == NAME) {
            this.setName((String)value);
        } else if (prop == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (prop == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == NAME) {
            return this.getName();
        }
        if (prop == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (prop == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        if (prop instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)prop);
        }
        return NOT_SUPPORTED;
    }

    public <T> boolean isOccProfilePropOverridden(IPropertySet.Prop<T> prop) {
        return OccSourceObj.isOccProfilePropSupported(prop) && this.get(new ProfileOverride<T>(prop)) != false;
    }

    public static <T> boolean isOccProfilePropSupported(IPropertySet.Prop<T> prop) {
        return SUPPORTED_OCC_PROFILE_PROPS.contains(prop);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop instanceof ProfileOverride) {
            ProfileOverride po = (ProfileOverride)prop;
            return (T)Boolean.valueOf(this.d_data.containsKey(po.prop.key));
        }
        return (T)this.d_data.getOrDefault(prop.key, prop.defVal);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (prop instanceof ProfileOverride) {
            ProfileOverride po = (ProfileOverride)prop;
            assert (OccSourceObj.isOccProfilePropSupported(po.prop));
            boolean override = (Boolean)value;
            if (!OccSourceObj.isOccProfilePropSupported(po.prop)) {
                return;
            }
            if (override && !this.d_data.containsKey(po.prop.key)) {
                this.setProperty(po.prop, po.prop.defVal);
            } else if (!override && this.d_data.containsKey(po.prop.key)) {
                this.d_data.remove(po.prop.key);
                this.changedEvt(po.prop);
            }
            return;
        }
        this.pauseUpdates();
        this.d_data.put(prop.key, value);
        if (prop == PROP_COMPONENT) {
            assert (value == null || value instanceof IEgressOccupiable || value instanceof EgressDoor);
            this.changedEvt(MerlinData.SELECTION_CHANGED);
        }
        this.changedEvt(prop);
        this.resumeUpdates();
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.get(PROP_PROFILE_DIST).getUnique());
        deps.add(DLink.WEAK, this.get(PROP_BEHAVIOR_DIST).getUnique());
        deps.add(DLink.WEAK, this.get(PROP_GROUP_TEMPLATE_DIST).getUnique());
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        if (old instanceof OccProfile) {
            this.replaceUrnValue(PROP_PROFILE_DIST, (OccProfile)old, (OccProfile)replacement);
        } else if (old instanceof Behavior) {
            this.replaceUrnValue(PROP_BEHAVIOR_DIST, (Behavior)old, (Behavior)replacement);
        } else if (old instanceof OccGroupTypeObj) {
            this.replaceUrnValue(PROP_GROUP_TEMPLATE_DIST, (OccGroupTypeObj)old, (OccGroupTypeObj)replacement);
        }
    }

    private <T> boolean replaceUrnValue(IPropertySet.Prop<IUrn<T>> prop, T old, T repl) {
        IUrn<T> urn = this.get(prop);
        Map<T, Double> dists = urn.getWeights();
        if (!dists.containsKey(old)) {
            return false;
        }
        dists = new LinkedIdentityHashMap<T, Double>(dists);
        Double oldDist = dists.remove(old);
        dists.merge(repl, oldDist, Double::sum);
        this.set(prop, new InfiniteUrn<T>(dists));
        return true;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        switch (this.type) {
            case REGION: {
                PropsBuilder gprops = new PropsBuilder();
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                Color translucentGreen = new Color(0, 255, 0, 120);
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                AABoxGeom geom = this.getRegionAreaGeom();
                Point3d min = geom.min;
                Point3d max = geom.max;
                Point3d p1 = geom.min;
                Point3d p2 = new Point3d(max.x, min.y, min.z);
                Point3d p3 = new Point3d(max.x, max.y, min.z);
                Point3d p4 = new Point3d(min.x, max.y, min.z);
                Point3d p5 = new Point3d(min.x, min.y, max.z);
                Point3d p6 = new Point3d(max.x, min.y, max.z);
                Point3d p7 = geom.max;
                Point3d p8 = new Point3d(min.x, max.y, max.z);
                ArrayList<LineSeg> lss = new ArrayList<LineSeg>();
                lss.add(new LineSeg(p1, p2));
                lss.add(new LineSeg(p2, p3));
                lss.add(new LineSeg(p3, p4));
                lss.add(new LineSeg(p4, p1));
                lss.add(new LineSeg(p1, p5));
                lss.add(new LineSeg(p2, p6));
                lss.add(new LineSeg(p3, p7));
                lss.add(new LineSeg(p4, p8));
                lss.add(new LineSeg(p5, p6));
                lss.add(new LineSeg(p6, p7));
                lss.add(new LineSeg(p7, p8));
                lss.add(new LineSeg(p8, p5));
                ArrayList<IManipulatable> geoms = new ArrayList<IManipulatable>();
                geoms.addAll(lss);
                geoms.add(geom);
                IGeom result = GeomUtil.group(geoms);
                return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(result), gprops);
            }
            case EGRESS_COMPONENT: {
                return DisplayGeom.EMPTY;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof AABoxGeom)) {
            return;
        }
        Point3d min = ((AABoxGeom)geom).min;
        Point3d max = ((AABoxGeom)geom).max;
        this.d_box = new AABox(min, max);
        this.changedEvt(new Object[0]);
    }

    @Override
    public IGeomNode getGeom() {
        switch (this.type) {
            case REGION: {
                return GeomNodeUtil.newNode(this.getRegionAreaGeom());
            }
            case EGRESS_COMPONENT: {
                if (Objects.equals(this.get(PROP_COMPONENT), null)) {
                    return DisplayGeom.EMPTY.node;
                }
                return this.getComponent().getGeom();
            }
        }
        assert (false);
        return null;
    }

    private AABoxGeom getRegionAreaGeom() {
        return new AABoxGeom(this.d_box);
    }

    private static Function1dProp newFlowrateProp(String name, String desc, String longDesc, IFunction1d defVal) {
        Function<Component, IFunction1d> f = comp -> OccSourceObj.newStepFunctionDialog(comp);
        Function1dProp.PredefFunction[] predefs = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("Step Function"), Intl.intl("Step Function"), f)};
        int persPerSecType = UnitSystem.getType(Unit.ONE.alternate("pers").divide(SI.SECOND));
        return new Function1dProp((Object)name, defVal, desc, longDesc, Intl.intl("Flow Rate by Time"), new Function1dProp.Integration(Intl.intl("Total Occupants: "), md -> md.simParams.runTimeMax), new Function1dProp.Var(Intl.intl("Time"), Intl.intl("Duration"), 1, UnitDoubleVR.above(SIUS.newud(0.0, 1), true)), new Function1dProp.Var(Intl.intl("Flow Rate"), persPerSecType, UnitDoubleVR.above(SIUS.newud(0.0, persPerSecType), true)), new UnitDouble[]{SIUS.newud(0.0, 1), SIUS.newud(0.0, 9), null, null}, predefs);
    }

    public UnitDouble getMaxWidth() {
        UnitDouble maxWidth = null;
        IUrn<OccProfile> propUrn = this.get(PROP_PROFILE_DIST);
        Iterator<OccProfile> iterator = propUrn.getWeights().keySet().iterator();
        while (iterator.hasNext()) {
            OccProfile o;
            OccProfile prof = o = iterator.next();
            OccProfile.OccShape shape = prof.getProperty(OccProfile.PROP_SHAPE);
            UnitDouble shapeWidth = shape.getWidth();
            if (maxWidth != null && shapeWidth.compareTo(maxWidth) <= 0) continue;
            maxWidth = shapeWidth;
        }
        return maxWidth;
    }

    private static IFunction1d newStepFunctionDialog(Component comp) {
        if (comp == null) {
            return null;
        }
        Window parent = SwingUtilities.getWindowAncestor(comp);
        FlowrateStepFunctionDialog dlg = new FlowrateStepFunctionDialog(parent, Intl.intl("Create Step Function"), 9);
        IFunction1d function = null;
        if (dlg.doModal() == 1) {
            dlg.validateData(true, false);
            function = dlg.createStepFunction();
        }
        return function;
    }

    public IEgressComp getComponent() {
        return this.get(PROP_COMPONENT);
    }

    public OccSourceType getType() {
        return this.type;
    }

    public Set<OccProfile> getAllProfiles() {
        return this.get(PROP_PROFILE_DIST).getUnique(LinkedHashSet.class);
    }

    public Set<Behavior> getAllBehaviors() {
        return this.get(PROP_BEHAVIOR_DIST).getUnique(LinkedHashSet.class);
    }

    public Set<OccGroupTypeObj> getAllGroupTemplates() {
        return this.get(PROP_GROUP_TEMPLATE_DIST).getUnique(LinkedHashSet.class);
    }

    public static void removeOccGroupTemplatesReferences(MerlinData md, Collection<OccGroupTypeObj> groupTemplatesToDel) {
        for (OccSourceObj source : md.occSources.flatten(OccSourceObj.class)) {
            IUrn<OccGroupTypeObj> groupTemplateDist = source.get(PROP_GROUP_TEMPLATE_DIST);
            if (groupTemplateDist == null) continue;
            LinkedIdentityHashSet toRemove = new LinkedIdentityHashSet();
            Map<OccGroupTypeObj, Double> weights = groupTemplateDist.getWeights();
            for (OccGroupTypeObj obj : weights.keySet()) {
                if (!groupTemplatesToDel.contains(obj)) continue;
                toRemove.add(obj);
            }
            if (toRemove.isEmpty()) continue;
            Undo.insertUndoEntry_propRestore(md, Collections.singleton(source), PROP_GROUP_TEMPLATE_DIST);
            LinkedIdentityHashMap<OccGroupTypeObj, Double> newWeights = new LinkedIdentityHashMap<OccGroupTypeObj, Double>(weights);
            for (OccGroupTypeObj obj : toRemove) {
                newWeights.remove(obj);
            }
            source.setProperty(PROP_GROUP_TEMPLATE_DIST, UrnUtil.newUrn(newWeights));
        }
    }

    static {
        PROP_TYPES.addAll(Sets.fromArrayHS(NamedMerlinObj.NAME, PROP_FLOW_RATE, PROP_PROFILE_DIST, PROP_BEHAVIOR_DIST, PROP_GROUP_TEMPLATE_DIST, PROP_ENFORCE_FLOWRATE, PROP_EMIT_AT_MAX_VEL, PROP_SPAWN_LOCS, PROP_COMPONENT, PROP_SEED, MerlinData.VISIBILITY, MerlinData.ENABLED));
        for (IPropertySet.Prop<?> prop : SUPPORTED_OCC_PROFILE_PROPS) {
            PROP_TYPES.add(new ProfileOverride(prop));
        }
    }

    public static enum OccSourceType {
        REGION,
        EGRESS_COMPONENT;

    }

    private static class FlowrateStepFunctionDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private MerlinUDF flowrateField;
        private MerlinUDF delayField;
        private MerlinUDF onField;
        private MerlinUDF offField;
        private guiIntField countField;

        public FlowrateStepFunctionDialog(Window parent, String name, int options) {
            super(parent, name, options);
            guiPanel panel = new guiPanel();
            GridBagHelper gb = new GridBagHelper(panel);
            this.flowrateField = new MerlinUDF(1.0, DoubleVR.above(0.0, true), FLOWRATE_UNIT);
            this.onField = new MerlinUDF(10.0, DoubleVR.above(0.0, false), SI.SECOND);
            this.delayField = new MerlinUDF(0.0, DoubleVR.above(0.0, true), SI.SECOND);
            this.offField = new MerlinUDF(20.0, DoubleVR.above(0.0, true), SI.SECOND);
            this.countField = new guiIntField(10, IntVR.above(0, false));
            gb.addRow(Intl.intl("Flow Rate:"), this.flowrateField);
            gb.addRow(Intl.intl("Initial Delay:"), this.delayField);
            gb.addRow(Intl.intl("On Duration:"), this.onField);
            gb.addRow(Intl.intl("Off Duration:"), this.offField);
            gb.addRow(Intl.intl("Number of Cycles:"), this.countField);
            gb.finalizeRows();
            this.setDialogComponent(panel);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        public IFunction1d createStepFunction() {
            double initialDelay = ((UnitDouble)this.delayField.getValue()).get(SI.SECOND);
            double onDuration = ((UnitDouble)this.onField.getValue()).get(SI.SECOND);
            double offDuration = ((UnitDouble)this.offField.getValue()).get(SI.SECOND);
            double periodLength = onDuration + offDuration;
            int numberOfPeriods = (Integer)this.countField.getValue();
            UnitDouble flowrate = (UnitDouble)this.flowrateField.getValue();
            ArrayList<RandomizedImpulseFunction1d.Interval> intervals = new ArrayList<RandomizedImpulseFunction1d.Interval>();
            TriFunction<Double, UnitDouble, Double, Double> hcycle = (t, fr, duration) -> {
                intervals.add(new RandomizedImpulseFunction1d.Interval(new UnitDouble((double)t, SI.SECOND), new UnitDouble((double)duration, SI.SECOND), (UnitDouble)fr));
                return t + duration;
            };
            BiFunction<Double, Double, Double> on = (t, duration) -> (Double)hcycle.apply((Double)t, flowrate, (Double)duration);
            BiFunction<Double, Double, Double> off = (t, duration) -> t + duration;
            double t2 = 0.0;
            if (initialDelay > 0.0) {
                t2 = off.apply(0.0, initialDelay);
            }
            if (theUtil.eq(onDuration, periodLength, 0.0)) {
                t2 = on.apply(t2, (double)numberOfPeriods * onDuration);
            } else {
                for (int perNum = 0; perNum < numberOfPeriods - 1; ++perNum) {
                    t2 = initialDelay + (double)perNum * periodLength;
                    t2 = on.apply(t2, onDuration);
                    t2 = off.apply(t2, offDuration);
                }
                t2 = initialDelay + (double)(numberOfPeriods - 1) * periodLength;
                t2 = on.apply(t2, onDuration);
            }
            intervals.trimToSize();
            return new RandomizedImpulseFunction1d(RandomizedImpulseFunction1d.Distribution.UNIFORM, intervals);
        }
    }

    public static class OccSourceComp
    extends Composite<OccSourceObj> {
        static final long serialVersionUID = 1834487306479339241L;

        public OccSourceComp() {
            this(Intl.intl("Occupant Sources"));
        }

        public OccSourceComp(String name) {
            super(name);
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccSourceComp(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Occupant Source Group");
        }
    }

    public static class ProfileOverride<T>
    extends IPropertySet.Prop<Boolean> {
        public final IPropertySet.Prop<T> prop;

        public ProfileOverride(IPropertySet.Prop<T> prop) {
            super("", false);
            this.prop = prop;
        }

        public boolean equals(Object obj) {
            return obj instanceof ProfileOverride && ((ProfileOverride)obj).prop.equals(this.prop);
        }

        public int hashCode() {
            return 11498275 + this.prop.hashCode();
        }

        public String toString() {
            return "[OccSourceObj.ProfileOverride:" + this.prop.key + "]";
        }
    }
}

