/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.util.Hierarchy;
import merlin.util.MerlinUtil;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class MerlinHierarchy
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<Object, Object> d_childParentMap = new IdentityHashMap<Object, Object>();
    private final Map<Object, Set<Object>> d_parentChildMap = new IdentityHashMap<Object, Set<Object>>();

    public boolean addToHierarchy(Object parent, Object child) {
        Set<Object> children;
        Object replaced = this.d_childParentMap.put(child, parent);
        if (replaced == parent) {
            return true;
        }
        if (replaced != null) {
            this.removeFromHierarchy(child);
        }
        if ((children = this.d_parentChildMap.get(parent)) == null) {
            children = new LinkedIdentityHashSet<Object>();
            this.d_parentChildMap.put(parent, children);
        }
        children.add(child);
        return true;
    }

    public boolean addAllToHierarchy(Object parent, Collection<?> children) {
        boolean success = true;
        for (Object child : children) {
            if (this.addToHierarchy(parent, child)) continue;
            success = false;
        }
        return success;
    }

    public boolean removeFromHierarchy(Object child) {
        Object parent = this.d_childParentMap.remove(child);
        if (parent == null) {
            return false;
        }
        Set<Object> children = this.d_parentChildMap.get(parent);
        assert (children != null);
        boolean removed = children.remove(child);
        assert (removed);
        if (children.isEmpty()) {
            this.d_parentChildMap.remove(parent);
        }
        return true;
    }

    public boolean removeAllFromHierarchy(Collection<?> objs) {
        boolean success = true;
        for (Object obj : objs) {
            if (this.removeFromHierarchy(obj)) continue;
            success = false;
        }
        return success;
    }

    public <T> Iterator<T> iterateParents(Class<T> parentType, Object child) {
        return Hierarchy.iterateParents(parentType, child, this::getParent);
    }

    public Object getParent(Object child) {
        return this.d_childParentMap.get(child);
    }

    public Set<Object> getChildren(Object parent) {
        Set children = this.d_parentChildMap.get(parent);
        if (children == null) {
            children = Collections.EMPTY_SET;
        }
        return children;
    }

    public int getNumChildren(Object parent) {
        int numChildren = 0;
        Set<Object> children = this.getChildren(parent);
        for (Object child : children) {
            numChildren += 1 + this.getNumChildren(child);
        }
        return numChildren;
    }

    public Set<Object> getParents(Collection<?> objs) {
        return Hierarchy.getParents(objs, this::getParent);
    }

    public boolean isDescendent(Object parent, Object child) {
        return Hierarchy.isDescendent(parent, child, this::getParent);
    }

    public Object getCommonParent(Collection<?> objs) {
        return Hierarchy.getCommonParent(objs, this::getParent);
    }

    public Object[] getPath(Object child) {
        return Hierarchy.getPath(child, this::getParent);
    }

    public Object[] getPath(Object child, Object stopParent, boolean includeStopParent) {
        return Hierarchy.getPath(child, stopParent, includeStopParent, this::getParent);
    }

    private void getPath(List<Object> path, Object child, Object stopParent, boolean includeStopParent) {
        Hierarchy.getPath(path, child, stopParent, includeStopParent, this::getParent);
    }

    public <T> Optional<T> findExistingGroup(MerlinData md, Class<T> searchType, Object dstRoot, Object srcObject, Object srcRoot) {
        Object[] igPath = this.getPath(srcObject, srcRoot, false);
        ArrayDeque<FindNode> open = new ArrayDeque<FindNode>();
        open.addLast(new FindNode(dstRoot, 0));
        while (!open.isEmpty()) {
            FindNode node = (FindNode)open.removeLast();
            String name = MerlinUtil.getName(igPath[node.pathIx]);
            for (Object group : theUtil.filter(this.getChildren(node.parent), searchType)) {
                if (!MerlinUtil.getName(group).equals(name)) continue;
                if (node.pathIx == igPath.length - 1) {
                    return Optional.of(group);
                }
                open.addLast(new FindNode(group, node.pathIx + 1));
            }
        }
        return Optional.empty();
    }

    private static class FindNode {
        public final Object parent;
        public final int pathIx;

        public FindNode(Object parent, int pathIx) {
            this.parent = parent;
            this.pathIx = pathIx;
        }
    }

    public static class FlattenedComparator<T extends IMerlinObj>
    implements Comparator<T> {
        private final MerlinHierarchy d_hierarchy;

        public FlattenedComparator(MerlinHierarchy hierarchy) {
            this.d_hierarchy = hierarchy;
        }

        @Override
        public int compare(T o1, T o2) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Object[] o1Parents = this.d_hierarchy.getPath(o1);
            Object[] o2Parents = this.d_hierarchy.getPath(o2);
            int minPathLength = Math.min(o1Parents.length, o2Parents.length);
            for (int i = 0; i < minPathLength; ++i) {
                if (o1Parents[i] == o2Parents[i]) continue;
                if (i == 0 || !(o1Parents[i - 1] instanceof Composite)) {
                    return this.commonParentCompare(o1, o2, null);
                }
                return this.commonParentCompare((IMerlinObj)o1Parents[i], (IMerlinObj)o2Parents[i], (Composite)o1Parents[i - 1]);
            }
            return this.directAncestorCompare(o1, o2);
        }

        private int directAncestorCompare(T o1, T o2) {
            if (this.d_hierarchy.isDescendent(o1, o2)) {
                return -1;
            }
            if (this.d_hierarchy.isDescendent(o2, o1)) {
                return 1;
            }
            assert (false);
            return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        }

        private int commonParentCompare(T o1, T o2, Composite<? super T> commonParent) {
            if (!(o1 instanceof Composite) && o2 instanceof Composite) {
                return 1;
            }
            if (o1 instanceof Composite && !(o2 instanceof Composite)) {
                return -1;
            }
            int nameComp = MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
            if (nameComp != 0) {
                return nameComp;
            }
            if (commonParent == null) {
                return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
            }
            return Integer.compare(commonParent.indexOf((ICompElement)o1), commonParent.indexOf((ICompElement)o2));
        }
    }
}

