/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CancelledException;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.ImportOptions;
import merlin.data.GeomComposite;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.data.value.ImpulseFunction1d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.theUtil;

public class ImportTraj
implements IImporter {
    private static final Logger LOGGER = Logger.getLogger(ImportTraj.class.getSimpleName());
    private static final TypedProp<Integer> Version = new TypedProp<Integer>((Object)"Version", 0);
    private static final TypedProp<String> AnimFile = new TypedProp<String>((Object)"AnimFile", "");
    private static final TypedProp<Double> TrajRot = new TypedProp<Double>((Object)"TrajRot", 0.0);
    private static final TypedProp<Double> TrajScale = new TypedProp<Double>((Object)"TrajScale", 0.0);
    private static final TypedProp<Double> TrajOffsetX = new TypedProp<Double>((Object)"TrajOffsetX", 0.0);
    private static final TypedProp<Double> TrajOffsetY = new TypedProp<Double>((Object)"TrajOffsetY", 0.0);
    private static final TypedProp<Double> TrajOffsetZ = new TypedProp<Double>((Object)"TrajOffsetZ", 0.0);
    private static final TypedProp<Double> TrajZOverride = new TypedProp<Double>((Object)"TrajZOverride", Double.NaN);
    private static final TypedProp<Double> TrajFramerate = new TypedProp<Double>((Object)"TrajFramerate", 16.0);
    private static final String Source = "Source";

    @Override
    public String[] getFileFilters() {
        return new String[]{"pfr", Intl.intl("Trajectory PFR")};
    }

    @Override
    public void initDefaultOptions(MerlinData md, String ext, IPropertySet options) {
    }

    @Override
    public boolean getAllowNewFile(MerlinData md, String ext, IPropertySet options) {
        return true;
    }

    @Override
    public void update(MerlinData md, Events events, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        return null;
    }

    @Override
    public IImporter.Result read(MerlinApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        ArrayList<OccSourceObj> sources = new ArrayList<OccSourceObj>();
        MerlinData md = options.get(ImportOptions.MD);
        try (BufferedInputStream pfrStream = new BufferedInputStream(new FileInputStream(fn));){
            String sourceKey;
            TeciProps props = new TeciProps();
            props.load(pfrStream);
            String trajFilePath = props.get(AnimFile);
            if (trajFilePath.trim().isEmpty()) {
                throw new IOException(Intl.intl("An animation file must be specified."));
            }
            File trajFile = new File(trajFilePath);
            if (!trajFile.exists() && !trajFile.isAbsolute()) {
                trajFile = new File(new File(fn).getParentFile(), trajFilePath);
            }
            if (!trajFile.exists()) {
                throw new FileNotFoundException(trajFile.getAbsolutePath());
            }
            double rot = props.get(TrajRot);
            Vector3d offset = new Vector3d(props.get(TrajOffsetX), props.get(TrajOffsetY), props.get(TrajOffsetZ));
            double scale = props.getDouble(TrajScale);
            double zoverride = props.getDouble(TrajZOverride);
            Matrix4d xform = Util.translateMat(offset.x, offset.y, offset.z);
            if (!Double.isNaN(zoverride)) {
                xform.m22 = 0.0;
                xform.m12 = 0.0;
                xform.m02 = 0.0;
                xform.m32 = (float)zoverride;
            }
            xform.mul(Util.rotMat(0.0, 0.0, 1.0, Math.toRadians(rot)));
            xform.mul(Util.scaleMat(scale, scale, scale));
            ArrayList<SourceInfo> sourceInfos = new ArrayList<SourceInfo>();
            int m = 1;
            while (props.containsKey(sourceKey = Source + m)) {
                String sourceStr = props.get(new TypedProp<String>((Object)sourceKey, ""));
                if (!sourceStr.isEmpty()) {
                    sourceInfos.add(ImportTraj.parseSourceInfo(sourceStr));
                }
                ++m;
            }
            sourceInfos.add(new SourceInfo(new AABox(), Color.BLUE));
            double framerate = props.get(TrajFramerate);
            int maxLocs = Math.max((int)Math.round(framerate / 2.0), 4);
            InfiniteUrn<OccProfile> profiles = new InfiniteUrn<OccProfile>(md.profiles.flatten(OccProfile.class).iterator().next());
            InfiniteUrn<Behavior> behaviors = new InfiniteUrn<Behavior>(md.behaviors.flatten(Behavior.class).iterator().next());
            HashMap occsEncountered = new HashMap();
            try (BufferedReader trajStream = new BufferedReader(new FileReader(trajFile));){
                trajStream.lines().forEach(line -> {
                    if (line.trim().startsWith("#")) {
                        return;
                    }
                    StringTokenizer toks = new StringTokenizer((String)line, " \t");
                    int aix = Integer.parseInt(toks.nextToken());
                    OccInfo oi = occsEncountered.computeIfAbsent(aix, i -> new OccInfo());
                    if (oi.locs.size() >= maxLocs) {
                        return;
                    }
                    long fid = Long.parseLong(toks.nextToken());
                    double x = Double.parseDouble(toks.nextToken());
                    double y = Double.parseDouble(toks.nextToken());
                    double z = Double.parseDouble(toks.nextToken());
                    Point3d loc = Util3D.xform(xform, new Point3d(x, y, z));
                    if (oi.locs.isEmpty()) {
                        oi.enterTime = (double)fid / framerate;
                        oi.locs.add(loc);
                        SourceInfo sourceInfo = sourceInfos.stream().filter(si -> !si.bounds.isValid() || si.bounds.contains(loc, 0.001)).findFirst().get();
                        sourceInfo.occs.put(aix, oi);
                    } else {
                        oi.locs.add(loc);
                    }
                });
                for (SourceInfo si : sourceInfos) {
                    AABox sourceBounds;
                    if (si.occs.isEmpty()) continue;
                    ArrayList<OccInfo> occs = new ArrayList<OccInfo>(si.occs.values());
                    Collections.sort(occs, (occ1, occ2) -> Double.compare(occ1.enterTime, occ2.enterTime));
                    ArrayList<UnitDouble> enterTimes = new ArrayList<UnitDouble>(occs.size());
                    ArrayList<Point3d> enterLocs = new ArrayList<Point3d>(occs.size());
                    int rotCount = 0;
                    Vector3d avgDir = new Vector3d();
                    for (OccInfo occ : occs) {
                        Point3d l2;
                        Point3d l1;
                        Vector3d dir;
                        enterTimes.add(new UnitDouble(occ.enterTime, SI.SECOND));
                        enterLocs.add(occ.locs.get(0));
                        if (occ.locs.size() <= 1 || Util3D.safeNormalize(dir = Util3D.vector(l1 = occ.locs.get(0), l2 = occ.locs.get(occ.locs.size() - 1)), 1.0E-9) == 0.0) continue;
                        avgDir.add(dir);
                        ++rotCount;
                    }
                    ConstantCurve initOrient = null;
                    if (rotCount != 0) {
                        avgDir.scale(1.0 / (double)rotCount);
                        double orient = Util3D.angle(GeomConstants.VEC3D_XPOS, avgDir, GeomConstants.VEC3D_ZPOS);
                        initOrient = new ConstantCurve(new UnitDouble(orient, SI.RADIAN));
                    }
                    if (!si.bounds.isValid()) {
                        enterLocs.stream().forEach(p -> sourceInfo.bounds.add((Point3d)p));
                    }
                    if (theUtil.eq0((sourceBounds = si.bounds).getHeight(), 1.0E-6)) {
                        Point3d min = sourceBounds.getMin();
                        Point3d max = sourceBounds.getMax();
                        sourceBounds = new AABox(min.x, min.y, min.z - 0.25, max.x, max.y, max.z + 0.25);
                    }
                    String trajName = FilenameManager.splitFilename(new File(fn).getName())[0];
                    String sourceName = String.format("%s%d", trajName, sources.size());
                    OccSourceObj occSource = new OccSourceObj(sourceName, sourceBounds);
                    occSource.set(OccSourceObj.PROP_ENFORCE_FLOWRATE, new InfiniteUrn<Boolean>(true));
                    occSource.set(OccSourceObj.PROP_SPAWN_LOCS, enterLocs);
                    occSource.set(OccSourceObj.PROP_PROFILE_DIST, profiles);
                    occSource.set(OccSourceObj.PROP_BEHAVIOR_DIST, behaviors);
                    occSource.set(OccSourceObj.PROP_FLOW_RATE, ImpulseFunction1d.toImpulseFunction(13, enterTimes));
                    if (initOrient != null) {
                        occSource.set(new OccSourceObj.ProfileOverride<ICurve>(OccProfile.PROP_INIT_ORIENT), true);
                        occSource.set(OccProfile.PROP_INIT_ORIENT, initOrient);
                    }
                    sources.add(occSource);
                }
            }
        }
        catch (Throwable t) {
            TeciLogging.log(LOGGER, t);
        }
        if (!sources.isEmpty()) {
            OccSourceObj.OccSourceComp comp = new OccSourceObj.OccSourceComp(new File(fn).getName());
            comp.addAll(sources);
            return new IImporter.Result(new GeomComposite(""), new Pair<OccSourceObj.OccSourceComp, OccSourceObj.OccSourceComp>(md.occSources, comp));
        }
        return IImporter.Result.EMPTY;
    }

    private static SourceInfo parseSourceInfo(String sourceStr) {
        StringTokenizer toks = new StringTokenizer(sourceStr, ",");
        DoubleSupplier nextDbl = () -> Double.parseDouble(toks.nextToken());
        Supplier<Float> nextFlt = () -> Float.valueOf(Float.parseFloat(toks.nextToken()));
        Point3d min = new Point3d(nextDbl.getAsDouble(), nextDbl.getAsDouble(), nextDbl.getAsDouble());
        Point3d max = new Point3d(nextDbl.getAsDouble(), nextDbl.getAsDouble(), nextDbl.getAsDouble());
        AABox bounds = new AABox(min, max);
        float r = nextFlt.get().floatValue();
        float g = nextFlt.get().floatValue();
        float b = nextFlt.get().floatValue();
        Color color = new Color(r, g, b);
        return new SourceInfo(bounds, color);
    }

    @Override
    public void cleanup(IPropertySet options) {
    }

    private static class OccInfo {
        public double enterTime;
        public List<Point3d> locs = new ArrayList<Point3d>();

        private OccInfo() {
        }
    }

    private static class SourceInfo {
        public final AABox bounds;
        public final Color color;
        public final Map<Integer, OccInfo> occs = new HashMap<Integer, OccInfo>();

        public SourceInfo(AABox bounds, Color color) {
            this.bounds = bounds;
            this.color = color;
        }
    }
}

