/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CloseGapsAction;
import merlin.actions.OccGenerator;
import merlin.actions.SelectionObserver;
import merlin.actions.SubtractAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.floorextract.Evac4BIMParseUtil;
import merlin.actions.floorextract.GenerateModelPropsDlg;
import merlin.builders.NewCompUtil;
import merlin.data.INameGenerator;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.RestorableProperties;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.value.ConstVariant;
import merlin.geom.GeomUtil;
import merlin.geom.StrutUtil;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import results.nativebuffered.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadConsumer;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TieBreaker;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.mtproc.MTListProcessorPool;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class GenerateModelFromBIM
extends AMerlinOp
implements IEventObserver {
    public static UIHook UI_HOOK_CONTEXT = new UIHook(new GenerateModelFromBIM(true), Intl.intl("Generate Model from BIM Selection..."));
    public static UIHook UI_HOOK_GLOBAL = new UIHook(new GenerateModelFromBIM(false), Intl.intl("Generate Model from BIM..."));
    public static final IPropertySet.Prop<UnitDouble> MAX_SLOPE;
    public static final IPropertySet.Prop<Boolean> SLOPE_INCLUSIVE;
    public static final IPropertySet.Prop<Integer> SEARCH_OPTIONS;
    public static final IPropertySet.Prop<UnitDouble> HEAD_HEIGHT;
    public static final IPropertySet.Prop<UnitDouble> MIN_COMP_WIDTH;
    public static final IPropertySet.Prop<Boolean> CLOSE_GAPS;
    public static final IPropertySet.Prop<UnitDouble> CLOSE_GAP_TOLERANCE;
    public static final IPropertySet.Prop<Boolean> NAME_FROM_IMPORTED_GEOM;
    public static final IPropertySet.Prop<Boolean> EXTRACT_STAIRS;
    public static final IPropertySet.Prop<UnitDouble> MAX_STAIR_RISER;
    public static final IPropertySet.Prop<UnitDouble> MAX_STAIR_TREAD_GAP;
    public static final IPropertySet.Prop<Boolean> EXTRACT_DOORS;
    public static final IPropertySet.Prop<Boolean> DEL_SMALL_ROOMS;
    public static final IPropertySet.Prop<Boolean> DEL_ROOMS_IN_SOLIDS;
    public static final IPropertySet.Prop<UnitDouble> MIN_ROOM_AREA;
    public static final IPropertySet.Prop<Boolean> EXTRACT_ONLY_TOPS_OF_SOLIDS;
    public static final IPropertySet.Prop<Boolean> GENERATE_OCCUPANTS;
    public static final IPropertySet.Prop<Boolean> GENERATE_PROFILES;
    private final boolean d_context;
    private final Progress d_progress = new Progress();
    private WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private static final Comparator<Double> s_areaComp;
    static theTimer timer;
    static double time;

    public GenerateModelFromBIM(boolean context) {
        this.d_context = context;
        if (this.d_context) {
            SelectionObserver.add(this, ImportedGeom.class);
        } else {
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }
        this.sync();
    }

    @Override
    public void update(Events events) {
        if (this.d_context) {
            this.sync();
        } else if (events.getAffectedChannels(ImportedGeom.class, new Class[0]).stream().anyMatch(AEventRec::isModified)) {
            this.sync();
        }
    }

    private void sync() {
        MerlinData md = MerlinApp.getApp().getData();
        if (!this.d_context) {
            this.setEnabled(!md.sceneGeom.flatten(ImportedGeom.class).isEmpty());
        } else {
            this.setEnabled(!md.selection.flatten(ImportedGeom.class).isEmpty());
        }
    }

    private static Predicate<ImportType> getFloorTypeFilter() {
        return ig -> {
            switch (ig) {
                case STAIR: 
                case ESCALATOR: 
                case FLOOR: 
                case RAMP: 
                case MOVING_WALKWAY: 
                case ROOM: {
                    return true;
                }
            }
            return false;
        };
    }

    private static Predicate<ImportedGeom> getFloorFilter() {
        Predicate<ImportType> typeFilter = GenerateModelFromBIM.getFloorTypeFilter();
        return ig -> typeFilter.test(ig.getImportedType());
    }

    protected TaskProgress getProgress() {
        return this.d_progress.d_progress;
    }

    protected void checkCancelled() throws CancellationException {
        this.d_progress.d_progress.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        RestorableProperties newProps;
        Collection<Object> pickGeom = Collections.emptyList();
        md.beginRead();
        try {
            boolean valid;
            Predicate<ImportedGeom> objFilter = GenerateModelFromBIM.getFloorFilter();
            if (!this.d_context) {
                valid = !md.sceneGeom.flatten(ImportedGeom.class, objFilter).isEmpty();
            } else {
                boolean bl = valid = !md.selection.flatten(ImportedGeom.class, objFilter).isEmpty();
            }
            if (!valid) {
                String validTypes = String.join((CharSequence)"<br>", (CharSequence[])Stream.of(ImportType.values()).filter(GenerateModelFromBIM.getFloorTypeFilter()).sorted((t1, t2) -> t1.name.compareToIgnoreCase(t2.name)).map(t -> "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + t.name).toArray(String[]::new));
                assert (!validTypes.isEmpty());
                String msg = !this.d_context ? String.format("<html>" + Intl.intl("Cannot generate model elements. There must be imported objects with<br><b>Import Type</b> set to any of the following:<br>%s"), validTypes) : String.format("<html>" + Intl.intl("Cannot generate model elements. The selected objects must have<br><b>Import Type</b> set to any of the following:<br>%s"), validTypes);
                md.ui(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Cannot Generate Model"), 2));
                return;
            }
            objFilter = Predicates.or(objFilter, ig -> ig.isA(ImportType.DOOR) || ig.isA(ImportType.ROOM) || ig.isA(ImportType.BUILDING));
            pickGeom = !this.d_context ? md.sceneGeom.flatten(ImportedGeom.class, objFilter) : new ArrayList<ImportedGeom>(md.selection.flatten(ImportedGeom.class, objFilter));
            Predicate<ImportedGeom> occupantFilter = ig -> ig.isA(ImportType.ROOM) || ig.isA(ImportType.BUILDING);
            boolean showOccSection = !theUtil.filter(pickGeom, occupantFilter).isEmpty();
            newProps = md.ui(() -> {
                GenerateModelPropsDlg dlg = new GenerateModelPropsDlg((Window)app.getActiveFrame(), showOccSection);
                dlg.load(merlinData.actionProps);
                if (dlg.doModal() != 1) {
                    throw new CancellationException();
                }
                RestorableProperties result = merlinData.actionProps.clone();
                dlg.save(result);
                return result;
            });
            if (pickGeom.isEmpty()) {
                return;
            }
        }
        catch (CancellationException e) {
            return;
        }
        finally {
            md.endRead();
        }
        theTimer timer = new theTimer();
        this.d_progress.reset();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Generating Model"), true, this.d_progress.d_progress);
        pm.begin();
        try {
            this.extractFloor(app, md, pickGeom, newProps);
            pm.end();
            if (!this.d_warnings.isEmpty()) {
                md.ui(() -> new WarningDlg<Warning>((Window)app.getActiveFrame(), Intl.intl("Model Generation Warnings"), Intl.intl("Problem generating model."), this.d_warnings).doModal());
            }
        }
        catch (CancellationException showOccSection) {
        }
        catch (ExtractException e) {
            pm.end();
            md.ui(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), e.getLocalizedMessage(), Intl.intl("Error Generating Model"), 0));
        }
        finally {
            pm.end();
            this.d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        }
        System.out.println("Elapsed: " + timer.curr());
        System.out.println("Test time: " + time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFloor(MerlinApp app, MerlinData md, Collection<? extends ImportedGeom> pickGeom, RestorableProperties eprops) throws CancellationException, ExtractException {
        ExtractResults extractResults;
        ExtractProps props = new ExtractProps(eprops);
        md.beginRead();
        try {
            extractResults = this.extract(md, pickGeom, props);
        }
        finally {
            md.endRead();
        }
        LinkedIdentityHashSet<? extends IEgressComp> toSelect = new LinkedIdentityHashSet<IEgressComp>(extractResults.newObjs);
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Generate Model"));
            BiConsumer<Class, INameGenerator> generateNames = (clazz, nameGen) -> {
                for (IEgressComp comp : MerlinUtil.flatten(extractResults.newObjs, clazz)) {
                    if (!comp.getName().isEmpty()) continue;
                    comp.setName(nameGen.getCurrentName());
                    nameGen.nextName();
                }
            };
            generateNames.accept(EgressRoom.class, md.roomNameGen);
            generateNames.accept(EgressStair.class, md.stairNameGen);
            generateNames.accept(EgressCorridor.class, md.rampNameGen);
            generateNames.accept(EgressDoor.class, md.doorNameGen);
            ArrayList toClean = new ArrayList();
            IdentityHashSet<EgressRoom> newRoomSet = new IdentityHashSet<EgressRoom>(MerlinUtil.flatten(extractResults.newObjs, EgressRoom.class));
            BiConsumer<EgressRoom, EgressRoom> selectFunc = (originalRoom, child) -> {
                if (newRoomSet.contains(originalRoom)) {
                    toSelect.remove(originalRoom);
                    toSelect.add(child);
                }
            };
            NewCompUtil.addEgressComps(md, false, extractResults.newObjs);
            SubtractAction.subtract(app, md, 0, toClean::add, selectFunc, MerlinUtil.flatten(extractResults.newObjs, EgressRoom.class));
            if (props.get(GENERATE_PROFILES).booleanValue()) {
                Undo.insertUndoEntry_delete(md, md.profiles, extractResults.requestedProfiles);
                md.profiles.addAll(extractResults.requestedProfiles);
                toSelect.addAll(extractResults.requestedProfiles);
            }
            EgressRoom.cleanup(md, toClean);
        }
        finally {
            md.endWrite();
        }
        GenerateOccupantsResults occResults = new GenerateOccupantsResults();
        md.beginRead();
        try {
            if (props.get(GENERATE_OCCUPANTS).booleanValue()) {
                occResults = this.generateOccupants(extractResults, md);
            }
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        try {
            if (props.get(GENERATE_OCCUPANTS).booleanValue()) {
                if (occResults.generatedBehavior != null) {
                    occResults.generatedBehavior.setName(md.behaviorNameGen.nextName());
                    Undo.insertUndoEntry_delete(md, md.behaviors, occResults.generatedBehavior);
                    md.behaviors.add(occResults.generatedBehavior);
                    toSelect.add(occResults.generatedBehavior);
                }
                NameGenerator groupNames = new NameGenerator("");
                for (Pair<OccGenerator, String> occs : occResults.generatedOccs) {
                    Collection<EgressAgent> agents = ((OccGenerator)occs.v1).finalizeData();
                    String name = groupNames.generateValidName((String)occs.v2);
                    groupNames.registerName(name);
                    OccGenerator.distributeAgents(md, agents, name);
                    toSelect.addAll(agents);
                }
            }
            md.selection.set(toSelect);
            md.actionProps.replace(eprops);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private GenerateOccupantsResults generateOccupants(ExtractResults extractResults, MerlinData md) {
        Collection<OccProfile> profiles;
        if (extractResults.requestedOccs.isEmpty() && extractResults.preEvacTime == null) {
            return new GenerateOccupantsResults();
        }
        Urn<OccProfile> profileDist = !extractResults.requestedProfiles.isEmpty() ? new Urn<OccProfile>(extractResults.requestedProfiles) : ((profiles = md.profiles.flatten(OccProfile.class)).stream().anyMatch(p -> p == merlinData.profiles.DEFAULT) ? new Urn<OccProfile>(md.profiles.DEFAULT) : new Urn<OccProfile>(profiles.iterator().next()));
        BehaviorRoot root = new BehaviorRoot();
        root.addDefault();
        Behavior defaultBehavior = root.DEFAULT;
        if (extractResults.preEvacTime != null) {
            defaultBehavior.setInitialDelay(extractResults.preEvacTime);
        }
        Urn<Behavior> behaviorDist = new Urn<Behavior>(defaultBehavior);
        ArrayList<Pair<OccGenerator, String>> generatedOccs = new ArrayList<Pair<OccGenerator, String>>();
        Random random = new Random(0L);
        for (Pair<Collection<EgressRoom>, IOccCount> pair : extractResults.requestedOccs) {
            long numOccs;
            Collection rooms = (Collection)pair.v1;
            EgressRoom firstRoom = (EgressRoom)rooms.stream().findFirst().get();
            IOccCount count = (IOccCount)pair.v2;
            Collection models = rooms.stream().map(EgressRoom::getModel).collect(Collectors.toList());
            OccGenerator occGenerator = new OccGenerator(md, random, models, OccGenerator.getMaxDiam(profileDist), new UnitDouble(0.125, SI.SECOND), 400, profileDist, behaviorDist);
            if (occGenerator.generate((int)(numOccs = Math.min(count.getNumOccs(() -> new UnitDouble(occGenerator.getTotalArea(), merlin.geom.Geometry.AREA_UNIT)), Integer.MAX_VALUE)), 1, 0)) {
                generatedOccs.add(new Pair<OccGenerator, String>(occGenerator, firstRoom.getName()));
                continue;
            }
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("%s cannot support the requested occupant density."), firstRoom.getName()), String.format(Intl.intl("Did not add occupants to %s."), firstRoom.getName())));
        }
        GenerateOccupantsResults occResults = new GenerateOccupantsResults();
        occResults.generatedOccs = generatedOccs;
        occResults.generatedBehavior = defaultBehavior;
        return occResults;
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(Integer.MAX_VALUE) && !edge.faces.isEmpty() || !edge.partOfGroup(Integer.MAX_VALUE) && edge.faces.size() == 1;
    }

    private static Collection<GeomFace> findFloorFaces(ExtractInfo einfo, Collection<? extends ImportedGeom> geoms) {
        if (!einfo.getProp(EXTRACT_STAIRS).booleanValue()) {
            geoms = theUtil.filter(geoms, g -> !GenerateModelFromBIM.isAStair(g));
        }
        boolean topsOfSolids = einfo.getProp(EXTRACT_ONLY_TOPS_OF_SOLIDS);
        ArrayList<GeomFace> result = new ArrayList<GeomFace>();
        for (ImportedGeom importedGeom : geoms) {
            Collection<Pair<IPolygon, Elements.Orient>> faces = einfo.faceCache.getFaces(importedGeom);
            RTree<IPolygon> solidSearch = null;
            if (topsOfSolids && GenerateModelFromBIM.isSolid(importedGeom) || importedGeom.isA(ImportType.ROOM)) {
                solidSearch = new RTree<IPolygon>();
                for (Pair<IPolygon, Elements.Orient> face : faces) {
                    solidSearch.insert(((IPolygon)face.v1).getBoundingBox(new AABox()), (IPolygon)face.v1);
                }
            }
            Iterator<Pair<IPolygon, Elements.Orient>> fit = faces.iterator();
            int ix = 0;
            while (fit.hasNext()) {
                Boolean onTop;
                Pair<IPolygon, Elements.Orient> face = fit.next();
                Plane3d plane = ((IPolygon)face.v1).getPlane(face.v2 == Elements.Orient.CCW);
                double slope = GenerateModelFromBIM.getSlopeRad(plane.getNormal());
                if (slope >= einfo.eprops.maxSlopeRad && Math.PI - slope >= einfo.eprops.maxSlopeRad || solidSearch != null && (onTop = GenerateModelFromBIM.polyTouchingTopOfSolid((IPolygon)face.v1, solidSearch)) != null && onTop.booleanValue() == importedGeom.isA(ImportType.ROOM)) continue;
                result.add(new GeomFace(importedGeom, (IPolygon)face.v1, (Elements.Orient)((Object)face.v2), ix));
                ++ix;
            }
        }
        System.out.println("Floor face count: " + result.size());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private ExtractResults extract(MerlinData md, Collection<? extends ImportedGeom> pickGeom, ExtractProps eprops) throws ExtractException, CancellationException {
        void var20_32;
        ExtractInfo einfo = new ExtractInfo(md, eprops);
        IFilteredCollection<ImportedGeom> floorGeom = theUtil.filter(pickGeom, GenerateModelFromBIM.getFloorFilter());
        Pair<Model, LinkedHashMap<Integer, ImportedGeom>> result = this.generateFloor(einfo, floorGeom);
        NameGenerator roomNames = new NameGenerator("");
        NameGenerator doorNames = new NameGenerator("");
        int[] nonBoundGroup = new int[]{0};
        Model resultModel = (Model)result.v1;
        for (Face face : resultModel.getFaces()) {
            face.addGroup(0);
        }
        Iterator<AModelObj> iterator = resultModel.getEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge;
            edge.addGroup(GenerateModelFromBIM.isBoundaryEdge(edge = (Edge)iterator.next()) ? 1 : 0);
        }
        for (Vertex vert : resultModel.getVerts()) {
            vert.groups = nonBoundGroup;
        }
        resultModel = this.removeInvalidRooms(einfo, resultModel);
        ArrayList<? extends IEgressComp> newObjs = new ArrayList<IEgressComp>();
        Consumer<Edge> addUsedEdge = e -> {};
        Predicate<Edge> keepEdges = Predicates.alwaysFalse();
        resultModel = this.generateStairs(einfo, doorNames, resultModel, (LinkedHashMap)result.v2, newObjs, addUsedEdge, Predicates.alwaysFalse());
        resultModel = this.generateDoors(einfo, doorNames, pickGeom, resultModel, newObjs, addUsedEdge, keepEdges);
        this.d_progress.nextStep(Intl.intl("Finishing up"), -1);
        int[] boundary = new int[]{1};
        for (Edge edge : resultModel.getEdges()) {
            if (edge.partOfGroup(1)) {
                edge.groups = boundary;
                continue;
            }
            edge.groups = nonBoundGroup;
        }
        EgressRoom room = new EgressRoom("", resultModel);
        this.checkCancelled();
        LinkedIdentityHashSet<EgressRoom> newRooms = new LinkedIdentityHashSet<EgressRoom>((Collection<EgressRoom>)room.separate());
        LinkedIdentityHashMap importedRoomGeom = new LinkedIdentityHashMap();
        for (EgressRoom egressRoom : newRooms) {
            Iterator name;
            this.checkCancelled();
            IdentityHashMap<ImportedGeom, Double> identityHashMap = new IdentityHashMap<ImportedGeom, Double>();
            for (Face face : egressRoom.getModel().getFaces()) {
                for (int gid : face.groups) {
                    ImportedGeom ig2 = (ImportedGeom)((LinkedHashMap)result.v2).get(gid);
                    if (ig2 == null) continue;
                    identityHashMap.merge(ig2, face.getArea(), (v1, v2) -> v1 + v2);
                }
            }
            Optional<ImportedGeom> prioritisedGeom = identityHashMap.entrySet().stream().max((e1, e2) -> ((ImportedGeom)e1.getKey()).isA(ImportType.ROOM) != ((ImportedGeom)e2.getKey()).isA(ImportType.ROOM) ? (((ImportedGeom)e1.getKey()).isA(ImportType.ROOM) ? 1 : -1) : Double.compare((Double)e1.getValue(), (Double)e2.getValue())).map(e -> (ImportedGeom)e.getKey());
            if (prioritisedGeom.isPresent() && prioritisedGeom.get().isA(ImportType.ROOM)) {
                ImportedGeom ig3 = prioritisedGeom.get();
                if (!importedRoomGeom.containsKey(ig3)) {
                    importedRoomGeom.put(ig3, new ArrayList());
                }
                ((Collection)importedRoomGeom.get(ig3)).add(egressRoom);
            }
            if (prioritisedGeom.isPresent() && eprops.nameFromImportedGeom) {
                String n = roomNames.generateValidName(prioritisedGeom.get().getName());
                roomNames.registerName(n);
                name = n;
            } else {
                name = "";
            }
            for (Face face : egressRoom.getModel().getFaces()) {
                face.groups = nonBoundGroup;
            }
            egressRoom.setName((String)((Object)name));
            egressRoom.setColor(theUtil.newRandomColor());
        }
        this.checkCancelled();
        for (EgressRoom egressRoom : newRooms) {
            egressRoom.setModel(GenerateModelFromBIM.cleanup(egressRoom.getModel(), keepEdges));
        }
        this.checkCancelled();
        for (Map.Entry entry : importedRoomGeom.entrySet()) {
            Integer n = ((ImportedGeom)entry.getKey()).get(ImportedGeom.PROP_SPACE_OCCUPANCY_NUMBER_PEAK);
            if (n == null || n < 0) continue;
            if (((Collection)entry.getValue()).size() > 1) {
                Object totalArea = new UnitDouble(0.0, SIUS.unit(4));
                for (EgressRoom igRoom : (Collection)entry.getValue()) {
                    totalArea = ((UnitDouble)totalArea).add(igRoom.getArea());
                }
                if (!((UnitDouble)totalArea).gt(new UnitDouble(0.0, SIUS.unit(4)), 0.0)) continue;
                for (EgressRoom igRoom : (Collection)entry.getValue()) {
                    double proportion = igRoom.getArea().divide((UnitDouble)totalArea).getValueNoUnit();
                    int proportionalCapacity = (int)Math.round((double)n.intValue() * proportion);
                    igRoom.setCapacityEnabled(true);
                    igRoom.setCapacity(new ConstOccCount(proportionalCapacity));
                }
                continue;
            }
            for (EgressRoom igRoom : (Collection)entry.getValue()) {
                igRoom.setCapacityEnabled(true);
                igRoom.setCapacity(new ConstOccCount(n));
            }
        }
        this.checkCancelled();
        newObjs.addAll(newRooms);
        this.checkCancelled();
        ArrayList<Pair<Collection<EgressRoom>, IOccCount>> requestedOccs = new ArrayList<Pair<Collection<EgressRoom>, IOccCount>>();
        for (Map.Entry entry : importedRoomGeom.entrySet()) {
            ImportedGeom ig4 = (ImportedGeom)entry.getKey();
            Integer occupancyNumber = ig4.get(ImportedGeom.PROP_SPACE_OCCUPANCY_NUMBER);
            UnitDouble areaPerOccupant = ig4.get(ImportedGeom.PROP_SPACE_AREA_PER_OCCUPANT);
            if (occupancyNumber != null && occupancyNumber > 0) {
                requestedOccs.add(new Pair(entry.getValue(), new ConstOccCount(occupancyNumber)));
                continue;
            }
            if (areaPerOccupant == null || !(areaPerOccupant.getValueNoUnit() > 0.0)) continue;
            requestedOccs.add(new Pair(entry.getValue(), new OccArea(areaPerOccupant)));
        }
        this.checkCancelled();
        ArrayList<OccProfile> arrayList = new ArrayList<OccProfile>();
        Object var20_31 = null;
        IFilteredCollection<ImportedGeom> buildingGeom = theUtil.filter(pickGeom, ig -> ig.isA(ImportType.BUILDING));
        for (ImportedGeom building : buildingGeom) {
            String buildingPreEvacTime;
            if (eprops.get(GENERATE_PROFILES).booleanValue()) {
                try {
                    arrayList.addAll(Evac4BIMParseUtil.parseProfiles(building.get(ImportedGeom.PROP_BUILDING_OCC_PROFILES_LIST), md));
                }
                catch (IllegalArgumentException e3) {
                    this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Invalid occupant profile description from %s."), building.getName()), Intl.intl("Skipped generating profiles.")));
                }
            }
            if ((buildingPreEvacTime = building.get(ImportedGeom.PROP_BUILDING_PRE_EVACUATION_TIME)) == null || buildingPreEvacTime.equals("-1")) continue;
            try {
                IDistributedVal<UnitDouble> iDistributedVal = Evac4BIMParseUtil.parseDist(buildingPreEvacTime, SIUS.unit(1), 0.0);
            }
            catch (IllegalArgumentException e4) {
                this.d_warnings.addWarning(new Warning(Intl.intl("Invalid specification of pre-evacuation time."), Intl.intl("Skipped setting initial delay.")));
            }
        }
        ExtractResults results = new ExtractResults();
        results.newObjs = newObjs;
        results.requestedProfiles = arrayList;
        results.requestedOccs = requestedOccs;
        results.preEvacTime = var20_32;
        return results;
    }

    private Model removeInvalidRooms(ExtractInfo einfo, Model floorModel) {
        this.d_progress.nextStep(Intl.intl("Closing gaps and removing invalid rooms"), -1);
        ExtractProps eprops = einfo.eprops;
        if (eprops.get(CLOSE_GAPS).booleanValue()) {
            theTimer timer = new theTimer();
            floorModel = CloseGapsAction.closeGaps(floorModel, eprops.closeGapSize);
            System.out.printf("gaps closed: %g%n", timer.curr());
        }
        this.checkCancelled();
        if (eprops.get(DEL_SMALL_ROOMS).booleanValue()) {
            this.removeSmallRooms(einfo, floorModel);
        }
        return floorModel;
    }

    private void removeSmallRooms(ExtractInfo einfo, Model floorModel) {
        ExtractProps eprops = einfo.eprops;
        ArrayList toDelete = new ArrayList();
        IdentityHashSet closed = new IdentityHashSet();
        for (Face face : floorModel.getFaces()) {
            this.checkCancelled();
            if (closed.contains(face)) continue;
            ArrayList connected = new ArrayList();
            GenerateModelFromBIM.getConnectedFaces(face, connected::add);
            double totArea = 0.0;
            for (Face cface : connected) {
                totArea += cface.getArea();
            }
            if (totArea <= eprops.minRoomArea) {
                toDelete.addAll(connected);
            }
            closed.addAll(connected);
        }
        for (Face face : toDelete) {
            this.checkCancelled();
            floorModel.deleteFace(face, true, true);
        }
    }

    private static boolean isSolid(IGeomNode node) {
        IGeom geom = node.getLocalGeom();
        if (geom.getNumPrims(1) > 0 && geom.isShell()) {
            return false;
        }
        return node.getChildren().stream().allMatch(GenerateModelFromBIM::isSolid);
    }

    private static boolean isSolid(ImportedGeom ig) {
        IGeomNode node = ig.getGeom();
        return node.getNumPrims(1) > 0 && GenerateModelFromBIM.isSolid(node);
    }

    private void removeFacesInSolids(ExtractInfo einfo, Model floorModel) throws CancellationException {
        AABox bounds;
        this.checkCancelled();
        LinkedIdentityHashSet solidObjs = new LinkedIdentityHashSet();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        for (ImportedGeom ig2 : einfo.md.sceneGeom.flatten(ImportedGeom.class, obstFilter)) {
            AABox bounds2;
            Iterator<Face> node = ig2.getGeom();
            if (!GenerateModelFromBIM.isSolid(ig2) || (bounds2 = node.getBoundingBox(new AABox())).getWidth() < 3.0E-6 || bounds2.getDepth() < 3.0E-6 || bounds2.getHeight() < 3.0E-6) continue;
            solidObjs.add(ig2);
        }
        if (solidObjs.isEmpty()) {
            return;
        }
        ArrayList facesToTest = new ArrayList();
        BiConsumer<Face, ImportedGeom> addFace = (face, ig) -> facesToTest.add(new Pair<Face, ImportedGeom>((Face)face, (ImportedGeom)ig));
        if (solidObjs.size() < floorModel.getFaces().size()) {
            for (ImportedGeom ig3 : solidObjs) {
                bounds = ig3.getBounds();
                for (Face f : floorModel.findFaces(bounds)) {
                    addFace.accept(f, ig3);
                }
            }
        } else {
            for (Face face2 : floorModel.getFaces()) {
                bounds = face2.getBounds();
                IResult<IDisplayableGeomSrc> result = (disp, ctmt) -> {
                    if (!(disp instanceof ImportedGeom)) {
                        return;
                    }
                    ImportedGeom ig = (ImportedGeom)disp;
                    if (!obstFilter.test(ig)) {
                        return;
                    }
                    addFace.accept(face2, ig);
                };
                einfo.md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), result, einfo.eprops.searchOptions);
            }
        }
        Set foundGeomsSet = facesToTest.stream().map(l -> (ImportedGeom)l.v2).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
        ArrayList foundGeomsList = new ArrayList(foundGeomsSet);
        Map igSearches = Collections.synchronizedMap(new IdentityHashMap());
        MTProcessor mtproc = new MTProcessor(Runtime.getRuntime().availableProcessors(), MTProcessor.Schedule.GUIDED, new MTListProcessorPool());
        this.mtproc(mtproc, foundGeomsList, (ig, tix, ix) -> {
            RTree search = new RTree();
            for (Pair<IPolygon, Elements.Orient> face : extractInfo.faceCache.getFaces((ImportedGeom)ig)) {
                search.insert(((IPolygon)face.v1).getBoundingBox(new AABox()), face.v1);
            }
            igSearches.put(ig, search);
        });
        Set<Face> facesToRemove = Collections.synchronizedSet(new LinkedIdentityHashSet());
        Collections.shuffle(facesToTest, new Random(11512195L));
        this.mtproc(mtproc, facesToTest, (pair, tix, ix) -> {
            this.checkCancelled();
            Face face = (Face)pair.v1;
            if (facesToRemove.contains(face)) {
                return;
            }
            ImportedGeom ig = (ImportedGeom)pair.v2;
            RTree solidPolys = (RTree)igSearches.get(ig);
            if (GenerateModelFromBIM.faceInSolidNotTouchingTop(floorModel, face, solidPolys)) {
                facesToRemove.add(face);
            }
        });
        for (Face face3 : facesToRemove) {
            floorModel.deleteFace(face3, true, true);
        }
    }

    private static Boolean polyTouchingTopOfSolid(IPolygon poly, RTree<IPolygon> solid) {
        Random rand = new Random(11512195L);
        Supplier<Point3d> pointGen = poly.getPointGenerator(rand, false, 1.0E-6);
        int nattempts = 10;
        for (int m = 0; m < nattempts; ++m) {
            Point3d p = pointGen.get();
            if (p == null) {
                System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".polyInSolidNotTouchingTop failed to find a point in face%n", new Object[0]);
                return null;
            }
            AABox solidBounds = solid.getBoundingBox();
            if (!solidBounds.contains(p, 1.0E-6)) {
                return false;
            }
            Inter3D.PointClassify pc = Inter3D.testPointInSolid(solid, true, p, GeomConstants.VEC3D_ZNEG, 1.0E-6);
            if (pc == null) continue;
            return pc.positive;
        }
        System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".polyInSolidNotTouchingTop failed to find valid intersection ray after %d attempts%n", nattempts);
        return null;
    }

    private static boolean faceInSolidNotTouchingTop(Model model, Face face, RTree<IPolygon> solid) {
        Random rand = new Random(11512195L);
        int nattempts = 10;
        for (int m = 0; m < nattempts; ++m) {
            Point3d p = model.findRandomPointInFace(face, rand);
            if (p == null) {
                System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".faceInSolidNotTouchingTop failed to find a point in face%n", new Object[0]);
                return false;
            }
            AABox solidBounds = solid.getBoundingBox();
            if (!solidBounds.contains(p, 1.0E-6)) {
                return false;
            }
            Inter3D.PointClassify pc = Inter3D.testPointInSolid(solid, true, p, GeomConstants.VEC3D_ZPOS, 1.0E-6);
            if (pc == null) continue;
            return pc.positive;
        }
        System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".faceInSolidNotTouchingTop failed to find valid intersection ray after %d attempts%n", nattempts);
        return false;
    }

    private static Vector3d getEdgeNormal(EdgeUse eu, boolean out) {
        Vector3d eudir = eu.getTangent(0.0);
        Vector3d fnormal = eu.edge.faces.get((int)0).plane.getNormal();
        Vector3d stairDir = out ? Util3D.cross(eudir, fnormal) : Util3D.cross(fnormal, eudir);
        stairDir.z = 0.0;
        if (Util3D.safeNormalize(stairDir, 1.0E-9) == 0.0) {
            return null;
        }
        return stairDir;
    }

    private static Vector3d getEdgeNormal(Edge edge, boolean out) {
        if (edge.faces.size() != 1) {
            return null;
        }
        Face face = edge.faces.get(0);
        List<EdgeUse> eus = face.getUses(edge);
        if (eus.size() != 1) {
            return null;
        }
        return GenerateModelFromBIM.getEdgeNormal(eus.get(0), out);
    }

    private static double getOverlapAmount2d(Edge e1, Edge e2) {
        double[] overlap = GenerateModelFromBIM.getOverlap2dE1(e1, 0.0, 1.0, e2, 0.0, 1.0);
        return Math.abs(overlap[0] - overlap[1]);
    }

    private static double[][] getOverlap2d(Edge e1, double e1t1, double e1t2, Edge e2, double e2t1, double e2t2) {
        double[] e1t = GenerateModelFromBIM.getOverlap2dE1(e1, e1t1, e1t2, e2, e2t1, e2t2);
        double[] e2t = GenerateModelFromBIM.getOverlap2dE1(e2, e2t1, e2t2, e1, e1t[0], e1t[1]);
        return new double[][]{e1t, e2t};
    }

    private static double[] getOverlap2dE1(Edge e1, double e1t1, double e1t2, Edge e2, double e2t1, double e2t2) {
        double[] e1range = Util.rectify(e1t1, e1t2);
        Point3d e2p1 = e2.curve.get(e2t1);
        Point3d e2p2 = e2.curve.get(e2t2);
        e1t1 = Inter2D.nearestTOnLineSeg(e2p1.x, e2p1.y, e1.v1.loc.x, e1.v1.loc.y, e1.v2.loc.x, e1.v2.loc.y);
        e1t1 = Util.clampT(e1t1, e1range[0], e1range[1]);
        e1t2 = Inter2D.nearestTOnLineSeg(e2p2.x, e2p2.y, e1.v1.loc.x, e1.v1.loc.y, e1.v2.loc.x, e1.v2.loc.y);
        e1t2 = Util.clampT(e1t2, e1range[0], e1range[1]);
        return new double[]{e1t1, e1t2};
    }

    private static boolean isConnected(Face f1, Face f2) {
        if (f1 == f2) {
            return true;
        }
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.push(f1);
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(f1);
        while (!open.isEmpty()) {
            Face f = (Face)open.pop();
            for (FaceLoop loop : f.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face aface : eu.edge.faces) {
                        if (aface == f || !closed.add(aface)) continue;
                        if (aface == f2) {
                            return true;
                        }
                        open.push(aface);
                    }
                }
            }
        }
        return false;
    }

    private static void getConnectedFaces(Face seed, Consumer<Face> result) {
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.push(seed);
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(seed);
        while (!open.isEmpty()) {
            Face f = (Face)open.pop();
            result.accept(f);
            for (FaceLoop loop : f.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face aface : eu.edge.faces) {
                        if (!closed.add(aface)) continue;
                        open.push(aface);
                    }
                }
            }
        }
    }

    private static List<List<Edge>> getParallelSets(List<Edge> edges) {
        ArrayList<List<Edge>> result = new ArrayList<List<Edge>>();
        BitSet closed = new BitSet();
        for (int m = 0; m < edges.size(); ++m) {
            if (closed.get(m)) continue;
            closed.set(m);
            Edge e1 = edges.get(m);
            Vector3d e1dir = e1.curve.getTangent(0.0);
            if (Util3D.safeNormalize(e1dir, 1.0E-9) == 0.0) continue;
            ArrayList<Edge> edgeSet = new ArrayList<Edge>();
            edgeSet.add(e1);
            for (int n = m + 1; n < edges.size(); ++n) {
                if (closed.get(n)) continue;
                Edge e2 = edges.get(n);
                Vector3d e2dir = e2.curve.getTangent(0.0);
                if (Util3D.safeNormalize(e2dir, 1.0E-9) == 0.0) {
                    closed.set(n);
                    continue;
                }
                if (!Util3D.testParallel(e1dir, e2dir, 1.0E-6)) continue;
                edgeSet.add(e2);
                closed.set(n);
            }
            result.add(edgeSet);
        }
        return result;
    }

    private static double getZ(Edge edge) {
        return (edge.v1.loc.z + edge.v2.loc.z) * 0.5;
    }

    private static List<Edge> findNextStairEnd(ExtractProps eprops, List<List<Edge>> edgeSets, EdgeUse seedEdgeUse, Vector3d stairDir, boolean posDir) {
        Optional<List> oedgeSet = edgeSets.stream().filter(eset -> eset.contains(edgeUse.edge)).findFirst();
        if (!oedgeSet.isPresent()) {
            return Collections.emptyList();
        }
        Edge seedEdge = seedEdgeUse.edge;
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(stairDir, e.v1.loc);
        TreeMap<Double, List> sortedEdges = new TreeMap<Double, List>((e1, e2) -> theUtil.compare(e1, e2, 0.001));
        for (Edge edge : oedgeSet.get()) {
            sortedEdges.computeIfAbsent(getT.applyAsDouble(edge), e -> new ArrayList()).add(edge);
        }
        ArrayList edgeSet = new ArrayList(sortedEdges.entrySet());
        IdentityHashSet visitedEdges = new IdentityHashSet();
        Function<Pair, Pair> findEdgeOnNextStep = fromInfo -> {
            Edge fromEdge = (Edge)fromInfo.v1;
            double fromZ = GenerateModelFromBIM.getZ(fromEdge);
            int fromIx = (Integer)fromInfo.v2;
            double fromT = (Double)((Map.Entry)edgeSet.get(fromIx)).getKey();
            Face fromFace = fromEdge.faces.get(0);
            for (int m = fromIx; m < edgeSet.size(); ++m) {
                Map.Entry eentry = (Map.Entry)edgeSet.get(m);
                double t = (Double)eentry.getKey();
                if (Math.abs(t - fromT) > extractProps.maxStairTreadGap) {
                    return fromInfo;
                }
                Edge bestEdge = null;
                double bestEdgeOverlap = 0.0;
                for (Edge e : (List)eentry.getValue()) {
                    double overlapAmount;
                    EdgeUse eeu;
                    Vector3d inDir;
                    List<EdgeUse> eus;
                    double z;
                    if (e == fromEdge || visitedEdges.contains(e) || e.faces.get(0) == fromFace || theUtil.eq(fromZ, z = GenerateModelFromBIM.getZ(e), 0.001) || Math.abs(z - fromZ) > extractProps.maxStairRiser || (eus = e.faces.get(0).getUses(e)).size() != 1 || (inDir = GenerateModelFromBIM.getEdgeNormal(eeu = eus.get(0), false)) == null || inDir.dot(stairDir) <= 0.0 || theUtil.le0(overlapAmount = GenerateModelFromBIM.getOverlapAmount2d(fromEdge, e), 1.0E-6) || bestEdge != null && !(overlapAmount > bestEdgeOverlap)) continue;
                    bestEdge = e;
                    bestEdgeOverlap = overlapAmount;
                }
                if (bestEdge == null) continue;
                return new Pair<Object, Integer>(bestEdge, m);
            }
            return fromInfo;
        };
        Function<Pair, Pair> findNextEdgeOnCurrStep = fromInfo -> {
            int fromIx = (Integer)fromInfo.v2;
            Edge fromEdge = (Edge)fromInfo.v1;
            Face fromFace = fromEdge.faces.get(0);
            for (int m = fromIx + 1; m < edgeSet.size(); ++m) {
                Map.Entry eentry = (Map.Entry)edgeSet.get(m);
                Edge bestEdge = null;
                double bestEdgeOverlap = 0.0;
                for (Edge e : (List)eentry.getValue()) {
                    double overlapAmount;
                    EdgeUse eeu;
                    Vector3d outDir;
                    List<EdgeUse> eus;
                    Face f;
                    assert (e != fromEdge);
                    if (visitedEdges.contains(e) || !GenerateModelFromBIM.isConnected(fromFace, f = e.faces.get(0)) || (eus = f.getUses(e)).size() != 1 || (outDir = GenerateModelFromBIM.getEdgeNormal(eeu = eus.get(0), true)) == null || outDir.dot(stairDir) <= 0.0 || theUtil.le0(overlapAmount = GenerateModelFromBIM.getOverlapAmount2d(fromEdge, e), 1.0E-6) || bestEdge != null && !(overlapAmount > bestEdgeOverlap)) continue;
                    bestEdge = e;
                    bestEdgeOverlap = overlapAmount;
                }
                if (bestEdge == null) continue;
                return new Pair<Object, Integer>(bestEdge, m);
            }
            return fromInfo;
        };
        ArrayList<Edge> result = new ArrayList<Edge>();
        Consumer<Pair> addEdge = e -> {
            result.add((Edge)e.v1);
            visitedEdges.add(e.v1);
        };
        int seedListIx = -1;
        for (int m = 0; m < edgeSet.size(); ++m) {
            if (!((List)((Map.Entry)edgeSet.get(m)).getValue()).contains(seedEdge)) continue;
            seedListIx = m;
            break;
        }
        if (seedListIx == -1) {
            return Collections.emptyList();
        }
        Pair seedIx = new Pair(seedEdge, seedListIx);
        if (posDir) {
            addEdge.accept(seedIx);
            Pair nextStepEdgeIx = findEdgeOnNextStep.apply(seedIx);
            if (nextStepEdgeIx == seedIx) {
                result.clear();
                return result;
            }
            seedIx = nextStepEdgeIx;
            addEdge.accept(seedIx);
        }
        Pair edgeIx = seedIx;
        Pair nextStepEdgeIx;
        while ((nextStepEdgeIx = findNextEdgeOnCurrStep.apply(edgeIx)) != edgeIx) {
            edgeIx = nextStepEdgeIx;
            addEdge.accept(edgeIx);
            nextStepEdgeIx = findEdgeOnNextStep.apply(edgeIx);
            if (nextStepEdgeIx == edgeIx) {
                assert (result.size() > 0);
                result.remove(result.size() - 1);
                return result;
            }
            edgeIx = nextStepEdgeIx;
            addEdge.accept(edgeIx);
        }
        return result;
    }

    private boolean canReach(ExtractInfo einfo, Edge fromEdge, Edge toEdge, Predicate<? super ImportedGeom> obstFilter) {
        Vector3d normal = GenerateModelFromBIM.getEdgeNormal(fromEdge, true);
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(normal, e.v1.loc);
        double t1 = getT.applyAsDouble(fromEdge);
        double t2 = getT.applyAsDouble(toEdge);
        return this.canReach(einfo, fromEdge, toEdge, Math.abs(t2 - t1), obstFilter);
    }

    private boolean canReach(ExtractInfo einfo, Edge fromEdge, Edge toEdge, double tdist, Predicate<? super ImportedGeom> obstFilter) {
        Vector3d toDir;
        ExtractProps eprops = einfo.eprops;
        double[][] overlap = GenerateModelFromBIM.getOverlap2d(fromEdge, 0.0, 1.0, toEdge, 0.0, 1.0);
        double maxShrinkDist = 0.1;
        BiFunction<Edge, double[], double[]> shrinkEdge = (edge, ts) -> {
            double length = edge.curve.length();
            double tlength = Math.abs(ts[0] - ts[1]);
            double edgeShrinkT = maxShrinkDist / length;
            double middleT = (ts[0] + ts[1]) * 0.5;
            double newWidthT = tlength - edgeShrinkT;
            if (newWidthT < 0.001 && (newWidthT = 0.001) > tlength) {
                return ts;
            }
            double halfWidthT = newWidthT * 0.5;
            return new double[]{middleT - halfWidthT, middleT + halfWidthT};
        };
        overlap[0] = shrinkEdge.apply(fromEdge, overlap[0]);
        overlap[1] = shrinkEdge.apply(toEdge, overlap[1]);
        double fromz = GenerateModelFromBIM.getZ(fromEdge);
        double toz = GenerateModelFromBIM.getZ(toEdge);
        double offsetz = Util.clampT(eprops.maxStairRiser - Math.abs(fromz - toz), 0.001, eprops.headHeight);
        BiFunction<Point3d, Double, Point3d> offsetUp = (p, z) -> new Point3d(p.x, p.y, p.z + z);
        BiFunction<Point3d, Point3d, Point3d[]> extrudeEdgeUp = (ehp1, ehp2) -> {
            Point3d p1 = (Point3d)offsetUp.apply((Point3d)ehp1, offsetz);
            Point3d p2 = (Point3d)offsetUp.apply((Point3d)ehp2, offsetz);
            Point3d p3 = (Point3d)offsetUp.apply((Point3d)ehp2, extractProps.headHeight);
            Point3d p4 = (Point3d)offsetUp.apply((Point3d)ehp1, extractProps.headHeight);
            return new Point3d[]{p1, p2, p3, p4};
        };
        if (theUtil.eq0(tdist, 1.0E-6)) {
            Point3d ehp22;
            Edge higherEdge = fromz > toz ? fromEdge : toEdge;
            double[] higherOverlap = fromz > toz ? overlap[0] : overlap[1];
            Point3d ehp12 = higherEdge.curve.get(higherOverlap[0]);
            Point3d[] quad = extrudeEdgeUp.apply(ehp12, ehp22 = higherEdge.curve.get(higherOverlap[1]));
            Plane3d quadPlane = Util3D.simplePolygonPlane(Arrays.asList(quad), true);
            if (quadPlane == null) {
                return true;
            }
            AABox searchBox = new AABox(quad);
            CollResult foundObjs = new CollResult(ImportedGeom.class, obstFilter);
            einfo.md.geomLocation.getLocator().find((ITest<AABox>)searchBox, foundObjs, eprops.searchOptions);
            Point3d[] triPoints = new Point3d[3];
            List<Point3d> triList = Arrays.asList(triPoints);
            for (ImportedGeom ig : foundObjs.coll) {
                this.checkCancelled();
                Collection<Pair<Triangle, Elements.Orient>> tris = einfo.faceCache.getTris(einfo.md, ig);
                for (Pair<Triangle, Elements.Orient> tri : tris) {
                    this.checkCancelled();
                    triPoints[0] = ((Triangle)tri.v1).p1;
                    triPoints[1] = ((Triangle)tri.v1).p2;
                    triPoints[2] = ((Triangle)tri.v1).p3;
                    Plane3d triPlane = Util3D.simplePolygonPlane(triList, true);
                    if (triPlane == null || !Inter3D.testConvexPolyConvexPoly(quad, quadPlane, triPoints, triPlane, 1.0E-6)) continue;
                    return false;
                }
            }
            return true;
        }
        Point3d e1p1 = fromEdge.curve.get(overlap[0][0]);
        Point3d e1p2 = fromEdge.curve.get(overlap[0][1]);
        Point3d e2p1 = toEdge.curve.get(overlap[1][0]);
        Point3d e2p2 = toEdge.curve.get(overlap[1][1]);
        Vector3d fromDir = Util3D.vector(e1p1, e1p2);
        Vector3d cross = Util3D.cross(fromDir, Util3D.vector(e1p1, e2p1));
        if (cross.z < 0.0) {
            Point3d t = e1p1;
            e1p1 = e1p2;
            e1p2 = t;
            fromDir.negate();
        }
        if ((toDir = Util3D.vector(e2p1, e2p2)).dot(fromDir) > 0.0) {
            Point3d t = e2p1;
            e2p1 = e2p2;
            e2p2 = t;
        }
        Point3d[] fromQuad = extrudeEdgeUp.apply(e1p1, e1p2);
        Point3d[] toQuad = extrudeEdgeUp.apply(e2p1, e2p2);
        ArrayList<Point3d[]> quads = new ArrayList<Point3d[]>();
        quads.add(fromQuad);
        quads.add(toQuad);
        QuadConsumer<Point3d, Point3d, Point3d, Point3d> addQuad = (p1, p2, p3, p4) -> quads.add(new Point3d[]{p1, p2, p3, p4});
        addQuad.accept(fromQuad[0], fromQuad[3], toQuad[2], toQuad[1]);
        addQuad.accept(fromQuad[1], toQuad[0], toQuad[3], fromQuad[2]);
        addQuad.accept(fromQuad[0], toQuad[1], toQuad[0], fromQuad[1]);
        addQuad.accept(fromQuad[3], fromQuad[2], toQuad[3], toQuad[2]);
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>(6);
        for (Point3d[] quad : quads) {
            Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(quad), true);
            if (plane == null) continue;
            planes.add(plane);
        }
        ConvexHull ch = new ConvexHull(planes);
        AABox searchBox = new AABox();
        searchBox.add(fromQuad);
        searchBox.add(toQuad);
        CollResult foundObjs = new CollResult(ImportedGeom.class, obstFilter);
        ITest<AABox> test = box -> {
            Containment c = searchBox.test((AABox)box, 1.0E-6);
            if (c == Containment.OUTSIDE) {
                return c;
            }
            return ch.test((AABox)box, 1.0E-6);
        };
        einfo.md.geomLocation.getLocator().find(test, foundObjs, eprops.searchOptions);
        DefaultFilter pickFilter = new DefaultFilter(GeomType.FACE);
        final boolean[] intersected = new boolean[]{false};
        for (ImportedGeom ig : foundObjs.coll) {
            this.checkCancelled();
            IBoxCollector pickResult = new IBoxCollector(){

                @Override
                public void addNonFace(Object obj) throws CancelObjectPicking {
                }

                @Override
                public void addFace(Object obj, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal, IPrimProps faceProps) throws CancelObjectPicking {
                    intersected[0] = true;
                    throw new CancelObjectPicking();
                }
            };
            ig.pickBox(pickResult, pickFilter, ch);
            if (!intersected[0]) continue;
            return false;
        }
        return true;
    }

    private static Predicate<ImportedGeom> getObstFilter(ExtractInfo einfo) {
        Predicate<ImportedGeom> obstFilter = o -> !o.isA(ImportType.IGNORED) && !o.isA(ImportType.ROOM) && !o.isA(ImportType.DOOR);
        return obstFilter;
    }

    private List<Edge> getExtraStairEdges(ExtractInfo einfo, Model floorModel, Edge stairEdge, Predicate<Edge> edgeFilter) {
        if (stairEdge.faces.size() != 1) {
            return Collections.emptyList();
        }
        ExtractProps eprops = einfo.eprops;
        Face f = stairEdge.faces.get(0);
        List<EdgeUse> eus = f.getUses(stairEdge);
        if (eus.size() != 1) {
            return Collections.emptyList();
        }
        EdgeUse eu = eus.get(0);
        Vector3d normal = GenerateModelFromBIM.getEdgeNormal(eu, true);
        if (normal == null) {
            return Collections.emptyList();
        }
        Vector3d e1dir = stairEdge.curve.getTangent(0.0);
        double e1len = Util3D.safeNormalize(e1dir, 1.0E-9);
        if (e1len == 0.0) {
            return Collections.emptyList();
        }
        double xydist = eprops.maxStairTreadGap;
        double zdist = eprops.maxStairRiser;
        LineSeg ls = GenerateModelFromBIM.toLineSeg(stairEdge);
        LineSeg lsa = ls.transform(TransformUtil.translate(normal.x * xydist, normal.y * xydist, zdist).getInfo(), 0);
        LineSeg lsb = ls.transform(TransformUtil.translate(normal.x * xydist, normal.y * xydist, -zdist).getInfo(), 0);
        AABox searchBox = new AABox();
        ls.getBoundingBox(searchBox);
        lsa.getBoundingBox(searchBox);
        lsb.getBoundingBox(searchBox);
        List<Edge> nearEdges = floorModel.findEdges(searchBox);
        if (nearEdges.isEmpty()) {
            return Collections.emptyList();
        }
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(normal, e.v1.loc);
        double stairEdgeT = getT.applyAsDouble(stairEdge);
        double stairEdgeZ = GenerateModelFromBIM.getZ(stairEdge);
        double overlapTol = eprops.minCompWidth / e1len;
        ArrayList<Edge> nearestEdges = new ArrayList<Edge>();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        TriConsumer<Edge, Double, Double> tryAdd = (edge2, edget, tdist) -> {
            double[] edgeOverlap = null;
            ArrayList<Edge> toRemove = new ArrayList<Edge>();
            for (Edge nearestEdge : nearestEdges) {
                if (edgeOverlap == null) {
                    edgeOverlap = GenerateModelFromBIM.getOverlap2dE1(stairEdge, 0.0, 1.0, edge2, 0.0, 1.0);
                    edgeOverlap = Util.rectify(edgeOverlap);
                }
                double[] nearestOverlap = GenerateModelFromBIM.getOverlap2dE1(stairEdge, 0.0, 1.0, nearestEdge, 0.0, 1.0);
                if (!theUtil.lt(edgeOverlap[0], (nearestOverlap = Util.rectify(nearestOverlap))[1], 0.001) || !theUtil.gt(edgeOverlap[1], nearestOverlap[0], 0.001)) continue;
                double nearestT = getT.applyAsDouble(nearestEdge);
                if (theUtil.gt(edget, nearestT, 0.001)) {
                    return;
                }
                toRemove.add(nearestEdge);
            }
            if (!this.canReach(einfo, stairEdge, (Edge)edge2, (double)tdist, (Predicate<? super ImportedGeom>)obstFilter)) {
                return;
            }
            nearestEdges.removeAll(toRemove);
            nearestEdges.add((Edge)edge2);
        };
        for (Edge edge : nearEdges) {
            EdgeUse eu2;
            Vector3d normal2;
            Face f2;
            List<EdgeUse> eus2;
            double edgez;
            double tdist2;
            double edget2;
            double overlap;
            Vector3d e2dir;
            if (edge == stairEdge || !edgeFilter.test(edge) || Util3D.safeNormalize(e2dir = edge.curve.getTangent(0.0), 1.0E-9) == 0.0 || !Util3D.testParallel(e1dir, e2dir, 1.0E-6) || (overlap = GenerateModelFromBIM.getOverlapAmount2d(stairEdge, edge)) <= overlapTol || theUtil.lt(edget2 = getT.applyAsDouble(edge), stairEdgeT, 0.001) || (tdist2 = Math.abs(edget2 - stairEdgeT)) > eprops.maxStairTreadGap || theUtil.eq(edgez = GenerateModelFromBIM.getZ(edge), stairEdgeZ, 1.0E-6) || Math.abs(edgez - stairEdgeZ) > eprops.maxStairRiser || (eus2 = (f2 = edge.faces.get(0)).getUses(edge)).size() != 1 || (normal2 = GenerateModelFromBIM.getEdgeNormal(eu2 = eus2.get(0), false)) == null || normal2.dot(normal) < 0.0) continue;
            tryAdd.accept(edge, edget2, tdist2);
        }
        return nearestEdges;
    }

    private static double getWidthSq(Edge edge) {
        return Util2D.distanceSq(edge.v1.loc.x, edge.v1.loc.y, edge.v2.loc.x, edge.v2.loc.y);
    }

    private static double getWidth(Edge edge) {
        return Math.sqrt(GenerateModelFromBIM.getWidthSq(edge));
    }

    private static boolean testParallel(Edge e1, Edge e2) {
        Vector3d dir1 = e1.curve.getTangent(0.0);
        Vector3d dir2 = e2.curve.getTangent(0.0);
        return Util3D.testParallel(dir1, dir2, 1.0E-9);
    }

    private StairStep findStairStep(ExtractInfo einfo, Model floorModel, int stairid, Face seedFace) {
        IdentityHashMap connectedFaces = new IdentityHashMap();
        Function<Face, Set> getConnected = f -> {
            LinkedIdentityHashSet faces = (LinkedIdentityHashSet)connectedFaces.get(f);
            if (faces == null) {
                faces = new LinkedIdentityHashSet();
                GenerateModelFromBIM.getConnectedFaces(f, faces::add);
                for (Face face : faces) {
                    connectedFaces.put(face, faces);
                }
            }
            return faces;
        };
        ArrayDeque<Set> open = new ArrayDeque<Set>();
        Set seedFaces = getConnected.apply(seedFace);
        open.push(seedFaces);
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(seedFaces);
        double widthTolSq = einfo.eprops.minCompWidth * einfo.eprops.minCompWidth;
        Predicate<Edge> tooSmall = edge -> GenerateModelFromBIM.getWidthSq(edge) < widthTolSq;
        Predicate<Edge> sameZ = edge -> theUtil.eq(edge.v1.loc.z, edge.v2.loc.z, 0.01);
        Predicate<Edge> edgeFilter = e -> e.partOfGroup(1) && e.faces.size() == 1 && e.faces.get(0).getUses((Edge)e).size() == 1 && !tooSmall.test((Edge)e) && sameZ.test((Edge)e);
        IdentityHashMap steps = new IdentityHashMap();
        Function<Set, StairStep> getStep = f -> steps.computeIfAbsent(f, face -> new StairStep((Set<Face>)face));
        while (!open.isEmpty()) {
            Set faces = (Set)open.pop();
            StairStep step = getStep.apply(faces);
            for (Face face : faces) {
                if (!face.partOfGroup(stairid)) continue;
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        if (!edgeFilter.test(eu.edge)) continue;
                        List<Edge> extraEdges = this.getExtraStairEdges(einfo, floorModel, eu.edge, edgeFilter);
                        for (Edge extraEdge : extraEdges) {
                            Set adjFaces = getConnected.apply(extraEdge.faces.get(0));
                            StairStep adjStep = getStep.apply(adjFaces);
                            StairStepConnection conn = new StairStepConnection(step, adjStep, eu.edge, extraEdge);
                            StairStepConnection revConn = conn.reverse();
                            if (!step.canConnect(conn) || !adjStep.canConnect(revConn)) continue;
                            step.connect(conn);
                            adjStep.connect(revConn);
                            if (!closed.add(adjFaces) || !extraEdge.partOfGroup(stairid)) continue;
                            open.push(adjFaces);
                        }
                    }
                }
            }
        }
        return (StairStep)steps.get(seedFaces);
    }

    private static boolean isAStair(ImportedGeom ig) {
        switch (ig.getImportedType()) {
            case STAIR: 
            case ESCALATOR: {
                return true;
            }
        }
        return false;
    }

    private Model generateStairs(ExtractInfo einfo, NameGenerator stairNames, Model floorModel, LinkedHashMap<Integer, ImportedGeom> idGeomMap, List<? super EgressStair> resultStairs, Consumer<Edge> usedEdges, Predicate<Edge> keepEdges) {
        this.d_progress.nextStep(Intl.intl("Adding stairs"), -1);
        if (!einfo.getProp(EXTRACT_STAIRS).booleanValue()) {
            this.d_progress.skipStep();
            return floorModel;
        }
        List stairs = idGeomMap.entrySet().stream().filter(entry -> GenerateModelFromBIM.isAStair((ImportedGeom)entry.getValue())).collect(Collectors.toList());
        if (stairs.isEmpty()) {
            this.d_progress.skipStep();
            return floorModel;
        }
        floorModel = GenerateModelFromBIM.cleanup(floorModel, keepEdges);
        this.d_progress.resetStep(stairs.size());
        LinkedIdentityHashSet stairKeepFaces = new LinkedIdentityHashSet();
        for (Map.Entry entry2 : stairs) {
            this.d_progress.increment();
            ImportedGeom stair = (ImportedGeom)entry2.getValue();
            int stairid = (Integer)entry2.getKey();
            List stairFaces = floorModel.getFaces(stairid).stream().collect(Collectors.toCollection(() -> new ArrayList()));
            ArrayDeque openFaces = new ArrayDeque(stairFaces);
            IdentityHashSet closedFaces = new IdentityHashSet();
            while (!openFaces.isEmpty()) {
                Face seedFace = (Face)openFaces.pop();
                if (!closedFaces.add(seedFace)) continue;
                StairStep step = this.findStairStep(einfo, floorModel, stairid, seedFace);
                if (step.connections.isEmpty()) continue;
                Supplier<String> generateName = () -> {
                    String name = stairNames.generateValidName(stair.getName());
                    stairNames.registerName(name);
                    return name;
                };
                step.createStairs(einfo.eprops, generateName, resultStairs::add, stairKeepFaces::add, closedFaces::add, usedEdges);
            }
        }
        Predicate<Face> isDelFace = f -> {
            boolean stairOnly = IntStream.of(f.groups).allMatch(g -> {
                ImportedGeom ig = (ImportedGeom)idGeomMap.get(g);
                return ig == null || GenerateModelFromBIM.isAStair(ig);
            });
            if (!stairOnly) {
                return false;
            }
            return !stairKeepFaces.contains(f);
        };
        List delFaces = floorModel.getFaces().stream().filter(isDelFace).collect(Collectors.toList());
        for (Face face : delFaces) {
            floorModel.deleteFace(face, true, true);
        }
        return floorModel;
    }

    private static LineSeg toLineSeg(Edge e) {
        return new LineSeg(e.v1.loc, e.v2.loc);
    }

    /*
     * WARNING - void declaration
     */
    private Model generateDoors(ExtractInfo einfo, NameGenerator doorNames, Collection<? extends ImportedGeom> pickGeom, Model floorModel, List<? super EgressDoor> resultDoors, Consumer<Edge> usedEdges, Predicate<Edge> keepEdges) {
        this.d_progress.nextStep(Intl.intl("Adding doors"), -1);
        if (!einfo.getProp(EXTRACT_DOORS).booleanValue()) {
            this.d_progress.skipStep();
            return floorModel;
        }
        Predicate<ImportedGeom> doorFilter = ig -> ig.isA(ImportType.DOOR);
        MerlinData md = einfo.md;
        IFilteredCollection<ImportedGeom> doors = theUtil.filter(pickGeom, doorFilter);
        if (doors.isEmpty()) {
            this.d_progress.skipStep();
            return floorModel;
        }
        this.d_progress.resetStep(doors.size());
        IdentityHashMap<ImportedGeom, DoorInfo> doorInfo = new IdentityHashMap<ImportedGeom, DoorInfo>();
        Function<ImportedGeom, Pair> getDoorGeom = door -> {
            IGeom fgeom;
            IGeomNode openingGeom = door.get(ImportedGeom.PROP_DOOR_VOID);
            if (openingGeom != null && (fgeom = openingGeom.flatten().getLocalGeom()).getNumPrims(1) != 0) {
                return new Pair<IGeom, Boolean>(fgeom, true);
            }
            return new Pair<IGeom, Boolean>(door.getGeom().flatten().getLocalGeom(), false);
        };
        for (ImportedGeom door2 : doors) {
            Object edge22;
            this.d_progress.increment();
            LinkedHashSet<Point2d> projectedPoints = new LinkedHashSet<Point2d>();
            Consumer<Point3d> addPoint = p -> projectedPoints.add(new Point2d(p.x, p.y));
            Consumer<Point3d[]> addPoints = points -> {
                for (Point3d p : points) {
                    addPoint.accept(p);
                }
            };
            Pair fgeom = getDoorGeom.apply(door2);
            for (IPrimitive prim : thunderheadeng.geometry.objs.GeomUtil.explode((IGeom)fgeom.v1, IPrimitive.class)) {
                Mesh mesh;
                if (prim instanceof IFace) {
                    mesh = ((IFace)prim).triangulate(md.simParams.faceError);
                    addPoints.accept(mesh.vertices);
                    continue;
                }
                if (prim instanceof ICurve) {
                    mesh = ((ICurve)prim).getSegments(md.simParams.edgeError);
                    addPoints.accept(mesh.vertices);
                    continue;
                }
                if (!(prim instanceof Point)) continue;
                addPoint.accept(((Point)prim).loc);
            }
            if (projectedPoints.size() <= 1) continue;
            Point2d[] mbb = Util2D.getMinimumBoundingBox(projectedPoints);
            assert (mbb.length == 4);
            if (mbb.length != 4) continue;
            AABox bounds = door2.getBounds();
            double zmin = bounds.getMinZ() - 0.1;
            double zmax = bounds.getMaxZ() + 1.0E-6;
            int doorEdgeId = einfo.nextId();
            ArrayList sides = new ArrayList(6);
            BiConsumer<IPolygon, Boolean> addFace = (poly, ccw) -> {
                Vector3d normal = poly.getNormal((boolean)ccw);
                if (normal.lengthSquared() == 0.0) {
                    return;
                }
                GenerateModelFromBIM.addFaceToModel(md, poly, ccw, floorModel, doorEdgeId);
                sides.add(new Plane3d(normal, poly.getPoint(0, 0)));
            };
            Point2d prev = mbb[3];
            for (int m = 0; m < 4; ++m) {
                Point2d curr = mbb[m];
                IPolygon poly2 = GenerateModelFromBIM.newPoly(prev.x, prev.y, zmin, curr.x, curr.y, zmin, curr.x, curr.y, zmax, prev.x, prev.y, zmax);
                addFace.accept(poly2, true);
                prev = curr;
            }
            IPolygon top = GenerateModelFromBIM.newPoly(mbb[0].x, mbb[0].y, zmax, mbb[1].x, mbb[1].y, zmax, mbb[2].x, mbb[2].y, zmax, mbb[3].x, mbb[3].y, zmax);
            addFace.accept(top, true);
            IPolygon bottom = GenerateModelFromBIM.newPoly(mbb[0].x, mbb[0].y, zmin, mbb[1].x, mbb[1].y, zmin, mbb[2].x, mbb[2].y, zmin, mbb[3].x, mbb[3].y, zmin);
            addFace.accept(bottom, false);
            for (Face face : new ArrayList<Face>(floorModel.getFaces(doorEdgeId))) {
                if (face.groups.length != 1) continue;
                floorModel.deleteFace(face, true, true);
            }
            boolean modelModified = false;
            for (Object edge22 : floorModel.getEdges(doorEdgeId)) {
                modelModified = true;
                ((AModelObj)edge22).addGroup(1);
            }
            int[] nArray = new int[]{doorEdgeId};
            edge22 = floorModel.getFaces(doorEdgeId).iterator();
            while (edge22.hasNext()) {
                Face face3 = (Face)edge22.next();
                modelModified = true;
                face3.removeGroups(nArray);
            }
            if (!modelModified) continue;
            ConvexHull ch = new ConvexHull(sides);
            List<Face> testFaces = floorModel.findFaces(aabox -> ch.test((AABox)aabox, 1.0E-6));
            this.checkCancelled();
            boolean facesFound = false;
            for (Face face4 : testFaces) {
                Point3d testpoint = floorModel.findPointInFace(face4);
                if (testpoint == null || ch.classify(testpoint, 1.0E-6) != ConvexHull.PointClassify.INSIDE) continue;
                facesFound = true;
                floorModel.deleteFace(face4, true, true);
            }
            doorInfo.put(door2, new DoorInfo(doorEdgeId, facesFound, (Boolean)fgeom.v2));
        }
        Model resultModel = GenerateModelFromBIM.cleanup(floorModel, keepEdges);
        Function<Edge, Vector3d> getEdgeDir = edge -> {
            Vector3d edir = Util3D.vector(edge.v1.loc, edge.v2.loc);
            edir.z = 0.0;
            if (Util3D.safeNormalize(edir, 0.0) == 0.0) {
                return null;
            }
            return edir;
        };
        BiConsumer<EgressDoor, ImportedGeom> setEvacDoorProps = (door, geom) -> {
            Boolean isAccesssible;
            UnitDouble flowrate = geom.get(ImportedGeom.PROP_DOOR_FLOWRATE);
            if (flowrate != null && flowrate.getRawValue() >= 0.0) {
                door.setFlowrate(new IEgressFlowrate.Limited(flowrate));
            }
            if ((isAccesssible = geom.get(ImportedGeom.PROP_DOOR_IS_ACCESSIBLE)) != null && !isAccesssible.booleanValue()) {
                door.setState(new ConstVariant<EgressDoorDir>(EgressDoorDir.NONE));
            }
        };
        for (ImportedGeom door3 : doors) {
            Point3d[] boundary;
            UnitDouble doorWidth;
            int doorid;
            List<Edge> edges;
            this.checkCancelled();
            DoorInfo di = (DoorInfo)doorInfo.get(door3);
            if (di == null || (edges = new ArrayList<Edge>(theUtil.filter(resultModel.getEdges(doorid = di.edgeId), edge -> getEdgeDir.apply((Edge)edge) != null))).isEmpty()) continue;
            Consumer<Edge> addExitDoor = edge -> {
                String name = doorNames.generateValidName(door3.getName());
                doorNames.registerName(name);
                LineSeg3D line = new LineSeg3D(edge.v1.loc, edge.v2.loc);
                usedEdges.accept((Edge)edge);
                EgressDoor createdDoor = new EgressDoor(name, false, null, null, line, line, new Point3d[]{edge.v1.loc, edge.v2.loc});
                setEvacDoorProps.accept(createdDoor, door3);
                resultDoors.add(createdDoor);
            };
            Vector3d doorDir = door3.get(ImportedGeom.PROP_DOOR_DIR);
            ToDoubleFunction<Edge> getDirAlign = doorDir != null ? e -> Math.abs(doorDir.dot((Vector3d)getEdgeDir.apply((Edge)e))) : e -> 0.0;
            Comparator edgeCompare = (e1, e2) -> {
                int comp = theUtil.compare(getDirAlign.applyAsDouble((Edge)e1), getDirAlign.applyAsDouble((Edge)e2), 1.0E-6);
                if (comp != 0) {
                    return comp;
                }
                return Double.compare(e2.curve.length(), e1.curve.length());
            };
            Collections.sort(edges, edgeCompare);
            double minDot = getDirAlign.applyAsDouble((Edge)edges.get(0));
            if ((edges = (List)edges.stream().filter(e -> e.faces.size() == 1 && !e.faces.get(0).isInternalEdge((Edge)e) && GenerateModelFromBIM.getEdgeNormal(e, true) != null && theUtil.le(getDirAlign.applyAsDouble((Edge)e), minDot, 0.001)).collect(Collectors.toCollection(() -> new ArrayList()))).isEmpty()) continue;
            if (edges.size() == 1) {
                addExitDoor.accept(edges.get(0));
                continue;
            }
            ArrayList<Edge[]> edgePairs = new ArrayList<Edge[]>();
            IdentityHashSet closedEdges = new IdentityHashSet();
            for (Edge e12 : edges) {
                void var32_46;
                if (!closedEdges.add(e12)) continue;
                Vector3d enormal = GenerateModelFromBIM.getEdgeNormal(e12, true);
                assert (enormal != null);
                Object var32_45 = null;
                double bestE2Overlap = -1.7976931348623157E308;
                for (int m = 1; m < edges.size(); ++m) {
                    double overlap;
                    Edge e22 = edges.get(m);
                    Vector3d e2normal = GenerateModelFromBIM.getEdgeNormal(e22, false);
                    assert (e2normal != null);
                    if (!theUtil.eq(enormal.dot(e2normal), 1.0, 0.001) || theUtil.le0(overlap = GenerateModelFromBIM.getOverlapAmount2d(e12, e22), 0.001) || !(overlap > bestE2Overlap)) continue;
                    Edge edge2 = e22;
                    bestE2Overlap = overlap;
                }
                if (var32_46 != null) {
                    closedEdges.add(var32_46);
                    edgePairs.add(new Edge[]{e12, var32_46});
                    continue;
                }
                edgePairs.add(new Edge[]{e12});
            }
            Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
            Predicate<Edge[]> isObstructed = epair -> {
                Edge e1 = epair[0];
                Edge e2 = ((Edge[])epair).length > 1 ? epair[1] : e1;
                return !this.canReach(einfo, e1, e2, obstFilter);
            };
            ToDoubleFunction<Edge[]> getOverlapLength = epair -> {
                double e1len = epair[0].v1.loc.distance(epair[0].v2.loc);
                if (((Edge[])epair).length == 1) {
                    return e1len;
                }
                double overlap = GenerateModelFromBIM.getOverlapAmount2d(epair[0], epair[1]);
                return overlap * e1len;
            };
            Edge[] edgeArray = (Edge[])edgePairs.stream().min((epair1, epair2) -> {
                boolean obstructed2;
                boolean obstructed1 = isObstructed.test((Edge[])epair1);
                if (obstructed1 != (obstructed2 = isObstructed.test((Edge[])epair2))) {
                    return obstructed1 ? 1 : -1;
                }
                double overlap1 = getOverlapLength.applyAsDouble((Edge[])epair1);
                double overlap2 = getOverlapLength.applyAsDouble((Edge[])epair2);
                return Double.compare(overlap2, overlap1);
            }).get();
            if (edgeArray.length == 1) {
                addExitDoor.accept(edgeArray[0]);
                continue;
            }
            Edge e13 = edgeArray[0];
            Edge e23 = edgeArray[1];
            double[][] overlap = GenerateModelFromBIM.getOverlap2d(e13, 0.0, 1.0, e23, 0.0, 1.0);
            if (!di.geomFromOpening && (doorWidth = door3.get(ImportedGeom.PROP_DOOR_WIDTH)) != null) {
                double maxWidth = doorWidth.get(Geometry.LU);
                BiConsumer<Edge, double[]> shrinkToWidth = (edge, ts) -> {
                    double ewidth = edge.v1.loc.distance(edge.v2.loc);
                    double maxWidthT = maxWidth / ewidth;
                    if (Math.abs(ts[1] - ts[0]) > maxWidthT) {
                        double midt = (ts[1] + ts[0]) * 0.5;
                        ts[0] = midt - maxWidthT * 0.5;
                        ts[1] = midt + maxWidthT * 0.5;
                    }
                };
                shrinkToWidth.accept(e13, overlap[0]);
                shrinkToWidth.accept(e23, overlap[1]);
            }
            if ((boundary = StrutUtil.calcStrutBoundaryFull(new LineSeg(e13.v1.loc, e13.v2.loc), new LineSeg(e23.v1.loc, e23.v2.loc), overlap[0][0], overlap[0][1], overlap[1][0], overlap[1][1])) == null) continue;
            String name = doorNames.generateValidName(door3.getName());
            doorNames.registerName(name);
            usedEdges.accept(e13);
            usedEdges.accept(e23);
            EgressDoor createdDoor = new EgressDoor(name, false, null, null, new LineSeg3D(e13.v1.loc, e13.v2.loc), new LineSeg3D(e23.v1.loc, e23.v2.loc), boundary);
            setEvacDoorProps.accept(createdDoor, door3);
            resultDoors.add(createdDoor);
        }
        return resultModel;
    }

    private static Model cleanup(Model floorModel, Predicate<Edge> usedEdges) {
        theTimer timer = new theTimer();
        Model resultModel = RoomUtil.cleanup(floorModel, 63, usedEdges, true);
        System.out.printf("room cleanup complete: %g s%n", timer.curr());
        return resultModel;
    }

    private static IPolygon newPoly(double ... vals) {
        int count = vals.length / 3;
        Point3d[] points = new Point3d[count];
        int m = 0;
        int pix = 0;
        while (m < vals.length) {
            double x = vals[m++];
            double y = vals[m++];
            double z = vals[m++];
            points[pix] = new Point3d(x, y, z);
            ++pix;
        }
        return PolyUtil.newPoly(points);
    }

    private Pair<Model, LinkedHashMap<Integer, ImportedGeom>> generateFloor(ExtractInfo einfo, Collection<? extends ImportedGeom> geom) throws ExtractException, CancellationException {
        ExtractProps eprops = einfo.eprops;
        double headHeight = eprops.headHeight;
        Collection<GeomFace> pickFaces = GenerateModelFromBIM.findFloorFaces(einfo, geom);
        if (pickFaces.isEmpty()) {
            throw new ExtractException(ExtractException.Type.NO_VALID_FACES);
        }
        Vector3d extrudeDir = new Vector3d(0.0, 0.0, headHeight);
        int wallGroup = Integer.MAX_VALUE;
        IdentityHashMap<ImportedGeom, Integer> geomIds = new IdentityHashMap<ImportedGeom, Integer>();
        LinkedHashMap idGeoms = new LinkedHashMap();
        this.d_progress.nextStep(Intl.intl("Adding floor faces"), pickFaces.size());
        Model floorModel = new Model();
        for (GeomFace face : pickFaces) {
            this.d_progress.increment();
            Integer id = geomIds.computeIfAbsent(face.geom, g -> {
                int result = einfo.nextId();
                idGeoms.put(result, g);
                return result;
            });
            GenerateModelFromBIM.addFaceToModel(einfo.md, face.face, face.orient == Elements.Orient.CCW, floorModel, id);
        }
        this.subtractObstructions(einfo, floorModel, extrudeDir, Integer.MAX_VALUE);
        if (eprops.get(DEL_SMALL_ROOMS).booleanValue()) {
            this.removeSmallRooms(einfo, floorModel);
        }
        if (eprops.get(DEL_ROOMS_IN_SOLIDS).booleanValue()) {
            this.removeFacesInSolids(einfo, floorModel);
        }
        return new Pair<Model, LinkedHashMap<Integer, ImportedGeom>>(floorModel, idGeoms);
    }

    private static double getSlopeRad(Vector3d normal) {
        double slope = 1.5707963267948966 - Math.atan2(normal.z, Math.sqrt(normal.x * normal.x + normal.y * normal.y));
        return slope;
    }

    private <T> void mtproc(MTProcessor mtproc, List<T> items, MTProcessor.IProc<T> proc) throws CancellationException {
        try {
            mtproc.process(items, proc);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private void subtractObstructions(ExtractInfo einfo, Model floorModel, Vector3d extrudeDir, int wallGroup) throws CancellationException {
        this.d_progress.nextStep(Intl.intl("Finding overhead obstructions"), floorModel.getFaces().size());
        MTProcessor mtproc = new MTProcessor(Runtime.getRuntime().availableProcessors(), MTProcessor.Schedule.GUIDED, new MTListProcessorPool());
        MerlinData md = einfo.md;
        FaceCache faceCache = einfo.faceCache;
        int options = einfo.eprops.searchOptions;
        md.geomLocation.updateDirty();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        Locator[] geomFinders = new Locator[mtproc.getNumThreads()];
        for (int m = 0; m < mtproc.getNumThreads(); ++m) {
            geomFinders[m] = new Locator<ImportedGeom>(ImportedGeom.class, obstFilter);
        }
        ArrayList obstructions = new ArrayList();
        this.mtproc(mtproc, new ArrayList<Face>(floorModel.getFaces()), (face, tix, ix) -> {
            this.d_progress.increment();
            AABox extrudedBounds = face.getBounds();
            extrudedBounds = new AABox(extrudedBounds.getMin(), Util3D.add(extrudedBounds.getMax(), (Tuple3d)extrudeDir));
            Locator geomFinder = geomFinders[tix];
            geomFinder.reset(extrudedBounds);
            merlinData.geomLocation.getLocator().find((ITest<AABox>)geomFinder.test, geomFinder.result, options);
            if (geomFinder.getResult().isEmpty()) {
                return;
            }
            NavigableMap<Double, Pair<ImportedGeom, AABox>> overhangFaces = new TreeMap(s_areaComp);
            for (ImportedGeom potGeom : geomFinder.getResult()) {
                this.checkCancelled();
                AABox bb = potGeom.getBounds();
                double area = bb.getWidth() * bb.getDepth();
                overhangFaces.put(area, new Pair<ImportedGeom, AABox>(potGeom, bb));
            }
            overhangFaces = overhangFaces.descendingMap();
            List list2 = obstructions;
            synchronized (list2) {
                obstructions.add(new Pair(new Pair<Face, AABox>((Face)face, extrudedBounds), overhangFaces.values()));
            }
        });
        int totalFacePairs = 0;
        for (Pair entry2 : obstructions) {
            for (Pair obstruction : (Collection)entry2.v2) {
                totalFacePairs += faceCache.getFaces((ImportedGeom)obstruction.v1).size();
            }
        }
        this.d_progress.nextStep(Intl.intl("Subtractring obstructions"), totalFacePairs);
        ArrayList toDelete = new ArrayList();
        ArrayList toAdd = new ArrayList();
        this.mtproc(mtproc, obstructions, (entry, tix, ix) -> {
            this.checkCancelled();
            Face face = (Face)((Pair)entry.v1).v1;
            AABox extrudedBounds = (AABox)((Pair)entry.v1).v2;
            Collection overhangFaces = (Collection)entry.v2;
            Plane3d bplane = face.plane;
            if (bplane.z < 0.0) {
                bplane = bplane.negate();
            }
            Matrix4d xform = Util.translateMat(vector3d.x, vector3d.y, vector3d.z);
            Plane3d tplane = bplane.transformBy(xform);
            Model newFaceModel = new Model();
            newFaceModel.addFace(face);
            Plane3d floorPlane = face.plane;
            double iz = 1.0 / floorPlane.z;
            Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -floorPlane.x * iz, -floorPlane.y * iz, 0.0, -floorPlane.w * iz, 0.0, 0.0, 0.0, 1.0);
            boolean modified = false;
            AABox facebb = new AABox();
            Iterator potGeomIt = overhangFaces.iterator();
            while (potGeomIt.hasNext()) {
                PlaneCat tcat;
                Pair potGeom = (Pair)potGeomIt.next();
                this.checkCancelled();
                AABox bb = (AABox)potGeom.v2;
                Point3d[] points = bb.getVerts();
                PlaneCat bcat = GenerateModelFromBIM.categorizePointsForSubtract(bplane, points);
                if (bcat.equals((Object)PlaneCat.PLANE_BELOW) || bcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (tcat = GenerateModelFromBIM.categorizePointsForSubtract(tplane, points)).equals((Object)PlaneCat.PLANE_ABOVE) || tcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
                Collection<Pair<IPolygon, Elements.Orient>> gfaces = faceCache.getFaces((ImportedGeom)potGeom.v1);
                if (bcat.equals((Object)PlaneCat.PLANE_ABOVE) && tcat.equals((Object)PlaneCat.PLANE_BELOW)) {
                    int fix = 0;
                    for (Pair<IPolygon, Elements.Orient> gfaceInfo : gfaces) {
                        this.d_progress.increment();
                        IPolygon gface = (IPolygon)gfaceInfo.v1;
                        facebb.reset();
                        gface.getBoundingBox(facebb);
                        if (!extrudedBounds.intersects(facebb, 1.0E-6)) continue;
                        Point3d[] verts = GenerateModelFromBIM.getVerts(gface, false);
                        modified |= GenerateModelFromBIM.projectAndSubtract(newFaceModel, verts, gface.getPlane(true), face.plane, projectionXform, wallGroup);
                        if (newFaceModel.getFaces().isEmpty()) {
                            this.d_progress.increment(gfaces.size() - fix - 1);
                            break;
                        }
                        ++fix;
                    }
                } else {
                    Object activeFaces = new ArrayList<IPolygon>(2);
                    ArrayList<IPolygon> clipFaces = new ArrayList(2);
                    int fix = 0;
                    for (Pair<IPolygon, Elements.Orient> gfaceInfo : gfaces) {
                        ArrayList<IPolygon> temp;
                        IPolygon poly;
                        PlaneCat ftcat;
                        Point3d[] verts;
                        PlaneCat fbcat;
                        this.d_progress.increment();
                        IPolygon gface = (IPolygon)gfaceInfo.v1;
                        facebb.reset();
                        gface.getBoundingBox(facebb);
                        if (!extrudedBounds.intersects(facebb, 1.0E-6) || (fbcat = GenerateModelFromBIM.categorizePointsForSubtract(bplane, verts = GenerateModelFromBIM.getVerts(gface, false))).equals((Object)PlaneCat.PLANE_BELOW) || fbcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (ftcat = GenerateModelFromBIM.categorizePointsForSubtract(tplane, verts)).equals((Object)PlaneCat.PLANE_ABOVE) || ftcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
                        activeFaces.clear();
                        activeFaces.add(gface);
                        if (fbcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                            clipFaces.clear();
                            Iterator iterator = activeFaces.iterator();
                            while (iterator.hasNext()) {
                                poly = (IPolygon)iterator.next();
                                GenerateModelFromBIM.clipFace(poly, bplane, true, (Collection<IPolygon>)clipFaces);
                            }
                            temp = activeFaces;
                            activeFaces = clipFaces;
                            clipFaces = temp;
                        }
                        if (ftcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                            clipFaces.clear();
                            temp = activeFaces.iterator();
                            while (temp.hasNext()) {
                                poly = (IPolygon)temp.next();
                                GenerateModelFromBIM.clipFace(poly, tplane, false, clipFaces);
                            }
                            temp = activeFaces;
                            activeFaces = clipFaces;
                            clipFaces = temp;
                        }
                        Plane3d gfacePlane = gface.getPlane(true);
                        Iterator iterator = activeFaces.iterator();
                        while (iterator.hasNext()) {
                            IPolygon poly2 = (IPolygon)iterator.next();
                            modified |= GenerateModelFromBIM.projectAndSubtract(newFaceModel, GenerateModelFromBIM.getVerts(poly2, false), gfacePlane, face.plane, projectionXform, wallGroup);
                        }
                        if (newFaceModel.getFaces().isEmpty()) {
                            this.d_progress.increment(gfaces.size() - fix - 1);
                            break;
                        }
                        ++fix;
                    }
                }
                if (!newFaceModel.getFaces().isEmpty()) continue;
                int skipCount = 0;
                while (potGeomIt.hasNext()) {
                    skipCount += faceCache.getFaces((ImportedGeom)((Pair)potGeomIt.next()).v1).size();
                }
                this.d_progress.increment(skipCount);
                break;
            }
            if (modified) {
                List list3 = toDelete;
                synchronized (list3) {
                    toDelete.add(face);
                }
                list3 = toAdd;
                synchronized (list3) {
                    toAdd.add(newFaceModel.getFaces());
                }
            }
        });
        for (Face face2 : toDelete) {
            floorModel.deleteFace(face2, true, true);
        }
        for (Collection newFaces : toAdd) {
            floorModel.add(newFaces, Collections.emptyList(), Collections.emptyList());
        }
    }

    private static Point3d[] getOuterVerts(Face face) {
        FaceLoop outerLoop = face.outerLoop();
        if (outerLoop == null) {
            return new Point3d[0];
        }
        ArrayList<Point3d> verts = new ArrayList<Point3d>(outerLoop.edges.size());
        for (EdgeUse eu : outerLoop.edges) {
            verts.add(eu.v1().loc);
        }
        return verts.toArray(new Point3d[verts.size()]);
    }

    private static Point3d[] getVerts(IPolygon face, boolean copy) {
        return PolyUtil.getAllVerts(face, copy);
    }

    private static void clipFace(IPolygon poly, Plane3d plane, boolean keepAbove, Collection<IPolygon> resultPolys) {
        if (!GenerateModelFromBIM.isConvex(poly)) {
            List<Triangle> tris = thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(0.0, poly);
            for (Triangle tri : tris) {
                GenerateModelFromBIM.clipFace(tri, plane, keepAbove, resultPolys);
            }
            return;
        }
        assert (poly.getNumLoops() == 1);
        int numPoints = poly.getNumPoints(0);
        ArrayList<Point3d> tempList = new ArrayList<Point3d>(numPoints);
        for (int m = 0; m < numPoints; ++m) {
            Point3d intersection;
            Point3d p1 = poly.getPoint(0, m);
            Point3d p2 = poly.getPoint(0, (m + 1) % numPoints);
            boolean p1Pos = theUtil.ge0(plane.dot(p1), 1.0E-6);
            boolean p2Pos = theUtil.ge0(plane.dot(p2), 1.0E-6);
            if (p1Pos == keepAbove) {
                tempList.add(p1);
            }
            if (p1Pos == p2Pos || (intersection = Inter3D.lineSegPlaneIntersection(p1, p2, plane, 0.0)) == null) continue;
            tempList.add(intersection);
        }
        if (tempList.size() > 2) {
            resultPolys.add(PolyUtil.newPoly(tempList.toArray(new Point3d[tempList.size()])));
        }
    }

    private static boolean isConvex(IPolygon poly) {
        if (poly.getNumLoops() > 1) {
            return false;
        }
        Point3d[] verts = PolyUtil.getAllVerts(poly, false);
        return verts.length == 3 || Util3D.isConvex(1.0E-6, verts);
    }

    private static PlaneCat categorizePointsForSubtract(Plane3d plane, Point3d ... points) {
        int aboveCount = 0;
        int belowCount = 0;
        int onCount = 0;
        for (Point3d p : points) {
            double dot = plane.dot(p);
            if (theUtil.eq0(dot, 1.0E-6)) {
                ++onCount;
                continue;
            }
            if (dot > 0.0) {
                ++aboveCount;
                continue;
            }
            ++belowCount;
        }
        if (aboveCount == points.length) {
            return PlaneCat.PLANE_ABOVE;
        }
        if (onCount == points.length) {
            return PlaneCat.PLANE_ALIGNED;
        }
        if (belowCount + onCount == points.length) {
            return PlaneCat.PLANE_BELOW;
        }
        return PlaneCat.PLANE_INTERSECTING;
    }

    private static boolean projectAndSubtract(Model floorModel, Point3d[] projectionFace, Plane3d projectionFacePlane, Plane3d projectionPlane, Matrix4d projectToPlaneXform, int wallGroup) {
        int id;
        boolean hasArea;
        ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
        for (int m = 0; m < projectionFace.length; ++m) {
            Point3d p1 = projectionFace[m];
            Point3d p2 = projectionFace[(m + 1) % projectionFace.length];
            LineSeg3D ls = new LineSeg3D(Util3D.xform(projectToPlaneXform, p1), Util3D.xform(projectToPlaneXform, p2));
            curves.add(ls);
        }
        if (!theUtil.eq0(projectionFacePlane.z, 1.0E-6) && (hasArea = GenerateModelFromBIM.addFaceToModel(floorModel, id = 0x7FFFFFFE, projectionPlane, curves))) {
            double areaSubtracted = 0.0;
            ArrayList<Face> wallGroupa = new ArrayList<Face>(floorModel.getFaces(id));
            for (Face subFace : wallGroupa) {
                if (subFace.groups.length > 1) {
                    areaSubtracted += subFace.getArea();
                }
                floorModel.deleteFace(subFace, true, true);
            }
            return theUtil.gt0(areaSubtracted, 1.0E-6);
        }
        Integer id2 = 0x7FFFFFFD;
        GenerateModelFromBIM.addEdgesToModel(floorModel, id2, curves);
        boolean modified = false;
        ArrayList<Edge> delEdges = new ArrayList<Edge>();
        for (Edge e : floorModel.getEdges(id2)) {
            if (!e.faces.isEmpty()) {
                e.removeGroup(id2);
                e.addGroup(wallGroup);
                modified = true;
                continue;
            }
            delEdges.add(e);
        }
        for (Edge e : delEdges) {
            floorModel.deleteEdge(e, true);
        }
        return modified;
    }

    private static boolean addFaceToModel(MerlinData md, IFace face, boolean ccw, Model model, int groupid) {
        return GeomUtil.addFaceToModel(face, ccw, model, groupid, md.simParams.edgeError, md.simParams.faceError);
    }

    private static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> curves) {
        return GeomUtil.addFaceToModel(model, groupid, plane, curves);
    }

    private static void addEdgesToModel(Model model, int groupid, Collection<? extends IParametric3D> curves) {
        model.addEdges(groupid, curves);
    }

    static {
        UI_HOOK_CONTEXT.setShortDesc(Intl.intl("Generates model elements from selected BIM objects (e.g. rooms, doors, stairs)"));
        UI_HOOK_GLOBAL.setShortDesc(Intl.intl("Generates model elements from all imported BIM objects (e.g. rooms, doors, stairs)"));
        MAX_SLOPE = new IPropertySet.Prop<UnitDouble>("MAX_SLOPE", new UnitDouble(45.0, NonSI.DEGREE_ANGLE));
        SLOPE_INCLUSIVE = new IPropertySet.Prop<Boolean>("SLOPE_INCLUSIVE", false);
        SEARCH_OPTIONS = new IPropertySet.Prop<Integer>("SEARCH_OPTIONS", 3);
        HEAD_HEIGHT = new IPropertySet.Prop<UnitDouble>("HEAD_HEIGHT", new UnitDouble(1.8, SI.METER));
        MIN_COMP_WIDTH = new IPropertySet.Prop<UnitDouble>("MIN_COMP_WIDTH", new UnitDouble(0.5, SI.METER));
        CLOSE_GAPS = new IPropertySet.Prop<Boolean>("CLOSE_GAPS", true);
        CLOSE_GAP_TOLERANCE = new IPropertySet.Prop<UnitDouble>("CLOSE_GAP_TOLERANCE", new UnitDouble(0.15, SI.METER));
        NAME_FROM_IMPORTED_GEOM = new IPropertySet.Prop<Boolean>("NAME_FROM_IMPORTED_GEOM", true);
        EXTRACT_STAIRS = new IPropertySet.Prop<Boolean>("EXTRACT_STAIRS", true);
        MAX_STAIR_RISER = new IPropertySet.Prop<UnitDouble>("MAX_STAIR_RISER", new UnitDouble(0.4, SI.METER));
        MAX_STAIR_TREAD_GAP = new IPropertySet.Prop<UnitDouble>("MAX_STAIR_TREAD_GAP", new UnitDouble(0.1, SI.METER));
        EXTRACT_DOORS = new IPropertySet.Prop<Boolean>("EXTRACT_DOORS", true);
        DEL_SMALL_ROOMS = new IPropertySet.Prop<Boolean>("DEL_SMALL_ROOMS", true);
        DEL_ROOMS_IN_SOLIDS = new IPropertySet.Prop<Boolean>("DEL_ROOMS_IN_SOLIDS", true);
        MIN_ROOM_AREA = new IPropertySet.Prop<UnitDouble>("MIN_ROOM_AREA", ((UnitDouble)GenerateModelFromBIM.CLOSE_GAP_TOLERANCE.defVal).multiply((UnitDouble)GenerateModelFromBIM.CLOSE_GAP_TOLERANCE.defVal));
        EXTRACT_ONLY_TOPS_OF_SOLIDS = new IPropertySet.Prop<Boolean>("EXTRACT_ONLY_TOPS_OF_SOLIDS", true);
        GENERATE_OCCUPANTS = new IPropertySet.Prop<Boolean>("GENERATE_OCCUPANTS", true);
        GENERATE_PROFILES = new IPropertySet.Prop<Boolean>("GENERATE_PROFILES", true);
        s_areaComp = new TieBreaker<Double>((o1, o2) -> o1.compareTo((Double)o2));
        timer = new theTimer();
        time = 0.0;
    }

    private static class Progress {
        private final TaskProgress d_progress = new TaskProgress();
        private final int d_totalSteps = 7;
        private int d_step = 0;
        private int d_progressIx = 0;

        public void reset() {
            this.d_step = 0;
            this.d_progress.reset();
        }

        public void resetStep(int max) {
            this.d_progress.setIndeterminate(max == -1);
            if (max != -1) {
                this.d_progress.reset(max);
            }
            this.d_progressIx = 0;
        }

        public void skipStep() {
            this.d_progress.setIndeterminate(false);
            this.d_progress.reset(100);
            this.d_progress.setProgress(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextStep(String msg, int max) {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                ++this.d_step;
                this.d_progress.setMessage(String.format(Intl.intl("Step %d/%d: %s"), this.d_step, 7, msg));
                this.resetStep(max);
            }
        }

        public void increment() throws CancellationException {
            this.increment(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increment(int count) throws CancellationException {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                this.d_progressIx += count;
                this.set(this.d_progressIx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int progress) throws CancellationException {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                if (progress == -1) {
                    this.d_progress.setIndeterminate(true);
                } else {
                    this.d_progress.setIndeterminate(false);
                    this.d_progress.setProgress(progress);
                    this.d_progress.check();
                }
            }
        }
    }

    private static enum PlaneCat {
        PLANE_ABOVE,
        PLANE_BELOW,
        PLANE_INTERSECTING,
        PLANE_ALIGNED;

    }

    private static class DoorInfo {
        public final int edgeId;
        public final boolean facesFound;
        public final boolean geomFromOpening;

        public DoorInfo(int edgeId, boolean facesFound, boolean geomFromOpening) {
            this.edgeId = edgeId;
            this.facesFound = facesFound;
            this.geomFromOpening = geomFromOpening;
        }
    }

    private static class ExtractInfo {
        public final MerlinData md;
        public final ExtractProps eprops;
        public final FaceCache faceCache;
        public int nextid = 100;

        public ExtractInfo(MerlinData md, ExtractProps eprops) {
            this.md = md;
            this.eprops = eprops;
            this.faceCache = new FaceCache(md);
        }

        public int nextId() {
            return this.nextid++;
        }

        public <T> T getProp(IPropertySet.Prop<T> prop) {
            return this.eprops.get(prop);
        }
    }

    private static class StairStep {
        public final Set<Face> faces;
        public final Set<StairStepConnection> connections = new LinkedHashSet<StairStepConnection>();
        private Double d_z = null;

        public StairStep(Set<Face> faces) {
            this.faces = faces;
        }

        public boolean canConnect(StairStepConnection conn) {
            return true;
        }

        public void connect(StairStepConnection conn) {
            this.connections.add(conn);
        }

        private Collection<StairStepConnection> getConnections() {
            return this.connections;
        }

        public double getZLoc() {
            if (this.d_z == null) {
                this.d_z = this.calcZLoc();
            }
            return this.d_z;
        }

        private double calcZLoc() {
            OptionalDouble z = this.faces.stream().filter(f -> theUtil.eq(Math.abs(f.plane.getNormal().z), 1.0, 1.0E-6)).mapToDouble(f -> f.plane.getPointOnPlane().z).max();
            if (z.isPresent()) {
                return z.getAsDouble();
            }
            double totalArea = 0.0;
            double totalWeightedZ = 0.0;
            ArrayList<Point2d> vertsList = new ArrayList<Point2d>();
            ArrayList<Point3d> vertsList3d = new ArrayList<Point3d>();
            for (Face face : this.faces) {
                Collection<Vertex> verts;
                if (face.edgeLoops.isEmpty() || (verts = face.edgeLoops.get(0).getVerts()).isEmpty()) continue;
                vertsList.clear();
                vertsList3d.clear();
                for (Vertex vert : verts) {
                    vertsList.add(new Point2d(vert.loc.x, vert.loc.y));
                    vertsList3d.add(vert.loc);
                }
                Point3d centroid = Util3D.simplePolygonCentroid((Point3d[])theUtil.toArray(vertsList3d));
                if (centroid == null) continue;
                double area = Math.abs(Util2D.simplePolygonArea((Point2d[])theUtil.toArray(vertsList)));
                totalArea += area;
                totalWeightedZ += area * centroid.z;
            }
            if (totalArea != 0.0) {
                return totalWeightedZ / totalArea;
            }
            for (Face face : this.faces) {
                for (FaceLoop loop : face.edgeLoops) {
                    Iterator<EdgeUse> iterator = loop.edges.iterator();
                    if (!iterator.hasNext()) continue;
                    EdgeUse eu = iterator.next();
                    return eu.v1().loc.z;
                }
            }
            return 0.0;
        }

        public void createStairs(ExtractProps eprops, Supplier<String> generateName, Consumer<EgressStair> stairs, Consumer<Face> keepFaces, Consumer<Face> closedFaces, Consumer<Edge> usedEdges) {
            StairStep seedStep = this.findTopStep();
            ArrayDeque<StairStepConnection> open = new ArrayDeque<StairStepConnection>(seedStep.getConnections());
            HashSet<StairStepConnection> closed = new HashSet<StairStepConnection>();
            double overlapLenTol = eprops.minCompWidth;
            ArrayList<StairStep> stairSteps = new ArrayList<StairStep>();
            ArrayList<Edge> stairEdges = new ArrayList<Edge>();
            while (!open.isEmpty()) {
                StairStepConnection step = (StairStepConnection)open.pop();
                if (!closed.add(step)) continue;
                stairSteps.clear();
                stairSteps.add(step.from);
                stairEdges.clear();
                stairEdges.add(step.fromEdge);
                stairEdges.add(step.toEdge);
                Vector3d stairDir = GenerateModelFromBIM.getEdgeNormal(step.toEdge, true);
                ToDoubleFunction<Edge> getT = e -> Util3D.dot(stairDir, e.v1.loc);
                double treadDepth = Double.NaN;
                double riser = GenerateModelFromBIM.getZ(step.toEdge) - GenerateModelFromBIM.getZ(step.fromEdge);
                Edge firstEdge = step.fromEdge;
                double[] firstEdgeTrim = new double[]{0.0, 1.0};
                double overlapTol = overlapLenTol / GenerateModelFromBIM.getWidth(firstEdge);
                while (step.to.connections.size() == 2) {
                    double rise;
                    StairStepConnection child;
                    Iterator<StairStepConnection> connit = step.to.getConnections().iterator();
                    StairStepConnection child1 = connit.next();
                    StairStepConnection child2 = connit.next();
                    StairStepConnection stairStepConnection = child = child1.equals(step) ? child2 : child1;
                    if (closed.contains(child) || !GenerateModelFromBIM.testParallel((Edge)stairEdges.get(0), child.fromEdge)) break;
                    Edge prevEdge = (Edge)stairEdges.get(stairEdges.size() - 1);
                    double[] overlap = GenerateModelFromBIM.getOverlap2dE1(firstEdge, firstEdgeTrim[0], firstEdgeTrim[1], child.fromEdge, 0.0, 1.0);
                    if (Math.abs(overlap[0] - overlap[1]) <= overlapTol || !theUtil.eq(rise = GenerateModelFromBIM.getZ(child.toEdge) - GenerateModelFromBIM.getZ(child.fromEdge), riser, Math.abs(Math.min(rise, riser)) * 0.25)) break;
                    double prevT = getT.applyAsDouble(prevEdge);
                    double currT = getT.applyAsDouble(child.fromEdge);
                    double run = currT - prevT;
                    if (!Double.isNaN(treadDepth) && !theUtil.eq(run, treadDepth, Math.abs(Math.min(run, treadDepth)) * 0.25)) break;
                    firstEdgeTrim = overlap;
                    if (Double.isNaN(treadDepth)) {
                        treadDepth = run;
                    }
                    closed.add(child);
                    stairSteps.add(child.from);
                    stairEdges.add(child.fromEdge);
                    stairEdges.add(child.toEdge);
                    step = child;
                }
                stairSteps.add(step.to);
                this.createStair(stairSteps, stairEdges, stairs, keepFaces, closedFaces, generateName, usedEdges);
                for (StairStepConnection child : step.to.getConnections()) {
                    if (closed.contains(child)) continue;
                    open.push(child);
                }
            }
        }

        private StairStep findTopStep() {
            ToDoubleFunction<Face> getFaceZ = f -> {
                if (theUtil.eq(Math.abs(f.plane.getNormal().dot(GeomConstants.VEC3D_ZPOS)), 1.0, 1.0E-9)) {
                    return f.plane.getPointOnPlane().z;
                }
                int totVerts = 0;
                double z = 0.0;
                for (FaceLoop loop : f.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        z += eu.v1().loc.z;
                        ++totVerts;
                    }
                }
                return z / (double)totVerts;
            };
            ToDoubleFunction<StairStep> getStepZ = step -> {
                double zsum = 0.0;
                double weightsum = 0.0;
                for (Face face : step.faces) {
                    double weight = face.getArea();
                    weightsum += weight;
                    zsum += getFaceZ.applyAsDouble(face) * weight;
                }
                if (weightsum == 0.0) {
                    return zsum;
                }
                return zsum / weightsum;
            };
            ArrayDeque<StairStep> open = new ArrayDeque<StairStep>();
            open.push(this);
            IdentityHashSet closed = new IdentityHashSet();
            closed.add(this);
            double topz = -1.7976931348623157E308;
            StairStep topStep = null;
            while (!open.isEmpty()) {
                StairStep step2 = (StairStep)open.pop();
                double z = getStepZ.applyAsDouble(step2);
                if (z > topz) {
                    topz = z;
                    topStep = step2;
                }
                for (StairStepConnection conn : step2.getConnections()) {
                    if (!closed.add(conn.to)) continue;
                    open.push(conn.to);
                }
            }
            return topStep;
        }

        private void createStair(List<StairStep> steps, List<Edge> edges, Consumer<EgressStair> stairs, Consumer<Face> keepFaces, Consumer<Face> closedFaces, Supplier<String> generateName, Consumer<Edge> usedEdges) {
            LineSeg e2ls;
            double[] zrange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            double[] trange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            ArrayList zlocs = new ArrayList();
            DoubleConsumer addZ = z -> {
                if (z < zrange[0]) {
                    dArray[0] = z;
                }
                if (z > zrange[1]) {
                    dArray[1] = z;
                }
                for (Double zloc : zlocs) {
                    if (!theUtil.eq(z, zloc, 0.001)) continue;
                    return;
                }
                zlocs.add(z);
            };
            Edge firstEdge = edges.get(0);
            double[] e1trim = new double[]{0.0, 1.0};
            addZ.accept(GenerateModelFromBIM.getZ(firstEdge));
            addZ.accept(GenerateModelFromBIM.getZ(edges.get(edges.size() - 1)));
            for (int m = 1; m < steps.size() - 1; ++m) {
                addZ.accept(steps.get(m).getZLoc());
            }
            Vector3d stairDir = GenerateModelFromBIM.getEdgeNormal(edges.get(0), true);
            ToDoubleFunction<Edge> getT = e -> Util3D.dot(stairDir, e.v1.loc);
            for (Edge e2 : edges) {
                double t;
                if (e2 != firstEdge) {
                    e1trim = GenerateModelFromBIM.getOverlap2dE1(firstEdge, e1trim[0], e1trim[1], e2, 0.0, 1.0);
                }
                if ((t = getT.applyAsDouble(e2)) < trange[0]) {
                    trange[0] = t;
                }
                if (!(t > trange[1])) continue;
                trange[1] = t;
            }
            if (zlocs.size() <= 1) {
                return;
            }
            double totalRun = trange[1] - trange[0];
            double totalRise = zrange[1] - zrange[0];
            int nrises = zlocs.size() - 1;
            double rise = nrises == 0 ? 0.0 : totalRise / (double)nrises;
            double run = nrises <= 1 ? 1.6 * rise : totalRun / (double)(nrises - 1);
            Edge stairEdge1 = edges.get(0);
            Edge stairEdge2 = edges.get(edges.size() - 1);
            double[] e2trim = GenerateModelFromBIM.getOverlap2dE1(stairEdge2, 0.0, 1.0, stairEdge1, e1trim[0], e1trim[1]);
            LineSeg e1ls = GenerateModelFromBIM.toLineSeg(stairEdge1);
            Point3d[] boundary = StrutUtil.calcStrutBoundaryFull(e1ls, e2ls = GenerateModelFromBIM.toLineSeg(stairEdge2), e1trim[0], e1trim[1], e2trim[0], e2trim[1]);
            if (boundary == null) {
                return;
            }
            steps.get((int)0).faces.forEach(keepFaces);
            steps.get((int)(steps.size() - 1)).faces.forEach(keepFaces);
            steps.stream().flatMap(step -> step.faces.stream()).forEach(closedFaces);
            String name = generateName.get();
            EgressStair estair = new EgressStair(name, null, null, e1ls, e2ls, new UnitDouble(rise, Geometry.LU), new UnitDouble(run, Geometry.LU), boundary);
            stairs.accept(estair);
            usedEdges.accept(stairEdge1);
            usedEdges.accept(stairEdge2);
        }
    }

    private static class StairStepConnection {
        public final StairStep from;
        public final StairStep to;
        public final Edge fromEdge;
        public final Edge toEdge;

        public StairStepConnection(StairStep from, StairStep to, Edge fromEdge, Edge toEdge) {
            this.from = from;
            this.to = to;
            this.fromEdge = fromEdge;
            this.toEdge = toEdge;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StairStepConnection)) {
                return false;
            }
            StairStepConnection conn = (StairStepConnection)obj;
            return conn.from == this.from && conn.to == this.to && conn.fromEdge == this.fromEdge && conn.toEdge == this.toEdge || conn.from == this.to && conn.to == this.from && conn.fromEdge == this.toEdge && conn.toEdge == this.fromEdge;
        }

        public int hashCode() {
            return 0xAFA983 ^ this.from.hashCode() + this.to.hashCode() + System.identityHashCode(this.fromEdge) + System.identityHashCode(this.toEdge);
        }

        public StairStepConnection reverse() {
            return new StairStepConnection(this.to, this.from, this.toEdge, this.fromEdge);
        }
    }

    private static class GeomFace {
        public final ImportedGeom geom;
        public final int faceix;
        public final IPolygon face;
        public final Elements.Orient orient;

        public GeomFace(ImportedGeom geom, IPolygon face, Elements.Orient orient, int faceix) {
            this.geom = geom;
            this.face = face;
            this.orient = orient;
            this.faceix = faceix;
        }

        public int hashCode() {
            return System.identityHashCode(this.geom) + this.faceix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GeomFace)) {
                return false;
            }
            GeomFace gf = (GeomFace)obj;
            return this.geom == gf.geom && this.faceix == gf.faceix;
        }
    }

    private static class FaceCache {
        private final MerlinData md;
        private final Map<ImportedGeom, Collection<Pair<IPolygon, Elements.Orient>>> cache;
        private final Map<ImportedGeom, Collection<Pair<Triangle, Elements.Orient>>> triCache;

        public FaceCache(MerlinData md) {
            this.md = md;
            this.cache = new IdentityHashMap<ImportedGeom, Collection<Pair<IPolygon, Elements.Orient>>>();
            this.triCache = new IdentityHashMap<ImportedGeom, Collection<Pair<Triangle, Elements.Orient>>>();
        }

        public synchronized Collection<Pair<IPolygon, Elements.Orient>> getFaces(ImportedGeom ig) {
            return this.cache.computeIfAbsent(ig, geom -> {
                IGeomNode fnode = geom.getGeom().flatten();
                IElemSource orients = (IElemSource)((Object)fnode.getLocalElements().get(Elements.ORIENT));
                List<IFace> faces = thunderheadeng.geometry.objs.GeomUtil.explode(fnode.getLocalGeom(), IFace.class);
                ArrayList<Pair<IPolygon, Elements.Orient>> polys = new ArrayList<Pair<IPolygon, Elements.Orient>>(faces.size());
                int ix = 0;
                for (IFace face : faces) {
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(ix)));
                    if (face instanceof IPolygon) {
                        polys.add(new Pair<IPolygon, Elements.Orient>((IPolygon)face, orient));
                        continue;
                    }
                    for (Triangle tri : thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(this.md.simParams.faceError, face)) {
                        polys.add(new Pair<Triangle, Elements.Orient>(tri, orient));
                    }
                }
                return polys;
            });
        }

        public synchronized Collection<Pair<Triangle, Elements.Orient>> getTris(MerlinData md, ImportedGeom ig) {
            return this.triCache.computeIfAbsent(ig, geom -> {
                Collection<Pair<IPolygon, Elements.Orient>> polys = this.getFaces((ImportedGeom)geom);
                if (polys.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList tris = new ArrayList();
                for (Pair<IPolygon, Elements.Orient> poly : polys) {
                    Mesh mesh = ((IPolygon)poly.v1).triangulate(merlinData.simParams.faceError);
                    int m = 0;
                    while (m < mesh.indices.length) {
                        Point3d p1 = mesh.vertices[mesh.indices[m++]];
                        Point3d p2 = mesh.vertices[mesh.indices[m++]];
                        Point3d p3 = mesh.vertices[mesh.indices[m++]];
                        tris.add(new Pair(new Triangle(p1, p2, p3), poly.v2));
                    }
                }
                return tris;
            });
        }
    }

    private static class Locator<T extends IDisplayableGeomSrc> {
        public AABoxTest test = new AABoxTest(new AABox(), 1.0E-6);
        public final CollResult<IDisplayableGeomSrc, T> result;

        public Locator(Class<T> clazz, Predicate<T> filter) {
            this.result = new CollResult(clazz, filter);
        }

        private void reset(AABox testBox) {
            this.test = new AABoxTest(testBox, 1.0E-6);
            this.result.coll.clear();
        }

        public Collection<T> getResult() {
            return this.result.coll;
        }
    }

    private static class GenerateOccupantsResults {
        public List<Pair<OccGenerator, String>> generatedOccs = Collections.emptyList();
        public Behavior generatedBehavior = null;

        private GenerateOccupantsResults() {
        }
    }

    private static class ExtractResults {
        public Collection<? extends IEgressComp> newObjs = Collections.emptyList();
        public Collection<OccProfile> requestedProfiles = Collections.emptyList();
        public List<Pair<Collection<EgressRoom>, IOccCount>> requestedOccs = Collections.emptyList();
        public IDistributedVal<UnitDouble> preEvacTime = null;

        private ExtractResults() {
        }
    }

    private static class ExtractException
    extends Exception {
        private static final long serialVersionUID = 7371118916953033117L;
        public final Type type;

        public ExtractException(Type type) {
            super(type.msg);
            this.type = type;
        }

        public static enum Type {
            NO_VALID_FACES(Intl.intl("There was no geometry matching the specified criteria."));

            public final String msg;

            private Type(String msg) {
                this.msg = msg;
            }
        }
    }

    public static class ExtractProps {
        public final IPropertySet props;
        public final double maxSlopeRad;
        public final boolean slopeInclusive;
        public final int searchOptions;
        public final double headHeight;
        public final double minCompWidth;
        public final double closeGapSize;
        public final boolean nameFromImportedGeom;
        public final double maxStairRiser;
        public final double maxStairTreadGap;
        public final double minRoomArea;

        ExtractProps(IPropertySet props) {
            this.props = props;
            this.maxSlopeRad = this.get(MAX_SLOPE).get(SI.RADIAN);
            this.slopeInclusive = this.get(SLOPE_INCLUSIVE);
            this.searchOptions = this.get(SEARCH_OPTIONS);
            this.headHeight = this.get(HEAD_HEIGHT).get(Geometry.LU);
            this.minCompWidth = this.get(MIN_COMP_WIDTH).get(Geometry.LU);
            this.closeGapSize = this.get(CLOSE_GAP_TOLERANCE).get(Geometry.LU);
            this.nameFromImportedGeom = this.get(NAME_FROM_IMPORTED_GEOM);
            this.maxStairRiser = this.get(MAX_STAIR_RISER).get(Geometry.LU);
            this.maxStairTreadGap = this.get(MAX_STAIR_TREAD_GAP).get(Geometry.LU);
            this.minRoomArea = this.get(MIN_ROOM_AREA).get(Geometry.LU.pow(2));
        }

        public <T> T get(IPropertySet.Prop<T> prop) {
            return this.props.get(prop);
        }
    }
}

