/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.CloseGapsAction;
import merlin.actions.NavMeshGen;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TieBreaker;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class ExtractFloor3DV2
extends AMerlinOp {
    private final TaskProgress d_progress = new TaskProgress();
    private ImportedGeom d_pickGeom = null;
    private Point3d d_pickLoc = null;
    private double d_maxSlopeRad = 1.4835298641951802;
    private boolean d_slopeInclusive = false;
    private boolean d_searchHidden = true;
    private double d_headHeight = 1.8;
    private double d_closeGapSize = 0.0;
    private static final Comparator<Double> s_areaComp = new TieBreaker<Double>((o1, o2) -> o1.compareTo((Double)o2));
    static theTimer timer = new theTimer();
    static double time = 0.0;

    public ExtractFloor3DV2(ImportedGeom pickGeom, Point3d pickLoc, double maxSlopeRad, double maxHeadHeight, double closeGapSize) {
        this.d_pickGeom = pickGeom;
        this.d_pickLoc = pickLoc;
        this.d_maxSlopeRad = maxSlopeRad;
        this.d_headHeight = maxHeadHeight;
        this.d_closeGapSize = closeGapSize;
    }

    protected TaskProgress getProgress() {
        return this.d_progress;
    }

    protected void checkCancelled() throws CancelledException {
        if (!this.d_progress.isRunning()) {
            throw CancelledException.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (this.d_pickGeom == null || this.d_pickLoc == null) {
            return;
        }
        theTimer timer = new theTimer();
        this.d_progress.reset();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Extracting Room"), true, this.d_progress);
        pm.begin();
        try {
            this.extractFloor(app, md, this.d_pickGeom, this.d_pickLoc);
        }
        catch (ExtractException e) {
            pm.end();
            JOptionPane.showMessageDialog(app.getActiveFrame(), e.getLocalizedMessage(), Intl.intl("Error Extracting Room"), 0);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            pm.end();
        }
        System.out.println("Elapsed: " + timer.curr());
        System.out.println("Test time: " + time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFloor(MerlinApp app, MerlinData md, ImportedGeom pickGeom, Point3d loc) throws ExtractException, CancelledException {
        Composite<ICompElement> geoms;
        md.beginRead();
        try {
            geoms = this.findFloor(md, this.d_maxSlopeRad, this.d_slopeInclusive, this.d_headHeight, this.d_searchHidden, pickGeom, loc).getDebugObjects(md);
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Extract Room"));
            Undo.insertUndoEntry_delete(md, md.sceneGeom, geoms);
            md.sceneGeom.add(geoms);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private Model closeGaps(Model model, Point3d pickPoint) {
        Model closedModel = CloseGapsAction.closeGaps(model, this.d_closeGapSize);
        if (closedModel == model) {
            return model;
        }
        Face seedFace = closedModel.findFace(pickPoint);
        if (seedFace == null) {
            return model;
        }
        LinkedIdentityHashSet closed = new LinkedIdentityHashSet();
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.push(seedFace);
        closed.add(seedFace);
        while (!open.isEmpty()) {
            Face face = (Face)open.pop();
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face adjFace : eu.edge.faces) {
                        if (!closed.add(adjFace)) continue;
                        open.push(adjFace);
                    }
                }
            }
        }
        Model result = new Model();
        for (Face face : closed) {
            result.addFace(face);
        }
        return result;
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(Integer.MAX_VALUE) && !edge.faces.isEmpty() || !edge.partOfGroup(Integer.MAX_VALUE) && edge.faces.size() == 1;
    }

    private static Collection<Edge> getBoundaryEdges(Model model) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : model.getEdges()) {
            if (!ExtractFloor3DV2.isBoundaryEdge(edge)) continue;
            edges.add(edge);
        }
        return edges;
    }

    private static Collection<IPolygon> getFaces(MerlinData md, ImportedGeom geom) {
        List<IFace> faces = thunderheadeng.geometry.objs.GeomUtil.explode(geom.getGeom().flatten().getLocalGeom(), IFace.class);
        ArrayList<IPolygon> polys = new ArrayList<IPolygon>(faces.size());
        for (IFace face : faces) {
            if (face instanceof IPolygon) {
                polys.add((IPolygon)face);
                continue;
            }
            polys.addAll(thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(md.simParams.faceError, face));
        }
        return polys;
    }

    private FaceExtraction extractFaces(MerlinApp app, MerlinData md, Map<ImportedGeom, Collection<IFace>> geomFaceMap) throws CancelledException {
        long tbegin = System.nanoTime();
        ArrayList<Collection<IFace>> geomGroups = new ArrayList<Collection<IFace>>();
        LinkedIdentityHashMap<ImportedGeom, Integer> geomIdMap = new LinkedIdentityHashMap<ImportedGeom, Integer>();
        int faceCount = 0;
        for (Map.Entry<ImportedGeom, Collection<IFace>> entry : geomFaceMap.entrySet()) {
            ImportedGeom geom = entry.getKey();
            Collection<IFace> faces = entry.getValue();
            faceCount += faces.size();
            int groupid = geomGroups.size();
            geomGroups.add(faces);
            geomIdMap.put(geom, groupid);
        }
        this.getProgress().setMax(faceCount);
        this.getProgress().setProgress(0);
        Model model = new Model();
        int faceix = 1;
        for (int m = 0; m < geomGroups.size(); ++m) {
            for (IFace face : (Collection)geomGroups.get(m)) {
                this.checkCancelled();
                this.getProgress().setProgress(faceix++);
                ExtractFloor3DV2.addFaceToModel(md, face, model, m);
            }
        }
        this.checkCancelled();
        this.getProgress().setIndeterminate(true);
        long tend = System.nanoTime();
        System.out.printf("Face extraction took %g seconds.%n", (double)(tend - tbegin) * 1.0E-9);
        System.out.println("added " + faceCount + " faces");
        System.out.println("resulted in " + model.getFaces().size() + " faces");
        return new FaceExtraction(geomIdMap, model);
    }

    private static Face findPickFace(Model model, int pickGroup, Point3d pickLoc) {
        List<Face> foundFaces = model.findFaces(new AABox(pickLoc));
        Face nearestFace = null;
        double nearestFaceDistSq = Double.MAX_VALUE;
        for (Face foundFace : foundFaces) {
            double distsq;
            Point3d pointInFace;
            if (!foundFace.partOfGroup(pickGroup) || !Model.compare(pickLoc, pointInFace = foundFace.plane.projectOntoPlane(pickLoc)) || (distsq = pickLoc.distanceSquared(pointInFace)) >= nearestFaceDistSq) continue;
            Model.FaceClassify fc = model.testPointOnFace(foundFace, pointInFace);
            if (fc.outside) continue;
            nearestFaceDistSq = distsq;
            nearestFace = foundFace;
        }
        return nearestFace;
    }

    private static GeomFace findPickFace(MerlinData md, ImportedGeom geom, Point3d pickLoc) {
        Collection<IPolygon> faces = ExtractFloor3DV2.getFaces(md, geom);
        Iterator<IPolygon> fit = faces.iterator();
        int ix = 0;
        while (fit.hasNext()) {
            IPolygon face = fit.next();
            Plane3d plane = face.getPlane(true);
            Point3d projp = plane.projectOntoPlane(pickLoc);
            if (projp.distanceSquared(pickLoc) < 1.0E-12 && face.classify((Point3d)projp, (double)1.0E-6).positive) {
                return new GeomFace(geom, face, ix);
            }
            ++ix;
        }
        return null;
    }

    private static Set<Face> getNeighborFaces(Face face, int id, int wallGroup) {
        LinkedIdentityHashSet<Face> adj = new LinkedIdentityHashSet<Face>();
        for (FaceLoop loop : face.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (eu.edge.partOfGroup(wallGroup)) continue;
                for (Face edgeFace : eu.edge.faces) {
                    if (edgeFace.partOfGroup(id)) continue;
                    adj.add(edgeFace);
                }
            }
        }
        return adj;
    }

    private static FaceUse refindFace(Model floorModel, FaceUse currfu, int fid) {
        if (!floorModel.getFaces().contains(currfu.face) || !currfu.face.partOfGroup(fid)) {
            Model.Group adjustedFaces = floorModel.getGroup(fid, true, false, false);
            if (adjustedFaces.faces.isEmpty()) {
                System.err.println("[239fd] Lost face during floor extraction.");
                return null;
            }
            currfu = new FaceUse(adjustedFaces.faces.iterator().next(), currfu.positive);
        }
        return currfu;
    }

    private static Vector3d getNormal(IPlanarFace face, boolean orient) {
        Vector3d normal = face.getPlane(true).getNormal();
        if (!orient) {
            normal.negate();
        }
        return normal;
    }

    private static double getFaceSlopeRad(IPlanarFace face, boolean orient) {
        Vector3d normal = ExtractFloor3DV2.getNormal(face, orient);
        return ExtractFloor3DV2.getSlopeRad(normal);
    }

    private void beginTask(theTimer timer, int estimate, String format, Object ... args) {
        String msg = String.format(format, args);
        System.out.print(msg + "...");
        System.out.flush();
        timer.reset();
        this.d_progress.setMessage(msg);
        this.d_progress.reset(estimate);
    }

    private void setTaskProgress(int progress) throws CancelledException {
        this.d_progress.setProgress(progress);
        this.checkCancelled();
    }

    private void endTask(theTimer timer) {
        System.out.printf("done (%g s)%n", timer.curr());
        System.out.flush();
    }

    private NavMeshGen.Result findFloor(MerlinData md, double maxFloorSlopeRad, boolean slopeInclusive, double headHeight, boolean searchInvisible, ImportedGeom geom, Point3d pickLoc) throws CancelledException {
        theTimer timer = new theTimer();
        NavMeshGen nmGen = new NavMeshGen();
        double maxSlope = !slopeInclusive ? maxFloorSlopeRad - 1.0E-6 : maxFloorSlopeRad;
        Function<IPolygon, NavMeshGen.TriType> getTriType = face -> {
            Plane3d plane = face.getPlane(true);
            double slope = ExtractFloor3DV2.getSlopeRad(plane.getNormal());
            if (slope < maxSlope || Math.PI - slope < maxSlope) {
                return NavMeshGen.TriType.BOTH;
            }
            return NavMeshGen.TriType.OBSTRUCTION;
        };
        this.beginTask(timer, md.sceneGeom.getDeepMembers(ImportedGeom.class).size(), "Gathering tris", new Object[0]);
        int progress = 0;
        int numTris = 0;
        for (ImportedGeom ig : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
            if (ig.isIgnoredInModelGeneration()) continue;
            this.setTaskProgress(progress++);
            for (IFace face2 : thunderheadeng.geometry.objs.GeomUtil.explode(ig.getGeom().flatten().getLocalGeom(), IFace.class)) {
                Mesh mesh = face2.triangulate(md.simParams.faceError);
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    NavMeshGen.TriType type = getTriType.apply(PolyUtil.newPoly(p1, p2, p3));
                    nmGen.addTri(type, p1, p2, p3);
                }
                numTris += mesh.indices.length / 3;
            }
        }
        this.endTask(timer);
        System.out.printf("Found %d tris%n", numTris);
        this.beginTask(timer, 1, "Extracting", new Object[0]);
        NavMeshGen.Result nresult = nmGen.buildNavMesh(this.d_progress, headHeight);
        this.endTask(timer);
        return nresult;
    }

    private Model findFloor_legacy(MerlinData md, double maxFloorSlopeRad, boolean slopeInclusive, double headHeight, int options, ImportedGeom geom, Point3d pickLoc) throws ExtractException, CancelledException {
        GeomFace pickFace;
        if (!slopeInclusive) {
            maxFloorSlopeRad -= 1.0E-6;
        }
        if ((pickFace = ExtractFloor3DV2.findPickFace(md, geom, pickLoc)) == null) {
            throw new ExtractException(ExtractException.Type.FAILED);
        }
        double slope = ExtractFloor3DV2.getSlopeRad(pickFace.face.getNormal(true));
        if (slope >= maxFloorSlopeRad && Math.PI - slope >= maxFloorSlopeRad) {
            throw new ExtractException(ExtractException.Type.INVALIDSLOPE);
        }
        Vector3d extrudeDir = new Vector3d(0.0, 0.0, headHeight);
        Locator<ImportedGeom> geomFinder = new Locator<ImportedGeom>(ImportedGeom.class, o -> !o.isIgnoredInModelGeneration());
        int id = 0;
        int uninitGroup = id++;
        int splitGroup = id++;
        int subtractedGroup = id++;
        int closedGroup = id++;
        int includeGroup = id++;
        int beginGroup = id++;
        int faceID = id++;
        int wallGroup = Integer.MAX_VALUE;
        Model floorModel = new Model();
        IdentityHashSet<ImportedGeom> closedGeom = new IdentityHashSet<ImportedGeom>();
        for (IPolygon face : ExtractFloor3DV2.getFaces(md, geom)) {
            ExtractFloor3DV2.addFaceToModel(md, face, floorModel, beginGroup);
        }
        closedGeom.add(geom);
        Face beginFace = ExtractFloor3DV2.findPickFace(floorModel, beginGroup, pickLoc);
        if (beginFace == null) {
            throw new ExtractException(ExtractException.Type.FAILED);
        }
        this.intersectFaces(md, floorModel, beginFace, geomFinder, closedGeom, options, maxFloorSlopeRad, uninitGroup, splitGroup);
        beginFace = ExtractFloor3DV2.findPickFace(floorModel, beginGroup, pickLoc);
        if (beginFace == null) {
            throw new ExtractException(ExtractException.Type.FAILED);
        }
        this.subtractObstructions(md, floorModel, beginFace, geomFinder, extrudeDir, options, subtractedGroup, Integer.MAX_VALUE);
        beginFace = ExtractFloor3DV2.findPickFace(floorModel, beginGroup, pickLoc);
        if (beginFace == null) {
            throw new ExtractException(ExtractException.Type.NOT_ENOUGH_HEAD_ROOM);
        }
        Stack<FaceUse> open = new Stack<FaceUse>();
        double beginSlope = ExtractFloor3DV2.getFaceSlopeRad(beginFace, true);
        if (beginSlope < maxFloorSlopeRad) {
            open.push(new FaceUse(beginFace, true));
        } else if (Math.PI - beginSlope < maxFloorSlopeRad) {
            open.push(new FaceUse(beginFace, false));
        } else {
            throw new ExtractException(ExtractException.Type.INVALIDSLOPE);
        }
        beginFace.addGroup(closedGroup);
        while (!open.isEmpty()) {
            this.checkCancelled();
            FaceUse currfu = (FaceUse)open.pop();
            currfu.face.addGroup(includeGroup);
            int fid = faceID++;
            currfu.face.addGroup(fid);
            Set<Face> adjToSplit = ExtractFloor3DV2.getNeighborFaces(currfu.face, splitGroup, Integer.MAX_VALUE);
            for (Face adjFace : adjToSplit) {
                this.intersectFaces(md, floorModel, adjFace, geomFinder, closedGeom, options, maxFloorSlopeRad, uninitGroup, splitGroup);
                this.checkCancelled();
            }
            if ((currfu = ExtractFloor3DV2.refindFace(floorModel, currfu, fid)) == null) continue;
            Set<Face> adjToSubtract = ExtractFloor3DV2.getNeighborFaces(currfu.face, subtractedGroup, Integer.MAX_VALUE);
            for (Face adjFace : adjToSubtract) {
                this.subtractObstructions(md, floorModel, adjFace, geomFinder, extrudeDir, options, subtractedGroup, Integer.MAX_VALUE);
                this.checkCancelled();
            }
            if ((currfu = ExtractFloor3DV2.refindFace(floorModel, currfu, fid)) == null) continue;
            for (FaceLoop loop : currfu.face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    FaceUse adjfu;
                    if (eu.edge.partOfGroup(Integer.MAX_VALUE) || (adjfu = ExtractFloor3DV2.getAdjacentFace(currfu, eu)) == null || adjfu.face.partOfGroup(closedGroup)) continue;
                    adjfu.face.addGroup(closedGroup);
                    if (!(ExtractFloor3DV2.getFaceSlopeRad(adjfu.face, adjfu.positive) < maxFloorSlopeRad)) continue;
                    open.push(adjfu);
                }
            }
        }
        ArrayList<Face> allFaces = new ArrayList<Face>(floorModel.getFaces());
        for (Face face : allFaces) {
            if (face.partOfGroup(includeGroup)) continue;
            floorModel.deleteFace(face, true, true);
        }
        return floorModel;
    }

    private static FaceUse getAdjacentFace(FaceUse fu, EdgeUse eu) {
        Vector3d normal = ExtractFloor3DV2.getNormal(fu.face, fu.positive);
        Vector3d edgeDir = fu.localEu(eu).getTangent(0.5);
        double minAngle = Double.MAX_VALUE;
        FaceUse nextfu = null;
        for (Face adjFace : eu.edge.faces) {
            List<EdgeUse> adjeus = ExtractFloor3DV2.getEdgeUses(adjFace, eu.edge);
            assert (!adjeus.isEmpty());
            for (EdgeUse adjeu : adjeus) {
                if (adjFace == fu.face && adjeu.orient == eu.orient) continue;
                boolean bl = eu.orient == adjeu.orient ? !fu.positive : fu.positive;
                boolean adjOrient = bl;
                Vector3d nextNormal = ExtractFloor3DV2.getNormal(adjFace, adjOrient);
                double angle = Util3D.angle(normal, nextNormal, edgeDir);
                if (!(angle < minAngle)) continue;
                minAngle = angle;
                nextfu = new FaceUse(adjFace, adjOrient);
            }
        }
        return nextfu;
    }

    private static List<EdgeUse> getEdgeUses(Face face, Edge edge) {
        ArrayList<EdgeUse> eus = new ArrayList<EdgeUse>(2);
        for (FaceLoop loop : face.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (eu.edge != edge) continue;
                eus.add(eu);
            }
        }
        return eus;
    }

    private static Vector3d getNormal(Face face, boolean orient) {
        Vector3d normal = face.plane.getNormal();
        if (!orient) {
            normal.negate();
        }
        return normal;
    }

    private static double getFaceSlopeRad(Face face, boolean orient) {
        Vector3d normal = ExtractFloor3DV2.getNormal(face, orient);
        return ExtractFloor3DV2.getSlopeRad(normal);
    }

    private static double getSlopeRad(Vector3d normal) {
        double slope = 1.5707963267948966 - Math.atan2(normal.z, Math.sqrt(normal.x * normal.x + normal.y * normal.y));
        return slope;
    }

    private void intersectFaces(MerlinData md, Model floorModel, Face face, Locator<ImportedGeom> geomFinder, Set<ImportedGeom> closedGeoms, int options, double maxSlopeRad, int unintID, int intersectedGroup) throws CancelledException {
        face.addGroup(intersectedGroup);
        AABox bounds = face.getBounds();
        ((Locator)geomFinder).reset(bounds);
        md.geomLocation.getLocator().find((ITest<AABox>)geomFinder.test, geomFinder.result, options);
        if (geomFinder.getResult().isEmpty()) {
            return;
        }
        Point3d[] fverts = ExtractFloor3DV2.getOuterVerts(face);
        NavigableMap sortedFaces = new TreeMap(s_areaComp);
        for (ImportedGeom geom : geomFinder.getResult()) {
            AABox facebb;
            Point3d[] verts;
            PlaneCat bbcat;
            this.checkCancelled();
            if (closedGeoms.contains(geom) || (bbcat = ExtractFloor3DV2.categorizePointsForIsect(face.plane, verts = (facebb = geom.getBounds()).getVerts())).equals((Object)PlaneCat.PLANE_ABOVE) || bbcat.equals((Object)PlaneCat.PLANE_BELOW)) continue;
            Collection<IPolygon> faces = ExtractFloor3DV2.getFaces(md, geom);
            boolean addFaces = false;
            ArrayList<IPolygon> validFaces = new ArrayList<IPolygon>(faces.size());
            for (IPolygon nface : faces) {
                this.checkCancelled();
                Plane3d nplane = nface.getPlane(true);
                double slope = ExtractFloor3DV2.getSlopeRad(nplane.getNormal());
                if (slope >= maxSlopeRad && Math.PI - slope >= maxSlopeRad) continue;
                validFaces.add(nface);
                addFaces = addFaces || ExtractFloor3DV2.maybeIntersects(fverts, face.plane, ExtractFloor3DV2.getVerts(nface, false), nplane);
            }
            if (!addFaces) continue;
            Double area = facebb.getWidth() * facebb.getDepth();
            sortedFaces.put(area, validFaces);
            closedGeoms.add(geom);
        }
        sortedFaces = sortedFaces.descendingMap();
        for (Collection faces : sortedFaces.values()) {
            for (IPolygon nface : faces) {
                this.checkCancelled();
                ExtractFloor3DV2.addFaceToModel(md, nface, floorModel, unintID);
            }
        }
    }

    private static boolean maybeIntersects(Point3d[] face1, Plane3d plane1, Point3d[] face2, Plane3d plane2) {
        PlaneCat f1cat = ExtractFloor3DV2.categorizePointsForIsect(plane2, face1);
        if (f1cat.equals((Object)PlaneCat.PLANE_ABOVE) || f1cat.equals((Object)PlaneCat.PLANE_BELOW)) {
            return false;
        }
        PlaneCat f2cat = ExtractFloor3DV2.categorizePointsForIsect(plane1, face2);
        return !f2cat.equals((Object)PlaneCat.PLANE_ABOVE) && !f2cat.equals((Object)PlaneCat.PLANE_BELOW);
    }

    private void subtractObstructions(MerlinData md, Model floorModel, Face face, Locator<ImportedGeom> geomFinder, Vector3d extrudeDir, int options, int subtractedGroup, int wallGroup) throws CancelledException {
        face.addGroup(subtractedGroup);
        AABox extrudedBounds = face.getBounds();
        extrudedBounds = new AABox(extrudedBounds.getMin(), Util3D.add(extrudedBounds.getMax(), (Tuple3d)extrudeDir));
        ((Locator)geomFinder).reset(extrudedBounds);
        md.geomLocation.getLocator().find((ITest<AABox>)geomFinder.test, geomFinder.result, options);
        if (geomFinder.getResult().isEmpty()) {
            return;
        }
        NavigableMap<Double, Pair<ImportedGeom, AABox>> overhangFaces = new TreeMap(s_areaComp);
        for (ImportedGeom potGeom : geomFinder.getResult()) {
            this.checkCancelled();
            AABox bb = potGeom.getBounds();
            double area = bb.getWidth() * bb.getDepth();
            overhangFaces.put(area, new Pair<ImportedGeom, AABox>(potGeom, bb));
        }
        overhangFaces = overhangFaces.descendingMap();
        Plane3d bplane = face.plane;
        if (bplane.z < 0.0) {
            bplane = bplane.negate();
        }
        Matrix4d xform = Util.translateMat(extrudeDir.x, extrudeDir.y, extrudeDir.z);
        Plane3d tplane = bplane.transformBy(xform);
        Model newFaceModel = new Model();
        newFaceModel.addFace(face);
        Plane3d floorPlane = face.plane;
        double iz = 1.0 / floorPlane.z;
        Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -floorPlane.x * iz, -floorPlane.y * iz, 0.0, -floorPlane.w * iz, 0.0, 0.0, 0.0, 1.0);
        boolean modified = false;
        AABox facebb = new AABox();
        for (Pair potGeom : overhangFaces.values()) {
            PlaneCat tcat;
            this.checkCancelled();
            AABox bb = (AABox)potGeom.v2;
            Point3d[] points = bb.getVerts();
            PlaneCat bcat = ExtractFloor3DV2.categorizePointsForSubtract(bplane, points);
            if (bcat.equals((Object)PlaneCat.PLANE_BELOW) || bcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (tcat = ExtractFloor3DV2.categorizePointsForSubtract(tplane, points)).equals((Object)PlaneCat.PLANE_ABOVE) || tcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
            Collection<IPolygon> gfaces = ExtractFloor3DV2.getFaces(md, (ImportedGeom)potGeom.v1);
            if (bcat.equals((Object)PlaneCat.PLANE_ABOVE) && tcat.equals((Object)PlaneCat.PLANE_BELOW)) {
                for (IPolygon gface : gfaces) {
                    this.checkCancelled();
                    gface.getBoundingBox(facebb);
                    if (!extrudedBounds.intersects(facebb, 1.0E-6)) continue;
                    Point3d[] verts = ExtractFloor3DV2.getVerts(gface, false);
                    modified |= ExtractFloor3DV2.projectAndSubtract(newFaceModel, verts, gface.getPlane(true), face.plane, projectionXform, wallGroup);
                    if (!newFaceModel.getFaces().isEmpty()) continue;
                    break;
                }
            } else {
                Object activeFaces = new ArrayList<IPolygon>(2);
                ArrayList<IPolygon> clipFaces = new ArrayList(2);
                for (IPolygon gface : gfaces) {
                    ArrayList<IPolygon> temp;
                    IPolygon poly;
                    PlaneCat ftcat;
                    Point3d[] verts;
                    PlaneCat fbcat;
                    this.checkCancelled();
                    facebb.reset();
                    gface.getBoundingBox(facebb);
                    if (!extrudedBounds.intersects(facebb, 1.0E-6) || (fbcat = ExtractFloor3DV2.categorizePointsForSubtract(bplane, verts = ExtractFloor3DV2.getVerts(gface, false))).equals((Object)PlaneCat.PLANE_BELOW) || fbcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (ftcat = ExtractFloor3DV2.categorizePointsForSubtract(tplane, verts)).equals((Object)PlaneCat.PLANE_ABOVE) || ftcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
                    activeFaces.clear();
                    activeFaces.add(gface);
                    if (fbcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                        clipFaces.clear();
                        Iterator iterator = activeFaces.iterator();
                        while (iterator.hasNext()) {
                            poly = (IPolygon)iterator.next();
                            ExtractFloor3DV2.clipFace(poly, bplane, true, (Collection<IPolygon>)clipFaces);
                        }
                        temp = activeFaces;
                        activeFaces = clipFaces;
                        clipFaces = temp;
                    }
                    if (ftcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                        clipFaces.clear();
                        temp = activeFaces.iterator();
                        while (temp.hasNext()) {
                            poly = (IPolygon)temp.next();
                            ExtractFloor3DV2.clipFace(poly, tplane, false, clipFaces);
                        }
                        temp = activeFaces;
                        activeFaces = clipFaces;
                        clipFaces = temp;
                    }
                    Plane3d gfacePlane = gface.getPlane(true);
                    Iterator iterator = activeFaces.iterator();
                    while (iterator.hasNext()) {
                        IPolygon poly2 = (IPolygon)iterator.next();
                        modified |= ExtractFloor3DV2.projectAndSubtract(newFaceModel, ExtractFloor3DV2.getVerts(poly2, false), gfacePlane, face.plane, projectionXform, wallGroup);
                    }
                    if (!newFaceModel.getFaces().isEmpty()) continue;
                    break;
                }
            }
            if (!newFaceModel.getFaces().isEmpty()) continue;
            break;
        }
        if (modified) {
            floorModel.deleteFace(face, true, true);
            for (Face newFace : newFaceModel.getFaces()) {
                floorModel.addFace(newFace);
            }
        }
        this.checkCancelled();
    }

    private static Point3d[] getOuterVerts(Face face) {
        FaceLoop outerLoop = face.outerLoop();
        if (outerLoop == null) {
            return new Point3d[0];
        }
        ArrayList<Point3d> verts = new ArrayList<Point3d>(outerLoop.edges.size());
        for (EdgeUse eu : outerLoop.edges) {
            verts.add(eu.v1().loc);
        }
        return verts.toArray(new Point3d[verts.size()]);
    }

    private static Point3d[] getVerts(IPolygon face, boolean copy) {
        return PolyUtil.getAllVerts(face, copy);
    }

    private static void clipFace(IPolygon poly, Plane3d plane, boolean keepAbove, Collection<IPolygon> resultPolys) {
        if (!ExtractFloor3DV2.isConvex(poly)) {
            List<Triangle> tris = thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(0.0, poly);
            for (Triangle tri : tris) {
                ExtractFloor3DV2.clipFace(tri, plane, keepAbove, resultPolys);
            }
            return;
        }
        assert (poly.getNumLoops() == 1);
        int numPoints = poly.getNumPoints(0);
        ArrayList<Point3d> tempList = new ArrayList<Point3d>(numPoints);
        for (int m = 0; m < numPoints; ++m) {
            Point3d intersection;
            Point3d p1 = poly.getPoint(0, m);
            Point3d p2 = poly.getPoint(0, (m + 1) % numPoints);
            boolean p1Pos = theUtil.ge0(plane.dot(p1), 1.0E-6);
            boolean p2Pos = theUtil.ge0(plane.dot(p2), 1.0E-6);
            if (p1Pos == keepAbove) {
                tempList.add(p1);
            }
            if (p1Pos == p2Pos || (intersection = Inter3D.lineSegPlaneIntersection(p1, p2, plane, 0.0)) == null) continue;
            tempList.add(intersection);
        }
        if (tempList.size() > 2) {
            resultPolys.add(PolyUtil.newPoly(tempList.toArray(new Point3d[tempList.size()])));
        }
    }

    private static boolean isConvex(IPolygon poly) {
        if (poly.getNumLoops() > 1) {
            return false;
        }
        Point3d[] verts = PolyUtil.getAllVerts(poly, false);
        return verts.length == 3 || Util3D.isConvex(1.0E-6, verts);
    }

    private static PlaneCat categorizePointsForSubtract(Plane3d plane, Point3d ... points) {
        int aboveCount = 0;
        int belowCount = 0;
        int onCount = 0;
        for (Point3d p : points) {
            double dot = plane.dot(p);
            if (theUtil.eq0(dot, 1.0E-6)) {
                ++onCount;
                continue;
            }
            if (dot > 0.0) {
                ++aboveCount;
                continue;
            }
            ++belowCount;
        }
        if (aboveCount == points.length) {
            return PlaneCat.PLANE_ABOVE;
        }
        if (onCount == points.length) {
            return PlaneCat.PLANE_ALIGNED;
        }
        if (belowCount + onCount == points.length) {
            return PlaneCat.PLANE_BELOW;
        }
        return PlaneCat.PLANE_INTERSECTING;
    }

    private static PlaneCat categorizePointsForIsect(Plane3d plane, Point3d ... points) {
        int aboveCount = 0;
        int belowCount = 0;
        int onCount = 0;
        for (Point3d p : points) {
            double dot = plane.dot(p);
            if (theUtil.eq0(dot, 1.0E-6)) {
                ++onCount;
                continue;
            }
            if (dot > 0.0) {
                ++aboveCount;
                continue;
            }
            ++belowCount;
        }
        if (aboveCount == points.length) {
            return PlaneCat.PLANE_ABOVE;
        }
        if (belowCount == points.length) {
            return PlaneCat.PLANE_BELOW;
        }
        if (onCount == points.length) {
            return PlaneCat.PLANE_ALIGNED;
        }
        return PlaneCat.PLANE_INTERSECTING;
    }

    private static boolean contains(int[] arr, int val) {
        for (int m = 0; m < arr.length; ++m) {
            if (arr[m] != val) continue;
            return true;
        }
        return false;
    }

    private static boolean projectAndSubtract(Model floorModel, Point3d[] projectionFace, Plane3d projectionFacePlane, Plane3d projectionPlane, Matrix4d projectToPlaneXform, int wallGroup) {
        int id;
        boolean hasArea;
        ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
        for (int m = 0; m < projectionFace.length; ++m) {
            Point3d p1 = projectionFace[m];
            Point3d p2 = projectionFace[(m + 1) % projectionFace.length];
            LineSeg3D ls = new LineSeg3D(Util3D.xform(projectToPlaneXform, p1), Util3D.xform(projectToPlaneXform, p2));
            curves.add(ls);
        }
        if (!theUtil.eq0(projectionFacePlane.z, 1.0E-6) && (hasArea = ExtractFloor3DV2.addFaceToModel(floorModel, id = 0x7FFFFFFE, projectionPlane, curves))) {
            double areaSubtracted = 0.0;
            Model.Group wallGroupa = floorModel.getGroup(id, true, false, false);
            for (Face subFace : wallGroupa.faces) {
                if (subFace.groups.length > 1) {
                    areaSubtracted += subFace.getArea();
                }
                floorModel.deleteFace(subFace, true, true);
            }
            return theUtil.gt0(areaSubtracted, 1.0E-6);
        }
        Integer id2 = 0x7FFFFFFD;
        ExtractFloor3DV2.addEdgesToModel(floorModel, id2, curves);
        boolean modified = false;
        int[] bound = new int[]{wallGroup};
        for (Edge e : floorModel.getGroup((int)id2.intValue(), (boolean)false, (boolean)true, (boolean)false).edges) {
            if (!e.faces.isEmpty()) {
                e.groups = bound;
                modified = true;
                continue;
            }
            floorModel.deleteEdge(e, true);
        }
        return modified;
    }

    private static boolean addFaceToModel(MerlinData md, IFace face, Model model, int groupid) {
        return GeomUtil.addFaceToModel(face, model, groupid, md.simParams.edgeError, md.simParams.faceError);
    }

    private static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> curves) {
        return GeomUtil.addFaceToModel(model, groupid, plane, curves);
    }

    private static void addEdgesToModel(Model model, int groupid, Collection<? extends IParametric3D> curves) {
        model.addEdges(groupid, curves);
    }

    private static List<LineSeg3D> adjustCurves(Collection<? extends IParametric3D> curves, Model model) {
        AABox searchBox = new AABox();
        double searchDist = 0.01;
        HashMap<Point3d, Point3d> pmap = new HashMap<Point3d, Point3d>();
        ArrayList<LineSeg3D> adjustedCurves = new ArrayList<LineSeg3D>(curves.size());
        for (IParametric3D iParametric3D : curves) {
            Point3d p1 = ExtractFloor3DV2.getModelPoint(model, iParametric3D.get(0.0), pmap, searchBox, searchDist);
            Point3d p2 = ExtractFloor3DV2.getModelPoint(model, iParametric3D.get(1.0), pmap, searchBox, searchDist);
            adjustedCurves.add(new LineSeg3D(p1, p2));
        }
        return adjustedCurves;
    }

    private static Point3d getModelPoint(Model model, Point3d p, Map<Point3d, Point3d> pmap, AABox searchBox, double searchDist) {
        Point3d existing = pmap.get(p);
        if (existing == null) {
            searchBox.set(p.x - searchDist, p.y - searchDist, p.z - searchDist, p.x + searchDist, p.y + searchDist, p.z + searchDist);
            List<Vertex> closeVerts = model.findVerts(searchBox);
            existing = closeVerts.isEmpty() ? p : closeVerts.get((int)0).loc;
            pmap.put(p, existing);
        }
        return existing;
    }

    private static enum PlaneCat {
        PLANE_ABOVE,
        PLANE_BELOW,
        PLANE_INTERSECTING,
        PLANE_ALIGNED;

    }

    private static class GeomFace {
        public final ImportedGeom geom;
        public final int faceix;
        public final IPolygon face;

        public GeomFace(ImportedGeom geom, IPolygon face, int faceix) {
            this.geom = geom;
            this.face = face;
            this.faceix = faceix;
        }

        public int hashCode() {
            return System.identityHashCode(this.geom) + this.faceix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GeomFace)) {
                return false;
            }
            GeomFace gf = (GeomFace)obj;
            return this.geom == gf.geom && this.faceix == gf.faceix;
        }
    }

    private static class FaceUse {
        public final Face face;
        public final boolean positive;

        public FaceUse(Face face, boolean positive) {
            this.face = face;
            this.positive = positive;
        }

        public EdgeUse localEu(EdgeUse globalEu) {
            if (!this.positive) {
                return new EdgeUse(globalEu.edge, !globalEu.orient);
            }
            return globalEu;
        }
    }

    private static class Locator<T extends IDisplayableGeomSrc> {
        public AABoxTest test = new AABoxTest(new AABox(), 1.0E-6);
        public final CollResult<IDisplayableGeomSrc, T> result;

        public Locator(Class<T> clazz, Predicate<T> filter) {
            this.result = new CollResult(clazz, filter);
        }

        private void reset(AABox testBox) {
            this.test = new AABoxTest(testBox, 1.0E-6);
            this.result.coll.clear();
        }

        public Collection<T> getResult() {
            return this.result.coll;
        }
    }

    private static class FaceExtraction {
        private final Map<ImportedGeom, Integer> geomGroupidMap;
        private final Model model;

        public FaceExtraction(Map<ImportedGeom, Integer> geomGroupidMap, Model model) {
            this.geomGroupidMap = geomGroupidMap;
            this.model = model;
        }

        public Model.Group getGroup(ImportedGeom geom) {
            Integer id = this.geomGroupidMap.get(geom);
            if (id == null) {
                return null;
            }
            return this.model.getGroup(id);
        }
    }

    private static class ExtractException
    extends Exception {
        private static final long serialVersionUID = -3400828575517731920L;
        public final Type type;

        public ExtractException(Type type) {
            super(type.msg);
            this.type = type;
        }

        public static enum Type {
            INVALIDSLOPE(Intl.intl("The slope of the chosen face exceeds the maximum allowable slope.")),
            NOT_ENOUGH_HEAD_ROOM(Intl.intl("There is insufficient head room at the chosen location.")),
            FAILED(Intl.intl("A room cannot be extracted from the chosen location."));

            public final String msg;

            private Type(String msg) {
                this.msg = msg;
            }
        }
    }
}

