/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.CloseGapsAction;
import merlin.actions.SubtractAction;
import merlin.actions.Undo;
import merlin.actions.floorextract.ExtractFloor2DSel;
import merlin.builders.NewCompUtil;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.GeomUtil;
import merlin.geom.ModelConstrictor;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class ExtractFloor2D
extends AMerlinOp {
    private final TaskProgress d_progress = new TaskProgress();
    private Point3d d_pickLoc = null;
    private boolean d_searchHidden = false;
    private double d_closeGapSize = Util.inchesToMeters(1.0);

    public ExtractFloor2D(Point3d pickLoc, double closeGapSize) {
        this.d_pickLoc = pickLoc;
        this.d_closeGapSize = closeGapSize;
    }

    public TaskProgress getProgress() {
        return this.d_progress;
    }

    protected void checkCancelled() throws CancelledException {
        super.checkCancelled(this.d_progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (this.d_pickLoc == null) {
            return;
        }
        this.d_progress.reset();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Extracting Room"), true, this.d_progress);
        pm.begin();
        try {
            EgressRoom room = null;
            md.beginRead();
            try {
                room = this.extractRoom(md);
            }
            catch (CancelledException cancelledException) {
            }
            finally {
                md.endRead();
            }
            if (room == null) {
                return;
            }
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Extract Room"));
                EgressRoom newRoom = room;
                room.setColor(theUtil.newRandomColor());
                md.roomNameGen.nextName();
                ArrayList<EgressRoom> toClean = new ArrayList<EgressRoom>();
                toClean.add(newRoom);
                ArrayList toSelect = new ArrayList();
                BiConsumer<EgressRoom, EgressRoom> selectFunc = (parentRoom, childRoom) -> {
                    if (parentRoom.equals(newRoom)) {
                        toSelect.add(childRoom);
                    }
                };
                NewCompUtil.addEgressComp(md, false, newRoom);
                SubtractAction.subtract(app, md, 0, toClean::add, selectFunc, newRoom);
                if (newRoom.getDomain() == md) {
                    md.selection.set(room);
                } else {
                    md.selection.set(toSelect);
                }
                EgressRoom.cleanup(md, toClean);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
        finally {
            pm.end();
        }
    }

    private EgressRoom extractRoom(MerlinData md) throws CancelledException {
        Face extractedFace = this.extract(md);
        if (extractedFace == null) {
            return null;
        }
        Model model = new Model();
        model.addFace(extractedFace, 0);
        int[] boundGroup = new int[]{1};
        int[] nonBoundGroup = new int[]{0};
        for (Edge edge : model.getEdges()) {
            edge.groups = ExtractFloor2D.isBoundaryEdge(edge) ? boundGroup : nonBoundGroup;
        }
        for (Vertex vert : model.getVerts()) {
            vert.groups = nonBoundGroup;
        }
        EgressRoom room = new EgressRoom(md.roomNameGen.getCurrentName(), model);
        return room;
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(0) && !edge.faces.isEmpty() || !edge.partOfGroup(0) && edge.faces.size() == 1;
    }

    private Face closeGaps(Model model) {
        model = CloseGapsAction.closeGaps(model, this.d_closeGapSize, new ModelConstrictor.IEdgeClassifier(){

            @Override
            public boolean isBoundary(Edge edge) {
                return edge.partOfGroup(1);
            }

            @Override
            public boolean isInternal(Edge edge) {
                return false;
            }

            @Override
            public boolean canSplit(Edge edge) {
                return true;
            }

            @Override
            public boolean isSplitTarget(Edge edge) {
                return this.isBoundary(edge);
            }
        });
        return model.findFace(this.d_pickLoc);
    }

    private Face extract(MerlinData md) throws CancelledException {
        AABox globalBB = new AABox();
        for (ImportedGeom geom : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
            this.checkCancelled();
            if (geom.getGeom().getNumPrims(2) <= 0 || !this.d_searchHidden && !md.isVisible(geom)) continue;
            globalBB.add(geom.getBounds());
        }
        int outerid = 0;
        Model model = ExtractFloor2DSel.getStartModel(globalBB, this.d_pickLoc.z, outerid);
        if (model == null) {
            return null;
        }
        Face testFace = model.findFace(this.d_pickLoc);
        if (testFace == null) {
            return null;
        }
        AABox faceBounds = testFace.getBounds();
        globalBB = new AABox(faceBounds.getMinX(), faceBounds.getMinY(), globalBB.getMinZ(), faceBounds.getMaxX(), faceBounds.getMaxY(), globalBB.getMaxZ());
        Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, this.d_pickLoc.z, 0.0, 0.0, 0.0, 1.0);
        int groupid = 1;
        IdentityHashSet<ImportedGeom> closedGeoms = new IdentityHashSet<ImportedGeom>();
        int maxit = 100;
        for (int it = 1; it <= maxit; ++it) {
            Collection<ImportedGeom> searchSet = this.getSearchSet(md, globalBB, it, maxit, closedGeoms);
            Collection<ImportedGeom> sortedGeoms = this.sortGeoms(md, searchSet);
            Iterator<ImportedGeom> lineIt = sortedGeoms.iterator();
            while (lineIt.hasNext()) {
                this.checkCancelled();
                ImportedGeom startGeom = lineIt.next();
                if (!closedGeoms.add(startGeom)) continue;
                List<LineSeg> projCurves = ExtractFloor2D.getProjCurves(md, startGeom, projectionXform);
                for (LineSeg ls : projCurves) {
                    GeomUtil.addCurveToModel(ls, model, groupid, 0.0);
                }
                Face face = model.findFace(this.d_pickLoc);
                if (!ExtractFloor2D.isOuterFace(face, outerid)) {
                    return this.completeFace(md, model, face, groupid, outerid, projectionXform, globalBB, closedGeoms);
                }
                if (model.getFaces().size() <= 1) continue;
                for (Face otherFace : new ArrayList<Face>(model.getFaces())) {
                    if (otherFace == face) continue;
                    model.deleteFace(otherFace, true, true);
                }
            }
        }
        return this.closeGaps(model);
    }

    public static boolean isFiltered(MerlinData md, ImportedGeom geom) {
        if (geom.isIgnoredInModelGeneration()) {
            return true;
        }
        AABox bounds = null;
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            if (!floor.isVisible()) continue;
            ConvexHull ch = md.floors.getClippingRegion(floor);
            if (bounds == null) {
                bounds = geom.getBounds().scale(1.000001);
            }
            if (!ch.containsAtLeastPart(bounds)) continue;
            return false;
        }
        return true;
    }

    public static Collection<ImportedGeom> findSceneGeom(final MerlinData md, ITest<AABox> test, boolean searchHidden) {
        Predicate<ImportedGeom> filter = new Predicate<ImportedGeom>(){

            @Override
            public boolean test(ImportedGeom o) {
                return !ExtractFloor2D.isFiltered(md, o);
            }
        };
        CollResult result = new CollResult(ImportedGeom.class, filter);
        md.geomLocation.getLocator().find(test, result, searchHidden ? 1 : 0);
        return new ArrayList<ImportedGeom>(result.coll);
    }

    private static boolean isOuterFace(Face face, int outerid) {
        FaceLoop outerLoop = face.outerLoop();
        return !outerLoop.edges.isEmpty() && outerLoop.edges.get((int)0).edge.partOfGroup(outerid);
    }

    private static void setZExtents(AABox bb, double minz, double maxz) {
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        min.z = minz;
        max.z = maxz;
        bb.set(min, max);
    }

    private Face completeFace(MerlinData md, Model model, Face inputFace, int testID, int globalFaceID, Matrix4d projXform, AABox globalBB, Set<ImportedGeom> closedGeoms) throws CancelledException {
        AABox bb = new AABox(inputFace.getBounds());
        ExtractFloor2D.setZExtents(bb, globalBB.getMinZ(), globalBB.getMaxZ());
        AABoxTest test = new AABoxTest(bb, 1.0E-6);
        Collection<ImportedGeom> igeoms = ExtractFloor2D.findSceneGeom(md, test, this.d_searchHidden);
        for (ImportedGeom geom : igeoms) {
            if (closedGeoms.contains(geom)) continue;
            for (LineSeg ls : ExtractFloor2D.getProjCurves(md, geom, projXform)) {
                GeomUtil.addCurveToModel(ls, model, testID, 0.0);
            }
            if (model.getFaces().size() <= 1) continue;
            Face face = model.findFace(this.d_pickLoc);
            for (Face otherFace : new ArrayList<Face>(model.getFaces())) {
                if (otherFace == face) continue;
                model.deleteFace(otherFace, true, true);
            }
        }
        return this.closeGaps(model);
    }

    private static List<LineSeg> getProjCurves(MerlinData md, ImportedGeom geom, Matrix4d projXform) {
        Collection<LineSeg> curves = ExtractFloor2D.getCurves(md, geom);
        ArrayList<LineSeg> projCurves = new ArrayList<LineSeg>(curves.size());
        TransformInfo ti = new TransformInfo(projXform);
        for (LineSeg curve : curves) {
            LineSeg projCurve = curve.transform(ti, 0);
            projCurves.add(projCurve);
        }
        return projCurves;
    }

    private Collection<ImportedGeom> getSearchSet(final MerlinData md, AABox globalBB, int iteration, int maxIterations, final Set<ImportedGeom> closed) throws CancelledException {
        double mult = (double)iteration / (double)maxIterations;
        double dx = globalBB.getWidth() * mult;
        double dy = globalBB.getDepth() * mult;
        double dist = Math.max(dx, dy);
        AABox searchBox = new AABox(this.d_pickLoc.x - dist, this.d_pickLoc.y - dist, globalBB.getMinZ(), this.d_pickLoc.x + dist, this.d_pickLoc.y + dist, globalBB.getMaxZ());
        AABoxTest test = new AABoxTest(searchBox, 1.0E-6);
        final ArrayList<ImportedGeom> geoms = new ArrayList<ImportedGeom>();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (obj instanceof ImportedGeom && !closed.contains(obj) && !ExtractFloor2D.isFiltered(md, (ImportedGeom)obj)) {
                    geoms.add((ImportedGeom)obj);
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, this.d_searchHidden ? 1 : 0);
        if (geoms.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return geoms;
    }

    private static Collection<LineSeg> getCurves(MerlinData md, ImportedGeom obj) {
        IGeom geom = obj.getGeom().flatten().getLocalGeom();
        return thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(md.simParams.edgeError, geom);
    }

    private Collection<ImportedGeom> sortGeoms(MerlinData md, Collection<ImportedGeom> geoms) throws CancelledException {
        TreeMap<Double, ImportedGeom> map = new TreeMap<Double, ImportedGeom>();
        Point3d linep = this.d_pickLoc;
        Vector3d linedir = new Vector3d(0.0, 0.0, 1.0);
        Point3d closestOnLine1 = new Point3d();
        Point3d closestOnLine2 = new Point3d();
        for (ImportedGeom obj : geoms) {
            double closestDist = Double.MAX_VALUE;
            for (LineSeg curve : ExtractFloor2D.getCurves(md, obj)) {
                double dist;
                this.checkCancelled();
                if (!Inter3D.lineLineSegProximity(closestOnLine1, closestOnLine2, linep, linedir, curve.evaluate(0.0), curve.evaluate(1.0)) || !((dist = closestOnLine1.distanceSquared(closestOnLine2)) < closestDist)) continue;
                closestDist = dist;
            }
            if (closestDist == Double.MAX_VALUE) continue;
            map.put(closestDist, obj);
        }
        return map.values();
    }
}

