/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MeasurementRegions;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.camera.CameraList;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.material.MaterialDB;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class DefaultPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return CameraList.class.getName().equals(mdRootField) || OccProfileComp.class.getName().equals(mdRootField) || AttractorComp.class.getName().equals(mdRootField) || VehicleShapeComp.class.getName().equals(mdRootField) || OccGroupTypeObj.OccGroupTypeComp.class.getName().equals(mdRootField) || AssistedEvacTeamComp.class.getName().equals(mdRootField) || MeasurementRegions.class.getName().equals(mdRootField) || QueueObjectComp.class.getName().equals(mdRootField) || OccTargetComp.class.getName().equals(mdRootField) || MaterialDB.class.getName().equals(mdRootField) || EgressBlockageComp.class.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
        CopyPasteUtil.renamePasteObj(nameSibs, pasteObj);
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, allPastedObjs, insertRoot, true);
        allPastedObjs.accept(pasteObj);
    }
}

