/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.TransformAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.SetZDialog;
import merlin.mv.ModelView;
import merlin.mv.tools.ZPickListener;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class SetZAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SetZAction(), Intl.intl("Set Z..."));
    private IPropertySet d_lastProps = null;

    public SetZAction() {
        SelectionObserver.add(this, IMerlinGeomSrc.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!TransformAction.getValidObjs(md).isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        IPropertySet initProps;
        double maxz;
        double minz;
        Set<IMerlinObj> transformObjs;
        final ModelView mv = app.getModelView();
        boolean anyHasHeight = false;
        md.beginRead();
        try {
            transformObjs = TransformAction.getValidObjs(md);
            AABox bounds = new AABox();
            for (IMerlinGeomSrc obj : TransformAction.getGeom(md, transformObjs)) {
                AABox geomBounds = obj.getGeom().getBoundingBox(new AABox());
                anyHasHeight = anyHasHeight || geomBounds.getMinZ() != geomBounds.getMaxZ();
                bounds.add(geomBounds);
            }
            minz = bounds.isValid() ? bounds.getMinZ() : 0.0;
            maxz = bounds.isValid() ? bounds.getMaxZ() : 0.0;
        }
        finally {
            md.endRead();
        }
        final SetZDialog dlg = new SetZDialog((Window)app.getMainFrame(), new UnitDouble(minz, Geometry.LENGTH_UNIT), new UnitDouble(maxz, Geometry.LENGTH_UNIT), anyHasHeight);
        ZPickListener pickListener = new ZPickListener(){
            final Set<UnitDouble> pickedHeights = new HashSet<UnitDouble>();

            @Override
            public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                IPropertySet props = dlg.save();
                props.set(SetZDialog.PROP_MOVE_OPTION, SetZDialog.MoveOption.MOVE_ABS);
                props.set(SetZDialog.PROP_MOVE_TO_LOCATION, p.zu());
                dlg.load(props);
            }

            @Override
            public void stopPicking() {
            }
        };
        if (this.d_lastProps != null) {
            initProps = this.d_lastProps;
        } else {
            initProps = new PropertySet();
            initProps.set(SetZDialog.PROP_MOVE_OPTION, SetZDialog.MoveOption.MOVE_ABS);
            initProps.set(SetZDialog.PROP_MOVE_TO_LOCATION, new UnitDouble(minz, Geometry.LENGTH_UNIT));
        }
        dlg.load(initProps);
        dlg.addDlgListener(new AbstractDlgListener(){

            @Override
            public void okPressed() {
                AMerlinOp op = new AMerlinOp(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        md.beginWrite();
                        try {
                            Undo.begin(Intl.intl("Set Z"));
                            SetZAction.this.d_lastProps = dlg.save();
                            ArrayList toClean = new ArrayList();
                            int unflattened = SetZAction.setZ(app, md, transformObjs, SetZAction.this.d_lastProps, toClean::add);
                            EgressRoom.cleanup(md, toClean);
                            Undo.end(md);
                            if (unflattened != 0) {
                                md.uiLater(() -> JOptionPane.showMessageDialog(app.getMainFrame(), String.format(Intl.intl("%d objects could not be flattened."), unflattened), Intl.intl("Unflattened Objects"), 2));
                            }
                        }
                        finally {
                            md.endWrite();
                        }
                    }
                };
                UIHook.run(null, "SetZAction", op, 0);
                mv.stopChoosingPoints();
            }

            @Override
            public void cancelPressed() {
                mv.stopChoosingPoints();
            }

            @Override
            public void closePressed() {
                mv.stopChoosingPoints();
            }
        });
        dlg.doModeless();
        md.ui(() -> mv.startChoosingPoints(pickListener));
    }

    private static int setZ(MerlinApp app, MerlinData md, Collection<? extends IMerlinObj> selObjs, IPropertySet dlgProps, Consumer<? super EgressRoom> toClean) {
        boolean flattenObjs = dlgProps.get(SetZDialog.PROP_FLATTEN);
        HashMap<Pair, TransformInfo> flattenTransforms = new HashMap<Pair, TransformInfo>();
        Function<Pair, TransformInfo> newFlattenTransform = p -> {
            double z = (Double)p.v1;
            boolean invertible = (Boolean)p.v2;
            double sz = invertible ? 1.0E-9 : 0.0;
            ITransform flattenXform = TransformUtil.translate(0.0, 0.0, z);
            return flattenXform.concatenate(new ScaleXform(1.0, 1.0, sz)).getInfo();
        };
        int[] unflattened = new int[]{0};
        switch (dlgProps.get(SetZDialog.PROP_MOVE_OPTION)) {
            case MOVE_REL: {
                double value = dlgProps.get(SetZDialog.PROP_OFFSET_LOCATION).get(Geometry.LENGTH_UNIT);
                TransformInfo xform = TransformUtil.translate(0.0, 0.0, value).getInfo();
                if (!flattenObjs) {
                    TransformAction.transform(app, md, toClean, selObjs, 0, xform);
                    break;
                }
                for (IMerlinGeomSrc obj2 : new ArrayList<IMerlinGeomSrc>(TransformAction.getGeom(md, selObjs))) {
                    IDOF dof = obj2.getGeom().getDOF();
                    double minz = obj2.getBounds().getMinZ();
                    TransformInfo fxform = flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(minz, false), newFlattenTransform);
                    if (!fxform.isAccepted(dof) && !(fxform = flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(minz, true), newFlattenTransform)).isAccepted(dof)) {
                        fxform = TransformUtil.IDENTITY_INFO;
                        unflattened[0] = unflattened[0] + 1;
                    }
                    TransformInfo oxform = xform.concatenate(fxform.xform);
                    TransformAction.transform(app, md, toClean, Collections.singleton((IMerlinObj)((Object)obj2)), 0, oxform);
                }
                break;
            }
            case MOVE_ABS: {
                ArrayList<IMerlinGeomSrc> moveObjs;
                double newz = dlgProps.get(SetZDialog.PROP_MOVE_TO_LOCATION).get(Geometry.LENGTH_UNIT);
                ArrayList<IMerlinGeomSrc> geoms = new ArrayList<IMerlinGeomSrc>(TransformAction.getGeom(md, selObjs));
                if (!flattenObjs) {
                    moveObjs = geoms;
                } else {
                    TransformInfo uixform = flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(newz, false), newFlattenTransform);
                    TransformInfo ixform = flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(newz, true), newFlattenTransform);
                    ArrayList<IMerlinGeomSrc> uiobjs = new ArrayList<IMerlinGeomSrc>();
                    ArrayList<IMerlinGeomSrc> iobjs = new ArrayList<IMerlinGeomSrc>();
                    moveObjs = new ArrayList();
                    for (IMerlinGeomSrc obj3 : geoms) {
                        IDOF dof = obj3.getGeom().getDOF();
                        if (uixform.isAccepted(dof)) {
                            uiobjs.add(obj3);
                            continue;
                        }
                        if (ixform.isAccepted(dof)) {
                            iobjs.add(obj3);
                            continue;
                        }
                        unflattened[0] = unflattened[0] + 1;
                        moveObjs.add(obj3);
                    }
                    TransformAction.transform(app, md, toClean, theUtil.filter(uiobjs, IMerlinObj.class), 0, uixform);
                    TransformAction.transform(app, md, toClean, theUtil.filter(iobjs, IMerlinObj.class), 0, ixform);
                }
                for (IMerlinGeomSrc obj4 : moveObjs) {
                    double minz = obj4.getBounds().getMinZ();
                    double dz = newz - minz;
                    TransformInfo oxform = TransformUtil.translate(0.0, 0.0, dz).getInfo();
                    TransformAction.transform(app, md, toClean, Collections.singleton((IMerlinObj)((Object)obj4)), 0, oxform);
                }
                break;
            }
            case MOVE_TO_MULTIPLE: {
                double offset = dlgProps.get(SetZDialog.PROP_MULTIPLE_OFFSET).get(Geometry.LENGTH_UNIT);
                double scale = dlgProps.get(SetZDialog.PROP_MULTIPLE_SCALE).get(Geometry.LENGTH_UNIT);
                Function<IMerlinGeomSrc, TransformInfo> getObjXform = obj -> {
                    double minz = obj.getBounds().getMinZ();
                    double i = Math.round((minz - offset) / scale);
                    double z = offset + i * scale;
                    if (flattenObjs) {
                        IDOF dof = obj.getGeom().getDOF();
                        TransformInfo uixform = (TransformInfo)flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(z, false), newFlattenTransform);
                        if (uixform.isAccepted(dof)) {
                            return uixform;
                        }
                        TransformInfo ixform = (TransformInfo)flattenTransforms.computeIfAbsent(new Pair<Double, Boolean>(z, true), newFlattenTransform);
                        if (ixform.isAccepted(dof)) {
                            return ixform;
                        }
                        nArray[0] = unflattened[0] + 1;
                    }
                    return TransformUtil.translate(0.0, 0.0, z - minz).getInfo();
                };
                for (IMerlinGeomSrc obj5 : new ArrayList<IMerlinGeomSrc>(TransformAction.getGeom(md, selObjs))) {
                    TransformInfo ti = getObjXform.apply(obj5);
                    if (ti.isIdentity()) continue;
                    TransformAction.transform(app, md, toClean, Collections.singleton((IMerlinObj)((Object)obj5)), 0, ti);
                }
                break;
            }
        }
        return unflattened[0];
    }

    private static interface TriFunction<T1, T2, T3, R> {
        public R accept(T1 var1, T2 var2, T3 var3);
    }
}

