/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectConnectedObjs<SelT extends IMerlinObj, T extends IMerlinObj>
extends AMerlinOp
implements IEventObserver {
    public static final UIHook ROOM_OCCS = new UIHook(new SelectConnectedObjs(IEgressOccupiable.class, SelectConnectedObjs::getOccupantsInNodes), Intl.intl("Select Occupants"));
    public static final UIHook ROOM_TARGETS = new UIHook(new SelectConnectedObjs(IEgressOccupiable.class, SelectConnectedObjs::getTargetsInNodes), Intl.intl("Select Occupant Targets"));
    public static final UIHook ROOM_BLOCKAGES = new UIHook(new SelectConnectedObjs(IEgressOccupiable.class, (md, objs) -> SelectConnectedObjs.getConnections(objs, EgressBlockage.class)), Intl.intl("Select Obstacles"));
    public static final UIHook BLOCKAGE_ROOMS = new UIHook(new SelectConnectedObjs(EgressBlockage.class, (md, objs) -> SelectConnectedObjs.getConnections(objs, IEgressOccupiable.class)), Intl.intl("Select Rooms"));
    private final Class<SelT> d_selType;
    private final BiFunction<MerlinData, Set<? extends SelT>, Collection<T>> d_getObjs;

    public static Set<EgressAgent> getOccupantsInNodes(MerlinData md, Set<? extends IEgressOccupiable> nodes) {
        LinkedIdentityHashSet<EgressAgent> occs = new LinkedIdentityHashSet<EgressAgent>();
        for (IEgressOccupiable iEgressOccupiable : nodes) {
            occs.addAll(iEgressOccupiable.getOccupants());
        }
        return occs;
    }

    public static List<OccTarget> getTargetsInNodes(MerlinData md, Set<? extends IEgressOccupiable> nodes) {
        ArrayList<OccTarget> occs = new ArrayList<OccTarget>();
        for (OccTarget target : md.occTargets.flatten(OccTarget.class)) {
            IEgressOccupiable room = target.getRoom();
            if (room == null || !nodes.contains(room)) continue;
            occs.add(target);
        }
        return occs;
    }

    public static <SelT extends IEgressObj, TopT extends IEgressObj> Set<TopT> getConnections(Set<? extends SelT> objs, Class<TopT> topType) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        for (IEgressObj obj : objs) {
            result.addAll(obj.getConnections(topType));
        }
        return result;
    }

    public SelectConnectedObjs(Class<SelT> selType, BiFunction<MerlinData, Set<? extends SelT>, Collection<T>> getObjs) {
        this.d_selType = selType;
        this.d_getObjs = getObjs;
        SelectionObserver.add(this, selType);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set ieComps = md.selection.getDeepSelected(this.d_selType);
        Collection<T> objs = this.d_getObjs.apply(md, ieComps);
        md.selection.clear();
        md.selection.selectAll(objs);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(this.d_selType));
    }
}

