/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectConnectedComps
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectConnectedComps(), Intl.intl("Select Connected Components"));
    private static final String ADJACENT = Intl.intl("Immediately adjacent");
    private static final String ALL = Intl.intl("Entire graph");
    private String d_defOption = ADJACENT;

    public SelectConnectedComps() {
        SelectionObserver.add(this, IEgressComp.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(IEgressComp.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<IEgressComp> connected;
        Object[] optionsList = new String[]{ADJACENT, ALL};
        Object selectedOption = JOptionPane.showInputDialog(app.getActiveFrame(), Intl.intl("Which connected components should be selected?"), Intl.intl("Select Connected Components"), 3, null, optionsList, this.d_defOption);
        Set comps = md.selection.getDeepSelected(IEgressComp.class);
        if (selectedOption == ADJACENT) {
            connected = SelectConnectedComps.getAdjacentComps(md, comps);
        } else if (selectedOption == ALL) {
            connected = SelectConnectedComps.getConnectedComps(md, comps);
        } else {
            return;
        }
        this.d_defOption = (String)selectedOption;
        md.selection.selectAll(connected);
    }

    public static Set<IEgressComp> getAdjacentComps(MerlinData md, Collection<? extends IEgressComp> nodes) {
        LinkedIdentityHashSet<IEgressComp> connected = new LinkedIdentityHashSet<IEgressComp>();
        for (IEgressComp iEgressComp : nodes) {
            Collection<? extends IEgressObj> x = iEgressComp.getConnections();
            for (IEgressObj iEgressObj : x) {
                if (!(iEgressObj instanceof IEgressComp)) continue;
                connected.add((IEgressComp)iEgressObj);
            }
        }
        return connected;
    }

    public static Set<IEgressComp> getConnectedComps(MerlinData md, Collection<? extends IEgressComp> nodes) {
        LinkedIdentityHashSet<IEgressComp> closed = new LinkedIdentityHashSet<IEgressComp>((Collection<IEgressComp>)nodes);
        ArrayDeque<? extends IEgressComp> open = new ArrayDeque<IEgressComp>(nodes);
        while (!open.isEmpty()) {
            IEgressComp elem = (IEgressComp)open.pop();
            for (IEgressObj iEgressObj : elem.getConnections()) {
                if (!(iEgressObj instanceof IEgressComp) || !closed.add((IEgressComp)iEgressObj)) continue;
                open.push((IEgressComp)iEgressObj);
            }
        }
        return closed;
    }
}

