/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccGroupObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.theUtil;

public class ChangeGroupAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ChangeGroupAction(), Intl.intl("Change &Group Node..."));

    public ChangeGroupAction() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        Set<ICompElement> sel = data.selection.getSelected(ICompElement.class);
        Set<Composite<?>> changeGroups = ChangeGroupAction.getValidChangeGroups(data, sel);
        this.setEnabled(!changeGroups.isEmpty());
    }

    private static boolean isValidMoveSet(MerlinData data, Collection<?> objs, Object commonParent) {
        return ChangeGroupAction.isMovable(objs) && commonParent != null && commonParent != data;
    }

    private static boolean isMovable(Collection<?> objs) {
        return !theUtil.filter(objs, new MoveFilter()).isEmpty();
    }

    public static Set<Composite<?>> getValidChangeGroups(MerlinData md, Set<ICompElement> objs) {
        Object commonParent = md.hierarchy.getCommonParent(objs);
        return ChangeGroupAction.getValidChangeGroups(md, objs, commonParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Composite<?>> getValidChangeGroups(MerlinData md, Set<? extends ICompElement> objs, Object commonParent) {
        if (!ChangeGroupAction.isValidMoveSet(md, objs, commonParent)) {
            return Collections.EMPTY_SET;
        }
        LinkedIdentityHashSet validChangeGroups = new LinkedIdentityHashSet();
        md.beginRead();
        try {
            IdentityHashSet invalidGroups = new IdentityHashSet();
            for (ICompElement iCompElement : objs) {
                if (!(iCompElement instanceof Composite)) continue;
                Composite group = (Composite)iCompElement;
                invalidGroups.add(group);
                invalidGroups.addAll(group.getDeepNodes());
            }
            Object[] path = md.hierarchy.getPath(commonParent, md, false);
            assert (path.length >= 1);
            commonParent = (Composite)path[0];
            ChangeGroupAction.addChangeGroups(md, validChangeGroups, objs, (Composite)commonParent, commonParent != md.floors);
            validChangeGroups.removeAll(invalidGroups);
        }
        finally {
            md.endRead();
        }
        return validChangeGroups;
    }

    private static void addChangeGroups(MerlinData md, Collection<Composite<?>> resultGroups, Collection<? extends ICompElement> testObjs, Composite<?> rootGroup, boolean includeRoot) {
        LinkedHashMap filterGroupMap = new LinkedHashMap();
        if (includeRoot) {
            ChangeGroupAction.mapFilterToGroup(rootGroup, filterGroupMap);
        }
        Collection<Composite> deepGroups = rootGroup.getDeepNodes();
        for (Composite composite : deepGroups) {
            ChangeGroupAction.mapFilterToGroup(composite, filterGroupMap);
        }
        for (Map.Entry entry : filterGroupMap.entrySet()) {
            if (!ChangeGroupAction.accept(md, (Predicate)entry.getKey(), testObjs)) continue;
            resultGroups.addAll((Collection)entry.getValue());
        }
    }

    private static void mapFilterToGroup(Composite<?> group, Map<Predicate<ICompElement>, List<Composite<?>>> map) {
        Predicate<ICompElement> filter = group.getFilter();
        List<Composite<?>> filterGroups = map.get(filter);
        if (filterGroups == null) {
            filterGroups = new ArrayList();
            map.put(filter, filterGroups);
        }
        filterGroups.add(group);
    }

    private static boolean accept(MerlinData md, Predicate<ICompElement> filter, Collection<? extends ICompElement> objs) {
        for (ICompElement iCompElement : objs) {
            if (filter.test(iCompElement)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<ICompElement> objs;
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        md.beginRead();
        try {
            objs = sel.getSelected(ICompElement.class);
        }
        finally {
            md.endRead();
        }
        Set<Composite<?>> validChangeGroups = ChangeGroupAction.getValidChangeGroups(md, objs);
        if (validChangeGroups.isEmpty()) {
            return;
        }
        GroupChooserDlg dlg = new GroupChooserDlg(app.getMainFrame(), validChangeGroups);
        if (dlg.doModal() == 1) {
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Change Group Node"));
                try {
                    Composite<ICompElement> group = dlg.getGroup();
                    if (dlg.isNewSubgroup()) {
                        Composite<?> subgroup = group.newGroup(dlg.getNewSubgroupName());
                        assert (subgroup != null);
                        AddObject.add((MerlinData)md, group, (int)group.getChildren().size(), (ICompElement[])new Composite[]{subgroup});
                        validChangeGroups = ChangeGroupAction.getValidChangeGroups(md, objs);
                        if (!validChangeGroups.contains(subgroup)) {
                            md.uiLater(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("The objects could not be moved to the new group."), Intl.intl("Error Changing Group"), 0));
                            return;
                        }
                        group = subgroup;
                    }
                    ChangeGroupAction.move(md, objs, group, group.getChildren().size());
                }
                finally {
                    Undo.end(md);
                }
            }
            finally {
                md.endWrite();
            }
        }
    }

    public static void move(MerlinData md, Collection<? extends ICompElement> objs, Composite<?> target, int insertPos) {
        ArrayList<MoveRecord> src = new ArrayList<MoveRecord>(objs.size());
        IdentityHashMap<Composite, SortCache<ICompElement>> parentIxMaps = new IdentityHashMap<Composite, SortCache<ICompElement>>();
        for (ICompElement iCompElement : objs) {
            Composite parent = (Composite)md.hierarchy.getParent(iCompElement);
            if (parent == null) continue;
            SortCache<ICompElement> ixCache = (SortCache<ICompElement>)parentIxMaps.get(parent);
            if (ixCache == null) {
                ixCache = new SortCache<ICompElement>(parent.getMembers());
                parentIxMaps.put(parent, ixCache);
            }
            int ix = ixCache.indexOf(iCompElement);
            src.add(new MoveRecord(iCompElement, parent, ix));
        }
        MoveOp op = new MoveOp(src, target, insertPos, true);
        Undo.insertEntry(md, op.perform(md.selection));
        RemoveGroupLeaderOp removeGroupLeaderOp = new RemoveGroupLeaderOp(src);
        Undo.insertEntry(md, removeGroupLeaderOp.perform(md.selection));
    }

    public class GroupChooserDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private guiComboBox<ICompElement> d_groups;
        private guiCheckBox d_newSubgroupCB;
        private guiTextField d_newSubgroupTF;

        public GroupChooserDlg(JFrame owner, Collection<Composite<?>> nodes) {
            super((Window)owner, Intl.intl("Change Group Node"), 9);
            Object topLevel = this.getTopLevel(nodes);
            this.d_groups = new guiComboBox(nodes);
            this.d_groups.setRenderer(new CompositeRenderer(topLevel));
            this.d_newSubgroupCB = new guiCheckBox(Intl.intl("New Subgroup:"));
            this.d_newSubgroupCB.setToolTipText(Intl.intl("Create a new subgroup under selected group."));
            this.d_newSubgroupTF = new guiTextField();
            this.d_newSubgroupTF.setEnabled(false);
            guiUtil.link((AbstractButton)this.d_newSubgroupCB, this.d_newSubgroupTF);
            guiPanel p = this.getDialogPane();
            p.setLayout(new GridBagLayout());
            GridBagUtil.add(p, new guiLabel(Intl.intl("Group Node") + ":"), 1, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_groups, 2, 1, 1, 1, 0, 6, 0, 0, 1, 1.0, 1.0, 17);
            GridBagUtil.add(p, this.d_newSubgroupCB, 1, 2, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_newSubgroupTF, 2, 2, 1, 1, 6, 6, 0, 0, 1, 1.0, 1.0, 17);
            Runnable syncState = () -> {
                Composite<ICompElement> parent = this.getGroup();
                boolean newGroupEnabled = parent != null && parent.canAddGroup();
                this.d_newSubgroupCB.setEnabled(newGroupEnabled);
                if (!newGroupEnabled) {
                    this.d_newSubgroupCB.setSelected(false);
                }
            };
            this.d_groups.addItemListener(e -> syncState.run());
            syncState.run();
        }

        private Object getTopLevel(Collection<Composite<?>> nodes) {
            MerlinData md = MerlinApp.getApp().getData();
            int[] levels = new int[nodes.size()];
            int ix = 0;
            int fewestLevels = Integer.MAX_VALUE;
            for (Composite<?> node : nodes) {
                Object[] path = md.hierarchy.getPath(node);
                levels[ix++] = path.length;
                if (path.length >= fewestLevels) continue;
                fewestLevels = path.length;
            }
            ArrayList topGroups = new ArrayList();
            ix = 0;
            for (Composite<?> node : nodes) {
                int level;
                if ((level = levels[ix++]) != fewestLevels) continue;
                topGroups.add(node);
            }
            return md.hierarchy.getCommonParent(topGroups);
        }

        public Composite<ICompElement> getGroup() {
            return (Composite)this.d_groups.getSelectedItem();
        }

        public boolean isNewSubgroup() {
            return this.d_newSubgroupCB.isSelected();
        }

        public String getNewSubgroupName() {
            return this.d_newSubgroupTF.getText();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.isNewSubgroup() && this.getNewSubgroupName().isEmpty()) {
                this.showMessageBox(Intl.intl("Enter a subgroup name."));
                return false;
            }
            return true;
        }

        private class CompositeRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;
            private final Object d_topLevel;

            public CompositeRenderer(Object topLevel) {
                this.d_topLevel = topLevel;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                MerlinData md = MerlinApp.getApp().getData();
                Composite group = (Composite)value;
                Object[] path = MerlinApp.getApp().getData().hierarchy.getPath(group, this.d_topLevel, false);
                String name = "";
                for (int m = 0; m < path.length - 1; ++m) {
                    name = name + "    ";
                }
                name = name + group.getName();
                guiUtil.decorateComboRenderer(md, GroupChooserDlg.this.d_groups, list, value, this, isSelected, cellHasFocus);
                this.setText(name);
                return this;
            }
        }
    }

    public static class RemoveGroupLeaderOp
    implements Undo.UndoOp {
        private List<MoveRecord> src;

        public RemoveGroupLeaderOp(List<MoveRecord> src) {
            this.src = src;
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            LinkedHashSet<OccGroupObj> occGroups = new LinkedHashSet<OccGroupObj>();
            for (MoveRecord rec : this.src) {
                if (!(rec.oldParent instanceof OccGroupObj)) continue;
                OccGroupObj group = (OccGroupObj)rec.oldParent;
                EgressAgent leader = group.getProperty(OccGroupObj.PROP_GROUP_LEADER);
                if (!(rec.moveObj instanceof Proxy) || ((Proxy)rec.moveObj).getObj() != leader) continue;
                occGroups.add(group);
            }
            Undo.PropRestoreOp undo = new Undo.PropRestoreOp(OccGroupObj.PROP_GROUP_LEADER, occGroups);
            for (OccGroupObj group : occGroups) {
                group.setProperty(OccGroupObj.PROP_GROUP_LEADER, null);
            }
            return undo;
        }
    }

    private static class MoveOp
    implements Undo.UndoOp {
        private final boolean d_ascend;
        private final List<MoveRecord> d_src;
        private final Composite<ICompElement> d_dest;
        private final int d_insertPos;

        public MoveOp(List<MoveRecord> src, Composite<?> dest, int insertPos, boolean ascend) {
            this.d_dest = dest;
            this.d_src = src;
            this.d_insertPos = insertPos;
            this.d_ascend = ascend;
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            MoveOp undo = new MoveOp(this.d_src, this.d_dest, this.d_insertPos, !this.d_ascend);
            MerlinApp.getApp().getData().pauseUpdates(false);
            if (this.d_ascend) {
                this.doAction();
            } else {
                this.undoAction();
            }
            MerlinApp.getApp().getData().resumeUpdates();
            sel.clear();
            this.d_dest.changedEvt(MerlinData.CHILDREN_CHANGED);
            for (MoveRecord mr : this.d_src) {
                mr.oldParent.changedEvt(MerlinData.CHILDREN_CHANGED);
                mr.moveObj.changedEvt(MerlinData.PARENT_CHANGED);
                sel.select(mr.moveObj);
            }
            return undo;
        }

        public void doAction() {
            LinkedIdentityHashSet toInsert = new LinkedIdentityHashSet();
            for (MoveRecord pair : this.d_src) {
                toInsert.add(pair.moveObj);
            }
            ICompElement insertAfter = null;
            Iterator<ICompElement> objit = this.d_dest.getMembers().iterator();
            for (int ix = 0; objit.hasNext() && ix < this.d_insertPos; ++ix) {
                ICompElement obj = objit.next();
                if (toInsert.contains(obj)) continue;
                insertAfter = obj;
            }
            for (MoveRecord pair : this.d_src) {
                pair.oldParent.remove(pair.moveObj);
            }
            int insertIx = 0;
            if (insertAfter != null) {
                insertIx = 1;
                for (ICompElement obj : this.d_dest.getMembers()) {
                    if (obj == insertAfter) break;
                    ++insertIx;
                }
            }
            this.d_dest.insert(toInsert, insertIx);
        }

        public void undoAction() {
            LinkedIdentityHashMap parentMap = new LinkedIdentityHashMap();
            for (int m = this.d_src.size() - 1; m >= 0; --m) {
                MoveRecord pair = this.d_src.get(m);
                this.d_dest.remove(pair.moveObj);
                ArrayList<MoveRecord> oldParentObjs = (ArrayList<MoveRecord>)parentMap.get(pair.oldParent);
                if (oldParentObjs == null) {
                    oldParentObjs = new ArrayList<MoveRecord>();
                    parentMap.put(pair.oldParent, oldParentObjs);
                }
                oldParentObjs.add(pair);
            }
            Comparator<MoveRecord> mrCompare = new Comparator<MoveRecord>(){

                @Override
                public int compare(MoveRecord o1, MoveRecord o2) {
                    return o1.oldPos - o2.oldPos;
                }
            };
            for (Map.Entry entry : parentMap.entrySet()) {
                List moveRecs = (List)entry.getValue();
                Collections.sort(moveRecs, mrCompare);
                ICompElement[] objsArr = new ICompElement[moveRecs.size()];
                int[] ixes = new int[moveRecs.size()];
                for (int m = 0; m < moveRecs.size(); ++m) {
                    MoveRecord mr = (MoveRecord)moveRecs.get(m);
                    objsArr[m] = mr.moveObj;
                    ixes[m] = mr.oldPos;
                }
                ((Composite)entry.getKey()).insert(objsArr, ixes);
            }
        }
    }

    private static class MoveRecord {
        public final ICompElement moveObj;
        public final Composite<?> oldParent;
        public final int oldPos;

        public MoveRecord(ICompElement moveObj, Composite<?> oldParent, int oldPos) {
            this.moveObj = moveObj;
            this.oldParent = oldParent;
            this.oldPos = oldPos;
        }
    }

    private static class MoveFilter
    implements Predicate<Object> {
        private MoveFilter() {
        }

        @Override
        public boolean test(Object o) {
            return EntryPointFactory.get(o).isMovable(MerlinApp.getApp().getData(), o);
        }
    }
}

