/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.OccSourceBuilder;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccSourceObj;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class AddOccupantSourceAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddOccupantSourceAction(), Intl.intl("Add Occupant Source"));

    public AddOccupantSourceAction() {
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        INameGenerator nameGenerator = md.occSourceNameGen;
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("New Occupants Source"));
            try {
                ArrayList<EgressDoor> comps = new ArrayList<EgressDoor>();
                comps.addAll(md.selection.flatten(EgressDoor.class));
                comps.addAll(md.selection.flatten(IEgressOccupiable.class).stream().filter(OccSourceObj.occsAllowedFilter()).collect(Collectors.toList()));
                AddOccupantSourceAction.addOccSources(md, nameGenerator, comps);
            }
            finally {
                Undo.end(md);
            }
        }
        finally {
            md.endWrite();
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.flatten(EgressDoor.class).isEmpty() || sel.flatten(IEgressOccupiable.class).stream().anyMatch(OccSourceObj.occsAllowedFilter()));
    }

    public static void addOccSources(MerlinData md, INameGenerator nameGenerator, Collection<? extends IEgressComp> comps) {
        ArrayList<OccSourceObj> sources = new ArrayList<OccSourceObj>(comps.size());
        for (IEgressComp iEgressComp : comps) {
            OccSourceObj obj = OccSourceBuilder.createOccSourceObj(md, null, iEgressComp, nameGenerator);
            sources.add(obj);
            nameGenerator.nextName();
        }
        AddObject.add(md, md.occSources, md.occSources.getMembers().size(), sources);
    }
}

