/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.IProps;
import inferno.data2.NavigateMeshData;
import inferno.data2.Occupant;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.vis.AbstractTable;
import inferno.vis.GLWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class NavigateMeshTable
extends AbstractTable {
    private JList<?> d_highCostOccsList;
    private KB d_kb;
    private GLWindow d_glWindow;
    private String d_selectedAgentName;
    private JPanel d_panel = new JPanel(new BorderLayout());
    private JLabel d_label;
    private Function<NavigateMeshData.DirData, double[]> d_getDirData;
    private Function<NavigateMeshData.DirData, Double> d_getTotal;
    private boolean d_showHighCostOccs;
    private String d_msg;

    public NavigateMeshTable(KB kb, GLWindow glWindow, Function<NavigateMeshData.DirData, double[]> getDirData, Function<NavigateMeshData.DirData, Double> getTotal, String msg, boolean showHighCostOccs) {
        this.d_kb = kb;
        this.d_glWindow = glWindow;
        this.d_getDirData = getDirData;
        this.d_getTotal = getTotal;
        this.d_msg = msg;
        this.d_showHighCostOccs = showHighCostOccs;
        this.d_label = new JLabel(this.d_msg + ", showing results for: ");
        this.d_label.setFont(this.d_label.getFont().deriveFont(1));
        this.d_panel.add((Component)this.d_label, "North");
        JScrollPane p = new JScrollPane(this.d_table);
        p.setPreferredSize(new Dimension(p.getPreferredSize().width, 330));
        this.d_panel.add((Component)p, "Center");
        if (this.d_showHighCostOccs) {
            this.d_highCostOccsList = new JList();
            this.d_highCostOccsList.setPreferredSize(new Dimension(100, 100));
            this.d_highCostOccsList.setLayoutOrientation(2);
            this.d_highCostOccsList.setName("High cost occupants");
            this.d_highCostOccsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String occName = (String)NavigateMeshTable.this.d_highCostOccsList.getSelectedValue();
                    if (occName != null) {
                        for (OccAgent agent : NavigateMeshTable.this.d_kb.getActiveAgents()) {
                            if (agent.getOcc().name.equals(occName)) {
                                agent.setSelected(true);
                                NavigateMeshTable.this.d_glWindow.getD_glView().render();
                                NavigateMeshTable.this.d_glWindow.updateTables(agent);
                                continue;
                            }
                            agent.setSelected(false);
                        }
                    }
                }
            });
            JPanel navMeshListPanel = new JPanel(new BorderLayout());
            navMeshListPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("High cost occupants"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            navMeshListPanel.add(this.d_highCostOccsList, "West");
            this.d_panel.add((Component)navMeshListPanel, "South");
        }
    }

    @Override
    public void initModel(String className) throws SecurityException, ClassNotFoundException {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("dir");
        for (NavigateMeshData.Behavior behavior : NavigateMeshData.Behavior.values()) {
            columnNames.add(behavior.desc);
        }
        columnNames.add("total");
        this.d_columnNames = theUtil.toArray(columnNames, String.class);
        this.d_values = new Object[15][this.d_columnNames.length];
    }

    @Override
    public void update(List<Object> data) {
        if (data != null) {
            this.clearTable();
            IProps props = this.d_kb.getProps();
            Occupant occ = (Occupant)data.get(0);
            int rowIndex = 0;
            Serializable ser = props.getDbgObj(occ, "NAVMESH_DIR");
            if (ser != null) {
                List<NavigateMeshData.DirData> navMeshData = ((NavigateMeshData)ser).getData();
                for (NavigateMeshData.DirData rD : navMeshData) {
                    this.addRow(rD, rowIndex++);
                }
                this.d_selectedAgentName = occ.name;
                this.updateLabel();
                this.d_table.putClientProperty("HIGHLIGHTED_ROW", ((NavigateMeshData)ser).getBestDirIndex());
                this.d_table.repaint();
                this.showHighCostOccs(((NavigateMeshData)ser).getHighCostOccs());
            }
        } else {
            this.clearTable();
            this.d_selectedAgentName = "";
            this.updateLabel();
            if (this.d_showHighCostOccs) {
                this.d_highCostOccsList.clearSelection();
            }
            this.d_table.putClientProperty("HIGHLIGHTED_ROW", -1);
            this.d_table.repaint();
        }
    }

    private void clearTable() {
        for (int row = 0; row < this.d_table.getRowCount(); ++row) {
            for (int col = 0; col < this.d_table.getColumnCount(); ++col) {
                this.d_table.setValueAt("", row, col);
            }
        }
    }

    private void updateLabel() {
        this.d_label.setText(this.d_msg + ": showing results for: " + this.d_selectedAgentName);
    }

    private void addRow(NavigateMeshData.DirData rowData, int rowIndex) {
        int colIndex = 0;
        try {
            this.d_table.setValueAt(NavigateMeshTable.format(rowData.dir), rowIndex, colIndex++);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (int m = 0; m < rowData.costs.length; ++m) {
            this.d_table.setValueAt(Global.format(this.d_getDirData.apply(rowData)[m]), rowIndex, colIndex++);
        }
        this.d_table.setValueAt(Global.format(this.d_getTotal.apply(rowData)), rowIndex, colIndex++);
    }

    private void showHighCostOccs(Collection<OccAgent> highCostOccs) {
        if (!this.d_showHighCostOccs) {
            return;
        }
        DefaultListModel listModel = new DefaultListModel();
        highCostOccs.forEach(x -> listModel.addElement(x.getOcc().name));
        this.d_highCostOccsList.setModel(listModel);
    }

    public JList<?> getHighCostOccsList() {
        return this.d_highCostOccsList;
    }

    public Component getPanel() {
        return this.d_panel;
    }
}

