/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.sim.KB;
import inferno.sim.Param;
import inferno.test.Tweaks;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import merlin.actions.InfernoUtil;
import merlin.actions.WriteMesh;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.io.MerlinOIS;

public class ParsePth {
    public static final int OPT_PREPARE_VIS = 1;
    public static final int OPT_UPGRADE_DEFAULTS = 2;
    public static final int OPT_CONVERT_TO_SOCIAL_DISTANCE = 4;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KB load(String inFile, File outDir, String outName, Tweaks.ITweak tweaks, int options) {
        try (FileInputStream fis = new FileInputStream(inFile);){
            KB kB = ParsePth.load(fis, outDir, outName, tweaks, options);
            return kB;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static KB load(InputStream inStream, File outDir, String outName, Tweaks.ITweak tweaks, int options) throws Throwable {
        File parentDir = new File(outDir, outName).getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        MerlinData md = new MerlinData(false);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        MerlinOIS ois = new MerlinOIS(bis, false, tp -> {});
        MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
        decisions.pre104UseNewDefaults = () -> ParsePth.test(options, 2);
        decisions.pre139ConvertToSocialDistance = () -> ParsePth.test(options, 4);
        MerlinData mdTemp = ois.readModel(decisions);
        md.loadFrom(mdTemp);
        if (tweaks != null) {
            tweaks.tweak(md);
        }
        String rootFn = InfernoUtil.rootFn(outName);
        boolean debug = System.getProperty("debug-vis") != null;
        Param p = InfernoUtil.mkInfernoParam(null, md, outDir, rootFn, debug);
        ArrayList<SimError> errors = new ArrayList<SimError>();
        InfernoUtil.KBInfo kbi = InfernoUtil.mkInfernoKB(md, p, errors);
        if (tweaks != null) {
            tweaks.tweak(kbi.kb);
        }
        try {
            WriteMesh.writeInputFile(md, outDir, rootFn, kbi, p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return kbi.kb;
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }
}

