/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.test.TestPrefs;
import java.io.File;
import java.util.Map;
import java.util.function.Function;

public class EnvUtil {
    public static File getDir(TestPrefs.Prop<String> prop) {
        String outputd = System.getenv().getOrDefault(prop.key.toString(), (String)prop.defVal.get());
        File outputf = new File(outputd);
        if (!outputf.isAbsolute()) {
            String outDir = ".";
            if (!outputd.startsWith("/") && !outputd.startsWith("\\")) {
                outDir = outDir + "/";
            }
            outDir = outDir + outputd;
            outputf = new File(outDir);
        }
        return outputf;
    }

    public static <T> T get(TestPrefs.Prop<T> prop) {
        Map<String, String> env = System.getenv();
        if (env.containsKey(prop.key)) {
            return prop.parser.apply(env.get(prop.key));
        }
        return prop.defVal.get();
    }

    public static <T> T getEnvProp(TestPrefs.Prop<T> prop, Function<String, T> parser) {
        Map<String, String> env = System.getenv();
        if (!env.containsKey(prop.key)) {
            return prop.defVal.get();
        }
        String val = env.get(prop.key);
        if (val == null) {
            return null;
        }
        try {
            return parser.apply(val);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return prop.defVal.get();
        }
    }
}

