/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.AStar;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import inferno.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.util.CompletedFuture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class RoomTarget
implements IGlobalTarget,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Set<ANode> targetRooms;
    private transient PathGen.IPathGoal d_prevGoal;
    private transient Predicate<PathChange> d_prevPathFilter;

    public RoomTarget(Collection<? extends ANode> rooms) {
        assert (Util.isOrdered(rooms));
        this.targetRooms = rooms instanceof Set ? (Set<Object>)rooms : new LinkedIdentityHashSet<ANode>(rooms);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RoomTarget && ((RoomTarget)obj).targetRooms.equals(this.targetRooms);
    }

    public int hashCode() {
        return 0xDF32FEE3 ^ this.targetRooms.hashCode();
    }

    @Override
    public boolean isStatic(KB kb) {
        return true;
    }

    @Override
    public int update(KB kb, OccAgent agent) {
        return 0;
    }

    @Override
    public void invalidate() {
        this.d_prevGoal = null;
        this.d_prevPathFilter = null;
    }

    @Override
    public Collection<? extends ILocalTarget> getLocalTargets(KB kb, OccAgent agent, ANode currentRoom) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isLocalTarget(ILocalTarget target) {
        return false;
    }

    @Override
    public Future<Estimate.DoorToGoalValue> getDistFromLocalTarget(KB kb, OccAgent agent, LocalDoorTarget localDoor, ANode currentRoom) {
        Predicate<Tri> triFilter = TriFilters.filterDangerous(Filters.accept(this.targetRooms), false);
        Predicate<PathChange> pathFilter = agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.DOOR_TO_GOAL);
        PathGen.IPathGoal goal = this.getGoal(pathFilter);
        if (goal instanceof InvalidGoal) {
            return new CompletedFuture<Estimate.DoorToGoalValue>(Estimate.DoorToGoalValue.noPath(localDoor.door, goal));
        }
        return kb.getPathEstimates().doorToGoalDistance(localDoor.door, goal, currentRoom, pathFilter);
    }

    protected PathGen.IPathGoal getGoal(Predicate<PathChange> pathFilter) {
        if (this.d_prevGoal == null || !Objects.equals(pathFilter, this.d_prevPathFilter)) {
            this.d_prevGoal = this.makeGoal(pathFilter);
            this.d_prevPathFilter = pathFilter;
        }
        return this.d_prevGoal;
    }

    protected PathGen.IPathGoal makeGoal(Predicate<PathChange> pathFilter) {
        LinkedIdentityHashSet<WingedEdge> doors = new LinkedIdentityHashSet<WingedEdge>();
        for (ANode room : this.targetRooms) {
            for (WingedEdge door : room.getDoorEdges()) {
                Tri targetTri;
                PathChange pc;
                if (door.isExit() || door.getNode1() == door.getNode2() || !pathFilter.test(pc = new PathChange(targetTri = door.t1.node == room ? door.t1 : door.t2, door))) continue;
                doors.add(door);
            }
        }
        if (doors.isEmpty()) {
            return InvalidGoal.INSTANCE;
        }
        return PathGen.newEdgeGoal(doors);
    }

    private static class InvalidGoal
    implements PathGen.IPathGoal {
        public static InvalidGoal INSTANCE = new InvalidGoal();

        private InvalidGoal() {
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return false;
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            return 0.0;
        }

        @Override
        public double getDistance(SplitEdge[] sedges, PathGen.GoalDest goalReached, Point3d p) {
            return 0.0;
        }

        @Override
        public Pair<PathGen.GoalDest, Double> testReached(PathChange pc, Point3d prevPt) {
            return null;
        }

        @Override
        public TriPoint project(PathGen.GoalDest goalReached, SplitEdge[] shortenedEdges, Point3d p) {
            return null;
        }

        @Override
        public Pair<PathGen.GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            return null;
        }

        @Override
        public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPts, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            return null;
        }
    }
}

