/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.AStar;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.IPath;
import inferno.sim.path.PartialPath;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.steering.OccPathDebug;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class LocalDoorTarget
implements ILocalTarget,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ANode door;
    public final boolean isVirtual;
    private transient PathGen.IEdgeGoal d_goal;

    public LocalDoorTarget(ANode door) {
        this(door, false);
    }

    public LocalDoorTarget(ANode door, boolean isVirtual) {
        this.door = door;
        this.isVirtual = isVirtual;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LocalDoorTarget && ((LocalDoorTarget)obj).door == this.door;
    }

    public int hashCode() {
        return 0x9243A834 ^ this.door.hashCode();
    }

    @Override
    public Vector3d getNaiveDistanceVec(KB kb, OccAgent agent, ANode room) {
        return kb.getPathEstimates().getDistanceField(kb, room, this.door).getValue(agent.getLoc());
    }

    private PathGen.IEdgeGoal getGoal() {
        if (this.d_goal != null) {
            return this.d_goal;
        }
        this.d_goal = PathGen.newDoorGoal(this.door);
        return this.d_goal;
    }

    @Override
    public boolean isReachable(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter) {
        PathGen.IEdgeGoal pathGoal = this.getGoal();
        PathGen.IPathResult searchResult = this.getPath(kb, agent, pathPlanningFilter, pathGoal, null, true);
        return searchResult.isSuccessful();
    }

    @Override
    public LocallyQuickest.LQuickPath getLocalPath(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter, IGlobalTarget gTarget, Estimate.DoorToGoalValue tailInfo) {
        Pair<IPath, Estimate.PointToGoalDist> p;
        PathGen.IEdgeGoal pathGoal = this.getGoal();
        Mesh m = kb.getMesh();
        OccPathDebug dbgInfo = new OccPathDebug(kb, agent);
        PathGen.IPathResult searchResult = this.getPath(kb, agent, pathPlanningFilter, pathGoal, dbgInfo.getConsumer(), false);
        if (!searchResult.isSuccessful()) {
            return null;
        }
        ArrayList<TriEdge> pathEdges = new ArrayList<TriEdge>(searchResult.getEdges());
        Predicate<WingedEdge> edgeFilter = LocalDoorTarget.getEdgeFilter(pathEdges);
        List<TriPoint> pts = searchResult.getPoints();
        boolean isGTarget = gTarget.isLocalTarget(this);
        if (isGTarget) {
            p = LocalDoorTarget.createPathToExit(kb, agent, pts, this.door, pathGoal, edgeFilter, dbgInfo.get());
        } else {
            DoorDir dir = tailInfo.getDir(this.door);
            assert (dir != null);
            p = this.createPathToInternalDoor(kb, agent, m, pts, pathGoal, dir, edgeFilter, tailInfo, dbgInfo.get());
        }
        return new LocallyQuickest.LQuickPath((IPath)p.v1, pathEdges, (Estimate.PointToGoalDist)p.v2);
    }

    private static Predicate<WingedEdge> getEdgeFilter(List<TriEdge> pathEdges) {
        LinkedIdentityHashSet allowedDoorNodes = new LinkedIdentityHashSet(2);
        for (TriEdge edge : pathEdges) {
            if (!edge.edge.isDoor()) continue;
            allowedDoorNodes.add(edge.edge.data.node);
        }
        return EdgeFilters.filterDoors(Filters.accept(allowedDoorNodes));
    }

    private static WingedEdge getDoorEdge(ANode door, List<TriPoint> path) {
        for (int m = path.size() - 1; m >= 0; --m) {
            WingedEdge edge = path.get(m).getEdge();
            if (edge.getDoorNode() != door) continue;
            assert (m == path.size() - 1) : "Door edge should be last on path";
            return edge;
        }
        assert (false);
        return door.getDoorEdges().get(door.getDoorEdges().size() / 2);
    }

    private PathGen.IPathResult getPath(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter, PathGen.IPathGoal pathGoal, Consumer<AStar.DebugInfo> dbgInfo, boolean testOnly) {
        Occupant occ = agent.getOcc();
        Mesh m = kb.getMesh();
        if (this.door.isClosed(kb, agent) && Double.isInfinite(this.door.getNextOpenTime(kb, agent)) && this.door.getDoorEdges().stream().noneMatch(doorEdge -> pathPlanningFilter.test(new PathChange(occupant.tri, (WingedEdge)doorEdge)))) {
            return new PathGen.PathFailure(4);
        }
        if (testOnly) {
            return PathGen.testPath(m, occ.tri, null, null, occ.loc, pathGoal, occ.bodyShape.getGeomRadius(), Double.MAX_VALUE, pathPlanningFilter, dbgInfo);
        }
        PathGen.IPathResult result = PathGen.getPath(m, occ.tri, null, null, occ.loc, pathGoal, occ.bodyShape.getGeomRadius(), Double.MAX_VALUE, pathPlanningFilter, dbgInfo);
        return result;
    }

    private static Pair<IPath, Estimate.PointToGoalDist> createPathToExit(KB kb, OccAgent agent, List<TriPoint> pts, ANode exitDoor, PathGen.IEdgeGoal goal, Predicate<WingedEdge> edgeFilter, AStar.DebugInfo dbgInfo) {
        assert (exitDoor.isExitDoor());
        if (pts.size() == 1) {
            pts.add(pts.get(0));
        }
        Path path = goal.generatePath(kb, agent, pts, edgeFilter, false, null, dbgInfo);
        assert (path != null);
        WingedEdge exitEdge = LocalDoorTarget.getDoorEdge(exitDoor, pts);
        TriPoint lastPt = pts.get(pts.size() - 1);
        double lastt = exitEdge.base.get(lastPt.p);
        return new Pair<IPath, Estimate.PointToGoalDist>(path, Estimate.PointToGoalDist.zeroPath(exitEdge, lastt, DoorDir.getExitDir(exitDoor)));
    }

    private Pair<IPath, Estimate.PointToGoalDist> createPathToInternalDoor(KB kb, OccAgent agent, Mesh navMesh, List<TriPoint> pts, PathGen.IEdgeGoal goal, DoorDir dir, Predicate<WingedEdge> edgeFilter, Estimate.DoorToGoalValue tailInfo, AStar.DebugInfo dbgInfo) {
        if (pts.size() == 1) {
            pts = new ArrayList<TriPoint>(pts);
            pts.add(pts.get(0));
        }
        Path path = goal.generatePath(kb, agent, pts, edgeFilter, this.isVirtual, dir, dbgInfo);
        assert (path != null);
        TriPoint lastPt = pts.get(pts.size() - 1);
        Estimate.PointToGoalDist dist = tailInfo.getDistFrom(lastPt.p);
        return new Pair<IPath, Estimate.PointToGoalDist>(new PartialPath(path, dist.path, dist.dist), dist);
    }

    @Override
    public double getLocalDelayEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double tTargetChosen, double localDist, Estimate.DoorToGoalValue globalDist) {
        DoorDir dir = this.getLocalDoorDirection(globalDist);
        double crossTime = estimator.getCrossTime(kb, agent, this.door, dir, localDist, Double.POSITIVE_INFINITY, tTargetChosen, kb.getCurrentSimTime());
        return crossTime;
    }

    @Override
    public double getLocalTravelTimeEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double localDist) {
        double travelTime = estimator.getTravelTime(kb, agent, localDist);
        return travelTime;
    }

    public DoorDir getLocalDoorDirection(Estimate.DoorToGoalValue globalTargetDist) {
        DoorDir dir = globalTargetDist.getDir(this.door);
        assert (dir != null);
        return dir;
    }

    public String toString() {
        return this.door.name;
    }
}

