/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.IAgentBodyShape;
import inferno.data2.PolygonShape;
import inferno.sim.OccAgent;

public class BehaviorWeights {
    public double seek;
    public double avoidOccs;
    public double avoidWalls;
    public double avoidObstacles;
    public double seekSep;
    public double socialDist;
    public double seekWallSep;
    public double laneBehavior;
    public double cornerBehavior;
    public double pass;

    public BehaviorWeights(OccAgent oa, IAgentBodyShape shape, boolean isSocialDistancing) {
        this.seek = Prefs.SEEK.def;
        this.avoidOccs = Prefs.AVOIDOCCS.def;
        this.avoidWalls = Prefs.AVOIDWALLS.def;
        this.avoidObstacles = Prefs.AVOIDOBSTACLES.def;
        this.seekSep = Prefs.SEEKSEP.def;
        this.socialDist = Prefs.SOCIALDIST.def;
        this.seekWallSep = Prefs.SEEKWALLSEP.def;
        this.laneBehavior = Prefs.LANEBEHAVIOR.def;
        this.cornerBehavior = Prefs.CORNERBEHAVIOR.def;
        this.pass = Prefs.PASS.def;
        if (shape instanceof PolygonShape) {
            this.seekSep = 1.5;
            this.socialDist = 1.5;
            this.cornerBehavior = 0.0;
        }
        if (oa.getOcc().occupantGroup != null && oa.getOcc().occupantGroup.getCurrentSize() > 1) {
            this.pass = 0.1;
        }
        if (oa.getOcc().occupantGroup != null && oa.getOcc().occupantGroup.getCurrentSize() > 1 && oa.getOcc().occupantGroup.getCurrentMaxDist() <= 1.0) {
            this.seekSep = 0.1;
            this.avoidOccs = 0.1;
        } else if (isSocialDistancing) {
            this.seekSep *= 0.25;
        }
        if (oa.getLoc().tri.getSpeedModifier().getTerrainSpeed() != 0.0) {
            this.avoidWalls = 0.0;
            this.seekWallSep = 0.0;
        }
        if (oa.getOcc().qpath != null) {
            this.seekSep = 0.2;
            this.pass = 0.01;
            this.avoidOccs = oa.getOcc().qpath.isForceFollowPath() ? 0.01 : 0.1;
        }
    }

    public static enum Prefs {
        SEEK("seek", 0.5),
        AVOIDOCCS("avoidOccs", 1.0),
        AVOIDWALLS("avoidWalls", 1.0),
        AVOIDOBSTACLES("avoidObstacles", 5.0),
        SEEKSEP("seekSep", 2.0),
        SOCIALDIST("socialDist", 4.0),
        SEEKWALLSEP("seekWallSep", 1.0),
        LANEBEHAVIOR("laneBehavior", 1.0),
        CORNERBEHAVIOR("cornerBehavior", 0.2),
        PASS("pass", 0.5);

        public final double def;

        private Prefs(String key, double defVal) {
            key = "bw." + key;
            String sval = System.getProperty(key);
            if (sval != null) {
                try {
                    defVal = Double.parseDouble(sval);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.def = defVal;
        }
    }
}

