/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;

public class Steer
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final IPostOp NOOP = new NoOp();
    public final Vector3d vel;
    public final Vector3d goalOrient;
    public final double turnVel;
    public final double priority;
    public final double squeezeFactor;
    public final OccAgent[] avoidOccs;
    public final Predicate<OccAgent> collisionFilter;
    public final IPostOp postOp;
    public final Object meta;
    public final boolean tightGeometry;
    public final boolean collidable;

    public Steer(Object meta, Vector3d vel, Vector3d goalOrient, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, boolean collidable, OccAgent ... avoidOccs) {
        this(meta, vel, goalOrient, Double.NaN, priority, squeezeFactor, collisionFilter, tightGeometry, collidable, NOOP, avoidOccs);
    }

    public Steer(Object meta, Vector3d vel, double turnVel, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, boolean collidable, OccAgent ... avoidOccs) {
        this(meta, vel, null, turnVel, priority, squeezeFactor, collisionFilter, tightGeometry, collidable, NOOP, avoidOccs);
    }

    private Steer(Object meta, Vector3d vel, Vector3d goalOrient, double turnVel, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, boolean collidable, IPostOp postOp, OccAgent ... avoidOccs) {
        this.vel = vel;
        this.goalOrient = goalOrient;
        this.turnVel = turnVel;
        this.priority = priority;
        this.squeezeFactor = squeezeFactor;
        this.avoidOccs = avoidOccs;
        this.collisionFilter = collisionFilter;
        this.postOp = postOp;
        this.meta = meta;
        this.collidable = collidable;
        this.tightGeometry = tightGeometry;
    }

    public Steer applyPostOp(IPostOp op) {
        return new Steer(this.meta, this.vel, this.goalOrient, this.turnVel, this.priority, this.squeezeFactor, this.collisionFilter, this.tightGeometry, this.collidable, (IPostOp)this.postOp.andThen((BiConsumer)op), this.avoidOccs);
    }

    public Steer applyAvoidOccs(OccAgent ... avoidOccs) {
        return new Steer(this.meta, this.vel, this.goalOrient, this.priority, this.squeezeFactor, this.collisionFilter, this.tightGeometry, this.collidable, avoidOccs);
    }

    private static final class AndThenOp
    implements IPostOp {
        static final long serialVersionUID = 1L;
        public final IPostOp prev;
        public final IPostOp next;

        public AndThenOp(IPostOp prev, IPostOp next) {
            this.prev = prev;
            this.next = next;
        }

        @Override
        public void accept(KB t, OccAgent u) {
            this.prev.accept(t, u);
            this.next.accept(t, u);
        }
    }

    private static final class NoOp
    implements IPostOp {
        static final long serialVersionUID = 1L;

        private NoOp() {
        }

        @Override
        public void accept(KB t, OccAgent u) {
        }

        @Override
        public IPostOp andThen(BiConsumer<? super KB, ? super OccAgent> after) {
            assert (after instanceof IPostOp);
            return (IPostOp)after;
        }
    }

    public static interface IPostOp
    extends BiConsumer<KB, OccAgent>,
    Serializable {
        default public IPostOp andThen(BiConsumer<? super KB, ? super OccAgent> after) {
            if (!2.$assertionsDisabled && !(after instanceof IPostOp)) {
                throw new AssertionError();
            }
            return new AndThenOp(this, (IPostOp)after);
        }

        static {
            if (2.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

