/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.scripting.AgentsApi;
import inferno.sim.scripting.GeomApi;
import inferno.sim.scripting.IoApi;
import inferno.sim.scripting.SimulationControlApi;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptHandler {
    private ScriptEngine d_nashornJsEngine;
    private Api d_api;
    private Engine d_pthEngine;

    public ScriptHandler(Engine e, KB kb) {
        this.d_pthEngine = e;
        ScriptEngineManager factory = new ScriptEngineManager();
        this.d_nashornJsEngine = factory.getEngineByName("JavaScript");
        this.d_api = new Api(kb);
        this.d_nashornJsEngine.put("api", this.d_api);
    }

    public void init(String script) {
        try {
            this.d_nashornJsEngine.eval(script);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public void invokeCallbacks(String method) {
        if ("onUpdate".equals(method)) {
            this.d_api.simctl.invokeCallbacksOnUpdate();
        } else if ("onExit".equals(method)) {
            this.d_api.simctl.invokeCallbacksOnExit();
        }
    }

    public static class Api {
        public final GeomApi geometry;
        public final SimulationControlApi simctl;
        public final AgentsApi agents;
        public final IoApi io;

        public Api(KB kb) {
            this.geometry = new GeomApi(kb);
            this.simctl = new SimulationControlApi(kb);
            this.agents = new AgentsApi(kb);
            this.io = new IoApi(kb);
        }
    }
}

