/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.profiling;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

public class TimeAccumSingleThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Thread d_thread = null;
    private AccumNode d_root;
    private AccumNode d_currentNode;
    private Deque<AccumNode> d_rollback = new ArrayDeque<AccumNode>();
    private boolean d_ignore = false;

    public TimeAccumSingleThread() {
        this.d_currentNode = this.d_root = new AccumNode("", null);
    }

    public void setIgnore(boolean flag) {
        this.d_ignore = flag;
    }

    public void pushRollback() {
        if (this.d_ignore) {
            return;
        }
        this.d_rollback.push(this.d_currentNode);
    }

    public void execRollback() {
        if (this.d_ignore) {
            return;
        }
        AccumNode target = this.d_rollback.pop();
        while (this.d_currentNode != target) {
            this.end(this.d_currentNode.getId());
        }
    }

    private void enforceSingleThreadRule() {
        if (this.d_thread == null) {
            this.d_thread = Thread.currentThread();
        }
        if (this.d_thread != Thread.currentThread()) {
            String msg = String.format("ST Accumulator called by unexpected thread. caller=%s expected=%s", Thread.currentThread().getName(), this.d_thread.getName());
            throw new IllegalStateException(msg);
        }
    }

    public void begin(String id) {
        if (this.d_ignore) {
            return;
        }
        this.d_currentNode = this.d_currentNode.getChildNode(id);
        this.d_currentNode.begin();
    }

    public void end(String id) {
        if (this.d_ignore) {
            return;
        }
        if (id == null || !id.equals(this.d_currentNode.getId())) {
            throw new IllegalArgumentException("id=" + id + " expected: " + this.d_currentNode.getId());
        }
        this.d_currentNode.end();
        this.d_currentNode = this.d_currentNode.getParentNode();
    }

    public void endAll() {
        while (this.d_currentNode != this.d_root) {
            this.end(this.d_currentNode.getId());
        }
    }

    public void printSummary(PrintStream out) {
        if (this.d_currentNode != this.d_root) {
            System.err.println("Profiling incomplete. Invoking endAll().");
            this.endAll();
        }
        for (AccumNode node : this.d_root.getAllChildNodes()) {
            AccumNode accumNode = this.d_root;
            accumNode.d_timeAccumNanos = accumNode.d_timeAccumNanos + node.d_timeAccumNanos;
        }
        for (AccumNode node : this.d_root.getAllChildNodes()) {
            this.printSummaryNode(out, node, 0);
        }
    }

    public double getTimeInSeconds(String id) {
        ArrayDeque<AccumNode> fifo = new ArrayDeque<AccumNode>();
        fifo.add(this.d_root);
        while (!fifo.isEmpty()) {
            AccumNode current = (AccumNode)fifo.removeFirst();
            if (current.getId().equals(id)) {
                return (double)current.getAccumulatedTime() / 1.0E9;
            }
            for (AccumNode node : current.getAllChildNodes()) {
                fifo.add(node);
            }
        }
        return 0.0;
    }

    private void printSummaryNode(PrintStream out, AccumNode node, int depth) {
        long uncountedNanos;
        long accumNanos = node.getAccumulatedTime();
        long parentNanos = node.getParentNode() != null ? node.getParentNode().getAccumulatedTime() : accumNanos;
        this.printSummaryLine(out, node.getId(), parentNanos, accumNanos, depth);
        long sumChilds = 0L;
        for (AccumNode child : node.getAllChildNodes()) {
            this.printSummaryNode(out, child, depth + 1);
            sumChilds += child.getAccumulatedTime();
        }
        if (!node.getAllChildNodes().isEmpty() && sumChilds < accumNanos && accumNanos < 100L * (uncountedNanos = accumNanos - sumChilds)) {
            this.printSummaryLine(out, "*", accumNanos, uncountedNanos, depth + 1);
        }
    }

    private void printSummaryLine(PrintStream out, String id, long parent, long self, int leftPad) {
        String pad = 0 < (leftPad *= 3) ? String.format("%1$" + leftPad + "s", " ") : "";
        double fractionOfParent = (double)self / (double)parent;
        String paddedName = pad + id;
        String paddedPct = pad + String.format("%.1f%%", fractionOfParent * 100.0);
        out.printf("%-30s %s%n", paddedName, paddedPct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        Object bigDave;
        TimeAccumSingleThread ticks = new TimeAccumSingleThread();
        Object object = bigDave = new Object();
        synchronized (object) {
            ticks.begin("loop");
            for (int i = 0; i < 10; ++i) {
                ticks.begin("a");
                bigDave.wait(1L);
                ticks.begin("1");
                bigDave.wait(1L);
                ticks.end("1");
                ticks.begin("2");
                bigDave.wait(1L);
                ticks.end("2");
                ticks.end("a");
                ticks.begin("b");
                bigDave.wait(3L);
                ticks.end("b");
            }
            ticks.end("loop");
        }
        ticks.printSummary(System.err);
    }

    private class AccumNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String d_id;
        private AccumNode d_parent;
        private Map<String, AccumNode> d_children;
        private long d_timeAccumNanos;
        private long d_tStart;
        private long d_count;

        public AccumNode(String id, AccumNode parent) {
            this.d_id = id;
            this.d_parent = parent;
            this.d_children = Collections.EMPTY_MAP;
        }

        public String getId() {
            return this.d_id;
        }

        public AccumNode getChildNode(String id) {
            if (!this.d_children.containsKey(id)) {
                AccumNode child = new AccumNode(id, this);
                if (this.d_children.isEmpty()) {
                    this.d_children = new LinkedHashMap<String, AccumNode>();
                }
                this.d_children.put(id, child);
            }
            return this.d_children.get(id);
        }

        public Collection<AccumNode> getAllChildNodes() {
            return this.d_children.values();
        }

        public AccumNode getParentNode() {
            return this.d_parent;
        }

        public void begin() {
            this.d_tStart = System.nanoTime();
        }

        public void end() {
            ++this.d_count;
            this.d_timeAccumNanos += System.nanoTime() - this.d_tStart;
        }

        public long getAccumulatedTime() {
            return this.d_timeAccumNanos;
        }

        public long getCount() {
            return this.d_count;
        }
    }
}

