/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.InfernoPrefs;
import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Tag;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.OccStats;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.TsvOutput;
import inferno.sim.profiling.TimeAccum;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import merlin.Intl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.SystemProps;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class SummaryWriter {
    private static final Logger LOGGER = Logger.getLogger(SummaryWriter.class.getName());
    private static final NumberFormat formatter = new DecimalFormat("#0.00");

    public static void printSummary(KB kb, TimeAccum timeAccum) throws FileNotFoundException {
        try (PrintStream stream = Output.openTxtStream(kb.getParams().out_summary);){
            SummaryWriter.printSummary(stream, kb, true, timeAccum);
        }
    }

    public static void logSummary(Logger logger, KB kb, TimeAccum timeAccum) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            String charset = "UTF-8";
            PrintStream pstream = new PrintStream((OutputStream)stream, false, charset);
            SummaryWriter.printSummary(pstream, kb, false, timeAccum);
            pstream.flush();
            LOGGER.info(new String(stream.toByteArray(), charset));
        }
    }

    public static void printSummary(PrintStream strm, KB kb, boolean longform, TimeAccum timeAccum) {
        int usage;
        OccStats stats = kb.getOccStats();
        Function<OccAgent, String> printAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        strm.println();
        strm.println(Intl.intl("***SUMMARY***SUMMARY***SUMMARY***SUMMARY***SUMMARY***"));
        strm.println();
        strm.printf(Intl.intl("Simulation:         %s%n"), SummaryWriter.getBaseName(kb));
        strm.printf(Intl.intl("Version:            %s%n"), "2022.3.1207");
        strm.printf(Intl.intl("Mode:               %s%n"), SummaryWriter.getModeDesc(kb));
        strm.printf(Intl.intl("Total Occupants:    %d%n"), kb.getOccs().size());
        strm.println();
        Collection<Tag> completionTags = kb.getCompletionTags();
        List<OccAgent> completedAgents = theUtil.map(kb.getCompletedOccs(), p -> (OccAgent)p.v1);
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            strm.printf(Intl.intl("  Completed:          %d%n"), completed);
            strm.printf(Intl.intl("  Did not Complete:   %d (excluded from summary tables)%n"), didNotComplete);
        }
        strm.println();
        OccStats.ValueFunction<OccAgent> compTime = oa -> kb.getTagTime((OccAgent)oa, completionTags);
        OccStats.QuantityStats<OccAgent> compTimes = OccStats.QuantityStats.getStats(completedAgents, compTime);
        strm.printf(Intl.intl("Completion Times for All Occupants (s):%n"), new Object[0]);
        strm.printf(Intl.intl("  Min:              %5.1f %s%n"), compTimes.min, printAgent.apply((OccAgent)compTimes.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f %s%n"), compTimes.max, printAgent.apply((OccAgent)compTimes.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), compTimes.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), compTimes.stddev);
        strm.println();
        Function groupByBehavior = oa -> Collections.singleton(oa.getOcc().behavior);
        Function groupByProfile = oa -> Collections.singleton(oa.getOcc().parentProfile);
        strm.println(Intl.intl("Completion Times by Behavior (s):"));
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, b -> b.name, (oa, behavior) -> compTime.getValue((OccAgent)oa), compTime), Intl.intl("Behavior"));
        strm.println(Intl.intl("Completion Times by Profile (s):"));
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, p -> p.getName(), (oa, behavior) -> compTime.getValue((OccAgent)oa), compTime), Intl.intl("Profile"));
        OccStats.QuantityStats<OccAgent> travelDistances = stats.getTravelDistanceStats(kb);
        strm.printf(Intl.intl("Travel Distances for All Occupants (m):%n"), new Object[0]);
        strm.printf(Intl.intl("  Min:              %5.1f %s%n"), travelDistances.min, printAgent.apply((OccAgent)travelDistances.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f %s%n"), travelDistances.max, printAgent.apply((OccAgent)travelDistances.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), travelDistances.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), travelDistances.stddev);
        strm.println();
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        strm.printf(Intl.intl("Movement Distance by Behavior (m):%n"), new Object[0]);
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, b -> b.name, (oa, profile) -> travelDist.getValue((OccAgent)oa), travelDist), Intl.intl("Behavior"));
        strm.printf(Intl.intl("Movement Distance by Profile (m):%n"), new Object[0]);
        SummaryWriter.printTsvReport(strm, new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, p -> p.getName(), (oa, profile) -> travelDist.getValue((OccAgent)oa), travelDist), Intl.intl("Profile"));
        if (!longform) {
            return;
        }
        double startup_time = timeAccum.getTime("STARTUP");
        double cpu_time = timeAccum.getTime("SIMULATION");
        strm.printf(Intl.intl("[Components] All:   %d%n"), kb.getNodes().size());
        strm.printf(Intl.intl("[Components] Doors: %d%n"), kb.getDoorNodes().size());
        strm.printf(Intl.intl("Triangles:          %d%n"), kb.getMesh().getTris().length);
        if (SystemProps.get(InfernoPrefs.INCLUDE_TOUT).booleanValue()) {
            strm.printf(Intl.intl("Startup Time:       %1.1fs%n"), startup_time);
            strm.printf(Intl.intl("CPU Time:           %1.1fs%n"), cpu_time);
        }
        strm.println();
        if (!kb.getAllAttractors().isEmpty()) {
            strm.println();
            strm.println(Intl.intl("Attractor Usage Times (s):"));
            SummaryWriter.printTsvReport(strm, SummaryWriter.getAttrGroupStatInfo(kb), Intl.intl("Attractor"));
            strm.println();
        }
        if (!kb.getOccTargets().getAll().isEmpty()) {
            strm.println();
            strm.println(Intl.intl("Occupant Target Active Usage Times (s):"));
            SummaryWriter.printTsvReport(strm, SummaryWriter.getActiveOccTargetGroupStats(kb), Intl.intl("Occupant Target"));
            strm.println();
            strm.println(Intl.intl("Occupant Target Reserved Times (s):"));
            SummaryWriter.printTsvReport(strm, SummaryWriter.getReservedOccTargetGroupStats(kb), Intl.intl("Occupant Target"));
            strm.println();
        }
        strm.println(Intl.intl("Door Flow Rates:"));
        TsvOutput doorFlowRates = new TsvOutput();
        doorFlowRates.addRow(new String[]{Intl.intl("Door"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use"), Intl.intl("Flow_Avg")});
        doorFlowRates.addRow(new String[]{"", "(s)", "(s)", "", "(pers)", "(pers/s)"});
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "         ";
            if (1.0 < tLast - tFirst) {
                flow = String.format("%9.2f", (double)usage / (tLast - tFirst));
            }
            doorFlowRates.addRow(new String[]{n.annotatedName, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage), flow});
        }
        strm.println(doorFlowRates.toString());
        strm.println(Intl.intl("Room Usage:"));
        TsvOutput roomUsage = new TsvOutput();
        roomUsage.addRow(new String[]{Intl.intl("Room"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use")});
        roomUsage.addRow(new String[]{"", "(s)", "(s)", "", "(pers)"});
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            roomUsage.addRow(new String[]{n.annotatedName, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage)});
        }
        strm.println(roomUsage.toString());
    }

    private static <T> GroupStatInfo<T> getGroupStatInfoFromTimeMap(KB kb, String allStr, String noneStr, Function<OccStats.PerAgentData, Map<T, Double>> getMap, Function<T, String> getName) {
        return new GroupStatInfo<Object>(allStr, kb.getAllAgentsEver(), oa -> ((Map)getMap.apply(oa.getStats())).isEmpty() ? Collections.singleton(null) : ((Map)getMap.apply(oa.getStats())).keySet(), attr -> attr != null ? (String)getName.apply(attr) : noneStr, (oa, attr) -> attr != null ? ((Map)getMap.apply(oa.getStats())).getOrDefault(attr, 0.0) : Double.valueOf(kb.getOccStats().getExistanceTime(kb, (OccAgent)oa)), oa -> SummaryWriter.getTotalTime((Map)getMap.apply(oa.getStats())));
    }

    private static double getTotalTime(Map<?, Double> timeMap) {
        return timeMap.values().stream().mapToDouble(d -> d).sum();
    }

    private static GroupStatInfo<AttractorSim> getAttrGroupStatInfo(KB kb) {
        return SummaryWriter.getGroupStatInfoFromTimeMap(kb, Intl.intl("*all used attractors*"), Intl.intl("*no attractors*"), stats -> stats.attractorTime, attr -> attr.name);
    }

    private static GroupStatInfo<OccTarget> getActiveOccTargetGroupStats(KB kb) {
        return SummaryWriter.getOccTargetGroupStats(kb, stats -> stats.occTargetTimeActive);
    }

    private static GroupStatInfo<OccTarget> getReservedOccTargetGroupStats(KB kb) {
        return SummaryWriter.getOccTargetGroupStats(kb, stats -> stats.occTargetTimeReserved);
    }

    private static GroupStatInfo<OccTarget> getOccTargetGroupStats(KB kb, Function<OccStats.PerAgentData, Map<OccTarget, Double>> getMap) {
        return SummaryWriter.getGroupStatInfoFromTimeMap(kb, Intl.intl("*all used occupant targets*"), Intl.intl("*no occupant targets*"), getMap, target -> target.name);
    }

    private static <GroupT> void printTsvReport(PrintStream strm, GroupStatInfo<GroupT> gi, String typeName) {
        Function<OccAgent, String> quoteAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        String[] statCols = new String[]{typeName, Intl.intl("Count"), Intl.intl("Min"), Intl.intl("Min_Name"), Intl.intl("Max"), Intl.intl("Max_Name"), Intl.intl("Avg"), Intl.intl("StdDev")};
        Map groups = SummaryWriter.getReportingGroups(gi.agents, gi.groupFunc, gi.groupFormatter);
        TsvOutput tsv = new TsvOutput();
        tsv.addRow(statCols);
        TriConsumer<String, Collection, OccStats.QuantityStats> addStats = (groupName, groupAgents, result) -> {
            tsv.addRow(new String[]{groupName, Integer.toString(groupAgents.size()), String.format("%.1f", result.min), (String)quoteAgent.apply((OccAgent)result.minElement), String.format("%.1f", result.max), (String)quoteAgent.apply((OccAgent)result.maxElement), String.format("%.1f", result.avg), String.format("%.1f", result.stddev)});
            if (result.min == 0.0) {
                LOGGER.log(Level.INFO, "...");
            }
        };
        ArrayList<OccStats.QuantityStats<OccAgent>> allStats = new ArrayList<OccStats.QuantityStats<OccAgent>>(groups.size());
        for (Map.Entry entry : groups.entrySet()) {
            Object group = entry.getKey();
            OccStats.QuantityStats<OccAgent> result2 = OccStats.QuantityStats.getStats(entry.getValue(), oa -> groupStatInfo.valueFunc.apply((OccAgent)oa, group));
            allStats.add(result2);
            addStats.accept(gi.groupFormatter.apply(group), entry.getValue(), result2);
        }
        addStats.accept(gi.allName, gi.agents, OccStats.QuantityStats.getStats(gi.agents, gi.getAllStats));
        strm.println(tsv.toString());
    }

    public static void printSummaryJson(KB kb, TimeAccum timeAccum) throws FileNotFoundException {
        try (PrintStream strmSummary = Output.openTxtStream(kb.getParams().out_summary_json);){
            JSONObject obj = SummaryWriter.getSummaryAsJson(kb, timeAccum);
            strmSummary.println(obj.toJSONString());
        }
    }

    private static String printAgent(OccAgent a) {
        return a != null ? a.getName() : "";
    }

    public static JSONObject getSummaryAsJson(KB kb, TimeAccum timeAccum) {
        int usage;
        JSONObject obj = new JSONObject();
        obj.put("simulation", SummaryWriter.getBaseName(kb));
        obj.put("version", "2022.3.1207");
        obj.put("mode", SummaryWriter.getModeDesc(kb));
        obj.put("total_occupants", kb.getOccs().size());
        obj.put("components_all", kb.getNodes().size());
        obj.put("components_doors", kb.getDoorNodes().size());
        obj.put("triangles", kb.getMesh().getTris().length);
        obj.put("startup_time", String.format("%1.1f", timeAccum.getTime("STARTUP")));
        obj.put("cpu_time", String.format("%1.1f", timeAccum.getTime("SIMULATION")));
        Collection<Tag> completionTags = kb.getCompletionTags();
        List<OccAgent> completedAgents = theUtil.map(kb.getCompletedOccs(), p -> (OccAgent)p.v1);
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            obj.put("Completed", completed);
            obj.put("Did not Complete", didNotComplete);
        }
        OccStats.ValueFunction<OccAgent> compTime = oa -> kb.getTagTime((OccAgent)oa, completionTags);
        SummaryWriter.addStatsReportJson(obj, kb, "completion_times_all", "time", OccStats.QuantityStats.getStats(completedAgents, compTime));
        Function groupByBehavior = oa -> Collections.singleton(oa.getOcc().behavior);
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("completion_times_behavior", "behavior", "time"), new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, b -> b.name, (oa, group) -> compTime.getValue((OccAgent)oa), compTime));
        Function groupByProfile = oa -> Collections.singleton(oa.getOcc().parentProfile);
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("completion_times_profile", "profile", "time"), new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, p -> p.getName(), (oa, group) -> compTime.getValue((OccAgent)oa), compTime));
        SummaryWriter.addStatsReportJson(obj, kb, "movement_distances_all", "distance", kb.getOccStats().getTravelDistanceStats(kb));
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("movement_distances_behavior", "behavior", "distance"), new GroupStatInfo<BehaviorSim>(Intl.intl("*all behaviors*"), completedAgents, groupByBehavior, b -> b.name, (oa, group) -> travelDist.getValue((OccAgent)oa), travelDist));
        SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("movement_distance_profile", "profile", "distance"), new GroupStatInfo<OccProfileSim>(Intl.intl("*all profiles*"), completedAgents, groupByProfile, p -> p.getName(), (oa, group) -> travelDist.getValue((OccAgent)oa), travelDist));
        if (!kb.getAllAttractors().isEmpty()) {
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("attractor_usage_time", "attractor", "time"), SummaryWriter.getAttrGroupStatInfo(kb));
        }
        if (!kb.getOccTargets().getAll().isEmpty()) {
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("occupant_locations_active_usage_time", "occupant_location", "time"), SummaryWriter.getActiveOccTargetGroupStats(kb));
            SummaryWriter.addGroupStatsReportJson(obj, new StatsKeys("occupant_locations_reserved_time", "occupant_location", "time"), SummaryWriter.getReservedOccTargetGroupStats(kb));
        }
        JSONArray dfrArray = new JSONArray();
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "";
            if (1.0 < tLast - tFirst) {
                flow = formatter.format((double)usage / (tLast - tFirst));
            }
            JSONObject doorFlowRateItems = new JSONObject();
            doorFlowRateItems.put("door", n.annotatedName);
            doorFlowRateItems.put("first_in", formatter.format(tFirst));
            doorFlowRateItems.put("last_out", formatter.format(tLast));
            doorFlowRateItems.put("last_out_name", nLast != null ? nLast : "");
            doorFlowRateItems.put("total_use", usage);
            doorFlowRateItems.put("flow_avg", flow);
            dfrArray.add(doorFlowRateItems);
        }
        obj.put("door_flow_rates", dfrArray);
        JSONArray ruArray = new JSONArray();
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            JSONObject roomUsageItems = new JSONObject();
            roomUsageItems.put("room", n.annotatedName);
            roomUsageItems.put("first_in", formatter.format(tFirst));
            roomUsageItems.put("last_out", formatter.format(tLast));
            roomUsageItems.put("last_out_name", nLast != null ? nLast : "     ");
            roomUsageItems.put("total_use", usage);
            ruArray.add(roomUsageItems);
        }
        obj.put("room_usage", ruArray);
        return obj;
    }

    private static void addStatsReportJson(JSONObject obj, KB kb, String statsName, String quantityName, OccStats.QuantityStats<OccAgent> travelDistances) {
        JSONObject moveDistance = new JSONObject();
        JSONObject moveDistanceItems = new JSONObject();
        JSONObject movemin = new JSONObject();
        JSONObject moveminItems = new JSONObject();
        moveminItems.put(quantityName, formatter.format(travelDistances.min));
        moveminItems.put("name", SummaryWriter.printAgent((OccAgent)travelDistances.minElement));
        movemin.put("min", moveminItems);
        moveDistanceItems.putAll(movemin);
        JSONObject movemax = new JSONObject();
        JSONObject movemaxItems = new JSONObject();
        movemaxItems.put(quantityName, formatter.format(travelDistances.max));
        movemaxItems.put("name", SummaryWriter.printAgent((OccAgent)travelDistances.maxElement));
        movemax.put("max", movemaxItems);
        moveDistanceItems.putAll(movemax);
        moveDistanceItems.put("average", formatter.format(travelDistances.avg));
        moveDistanceItems.put("stdDev", formatter.format(travelDistances.stddev));
        moveDistance.put(statsName, moveDistanceItems);
        obj.putAll(moveDistance);
    }

    private static <GroupT> void addGroupStatsReportJson(JSONObject obj, StatsKeys statsKeys, GroupStatInfo<GroupT> gi) {
        JSONArray groupArray = new JSONArray();
        Map groupsB = SummaryWriter.getReportingGroups(gi.agents, gi.groupFunc, gi.groupFormatter);
        TriConsumer<String, Collection, OccStats.QuantityStats> addEntry = (groupName, groupAgents, gStats) -> {
            JSONObject minItems = new JSONObject();
            minItems.put(statsKeys.quantityName, formatter.format(gStats.min));
            minItems.put("name", SummaryWriter.printAgent((OccAgent)gStats.minElement));
            JSONObject maxItems = new JSONObject();
            maxItems.put(statsKeys.quantityName, formatter.format(gStats.max));
            maxItems.put("name", SummaryWriter.printAgent((OccAgent)gStats.maxElement));
            JSONObject completeTimeBehaviorItems = new JSONObject();
            completeTimeBehaviorItems.put(statsKeys.groupType, groupName);
            completeTimeBehaviorItems.put("count", groupAgents.size());
            completeTimeBehaviorItems.put("min", minItems);
            completeTimeBehaviorItems.put("max", maxItems);
            completeTimeBehaviorItems.put("avg", formatter.format(gStats.avg));
            completeTimeBehaviorItems.put("stdDev", formatter.format(gStats.stddev));
            groupArray.add(completeTimeBehaviorItems);
        };
        for (Map.Entry entry : groupsB.entrySet()) {
            Object group = entry.getKey();
            OccStats.QuantityStats<OccAgent> groupStats = OccStats.QuantityStats.getStats(entry.getValue(), oa -> groupStatInfo.valueFunc.apply((OccAgent)oa, group));
            addEntry.accept(gi.groupFormatter.apply(group), entry.getValue(), groupStats);
        }
        addEntry.accept(gi.allName, gi.agents, OccStats.QuantityStats.getStats(gi.agents, gi.getAllStats));
        obj.put(statsKeys.category, groupArray);
    }

    private static <GroupT> Map<GroupT, Collection<OccAgent>> getReportingGroups(Collection<OccAgent> completedAgents, Function<OccAgent, Collection<GroupT>> groupFunc, Function<GroupT, String> groupFormatter) {
        IdentityHashMap<Object, List> groups = new IdentityHashMap<Object, List>();
        for (OccAgent oa : completedAgents) {
            Collection<GroupT> names = groupFunc.apply(oa);
            for (GroupT name : names) {
                groups.computeIfAbsent(name, key -> new ArrayList()).add(oa);
            }
        }
        ArrayList names = new ArrayList(groups.keySet());
        Collections.sort(names, (g1, g2) -> {
            if (g1 == g2) {
                return 0;
            }
            if (g1 == null) {
                return 1;
            }
            if (g2 == null) {
                return -1;
            }
            return ((String)groupFormatter.apply(g1)).compareTo((String)groupFormatter.apply(g2));
        });
        LinkedIdentityHashMap sortedGroups = new LinkedIdentityHashMap();
        for (Object name : names) {
            sortedGroups.put(name, groups.remove(name));
        }
        return sortedGroups;
    }

    private static String getBaseName(KB kb) {
        String name = kb.getParams().out_snapshot_base;
        name = name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
        return name;
    }

    private static String getModeDesc(KB d_kb) {
        Param d_param = d_kb.getParams();
        if (d_param.reactive_steering) {
            if (d_kb.getQueuingDoors().size() == d_kb.getDoorNodes().size()) {
                return Intl.intl("Steering (Flow-limited)");
            }
            return Intl.intl("Steering");
        }
        return d_param.handle_collisions ? Intl.intl("SFPE (Prevent Collisions)") : Intl.intl("SFPE (Basic)");
    }

    private static class StatsKeys {
        public final String category;
        public final String groupType;
        public final String quantityName;

        public StatsKeys(String category, String groupType, String quantName) {
            this.category = category;
            this.groupType = groupType;
            this.quantityName = quantName;
        }
    }

    private static class GroupStatInfo<GroupT> {
        public final String allName;
        public final Collection<OccAgent> agents;
        public final Function<OccAgent, Collection<GroupT>> groupFunc;
        public final Function<GroupT, String> groupFormatter;
        public final BiFunction<OccAgent, ? super GroupT, Double> valueFunc;
        public final OccStats.ValueFunction<OccAgent> getAllStats;

        public GroupStatInfo(String allName, Collection<OccAgent> agents, Function<OccAgent, Collection<GroupT>> groupFunc, Function<GroupT, String> groupFormatter, BiFunction<OccAgent, ? super GroupT, Double> valueFunc, OccStats.ValueFunction<OccAgent> getAllStats) {
            this.allName = allName;
            this.agents = agents;
            this.groupFunc = groupFunc;
            this.groupFormatter = groupFormatter;
            this.valueFunc = valueFunc;
            this.getAllStats = getAllStats;
        }
    }
}

