/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.OccAnim;
import inferno.data2.Occupant;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.ai.ControlledOccGoal;
import inferno.data2.ai.IGoal;
import inferno.sim.BehaviorSim;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.ObjectTracker;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccTracker;
import inferno.sim.VehicleBody;
import inferno.sim.output.AVisWriter;
import java.awt.Color;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Color3b;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class OccVisWriter
extends AVisWriter
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int DEFAULT_AGENT_BLOCK_SIZE = 134000;
    private static final int VERSION = 19;
    private static final int FLAGS = 0;
    public static final int OCCPROP_DONE = 0;
    public static final int OCCPROP_RADIUS = 1;
    @Deprecated
    public static final int OCCPROP_COLOR = 2;
    public static final int OCCPROP_SEED = 3;
    public static final int OCCPROP_MODELID = 4;
    public static final int OCCPROP_HEIGHT = 5;
    public static final int OCCPROP_OPTIONS = 6;
    public static final int OCCPROP_MAXVEL = 7;
    public static final int OCCPROP_SHAPE = 8;
    public static final int OCCPROP_VISIBILITY = 9;
    public static final int OCCPROP_VIRTUALID = 10;
    @Deprecated
    public static final int OCCPROP_GROUP_COLOR = 11;
    @Deprecated
    public static final int OCCPROP_GROUP_TEMPLATE_COLOR = 12;
    @Deprecated
    public static final int OCCPROP_BEHAVIOR_COLOR = 13;
    @Deprecated
    public static final int OCCPROP_PROFILE_COLOR = 14;
    public static final int OCCPROP_IS_HUMANOID = 15;
    public static final int OCCPROP_REALISTIC_SHAPE = 16;
    public static final int VIS_HUMAN_NO_H_AVATAR_NO_V_AVATAR = OccVisWriter.getFlags(ViewType.VT_MARKER_DIAMOND, ViewType.VT_MARKER_FLAG, ViewType.VT_SIMPLE_CYL, ViewType.VT_SIMPLE_DISKS, ViewType.VT_SIMPLE_SPHERES);
    public static final int VIS_HUMAN_NO_H_AVATAR_V_AVATAR = -1;
    public static final int VIS_HUMAN_H_AVATAR_NO_V_AVATAR = -1;
    public static final int VIS_HUMAN_H_AVATAR_V_AVATAR = -1;
    public static final int VIS_VEHICLE_NO_H_AVATAR_NO_V_AVATAR = 0;
    public static final int VIS_VEHICLE_NO_H_AVATAR_V_AVATAR = 0;
    public static final int VIS_VEHICLE_H_AVATAR_NO_V_AVATAR = 0;
    public static final int VIS_VEHICLE_H_AVATAR_V_AVATAR = OccVisWriter.getFlags(ViewType.VT_MD5_CASUAL, ViewType.VT_MD5_GENERIC);
    public static final int OPT_CONTROLLED = 1;
    public static final byte STATE_NEEDS_ASSISTANCE = 1;
    public static final Vector3d OCC_ROT_REF = GeomConstants.VEC3D_YNEG;
    private final OccTracker d_occs;
    private final RelationTracker d_relations;
    private final AVisWriter.InterleavedBlockWriter d_agentDataBlockWriter;

    private static int getFlags(ViewType ... types) {
        int flags = 0;
        for (ViewType vt : types) {
            flags |= 1 << vt.ordinal();
        }
        return flags;
    }

    public static int getHumanoidFlags(boolean hasAvatar, boolean hasVehicleAvatar) {
        if (hasAvatar && hasVehicleAvatar) {
            return VIS_HUMAN_H_AVATAR_V_AVATAR;
        }
        if (hasAvatar) {
            return VIS_HUMAN_H_AVATAR_NO_V_AVATAR;
        }
        if (hasVehicleAvatar) {
            return VIS_HUMAN_NO_H_AVATAR_V_AVATAR;
        }
        return VIS_HUMAN_NO_H_AVATAR_NO_V_AVATAR;
    }

    public static int getVehicleFlags(boolean hasAvatar, boolean hasVehicleAvatar) {
        if (hasAvatar && hasVehicleAvatar) {
            return VIS_VEHICLE_H_AVATAR_V_AVATAR;
        }
        if (hasAvatar) {
            return VIS_VEHICLE_H_AVATAR_NO_V_AVATAR;
        }
        if (hasVehicleAvatar) {
            return VIS_VEHICLE_NO_H_AVATAR_V_AVATAR;
        }
        return VIS_VEHICLE_NO_H_AVATAR_NO_V_AVATAR;
    }

    public static int getVisFlags(boolean forHuman, boolean hasRealHumanAvatar, boolean hasRealVehicleAvatar) {
        if (forHuman) {
            return OccVisWriter.getHumanoidFlags(hasRealHumanAvatar, hasRealVehicleAvatar);
        }
        return OccVisWriter.getVehicleFlags(hasRealHumanAvatar, hasRealVehicleAvatar);
    }

    public OccVisWriter(String filename, KB kb) throws FileNotFoundException {
        super(filename, 19, 0);
        this.d_occs = new OccTracker(kb);
        this.d_relations = new RelationTracker();
        this.d_agentDataBlockWriter = new AVisWriter.InterleavedBlockWriter(this, 134000);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_agentDataBlockWriter.deserialize();
    }

    @Override
    protected void writeCustomHeaderData(KB kb, DataOutputStream oos) throws IOException {
        this.d_agentDataBlockWriter.init();
    }

    public void writeFrame(KB kb, double t, List<OccAgent> activeAgents) {
        DataOutputStream oos = this.getStream();
        try {
            Set<Relation> relations = OccVisWriter.getRelations(activeAgents);
            ArrayList<OccAgent> added = new ArrayList<OccAgent>();
            ArrayList<OccAgent> removed = new ArrayList<OccAgent>();
            ArrayList<Relation> addedRelations = new ArrayList<Relation>();
            ArrayList<Relation> removedRelations = new ArrayList<Relation>();
            Object changes = this.d_occs.beginUpdate(activeAgents, added, removed);
            this.d_relations.beginUpdate(relations, addedRelations, removedRelations);
            this.writeAgentData(t, added, removed, (OccTracker.Changes)changes, addedRelations, removedRelations);
            long frameix = this.getPos();
            OccVisWriter.writeAgentUpdate(oos, this.d_occs, this.d_occs.getObjs());
            this.writeFrameIx(t, frameix);
            this.d_occs.endUpdate((Collection<? extends OccAgent>)removed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeAgentData(double time, List<OccAgent> added, List<OccAgent> removed, OccTracker.Changes changes, List<Relation> addedRelations, List<Relation> removedRelations) throws IOException {
        if (added.isEmpty() && removed.isEmpty() && changes.isEmpty()) {
            return;
        }
        this.d_agentDataBlockWriter.beginWrite();
        DataOutputStream oos = new DataOutputStream(this.d_agentDataBlockWriter);
        long statusPos = this.d_agentDataBlockWriter.getPos();
        oos.writeByte(0);
        oos.writeFloat((float)time);
        OccVisWriter.writeTrackedObjs(oos, this.d_occs, changes.addedTrackedObjs);
        OccVisWriter.writeAgentsAdded(oos, this.d_occs, added, changes.addedVehicleProxies);
        OccVisWriter.writeAgentsRemoved(oos, this.d_occs, removed, changes.removedVehicleProxies);
        OccVisWriter.writeAgentsChanged(oos, this.d_occs);
        OccVisWriter.writeRelationsAdded(oos, addedRelations);
        OccVisWriter.writeRelationsRemoved(oos, removedRelations);
        long curPos = this.d_agentDataBlockWriter.getPos();
        this.d_agentDataBlockWriter.setPos(statusPos);
        oos.writeByte(1);
        this.d_agentDataBlockWriter.setPos(curPos);
        this.d_agentDataBlockWriter.endWrite();
    }

    private static void writePoint(DataOutput os, Point3d p) throws IOException {
        os.writeFloat((float)p.x);
        os.writeFloat((float)p.y);
        os.writeFloat((float)p.z);
    }

    public static void writeShape(DataOutput os, OccTracker.ITrackerShape shape) throws IOException {
        String name = "";
        OccVisWriter.writeString(os, name);
        if (shape instanceof OccTracker.CylShape) {
            os.writeInt(ShapeType.CYL.ordinal());
            OccTracker.CylShape cyl = (OccTracker.CylShape)shape;
            os.writeFloat((float)cyl.radius);
            os.writeFloat((float)cyl.height);
        } else if (shape instanceof OccTracker.IPolyShape) {
            os.writeInt(ShapeType.POLY.ordinal());
            OccTracker.IPolyShape poly = (OccTracker.IPolyShape)shape;
            os.writeFloat((float)poly.getHeight());
            Point3d[] points = poly.getPoints();
            os.writeInt(points.length);
            for (Point3d p : points) {
                os.writeFloat((float)p.x);
                os.writeFloat((float)p.y);
            }
        } else if (shape instanceof OccTracker.RealisticShape) {
            os.writeInt(ShapeType.REALISTIC.ordinal());
            OccTracker.RealisticShape rshape = (OccTracker.RealisticShape)shape;
            OccVisWriter.writeString(os, rshape.model);
            OccVisWriter.writePoint(os, rshape.offset);
            os.writeBoolean(rshape.isHuman);
        } else assert (false);
    }

    private static void writeSharedObj(DataOutput os, OccTracker.ITrackerSharedObj obj) throws IOException {
        int m;
        OccVisWriter.writeString(os, obj.getName());
        int maxcolors = obj.getMaxNumColors();
        ArrayList<Object> colors = new ArrayList<Object>();
        int ncolors = 0;
        for (m = 0; m < maxcolors; ++m) {
            Object color = obj.getColor(m);
            colors.add(color);
            if (color == null) continue;
            ++ncolors;
        }
        os.writeInt(ncolors);
        for (m = 0; m < maxcolors; ++m) {
            Object c = colors.get(m);
            OccVisWriter.writeColor(os, m, c);
        }
    }

    private static void writeGroup(DataOutput os, OccTracker.TrackedGroup obj) throws IOException {
        OccVisWriter.writeString(os, obj.getName());
        OccVisWriter.writeColor(os, 0, ((OccGroup)obj.obj).color);
        OccVisWriter.writeColor(os, 1, ((OccGroup)obj.obj).templateColor != null ? ((OccGroup)obj.obj).templateColor : ((OccGroup)obj.obj).color);
        os.writeBoolean(((OccGroup)obj.obj).respectSocialDist);
    }

    public static void writeTrackedObjs(DataOutput os, OccTracker tracker, Collection<? extends OccTracker.ITrackerObj> objs) throws IOException {
        os.writeInt(objs.size());
        for (OccTracker.ITrackerObj iTrackerObj : objs) {
            os.writeByte(iTrackerObj.getType().ordinal());
            if (iTrackerObj instanceof OccTracker.ITrackerShape) {
                OccVisWriter.writeShape(os, (OccTracker.ITrackerShape)iTrackerObj);
                continue;
            }
            if (iTrackerObj instanceof OccTracker.TrackedGroup) {
                OccVisWriter.writeGroup(os, (OccTracker.TrackedGroup)iTrackerObj);
                continue;
            }
            if (iTrackerObj instanceof OccTracker.ITrackerSharedObj) {
                OccVisWriter.writeSharedObj(os, (OccTracker.ITrackerSharedObj)iTrackerObj);
                continue;
            }
            assert (false);
        }
    }

    private static void writeString(DataOutput os, String str) throws IOException {
        if (os instanceof INativeStream) {
            ((INativeStream)os).writeString(str);
        } else {
            os.writeChars(str);
            os.writeChar(0);
        }
    }

    private static VehicleBody getVehicle(OccAgent agent) {
        return OccTracker.getVehicleBody(agent);
    }

    public static void writeAgentsAdded(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> added, Collection<Pair<OccAgent, Integer>> addedVehicles) throws IOException {
        oos.writeInt(added.size() + addedVehicles.size());
        for (OccAgent occAgent : added) {
            OccVisWriter.writeAgentDesc(oos, occAgent, tracker, false);
        }
        for (Pair pair : addedVehicles) {
            OccAgent agent = (OccAgent)pair.v1;
            assert (OccVisWriter.getVehicle(agent) != null);
            OccVisWriter.writeAgentDesc(oos, agent, tracker, true);
        }
    }

    public static void writeAgentsChanged(DataOutputStream oos, OccTracker tracker) throws IOException {
        oos.writeInt(0);
        oos.writeInt(0);
        oos.writeInt(0);
    }

    private static void writeColor(DataOutput oos, int key, Object c) throws IOException {
        if (c instanceof Point3f) {
            OccVisWriter.writeColor(oos, key, (Point3f)c);
        } else if (c instanceof Color3b) {
            OccVisWriter.writeColor(oos, key, (Color3b)c);
        } else if (c instanceof Color) {
            OccVisWriter.writeColor(oos, key, (Color)c);
        } else assert (false);
    }

    private static void writeColor(DataOutput oos, int key, Point3f c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(c.x);
            oos.writeFloat(c.y);
            oos.writeFloat(c.z);
        }
    }

    private static void writeColor(DataOutput oos, int key, Color3b c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(theUtil.toCCf(c.x));
            oos.writeFloat(theUtil.toCCf(c.y));
            oos.writeFloat(theUtil.toCCf(c.z));
        }
    }

    private static void writeColor(DataOutput oos, int key, Color c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(theUtil.toCCf((byte)c.getRed()));
            oos.writeFloat(theUtil.toCCf((byte)c.getGreen()));
            oos.writeFloat(theUtil.toCCf((byte)c.getBlue()));
        }
    }

    protected static void writeAgentDesc(DataOutputStream oos, OccAgent agent, OccTracker tracker, boolean vehicle) throws IOException {
        Occupant occ = agent.getOcc();
        VehicleBody vehicleBody = OccVisWriter.getVehicle(agent);
        int id = vehicle ? tracker.getVehicleId(agent) : occ.id;
        oos.writeInt(id);
        OccVisWriter.writeString(oos, occ.name);
        Pair<OccTracker.ITrackerShape, Boolean> collShape = OccTracker.getTrackerShape(agent, vehicle, false);
        Pair<OccTracker.ITrackerShape, Boolean> realShape = OccTracker.getTrackerShape(agent, vehicle, true);
        oos.writeInt(15);
        oos.writeBoolean(vehicle ? false : (Boolean)realShape.v2);
        oos.writeInt(3);
        oos.writeLong(occ.rseed);
        assert (collShape.v1 != null);
        oos.writeInt(8);
        oos.writeInt(tracker.getObjId((OccTracker.ITrackerObj)collShape.v1));
        if (realShape.v1 != null) {
            oos.writeInt(16);
            oos.writeInt(tracker.getObjId((OccTracker.ITrackerObj)realShape.v1));
        }
        oos.writeInt(7);
        oos.writeFloat(agent.getOcc().maxVel);
        int options = 0;
        if (OccVisWriter.isControlled(agent)) {
            options |= 1;
        }
        if (options != 0) {
            oos.writeInt(6);
            oos.writeInt(options);
        }
        oos.writeInt(9);
        oos.writeInt(OccVisWriter.getVisFlags(vehicle, agent, vehicleBody));
        if (vehicle) {
            oos.writeInt(10);
            oos.writeInt(occ.id);
        }
        oos.writeInt(0);
    }

    private static int getVisFlags(boolean forVehicle, OccAgent agent, VehicleBody vehicleBody) {
        boolean hasAvatar = agent.getOcc().avatar != null;
        boolean hasVehicleAvatar = vehicleBody != null && vehicleBody.avatar != null;
        return OccVisWriter.getVisFlags(!forVehicle, hasAvatar, hasVehicleAvatar);
    }

    public static void writeAgentsRemoved(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> removed, Collection<Pair<OccAgent, Integer>> removedVehicles) throws IOException {
        oos.writeInt(removed.size() + removedVehicles.size());
        for (OccAgent occAgent : removed) {
            Occupant occ = occAgent.getOcc();
            oos.writeInt(occ.id);
        }
        for (Pair pair : removedVehicles) {
            oos.writeInt((Integer)pair.v2);
        }
    }

    public static void writeRelationsAdded(DataOutputStream oos, Collection<? extends Relation> added) throws IOException {
        oos.writeInt(added.size());
        for (Relation relation : added) {
            oos.writeByte(relation.type);
            oos.writeInt(relation.occ1.getId());
            oos.writeInt(relation.occ2.getId());
        }
    }

    public static void writeRelationsRemoved(DataOutputStream oos, Collection<? extends Relation> removed) throws IOException {
        oos.writeInt(removed.size());
        for (Relation relation : removed) {
            oos.writeByte(relation.type);
            oos.writeInt(relation.occ1.getId());
            oos.writeInt(relation.occ2.getId());
        }
    }

    private static boolean isControlled(OccAgent agent) {
        for (IGoal goal : agent.getOcc().behavior) {
            if (!(goal instanceof ControlledOccGoal)) continue;
            return true;
        }
        return false;
    }

    public static void writeAgentUpdate(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> agents) throws IOException {
        int nvehicles = theUtil.filter(agents, a -> OccVisWriter.getVehicle(a) != null).size();
        oos.writeInt(agents.size() + nvehicles);
        for (OccAgent occAgent : agents) {
            OccVisWriter.writeAgentFrame(oos, tracker, occAgent, false);
            if (OccVisWriter.getVehicle(occAgent) == null) continue;
            OccVisWriter.writeAgentFrame(oos, tracker, occAgent, true);
        }
    }

    private static float calcSpeed(OccAgent agent, boolean vehicle) {
        OccAnim anim;
        Occupant occ = agent.getOcc();
        OccAnim occAnim = anim = vehicle && agent.hasVehicle() ? agent.getVehicle().getAnim() : occ.anim;
        if (anim.isIdle()) {
            return 0.0f;
        }
        float speed = anim == OccAnim.MOVEFLAT ? (float)Math.sqrt(occ.vel.x * occ.vel.x + occ.vel.y * occ.vel.y) : (float)occ.vel.length();
        if (speed >= occ.terrainSpeed) {
            return speed - occ.terrainSpeed;
        }
        return 0.0f;
    }

    private static void write(DataOutputStream oos, Tuple3f t) throws IOException {
        oos.writeFloat(t.x);
        oos.writeFloat(t.y);
        oos.writeFloat(t.z);
    }

    private static void write(DataOutputStream oos, float x, float y, float z) throws IOException {
        oos.writeFloat(x);
        oos.writeFloat(y);
        oos.writeFloat(z);
    }

    private static void writef(DataOutputStream oos, Tuple3d dir) throws IOException {
        oos.writeFloat((float)dir.x);
        oos.writeFloat((float)dir.y);
        oos.writeFloat((float)dir.z);
    }

    private static void writef(DataOutputStream oos, Quat4d dir) throws IOException {
        oos.writeFloat((float)dir.x);
        oos.writeFloat((float)dir.y);
        oos.writeFloat((float)dir.z);
        oos.writeFloat((float)dir.w);
    }

    public static Quat4d convertRotation(Vector3d dir, Vector3d ref) {
        if (theUtil.eq0(dir.lengthSquared(), 1.0E-12)) {
            dir = ref;
        } else {
            dir = new Vector3d(dir);
            dir.z = 0.0;
            double ilen = 1.0 / Math.sqrt(dir.x * dir.x + dir.y * dir.y);
            dir.x *= ilen;
            dir.y *= ilen;
        }
        return Util3D.shortestArcN(ref, dir, GeomConstants.VEC3D_ZPOS, 1.0E-5);
    }

    private static void writeColorB(DataOutputStream oos, Object c) throws IOException {
        if (c instanceof Color3b) {
            Color3b c3b = (Color3b)c;
            oos.writeByte(c3b.x);
            oos.writeByte(c3b.y);
            oos.writeByte(c3b.z);
        } else if (c instanceof Point3f) {
            Point3f c3b = (Point3f)c;
            oos.writeByte(theUtil.toCCb(c3b.x));
            oos.writeByte(theUtil.toCCb(c3b.y));
            oos.writeByte(theUtil.toCCb(c3b.z));
        } else if (c instanceof Color) {
            Color c3b = (Color)c;
            oos.writeByte(c3b.getRed());
            oos.writeByte(c3b.getGreen());
            oos.writeByte(c3b.getBlue());
        }
    }

    private static void writeColorB(DataOutputStream oos, Object c, Color3b backupColor) throws IOException {
        if (c == null) {
            assert (backupColor != null);
            OccVisWriter.writeColorB(oos, backupColor);
            return;
        }
        OccVisWriter.writeColorB(oos, c);
    }

    private static void writeSharedObjId(DataOutput os, OccTracker tracker, OccTracker.ITrackerSharedObj obj) throws IOException {
        os.writeInt(tracker.getObjId(obj));
    }

    protected static void writeAgentFrame(DataOutputStream oos, OccTracker tracker, OccAgent agent, boolean vehicle) throws IOException {
        Occupant occ = agent.getOcc();
        int id = vehicle ? tracker.getVehicleId(agent) : occ.id;
        oos.writeInt(id);
        Point3d loc = occ.getDisplayLoc();
        OccVisWriter.writef(oos, loc);
        Vector3d dir = new Vector3d(occ.displayOrient);
        if (dir.length() > 0.01) {
            dir.normalize();
        }
        Quat4d orient = OccVisWriter.convertRotation(dir, OCC_ROT_REF);
        OccVisWriter.writef(oos, orient);
        oos.writeFloat(occ.terrainSpeed);
        oos.writeFloat(OccVisWriter.calcSpeed(agent, vehicle));
        OccAnim anim = occ.anim;
        VehicleBody vehicleBody = OccVisWriter.getVehicle(agent);
        oos.writeByte((byte)anim.ordinal());
        int status = 0;
        if (agent.isAwaitingAssistance()) {
            status = (byte)(status | 1);
        }
        oos.writeByte(status);
        OccVisWriter.writeSharedObjId(oos, tracker, occ.occupantGroup != null ? new OccTracker.TrackedGroup(occ.occupantGroup) : null);
        BehaviorSim behavior = OccTracker.getCurrentBehavior(occ);
        OccVisWriter.writeSharedObjId(oos, tracker, behavior != null ? new OccTracker.TrackedBehavior(behavior) : null);
        OccVisWriter.writeSharedObjId(oos, tracker, occ.parentProfile != null ? new OccTracker.TrackedProfile(occ.parentProfile) : null);
        Color3b color = OccVisWriter.getColor(agent);
        OccVisWriter.writeColorB(oos, color, color);
        Pair<OccTracker.ITrackerShape, Boolean> collShape = OccTracker.getTrackerShape(agent, vehicle, false);
        Pair<OccTracker.ITrackerShape, Boolean> realShape = OccTracker.getTrackerShape(agent, vehicle, true);
        oos.writeBoolean(vehicle ? false : (Boolean)realShape.v2);
        oos.writeInt(tracker.getObjId((OccTracker.ITrackerObj)collShape.v1));
        oos.writeInt(tracker.getObjId((OccTracker.ITrackerObj)realShape.v1));
        oos.writeShort((short)OccVisWriter.getVisFlags(vehicle, agent, vehicleBody));
        oos.writeFloat(occ.socialDist);
        oos.writeFloat((float)agent.getStats().tSlowMaxContinuousCurrent);
    }

    private static Color3b getColor(OccAgent occ) {
        QServicePoint service;
        QPath queuePath = occ.getOcc().qpath;
        if (queuePath != null && (service = queuePath.getParentQueue().getService(occ, true)) != null && service.getIsOccupantWaiting()) {
            return OccVisWriter.toColor3b(queuePath.getParentQueue().getColor());
        }
        return occ.getOcc().visColor;
    }

    private static Color3b toColor3b(Color c) {
        return new Color3b((byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue());
    }

    public static Set<Relation> getRelations(Collection<OccAgent> agents) {
        LinkedHashSet<Relation> relations = new LinkedHashSet<Relation>();
        for (OccAgent agent : agents) {
            for (IRelation rel : agent.getRelations()) {
                IRelation ab;
                if (rel instanceof IRelation.AssistedBy) {
                    ab = (IRelation.AssistedBy)rel;
                    relations.add(new Relation(0, ab.agentHelping, agent));
                    continue;
                }
                if (!(rel instanceof IRelation.Assisting)) continue;
                ab = (IRelation.Assisting)rel;
                relations.add(new Relation(0, agent, ((IRelation.Assisting)ab).agentBeingHelped));
            }
        }
        return relations;
    }

    public static class RelationTracker
    extends ObjectTracker<Relation, Void> {
        private static final long serialVersionUID = 1L;

        public RelationTracker() {
            super(false);
        }
    }

    public static class Relation
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final byte OCCRELATION_ASSISTING = 0;
        public byte type;
        public OccAgent occ1;
        public OccAgent occ2;

        public Relation(byte type, OccAgent occ1, OccAgent occ2) {
            this.type = type;
            this.occ1 = occ1;
            this.occ2 = occ2;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Relation && ((Relation)obj).type == this.type && ((Relation)obj).occ1 == this.occ1 && ((Relation)obj).occ2 == this.occ2;
        }

        public int hashCode() {
            return 153239546 + this.type + System.identityHashCode(this.occ1) + System.identityHashCode(this.occ2);
        }
    }

    private static enum ShapeType {
        POLY,
        CYL,
        REALISTIC;

    }

    public static enum ViewType {
        VT_MD5_GENERIC,
        VT_MD5_CASUAL,
        VT_SIMPLE_DISKS,
        VT_SIMPLE_SPHERES,
        VT_SIMPLE_CYL,
        VT_MARKER_DIAMOND,
        VT_MARKER_FLAG;

    }
}

