/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.Tag;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.occsource.OccSource;
import inferno.sim.output.AOccDataWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import thunderheadeng.util.LinkedIdentityHashSet;

public class OccDataWriterSingle
extends AOccDataWriter {
    private static final long serialVersionUID = 1L;
    private final KB d_kb;
    private Set<OccAgent> d_agents;
    private final SerializedOutputStream d_stream;
    private final CSVWriter d_out;
    private transient List<Tag> d_tags;

    public OccDataWriterSingle(KB kb) {
        this.d_kb = kb;
        this.d_agents = new LinkedIdentityHashSet<OccAgent>(OccDataWriterSingle.filterAgents(kb.getActiveAgents()));
        this.d_tags = OccDataWriterSingle.calcSingleFileTags(this.d_kb, this.d_agents);
        String fn = kb.getParams().out_occ_detailed;
        this.d_stream = new SerializedOutputStream(fn);
        this.d_out = new CSVWriter();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_tags = OccDataWriterSingle.calcSingleFileTags(this.d_kb, this.d_agents);
    }

    private static List<Tag> calcSingleFileTags(KB d_kb, Collection<OccAgent> d_agents) {
        LinkedIdentityHashSet<Tag> tags = new LinkedIdentityHashSet<Tag>();
        OccDataWriterSingle.calcPossibleTags(d_kb, d_agents, tags);
        for (OccSource source : d_kb.getOccSources()) {
            boolean[] mayOutput = new boolean[]{false};
            try {
                source.getFutureProfileValues(OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, printExtra -> {
                    if (printExtra.getUnique(HashSet.class).contains(Boolean.TRUE)) {
                        blArray[0] = true;
                        throw new RuntimeException();
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!mayOutput[0]) continue;
            for (BehaviorSim behavior : source.getBehaviors()) {
                OccDataWriterSingle.getPossibleTags(behavior, tags);
            }
        }
        return new ArrayList<Tag>(tags);
    }

    @Override
    public void open(Param p) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() {
        this.d_out.close();
    }

    @Override
    public void writeHeader() {
        OccDataWriterSingle.writeHeader(this.d_out, this.d_kb, this.d_tags);
    }

    @Override
    public void writeFrame(double t, boolean removeFinished) {
        Iterator<OccAgent> it = this.d_agents.iterator();
        while (it.hasNext()) {
            OccAgent agent = it.next();
            OccDataWriterSingle.writeFrame(this.d_out, this.d_kb, t, agent, this.d_tags);
            if (!removeFinished || !agent.isDone()) continue;
            it.remove();
        }
    }

    private void writeFrame(double t, OccAgent agent) {
        OccDataWriterSingle.writeFrame(this.d_out, this.d_kb, t, agent, this.d_tags);
    }

    @Override
    public void addAgents(double t, Collection<OccAgent> agents) {
        agents = OccDataWriterSingle.filterAgents(agents);
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent);
            if (agent.isDone()) continue;
            this.d_agents.add(agent);
        }
    }
}

