/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.ai.ChangeTagGoal;
import inferno.io.CSVWriter;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccEnvData;
import inferno.sim.output.IOccDataWriter;
import inferno.sim.output.WriterIntl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public abstract class AOccDataWriter
implements IOccDataWriter {
    private static final long serialVersionUID = 1L;

    protected static boolean testOutput(OccAgent agent) {
        return agent.getOcc().outputTimeHistory > 0;
    }

    protected static Collection<OccAgent> filterAgents(Collection<OccAgent> agents) {
        return theUtil.filter(agents, AOccDataWriter::testOutput);
    }

    protected static void writeHeader(CSVWriter d_out, KB d_kb, List<Tag> d_tags) {
        List<String> h1 = AOccDataWriter.initList(Header.values().length, "");
        List<String> h2 = AOccDataWriter.initList(Header.values().length, "");
        TriConsumer<Integer, String, String> add = (col, name, unit) -> {
            h1.set((int)col, (String)name);
            h2.set((int)col, (String)unit);
        };
        for (Header header : Header.values()) {
            add.accept(header.ordinal(), header.name.fileStr, header.unit != null ? header.unit.fileStr : "");
        }
        for (Tag tag : d_tags) {
            h1.add(tag.name);
            h2.add("");
        }
        OccEnvData occEnv = d_kb.getOccEnvData();
        Map<String, OccEnvData.QInfo> quantities = occEnv.getSupportedQuantities();
        for (OccEnvData.QInfo qInfo : quantities.values()) {
            h1.add(qInfo.fdsName);
            h2.add(qInfo.unit);
        }
        for (String string : h1) {
            d_out.add(string);
        }
        d_out.nextRow();
        for (String string : h2) {
            d_out.add(string);
        }
        d_out.nextRow();
        d_out.flush();
    }

    protected static <T> List<T> initList(int size, T initVal) {
        ArrayList<T> items = new ArrayList<T>(size);
        for (int m = 0; m < size; ++m) {
            items.add(initVal);
        }
        return items;
    }

    protected static void calcPossibleTags(KB kb, Collection<OccAgent> occs, Set<Tag> tags) {
        tags.addAll(kb.getRoomTags());
        for (OccAgent oa : occs) {
            AOccDataWriter.getPossibleTags(oa.getOcc().behavior, tags);
        }
    }

    protected static void getPossibleTags(BehaviorSim behavior, Set<Tag> tags) {
        for (ChangeTagGoal goal : behavior.deepFlatten(ChangeTagGoal.class)) {
            if (goal.operator != ChangeTagGoal.Op.TAG) continue;
            tags.addAll(goal.tags);
        }
    }

    protected static void writeFrame(CSVWriter d_out, KB d_kb, double t, OccAgent d_oa, List<Tag> d_tags) {
        d_out.add(t);
        d_out.add(d_oa.getId());
        d_out.add(d_oa.getOcc().name);
        d_out.add(d_oa.isActive());
        Point3d displayPos = d_oa.getOcc().getDisplayLoc();
        d_out.add(displayPos.x);
        d_out.add(displayPos.y);
        d_out.add(displayPos.z);
        d_out.add(d_oa.getVelAdjusted(d_kb).length());
        d_out.add(d_oa.getOcc().totalDistanceMeters);
        if (d_oa.getOcc().curNode != null) {
            d_out.add(d_oa.getOcc().curNode.annotatedName);
            d_out.add(d_oa.getOcc().curNode.getTerrain().description);
        } else {
            d_out.addEmpty();
            d_out.add(Tri.Terrain.OPEN.description);
        }
        Optional<AttractorSim> attr = d_oa.getAiCore().getAttractorInUse(d_kb, d_oa);
        if (attr.isPresent()) {
            d_out.add(attr.get().name);
        } else {
            d_out.addEmpty();
        }
        Optional<OccTarget> otarget = d_oa.getAiCore().getOccTargetInUse(d_kb, d_oa);
        if (otarget.isPresent()) {
            d_out.add(otarget.get().name);
        } else {
            d_out.addEmpty();
        }
        assert (AOccDataWriter.getUnexpectedTag(d_kb, d_oa, d_tags) == null) : "The agent was tagged with an unexpected tag: " + AOccDataWriter.getUnexpectedTag(d_kb, d_oa, d_tags);
        for (Tag tag : d_tags) {
            d_out.add(tag.isTagged(d_oa));
        }
        OccEnvData occEnv = d_kb.getOccEnvData();
        Map<String, OccEnvData.QInfo> quantities = occEnv.getSupportedQuantities();
        Map<OccEnvData.QInfo, Double> envValues = occEnv.getValues(d_oa.getOcc());
        for (OccEnvData.QInfo qi : quantities.values()) {
            if (t < d_kb.getFdsOutputData().getEndTime()) {
                d_out.add(envValues.get(qi));
                continue;
            }
            d_out.addEmpty();
        }
        d_out.nextRow();
        d_out.flush();
    }

    protected static Tag getUnexpectedTag(KB d_kb, OccAgent d_oa, List<Tag> d_tags) {
        for (Tag tag : d_kb.getTags()) {
            if (tag.predefined || !tag.isTagged(d_oa) || d_tags.contains(tag)) continue;
            return tag;
        }
        return null;
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        TIME(WriterIntl.intl("t"), WriterIntl.intl("s")),
        ID(WriterIntl.intl("id"), null),
        NAME(WriterIntl.intl("name"), null),
        ACTIVE(WriterIntl.intl("active"), null),
        X(WriterIntl.intl("x"), WriterIntl.intl("m")),
        Y(WriterIntl.intl("y"), WriterIntl.intl("m")),
        Z(WriterIntl.intl("z"), WriterIntl.intl("m")),
        V(WriterIntl.intl("v"), WriterIntl.intl("m/s")),
        DIST(WriterIntl.intl("distance"), WriterIntl.intl("m")),
        LOC(WriterIntl.intl("location"), null),
        LOC_TYPE(WriterIntl.intl("terrain type"), null),
        ATTRACTOR(WriterIntl.intl("attractor"), null),
        OCCTARGET(WriterIntl.intl("occupant_target"), null);

        public final WriterIntl.ColHeader name;
        public final WriterIntl.ColHeader unit;

        private Header(WriterIntl.ColHeader name, WriterIntl.ColHeader unit) {
            this.name = name;
            this.unit = unit;
        }

        public String toString() {
            return this.name.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.name;
        }
    }
}

