/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.occsource;

import inferno.data2.value.IFunction1d;
import inferno.data2.value.ImpulseFunction1d;
import inferno.sim.KB;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;

public class RandomizedOccSourceFlowrate
implements IOccSourceFlowrate,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ImpulseFunction1d function;
    public final long occSourceSeed;
    private int d_currPulseIx = Integer.MAX_VALUE;
    private List<Double> d_releaseTimes = Collections.emptyList();
    private int d_prevReleaseIx = -1;
    private final Random d_random;

    public RandomizedOccSourceFlowrate(ImpulseFunction1d f, long occSourceSeed) {
        assert (f.defaultValue == 0.0);
        this.function = f;
        this.occSourceSeed = occSourceSeed;
        this.d_random = new Random(occSourceSeed ^ 0xAF9732L);
    }

    @Override
    public int releaseOccs(KB kb, double dt) {
        double simTime = kb.getCurrentSimTime() + dt;
        int skipped = this.initPulse(kb, simTime);
        if (this.d_releaseTimes.isEmpty()) {
            return skipped;
        }
        int ix = Collections.binarySearch(this.d_releaseTimes, simTime);
        if (ix < 0 && (ix = -ix - 2) < 0) {
            return skipped;
        }
        int result = ix - this.d_prevReleaseIx;
        this.d_prevReleaseIx = ix;
        return result + skipped;
    }

    private int initPulse(KB kb, double simTime) {
        int m;
        int entryIx = this.function.indexOf(simTime);
        if (this.d_currPulseIx == entryIx) {
            return 0;
        }
        int skipped = 0;
        if (this.d_currPulseIx != Integer.MAX_VALUE) {
            if (this.d_currPulseIx >= 0) {
                assert (!this.d_releaseTimes.isEmpty());
                skipped += this.d_releaseTimes.size() - 1 - this.d_prevReleaseIx;
                ++this.d_currPulseIx;
            } else {
                this.d_currPulseIx = -this.d_currPulseIx - 1;
            }
            int fromIx = this.d_currPulseIx;
            int toIx = entryIx < 0 ? -entryIx - 1 : entryIx;
            for (m = fromIx; m < toIx; ++m) {
                ImpulseFunction1d.Pulse pulse = this.function.entries.get(m);
                skipped += (int)Math.round(pulse.duration * pulse.y);
            }
        }
        this.d_currPulseIx = entryIx;
        this.d_releaseTimes = Collections.emptyList();
        this.d_prevReleaseIx = -1;
        if (this.d_currPulseIx < 0) {
            return skipped;
        }
        ImpulseFunction1d.Pulse pulse = this.function.entries.get(entryIx);
        int numOccs = (int)Math.round(pulse.duration * pulse.y);
        if (numOccs == 0) {
            return skipped;
        }
        this.d_releaseTimes = new ArrayList<Double>(numOccs);
        for (m = 0; m < numOccs; ++m) {
            this.d_releaseTimes.add(pulse.x + this.d_random.nextDouble() * pulse.duration);
        }
        Collections.sort(this.d_releaseTimes);
        return skipped;
    }

    @Override
    public int getMaxCount(double maxTime) {
        return (int)Math.round(this.function.getAUC(0.0, maxTime));
    }

    @Override
    public boolean isFlowing(KB kb) {
        return this.function.get(kb.getCurrentSimTime()) > 0.0;
    }

    @Override
    public double getEndTime(KB kb) {
        return this.function.getEndX();
    }

    @Override
    public void getFunctions(Consumer<? super IFunction1d> functions) {
        functions.accept(this.function);
    }

    @Override
    public JSONObject toJson(ToIntFunction<IFunction1d> distIndex) {
        JSONObject jobj = new JSONObject();
        jobj.put("type", "randomized");
        jobj.put("function", distIndex.applyAsInt(this.function));
        jobj.put("seed", this.occSourceSeed);
        return jobj;
    }

    public static RandomizedOccSourceFlowrate fromJson(JSONObject jobj, IntFunction<IFunction1d> functions) throws Exception {
        Object type = jobj.get("type");
        if (!type.equals("randomized")) {
            throw new Exception();
        }
        ImpulseFunction1d func = (ImpulseFunction1d)functions.apply(JsonUtil.getInt(jobj, "function"));
        long seed = JsonUtil.getLong(jobj, "seed");
        return new RandomizedOccSourceFlowrate(func, seed);
    }
}

