/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AGoalAiCore;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IGoalAiCore;
import inferno.sim.steering.ISteeringBehavior;
import java.io.Serializable;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class DefaultAiCore
extends AGoalAiCore {
    private static final long serialVersionUID = 1L;
    private IGoalInstance d_goalInst;
    private ISteeringBehavior d_steer = null;
    private ISeekArea d_currSeekArea;
    private final Set<AttractorSim> d_closedAttractors = new IdentityHashSet<AttractorSim>();
    private final NavigableMap<Double, AttractorSim> d_futureAttractor = new TreeMap<Double, AttractorSim>();
    private final Map<AttractorSim, Double> d_invFutureAttractor = new IdentityHashMap<AttractorSim, Double>();
    private final Map<AttractorSim, Double> d_attractorMemSeek = new LinkedIdentityHashMap<AttractorSim, Double>();
    private final Map<AttractorSim, Double> d_attractorMemIdle = new LinkedIdentityHashMap<AttractorSim, Double>();
    private final Map<AttractorSim, Pair<Double, Double>> d_attrsUseOnNextIdle = new LinkedIdentityHashMap<AttractorSim, Pair<Double, Double>>();
    private CurrAttractor d_currAttractor = null;
    private OccTarget d_currOccTarget = null;

    private boolean isInitialized() {
        return this.d_steer != null;
    }

    @Override
    public ISeekArea getCurrentSeekArea(KB kb, OccAgent agent) {
        return this.d_currSeekArea;
    }

    @Override
    public Optional<AttractorSim> getAttractorInUse(KB kb, OccAgent agent) {
        return this.d_currAttractor != null ? Optional.ofNullable(this.d_currAttractor.attractor) : Optional.empty();
    }

    @Override
    public Optional<OccTarget> getOccTargetInUse(KB kb, OccAgent agent) {
        return Optional.ofNullable(this.d_currOccTarget);
    }

    @Override
    public IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return this.d_goalInst != null ? this.d_goalInst : AiUtil.getDefaultCurrGoal(agent);
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        assert (this.isInitialized());
        return this.d_steer;
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return this.getCurrentGoalInstance(agent).getProgress(kb, agent);
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        assert (this.isInitialized());
        this.getCurrentGoalInstance(agent).doorCrossed(agent, door);
        this.d_steer.doorCrossed(t, agent, door);
    }

    @Override
    public void init(KB kb, OccAgent agent) {
        assert (!this.isInitialized());
        this.initGoal(kb, agent, agent.getGoalIx(), false);
    }

    private void initGoal(KB kb, OccAgent agent, int goalIx, boolean interrupted) {
        List<IGoal> goalSequence = agent.getOcc().behaviorStack.peek().behavior.goals;
        IGoal currentGoal = goalSequence.get(goalIx);
        IGoalInstance ginst = currentGoal.begin(kb, agent);
        this.initGoalInst(kb, agent, ginst, interrupted);
    }

    private void initGoalInst(KB kb, OccAgent agent, IGoalInstance ginst, boolean interrupted) {
        this.d_goalInst = ginst;
        this.d_currSeekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, null);
        if (this.d_steer != null) {
            this.d_steer.done(kb, agent, interrupted);
        }
        this.d_steer = ginst.generateSteeringBehavior(kb, agent);
        this.updateState(kb, agent);
    }

    @Override
    protected void updateState(KB kb, OccAgent agent) {
        super.updateState(kb, agent);
        this.d_currSeekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, this.getCurrentGoalInstance(agent));
    }

    private void clearOldAttractors(KB kb, OccAgent agent, boolean clearGlobal) {
        Occupant occ = agent.getOcc();
        BiConsumer<Map, Boolean> clearChanged = (memory, idle) -> {
            Iterator it = memory.entrySet().iterator();
            while (it.hasNext()) {
                Double plannedTime;
                double newInfluence;
                Map.Entry entry = it.next();
                AttractorSim attr = (AttractorSim)entry.getKey();
                double prevInfluence = (Double)entry.getValue();
                if (prevInfluence == (newInfluence = attr.getProbabilityOfInfluence(occ, true))) continue;
                it.remove();
                if (!idle.booleanValue() || !(newInfluence < prevInfluence) || (plannedTime = this.d_invFutureAttractor.remove(attr)) == null) continue;
                this.d_futureAttractor.remove(plannedTime);
            }
        };
        clearChanged.accept(this.d_attractorMemIdle, true);
        clearChanged.accept(this.d_attractorMemSeek, false);
        this.d_attrsUseOnNextIdle.entrySet().removeIf(entry -> {
            AttractorSim attr = (AttractorSim)entry.getKey();
            double prevSusc = (Double)((Pair)entry.getValue()).v1;
            double currSusc = attr.getProbabilityOfInfluence(occ, true);
            return currSusc < prevSusc;
        });
        Predicate<AttractorSim> canRemove = attr -> !this.d_invFutureAttractor.containsKey(attr) && !attr.isVisible(kb, occ);
        Iterator<AttractorSim> it = this.d_attractorMemIdle.keySet().iterator();
        while (it.hasNext()) {
            AttractorSim attr2 = it.next();
            if (!canRemove.test(attr2)) continue;
            it.remove();
            this.d_attractorMemSeek.remove(attr2);
        }
        this.d_attractorMemSeek.keySet().removeIf(canRemove);
        if (clearGlobal) {
            this.d_attractorMemSeek.keySet().removeAll(kb.getGlobalAttractors());
            this.d_attractorMemIdle.keySet().removeAll(kb.getGlobalAttractors());
        }
    }

    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        assert (this.isInitialized());
        boolean wasSeeking = this.isSeeking(kb, agent);
        Deque<BehaviorSim.BehaviorInProgress> behaviorStack = agent.getOcc().behaviorStack;
        IGoalInstance currGoal = this.getCurrentGoalInstance(agent);
        ISeekArea oldArea = currGoal.update(kb, agent);
        if (oldArea != null) {
            this.recordSeekArea(kb, agent, oldArea);
            this.updateState(kb, agent);
        }
        if (currGoal.needsNewSteeringBehavior(kb, agent)) {
            if (this.d_steer != null) {
                this.d_steer.done(kb, agent, false);
            }
            this.d_steer = currGoal.generateSteeringBehavior(kb, agent);
        }
        BiConsumer<Integer, Boolean> startGoal = (goalIx, interrupted) -> {
            boolean resetElevState = this.d_goalInst != null ? !this.d_goalInst.wasImmediate() : false;
            this.initGoal(kb, agent, (int)goalIx, (boolean)interrupted);
            agent.setGoalIx((int)goalIx, resetElevState);
        };
        Consumer<Boolean> startNextGoal = interrupted -> {
            int currentGoalIx = agent.getGoalIx();
            startGoal.accept(currentGoalIx + 1, (Boolean)interrupted);
        };
        this.clearOldAttractors(kb, agent, false);
        if (currGoal.isReached(kb, agent)) {
            ISeekArea areaReached = currGoal.end(kb, agent);
            if (areaReached != null) {
                this.recordSeekArea(kb, agent, areaReached);
            }
            if (this.d_currAttractor == null) {
                this.d_futureAttractor.clear();
                this.d_invFutureAttractor.clear();
                this.d_attrsUseOnNextIdle.clear();
                this.clearOldAttractors(kb, agent, true);
            }
            boolean initNewGoal = true;
            Iterator<Map.Entry<AttractorSim, Double>> goalSequence = behaviorStack.peek().behavior.goals;
            if (agent.getGoalIx() + 1 >= goalSequence.size()) {
                behaviorStack.pop();
                if (currGoal.isAlwaysTerminal()) {
                    behaviorStack.clear();
                }
                while (!(behaviorStack.isEmpty() || this.d_currAttractor != null && behaviorStack.size() <= this.d_currAttractor.stackSize || agent.getGoalIx() + 1 < behaviorStack.peek().behavior.size())) {
                    behaviorStack.pop();
                }
                if (behaviorStack.isEmpty()) {
                    agent.finish(kb);
                    initNewGoal = false;
                }
                if (this.d_currAttractor != null && behaviorStack.size() == this.d_currAttractor.stackSize) {
                    boolean bl;
                    initNewGoal = false;
                    boolean bl2 = true;
                    Runnable recordPrevSeekArea = () -> {
                        if (this.d_currAttractor.prevSeekArea != null) {
                            this.recordSeekArea(kb, agent, this.d_currAttractor.prevSeekArea);
                        }
                    };
                    if (this.d_currAttractor.goalResumePacket != null && this.d_currAttractor.interruptedGoal.resume(kb, agent, this.d_currAttractor.goalResumePacket)) {
                        recordPrevSeekArea.run();
                        this.initGoalInst(kb, agent, this.d_currAttractor.interruptedGoal, false);
                        bl = false;
                    }
                    if (bl) {
                        recordPrevSeekArea.run();
                        startGoal.accept(agent.getGoalIx(), false);
                    }
                    this.d_currAttractor = null;
                }
            }
            if (initNewGoal) {
                startNextGoal.accept(false);
            }
        }
        this.updateState(kb, agent);
        currGoal = this.getCurrentGoalInstance(agent);
        if (this.d_currAttractor == null && currGoal.canInterrupt(kb, agent)) {
            Supplier<AttractorSim> pickAttractor;
            AttractorSim attr;
            Occupant occ = agent.getOcc();
            boolean seeking = this.isSeeking(kb, agent);
            if (seeking != wasSeeking) {
                if (seeking) {
                    this.d_attrsUseOnNextIdle.clear();
                    for (Map.Entry<AttractorSim, Double> entry2 : this.d_futureAttractor.entrySet()) {
                        AttractorSim attr2 = (AttractorSim)((Object)entry2.getValue());
                        double chosenTime = (Double)((Object)entry2.getKey());
                        Double prevSusc = this.d_attractorMemIdle.get(attr2);
                        if (prevSusc == null) {
                            prevSusc = attr2.getProbabilityOfInfluence(occ, true);
                        }
                        this.d_attrsUseOnNextIdle.put(attr2, new Pair<Double, Double>(prevSusc, chosenTime));
                    }
                    this.d_attractorMemIdle.keySet().removeAll(this.d_invFutureAttractor.keySet());
                    this.d_futureAttractor.clear();
                    this.d_invFutureAttractor.clear();
                }
                this.clearOldAttractors(kb, agent, false);
                if (seeking) {
                    for (Map.Entry<AttractorSim, Double> entry3 : this.d_attractorMemIdle.entrySet()) {
                        boolean bl = !seeking;
                        double currSusc = entry3.getKey().getProbabilityOfInfluence(occ, bl);
                        if (!(currSusc <= entry3.getValue())) continue;
                        this.d_attractorMemSeek.put(entry3.getKey(), currSusc);
                    }
                } else {
                    this.d_attrsUseOnNextIdle.entrySet().removeIf(entry -> {
                        AttractorSim attr = (AttractorSim)entry.getKey();
                        double prevInfl = (Double)((Pair)entry.getValue()).v1;
                        double currInfl = attr.getProbabilityOfInfluence(occ, true);
                        return currInfl < prevInfl;
                    });
                }
            }
            Set<AttractorSim> closedAttrs = seeking ? this.d_attractorMemSeek.keySet() : this.d_attractorMemIdle.keySet();
            List<AttractorSim> list = kb.findPotentialAttractors(occ, !seeking, Predicates.and(Filters.reject(this.d_closedAttractors), Filters.reject(this.d_invFutureAttractor.keySet()), Filters.reject(closedAttrs)));
            if (!list.isEmpty() && !seeking) {
                double idleTime;
                double idleEndTime;
                IGoalInstance ginst = this.getCurrentGoalInstance(agent);
                IGoalInstance.IdleInfo ii = ginst.getIdleInfo(kb, agent);
                double d = idleEndTime = ii != null ? ii.idleEndTime : Double.POSITIVE_INFINITY;
                if (Double.isInfinite(idleEndTime)) {
                    idleEndTime = kb.getCurrentSimTime() + kb.getParams().attr_default_idle_time;
                }
                if ((idleTime = idleEndTime - kb.getCurrentSimTime()) != 0.0) {
                    Random r = kb.getTimeBasedRandom(occ, 217151353641L);
                    for (AttractorSim attr3 : list) {
                        double prevTime;
                        assert (!this.d_invFutureAttractor.containsKey(attr3));
                        double probability = attr3.getProbabilityOfInfluence(occ, !seeking);
                        this.d_attractorMemIdle.put(attr3, probability);
                        Pair<Double, Double> prevInfo = this.d_attrsUseOnNextIdle.remove(attr3);
                        if (prevInfo == null) {
                            double rval = r.nextDouble();
                            if (rval > probability) continue;
                            prevTime = Double.POSITIVE_INFINITY;
                        } else {
                            prevTime = (Double)prevInfo.v2;
                        }
                        double t = kb.getCurrentSimTime() + r.nextDouble() * idleTime;
                        if (this.d_futureAttractor.putIfAbsent(t = Math.min(t, prevTime), attr3) != null) continue;
                        this.d_invFutureAttractor.put(attr3, t);
                    }
                }
            }
            if ((attr = (pickAttractor = () -> {
                if (!seeking) {
                    if (!this.d_futureAttractor.isEmpty() && theUtil.ge(kb.getCurrentSimTime(), (Double)this.d_futureAttractor.firstKey(), 1.0E-6)) {
                        AttractorSim result = this.d_futureAttractor.pollFirstEntry().getValue();
                        this.d_invFutureAttractor.remove(result);
                        return result;
                    }
                    return null;
                }
                for (AttractorSim attr2 : attractors) {
                    this.d_attractorMemSeek.put(attr2, attr2.getProbabilityOfInfluence(occ, !seeking));
                }
                Random r = kb.getTimeBasedRandom(occ, 7913634181690L);
                List chosenAttrs = attractors.stream().filter(attr -> r.nextDouble() <= this.d_attractorMemSeek.get(attr)).collect(Collectors.toList());
                if (chosenAttrs.isEmpty()) {
                    return null;
                }
                if (chosenAttrs.size() == 1) {
                    return (AttractorSim)chosenAttrs.get(0);
                }
                return (AttractorSim)chosenAttrs.get(r.nextInt(chosenAttrs.size()));
            }).get()) != null) {
                this.d_closedAttractors.add(attr);
                Pair<ISeekArea, Serializable> interrupted2 = currGoal.interrupt(kb, agent);
                if (interrupted2.v1 != null) {
                    this.recordSeekArea(kb, agent, (ISeekArea)interrupted2.v1);
                }
                this.d_currAttractor = new CurrAttractor(attr, behaviorStack.size(), currGoal, interrupted2.v2, interrupted2.v1 != null ? (ISeekArea)interrupted2.v1 : this.d_currSeekArea);
                behaviorStack.push(new BehaviorSim.BehaviorInProgress(attr.behavior, -1));
                startNextGoal.accept(true);
            }
        }
        this.d_currOccTarget = IGoalAiCore.calcOccTargetInUse(kb, agent, currGoal);
        agent.updateStats(kb, e.getCurrentDt());
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
        this.getCurrentGoalInstance(agent).preMove(kb, agent, dt);
    }

    @Override
    public void processLost(KB kb, OccAgent agent) {
        this.getCurrentGoalInstance(agent).processLost(kb, agent);
    }

    private static class CurrAttractor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final AttractorSim attractor;
        public final int stackSize;
        public final IGoalInstance interruptedGoal;
        public final Object goalResumePacket;
        public final ISeekArea prevSeekArea;

        public CurrAttractor(AttractorSim attractor, int stackSize, IGoalInstance interruptedGoal, Object goalResumePacket, ISeekArea prevSeekArea) {
            this.attractor = attractor;
            this.stackSize = stackSize;
            this.interruptedGoal = interruptedGoal;
            this.goalResumePacket = goalResumePacket;
            this.prevSeekArea = prevSeekArea;
        }
    }
}

