/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.IGoalAiCore;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;

public abstract class AGoalAiCore
implements IGoalAiCore,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SEEK_GOALS = 2;
    private boolean d_seeking;
    private final ArrayDeque<ISeekArea> d_seekAreas = new ArrayDeque();

    @Override
    public Collection<ISeekArea> getSeekHistory() {
        return this.d_seekAreas;
    }

    protected void updateState(KB kb, OccAgent agent) {
        IGoalInstance ginst = this.getCurrentGoalInstance(agent);
        this.d_seeking = ginst.isSeeking(kb, agent);
    }

    @Override
    public boolean isSeeking(KB kb, OccAgent agent) {
        return this.d_seeking;
    }

    protected void recordSeekArea(KB kb, OccAgent agent, ISeekArea area) {
        this.d_seekAreas.addFirst(area);
        while (this.d_seekAreas.size() > 2) {
            this.d_seekAreas.removeLast();
        }
    }
}

