/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.data.EscalatorPreference;
import common.data.SpeedInSmoke;
import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.CylinderShape;
import inferno.data2.IAgentBodyShape;
import inferno.data2.OccPriority;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.SlopeSpeed;
import inferno.data2.SpeedInSmokeSim;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.ai.IGoal;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import inferno.elevator.ElevatorGoal;
import inferno.elevator.IElevator;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.VehicleBody;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.NodeFilters;
import inferno.sim.path.TriFilters;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Color3b;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class OccProfileSim
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final IFunction1d SFPE_STAIR_FUNCTION = PiecewiseFunction1d.newFunction(false, 0.0, 1.0, 0.5, 0.8785714285714287, 0.541, 0.8285714285714285, 0.638, 0.7714285714285716, 0.748, 0.7142857142857143, 1.8, 0.02428571428571429);
    public static final IFunction1d SFPE_RAMP_FUNCTION = PiecewiseFunction1d.newFunction(false, 0.0, 1.0, 1.0, 1.0);
    public static final Unit SPEED_UNIT = SI.METER.divide(SI.SECOND);
    public static final Prop<String> PROP_NAME = new Prop<String>("OccProfile.NAME", "", String.class, new PropOption[0]);
    public static final Prop<String> PROP_DESC = new Prop<String>("OccProfile.DESC", "", String.class, new PropOption[0]);
    public static final OccProp<ICurve> PROP_MAXVEL = new OccProp<ICurve>("OccProfile.MAXVEL", 160705858904975L, OccProfileSim.cc(1.19, SI.METER.divide(SI.SECOND)), ICurve.class, SPEED_UNIT, OccProfileSim.applyCurveToOcc(SPEED_UNIT, (o, v) -> {
        o.maxVel = (float)v;
    }), (kb, o) -> new UnitDouble(o.maxVel, SPEED_UNIT), new PropOption[0]);
    public static final Function1dProp PROP_FUNDAMENTAL = OccProfileSim.newFundamentalProp("OccProfile.FUNDAMENTAL", "Speed-Density Profile", "Modifies an occupant's maximum speed as a function of local occupant density.", OccProfileSim.getSFPEFundamentalCurve(0.15), (occ, func) -> {
        occ.fundamental = func;
    }, occ -> occ.fundamental);
    public static final Function1dProp PROP_STAIR_SPEED_UP = OccProfileSim.newSlopeProp("OccProfile.SPEED_STAIR_UP", "Speed Fraction Up", "<html>Modifies an occupant's maximum speed up stairs as a function<br>of stair slope (tread rise/tread run).", SFPE_STAIR_FUNCTION, null, null);
    public static final ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_UP = new ProfileFunctionProp(OccProfileSim.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_UP", "Speed-Density Up", "The speed-density function to use when the occupant travels up stairs.", null, null, null));
    public static final Function1dProp PROP_STAIR_SPEED_DOWN = OccProfileSim.newSlopeProp("OccProfile.SPEED_STAIR_DOWN", "Speed Fraction Down", "<html>Modifies an occupant's maximum speed down stairs as a function<br>of stair slope (tread rise/tread run).", SFPE_STAIR_FUNCTION, null, null);
    public static final ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_DOWN = new ProfileFunctionProp(OccProfileSim.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_DOWN", "Speed-Density Down", "The speed-density function to use when the occupant travels down stairs.", null, null, null));
    public static final SlopeSpeedProp PROP_STAIR_SPEED = new SlopeSpeedProp(PROP_STAIR_SPEED_UP, PROP_STAIR_FUNDAMENTAL_UP, PROP_STAIR_SPEED_DOWN, PROP_STAIR_FUNDAMENTAL_DOWN, (o, s) -> {
        o.stairSpeed = s;
    }, o -> o.stairSpeed);
    public static final Function1dProp PROP_RAMP_SPEED_UP = OccProfileSim.newSlopeProp("OccProfile.SPEED_RAMP_UP", "Speed Fraction Up", "<html>Modifies an occupant's maximum speed up ramps as a function<br>of ramp slope.", SFPE_RAMP_FUNCTION, null, null);
    public static final ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_UP = new ProfileFunctionProp(OccProfileSim.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_UP", "Speed-Density Up", "The speed-density function to use when the occupant travels up ramps.", null, null, null));
    public static final Function1dProp PROP_RAMP_SPEED_DOWN = OccProfileSim.newSlopeProp("OccProfile.SPEED_RAMP_DOWN", "Speed Fraction Down", "<html>Modifies an occupant's maximum speed down ramps as a function<br>of ramp slope.", SFPE_RAMP_FUNCTION, null, null);
    public static final ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_DOWN = new ProfileFunctionProp(OccProfileSim.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_DOWN", "Speed-Density Down", "The speed-density function to use when the occupant travels down ramps.", null, null, null));
    public static final Prop<SpeedInSmokeSim> PROP_SPEED_IN_SMOKE = new OccProp<SpeedInSmokeSim>("speedInSmoke", new SpeedInSmokeSim(SpeedInSmoke.Data.DEFAULT), SpeedInSmokeSim.class, SI.METER.divide(SI.SECOND), (rgen, prop, value, occ, seed, kb) -> {
        occ.smokeSpeed = value;
    }, (kb, occ) -> occ.smokeSpeed, new PropOption[0]);
    public static final SlopeSpeedProp PROP_RAMP_SPEED = new SlopeSpeedProp(PROP_RAMP_SPEED_UP, PROP_RAMP_FUNDAMENTAL_UP, PROP_RAMP_SPEED_DOWN, PROP_RAMP_FUNDAMENTAL_DOWN, (o, s) -> {
        o.rampSpeed = s;
    }, o -> o.rampSpeed);
    public static final OccProp<ICurve> PROP_ACCEL_TIME = new OccProp<ICurve>("OccProfile.ACCEL_TIME", 3772195293760533400L, OccProfileSim.cc(1.1, SI.SECOND), ICurve.class, SI.SECOND, OccProfileSim.applyCurveToOcc(SI.SECOND, (o, at) -> {
        o.accelFactor = 1.0f / (float)at;
    }), (kb, o) -> new UnitDouble(1.0f / o.accelFactor, SI.SECOND), new PropOption[0]);
    public static final OccProp<IShapeGen> PROP_SHAPE = new OccProp<IShapeGen>("OccProfile.SHAPE", new CylShapeGen(OccProfileSim.cc(0.4558, SI.METER), null, OccProfileSim.cc(1.8288, SI.METER)), IShapeGen.class, null, (rgen, prop, value, occ, seed, kb) -> {
        occ.bodyShape = value.generateShape(occ, rgen, seed, kb);
    }, (kb, o) -> o.bodyShape, PropOption.GEOMETRY);
    public static final OccProp<Double> PROP_MIN_SQUEEZE_FACTOR_CONST = new NullableProp<Double>("OccProfile.MIN_SQUEEZE_FACTOR_CONST", 9424230529086L, Double.valueOf(0.7), Double.class, null, (rgen, prop, value, occ, seed, kb) -> {
        occ.minSqueezeFactor = value != null ? value.floatValue() : 1.0f;
    }, (kb, o) -> Float.valueOf(o.minSqueezeFactor), 1.0, new PropOption[0]);
    public static final OccProp<Point3f> PROP_COLOR = new OccProp<Point3f>("OccProfile.COLOR", new Point3f(0.4f, 0.4f, 1.0f), Point3f.class, null, (rgen, prop, c, occ, seed, kb) -> {
        occ.visColor = new Color3b(theUtil.toCCb(c.x), theUtil.toCCb(c.y), theUtil.toCCb(c.z));
    }, (kb, o) -> o.visColor, PropOption.SKIP_PARAM);
    public static final OccProp<IUrn<String>> PROP_OCCMODEL = new OccProp<IUrn>("OccProfile.OCCMODEL", 59846346733L, new Urn<String>(OccProfileSim.getDefaultAvatars()), IUrn.class, null, OccProfileSim.applyDistToOcc((o, m) -> {
        o.avatar = m;
    }), (kb, o) -> o.avatar, new PropOption[0]);
    public static final OccProp<IUrn<Integer>> PROP_PRIORITY_LEVEL = new OccProp<IUrn>("OccProfile.PRIORITY_LEVEL", 691837209914168L, new Urn<Integer>(0), IUrn.class, null, (rgen, prop, value, occ, seed, kb) -> {
        int pLevel = (Integer)OccProfileSim.getDistVal(value, prop.seed, rgen, seed);
        UniformCurve resolveCurve = new UniformCurve(new UnitDouble(0.0, Unit.ONE), new UnitDouble(1.0, Unit.ONE));
        rgen.setSeed(seed ^ 0x245AFE234E32L);
        double resolveParam = resolveCurve.getValue(rgen).getValue(Unit.ONE);
        occ.priority = OccPriority.init(pLevel, resolveParam);
    }, (kb, o) -> OccPriority.getLevel(o.priority), new PropOption[0]);
    public static final OccProp<ICurve> PROP_PERSIST_TIME = new OccProp<ICurve>("OccProfile.PERSIST_TIME", 4501553410181778L, OccProfileSim.cc(1.0, SI.SECOND), ICurve.class, SI.SECOND, OccProfileSim.applyCurveToOcc(SI.SECOND, (o, t) -> {
        o.persistTime = (float)t;
    }), (kb, o) -> new UnitDouble(o.persistTime, SI.SECOND), new PropOption[0]);
    public static final OccProp<ICurve> PROP_COLLISION_RESPONSE_TIME = new OccProp<ICurve>("OccProfile.COLLISION_RESPONSE_TIME", 2872109906997839L, OccProfileSim.cc(1.5, SI.SECOND), ICurve.class, SI.SECOND, OccProfileSim.applyCurveToOcc(SI.SECOND, (o, t) -> {
        o.collisionResponseTime = (float)t;
    }), (kb, o) -> new UnitDouble(o.collisionResponseTime, SI.SECOND), new PropOption[0]);
    public static final OccProp<Spacing> PROP_SPACING = new OccProp<Spacing>("OccProfile.PROP_SPACING", 685236812626031156L, new Spacing(SpacingType.COMFORT_DIST, OccProfileSim.cc(0.08, SI.METER)), Spacing.class, SI.METER, (rgen, prop, value, occ, seed, kb) -> {
        UnitDouble sval = OccProfileSim.getDistVal(value.val, prop.seed, rgen, seed);
        occ.comfortDist = (float)value.type.comfortDist.get(new UnitDouble(occ.bodyShape.getOccRadius(), SI.METER), sval).get(SI.METER);
    }, (kb, o) -> new UnitDouble(o.comfortDist, SI.METER), new PropOption[0]);
    public static final OccProp<ICurve> PROP_SOCIAL_DIST = new OccProp<ICurve>("OccProfile.PROP_SOCIAL_DIST", 756474136765175587L, OccProfileSim.cc(Double.NaN, SI.METER), ICurve.class, SI.METER, OccProfileSim.applyCurveToOcc(SI.METER, (o, t) -> {
        o.socialDist = (float)t;
    }), (kb, o) -> Float.isNaN(o.socialDist) ? null : new UnitDouble(o.socialDist, SI.METER), new PropOption[0]);
    public static final OccProp<ICurve> PROP_SLOW_FACTOR = new OccProp<ICurve>("OccProfile.SLOW_FACTOR", 41361678648555699L, OccProfileSim.cc(0.1), ICurve.class, null, OccProfileSim.applyCurveToOcc(Unit.ONE, (o, f) -> {
        o.slowFactor = (float)f;
    }), (kb, o) -> Float.valueOf(o.slowFactor), new PropOption[0]);
    public static final OccProp<ICurve> PROP_BOUNDARY_LAYER = new OccProp<ICurve>("OccProfile.BOUNDARY_LAYER", 265469670362069667L, OccProfileSim.cc(15.0, SI.CENTI(SI.METER)), ICurve.class, SI.CENTI(SI.METER), OccProfileSim.applyCurveToOcc(SI.METER, (o, b) -> {
        o.boundaryLayer = (float)b;
    }), (kb, o) -> new UnitDouble(o.boundaryLayer, SI.METER), new PropOption[0]);
    public static final OccProp<IUrn<Boolean>> PROP_ASSIST = new OccProp<IUrn>("OccProfile.ASSIST", 9435912272635L, new Urn<Boolean>(false), IUrn.class, null, OccProfileSim.applyDistToOcc((o, a) -> {
        o.reqAssistedBy = a;
    }), (kb, o) -> o.reqAssistedBy, PropOption.SKIP_PARAM);
    public static final OccProp<IUrn<Boolean>> PROP_OBEY_ONEWAY_DOORS = new OccProp<IUrn>("OccProfile.OBEY_ONEWAY_DOORS", 1527562427425878947L, new Urn<Boolean>(true), IUrn.class, null, OccProfileSim.applyDistToOcc((o, v) -> {
        o.obeyOnewayDoors = v;
    }), (kb, o) -> o.obeyOnewayDoors, new PropOption[0]);
    public static final OccProp<IUrn<EscalatorPreference>> PROP_ESCALATOR_PREF = new OccProp<IUrn>("OccProfile.ESCALATOR_PREF", -6968375068520378298L, new Urn<EscalatorPreference>(EscalatorPreference.STAND_ANYWHERE), IUrn.class, null, OccProfileSim.applyDistToOcc((o, v) -> {
        o.movingTerrainPref = v;
    }), (kb, o) -> o.movingTerrainPref, new PropOption[0]);
    public static final OccProp<ICurve> PROP_LOCAL_QUEUE_TIME_FACTOR = new OccProp<ICurve>("OccProfile.LOCAL_QUEUE_TIME_FACTOR", 725907575970042L, OccProfileSim.cc(1.0), ICurve.class, null, OccProfileSim.applyCurveToOcc(Unit.ONE, (o, v) -> {
        o.localQueueTimeFactor = v;
    }), (kb, o) -> o.localQueueTimeFactor, new PropOption[0]);
    public static final OccProp<ICurve> PROP_LOCAL_TRAVEL_TIME_FACTOR = new OccProp<ICurve>("OccProfile.LOCAL_TRAVEL_TIME_FACTOR", 625208248450526L, OccProfileSim.cc(1.0), ICurve.class, null, OccProfileSim.applyCurveToOcc(Unit.ONE, (o, v) -> {
        o.localTravelTimeFactor = v;
    }), (kb, o) -> o.localTravelTimeFactor, new PropOption[0]);
    public static final OccProp<ICurve> PROP_TAIL_TIME_FACTOR = new OccProp<ICurve>("OccProfile.TAIL_TIME_FACTOR", 686610875145200458L, OccProfileSim.cc(1.0), ICurve.class, null, OccProfileSim.applyCurveToOcc(Unit.ONE, (o, v) -> {
        o.tailTimeFactor = v;
    }), (kb, o) -> o.tailTimeFactor, new PropOption[0]);
    public static final OccProp<ICurve> PROP_CURR_DOOR_PREF = new OccProp<ICurve>("OccProfile.CURR_DOOR_PREF", 9478288431L, OccProfileSim.cc(35.0, NonSI.PERCENT), ICurve.class, NonSI.PERCENT, OccProfileSim.applyCurveToOcc(Unit.ONE, (o, v) -> {
        o.currDoorFactor = Util.clampT(1.0 - v, 0.0, 1.0);
    }), (kb, o) -> new UnitDouble(1.0 - o.currDoorFactor, Unit.ONE), new PropOption[0]);
    public static final OccProp<ICurve> PROP_CURRENT_ROOM_DIST_PENALTY = new OccProp<ICurve>("OccProfile.DIST_TRAVELLED_DOUBLE_DIST", 18843351117539L, OccProfileSim.cc(35.0, SI.METER), ICurve.class, SI.METER, OccProfileSim.applyCurveToOcc(SI.METER, (o, distTravelledDoubleDist) -> {
        o.distTravelledFactor = distTravelledDoubleDist == 0.0 ? 0.0 : Math.log(2.0) / distTravelledDoubleDist;
    }), (kb, o) -> new UnitDouble(o.distTravelledFactor == 0.0 ? 0.0 : Math.log(2.0) / o.distTravelledFactor, SI.METER), new PropOption[0]);
    public static final OccProp<IUrn<Boolean>> PROP_PRINT_EXTRA_OUTPUT = new OccProp<IUrn>("OccProfile.PRINT_EXTRA_OUTPUT", 14614216L, new Urn<Boolean>(false), IUrn.class, null, OccProfileSim.applyDistToOcc((o, v) -> {
        o.outputTimeHistory = v != false ? 1 : 0;
    }), (kb, o) -> o.outputTimeHistory != 0, PropOption.SKIP_PARAM);
    public static final OccProp<IUrn<Boolean>> PROP_REQUIRES_ASSISTANCE = new OccProp<IUrn>("OccProfile.REQUIRES_ASSISTANCE", 281103528794162L, new Urn<Boolean>(false), IUrn.class, null, OccProfileSim.applyDistToOcc((occ, ra) -> {
        occ.requiresAssistance = ra;
    }), (kb, o) -> o.requiresAssistance, PropOption.GEOMETRY);
    public static final Vector3d INIT_ORIENT_REF = GeomConstants.VEC3D_XPOS;
    public static final OccProp<ICurve> PROP_INIT_ORIENT = new OccProp<ICurve>("OccProfile.INIT_ORIENT", new UniformCurve(new UnitDouble(0.0, SI.RADIAN), new UnitDouble(Math.PI * 2, SI.RADIAN)), ICurve.class, NonSI.DEGREE_ANGLE, OccProfileSim.applyCurveToOcc(SI.RADIAN, (o, angleRad) -> {
        Vector3d orient = new Vector3d(INIT_ORIENT_REF);
        Inter.rotateTuple2D(orient, (float)angleRad, new Point3d(0.0, 0.0, 0.0));
        o.orient = orient;
    }), (kb, o) -> new UnitDouble(Util3D.angle0To2PI(INIT_ORIENT_REF, o.orient, GeomConstants.VEC3D_ZPOS), SI.RADIAN), PropOption.GEOMETRY);
    public static final OccProp<Float> PROP_REAC_TIME = new OccProp<Float>("OccProfile.REAC_TIME", Float.valueOf(0.1f), Float.class, SI.SECOND, OccProfileSim.applyDirectToOcc((o, v) -> {
        o.reacTime = v.floatValue();
    }), (kb, o) -> new UnitDouble(o.reacTime, SI.SECOND), PropOption.SKIP_PARAM);
    public static final OccProp<IUrn<Boolean>> PROP_REMOVE_WHEN_FINISHED = new OccProp<IUrn>("OccProfile.REMOVE_WHEN_FINISHED", new Urn<Boolean>(true), IUrn.class, null, OccProfileSim.applyDistToOcc((o, v) -> {
        o.removeWhenFinished = v;
    }), (kb, o) -> o.removeWhenFinished, PropOption.SKIP_PARAM);
    public static final Prop<CompRestrictions> PROP_RESTRICTED_COMPONENTS = new OccProp<CompRestrictions>("OccProfile.RESTRICTED_COMPONENTS", new CompRestrictions(), CompRestrictions.class, null, OccProfileSim.applyDirectToOcc((o, v) -> {
        o.compRestrictions = v;
    }), (kb, o) -> o.compRestrictions, PropOption.GEOMETRY, PropOption.SKIP_PARAM);
    public static final Prop<ICurve> PROP_ELEVATOR_WAIT_TIME = new OccProp<ICurve>("OccProfile.ELEVATOR_WAIT_TIME", new ConstantCurve(new UnitDouble(0.0, SI.SECOND)), ICurve.class, SI.SECOND, OccProfileSim.applyCurveToOcc(SI.SECOND, (o, v) -> {
        o.elevatorWaitTime = new ElevatorWaitTime(v);
    }), (kb, o) -> new UnitDouble(o.elevatorWaitTime.maxWaitTime, SI.SECOND), new PropOption[0]);
    public static final Prop<Boolean> PROP_NO_CHANGE = new Prop<Boolean>("OccProfile.NO_CHANGE", false, Boolean.class, PropOption.SKIP_PARAM);
    public static final ICurve ZERO_PERCENT = new ConstantCurve(new UnitDouble(0.0, NonSI.PERCENT));
    public static final Function<AttractorSim, IDistributedVal<UnitDouble>> NO_SUSCEPTIBILITY = new ConstFunction<AttractorSim, ICurve>(ZERO_PERCENT);
    private static final Function<AttractorSim, IDistributedVal<UnitDouble>> DEF_ATTRACTOR_SUSCEPTIBILITY_IDLE = new ConstFunction<AttractorSim, ConstantCurve>(OccProfileSim.cc(5.0, NonSI.PERCENT));
    private static final Function<AttractorSim, IDistributedVal<UnitDouble>> DEF_ATTRACTOR_SUSCEPTIBILITY_SEEK = new ConstFunction<AttractorSim, ConstantCurve>(OccProfileSim.cc(1.0, NonSI.PERCENT));
    public static final OccProp<Function<AttractorSim, IDistributedVal<UnitDouble>>> PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK = new OccProp<Function<AttractorSim, IDistributedVal<UnitDouble>>>("OccProfile.ATTRACTOR_SUSCEPTIBILITY", 574529506091934536L, DEF_ATTRACTOR_SUSCEPTIBILITY_SEEK, Function.class, Unit.ONE, OccProfileSim.applyAttrSuscpToOcc((occ, suscp) -> {
        occ.attractorSuscSeek = suscp;
    }), (kb, occ) -> occ.attractorSuscSeek, new PropOption[0]);
    public static final OccProp<Function<AttractorSim, IDistributedVal<UnitDouble>>> PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE = new OccProp<Function<AttractorSim, IDistributedVal<UnitDouble>>>("OccProfile.ATTRACTOR_SUSCEPTIBILITY_IDLE", 574529506091934536L, DEF_ATTRACTOR_SUSCEPTIBILITY_IDLE, Function.class, Unit.ONE, OccProfileSim.applyAttrSuscpToOcc((occ, suscp) -> {
        occ.attractorSuscIdle = suscp;
    }), (kb, occ) -> occ.attractorSuscIdle, new PropOption[0]);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(OccProfileSim.class);
    public static final Map<Object, IPropertySet.Prop<?>> PROP_TYPES_MAP;
    public static final List<IOccProp<?>> ALL_OCC_PROPS;
    private static final Random s_curveSeedGen;
    private Map<Object, Object> d_data = new ListMap<Object, Object>();
    private static final WeakHashMap<SlopeSpeed, SlopeSpeed> s_slopeSpeedMap;

    private static final ConstantCurve cc(double val) {
        return OccProfileSim.cc(val, Unit.ONE);
    }

    private static String bea(String name) {
        return String.format("md5/%1$s/%1$s.bea", name);
    }

    public static Collection<String> getDefaultAvatars() {
        return Arrays.asList(OccProfileSim.bea("BMan0001"), OccProfileSim.bea("BMan0002"), OccProfileSim.bea("BMan0003"), OccProfileSim.bea("BMan0012"), OccProfileSim.bea("BWom0001"), OccProfileSim.bea("BWom0002"), OccProfileSim.bea("BWom0011"), OccProfileSim.bea("CMan0001"), OccProfileSim.bea("CMan0002"), OccProfileSim.bea("CMan0003"), OccProfileSim.bea("CMan0012"), OccProfileSim.bea("CWom0001"), OccProfileSim.bea("CWom0018"), OccProfileSim.bea("CWom0019"));
    }

    private static final ConstantCurve cc(double val, Unit unit) {
        return new ConstantCurve(new UnitDouble(val, unit));
    }

    public static void sortOccProps(List<? extends IOccProp<?>> props) {
        Collections.sort(props, (o1, o2) -> {
            if (o1 == PROP_SHAPE && o2 == PROP_SPACING) {
                return -1;
            }
            if (o1 == PROP_SPACING && o2 == PROP_SHAPE) {
                return 1;
            }
            return 0;
        });
    }

    public static long newSeed() {
        return theUtil.randomSeed(s_curveSeedGen);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof OccProfileSim && ((OccProfileSim)obj).d_data.equals(this.d_data);
    }

    private static LinkedHashMap<Object, IPropertySet.Prop<?>> getAllPropTypesMap(Collection<IPropertySet.Prop<?>> allProps) {
        LinkedHashMap types = new LinkedHashMap();
        for (IPropertySet.Prop<?> prop : allProps) {
            types.put(prop.key, prop);
        }
        return types;
    }

    public <T> T getProp(IOccProp<T> prop) {
        assert (prop instanceof IPropertySet.Prop);
        if (prop instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)((Object)prop));
        }
        return null;
    }

    public <T> boolean isDefined(IOccProp<T> prop) {
        assert (prop instanceof IPropertySet.Prop);
        if (!(prop instanceof IPropertySet.Prop)) {
            return false;
        }
        return this.isDefined((IPropertySet.Prop)((Object)prop));
    }

    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_data.containsKey(prop.key);
    }

    public <T> boolean isDefined(OccProp<T> prop) {
        return this.isDefined((IPropertySet.Prop<T>)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        if (prop instanceof SlopeSpeedProp) {
            SlopeSpeedProp sprop = (SlopeSpeedProp)prop;
            SlopeSpeed sspeed = new SlopeSpeed(this.getProperty(sprop.fracUpProp), (IFunction1d)this.getProperty(sprop.fundUpProp).apply(this), this.getProperty(sprop.fracDownProp), (IFunction1d)this.getProperty(sprop.fundDownProp).apply(this));
            WeakHashMap<SlopeSpeed, SlopeSpeed> weakHashMap = s_slopeSpeedMap;
            synchronized (weakHashMap) {
                SlopeSpeed espeed = s_slopeSpeedMap.putIfAbsent(sspeed, sspeed);
                return (T)(espeed != null ? espeed : sspeed);
            }
        }
        if (this.d_data.containsKey(prop.key)) {
            return (T)this.d_data.get(prop.key);
        }
        return prop.defVal;
    }

    public <T> void applyToOcc(Occupant occ, Random rgen, long seed, IOccProp<T> prop, KB kb) {
        assert (prop instanceof IPropertySet.Prop);
        prop.apply(occ, rgen, seed, this.getProperty((IPropertySet.Prop)((Object)prop)), kb);
    }

    public void applyToOcc(Occupant occ, Random rgen, long seed, Predicate<? super IOccProp<?>> filter, KB kb) {
        ALL_OCC_PROPS.stream().filter(filter).forEach(prop -> this.applyToOcc(occ, rgen, seed, (IOccProp)prop, kb));
    }

    public <T> T getDistVal(Prop<? extends IDistributedVal<T>> prop, Random rand, long baseSeed) {
        return OccProfileSim.getDistVal(this.getProperty(prop), prop.seed, rand, baseSeed);
    }

    public static <T> T getDistVal(IDistributedVal<T> distVal, long propSeed, Random rand, long baseSeed) {
        if (distVal == null) {
            return null;
        }
        long newSeed = baseSeed ^ propSeed;
        rand.setSeed(newSeed);
        return distVal.getValue(rand);
    }

    public UnitDouble getSpacingVal(Random rand, long baseSeed) {
        Spacing spacing = this.getProperty(PROP_SPACING);
        assert (spacing != null);
        long newSeed = baseSeed ^ OccProfileSim.PROP_SPACING.seed;
        rand.setSeed(newSeed);
        return spacing.val.getValue(rand);
    }

    public UnitDouble getComfortDistance(Random rand, long baseSeed, UnitDouble occRadius) {
        Spacing spacing = this.getProperty(PROP_SPACING);
        UnitDouble spacingVal = this.getSpacingVal(rand, baseSeed);
        return spacing.type.comfortDist.get(occRadius, spacingVal);
    }

    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.d_data.put(prop.key, value);
    }

    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    public String toString() {
        return "OccProfile[name=" + this.getName() + "]";
    }

    public int getNumLocal() {
        return this.d_data.size();
    }

    public static Collection<String> getDefault3dModels() {
        return Arrays.asList("BMan0001", "BMan0002", "BMan0003", "BMan0012", "BWom0001", "BWom0002", "BWom0011", "CMan0001", "CMan0002", "CMan0003", "CMan0012", "CWom0001", "CWom0018", "CWom0019");
    }

    private static <T extends ICurve> ApplyToOcc<T> applyCurveToOcc(Unit unit, ApplyDoubleToOcc doubleToOcc) {
        return (rgen, prop, value, occ, seed, kb) -> {
            UnitDouble udVal = OccProfileSim.getDistVal(value, prop.seed, rgen, seed);
            double dval = udVal != null ? udVal.get(unit) : Double.NaN;
            doubleToOcc.accept(occ, dval);
        };
    }

    private static <T extends ICurve> ApplyToOcc<T> applyNullableCurveToOcc(Unit unit, ApplyDoubleToOcc doubleToOcc) {
        return (rgen, prop, value, occ, seed, kb) -> doubleToOcc.accept(occ, value != null ? OccProfileSim.getDistVal(value, prop.seed, rgen, seed).get(unit) : Double.NaN);
    }

    private static ApplyToOcc<Function<AttractorSim, IDistributedVal<UnitDouble>>> applyAttrSuscpToOcc(BiConsumer<Occupant, Function<AttractorSim, Double>> setter) {
        return (rgen, prop, value, occ, seed, kb) -> {
            Function<AttractorSim, Double> result = OccProfileSim.getDistAttractorSusceptibility(kb, prop, value, kb.getAllAttractors(), seed, true);
            setter.accept(occ, result);
        };
    }

    public static Function<AttractorSim, Double> getDistAttractorSusceptibility(KB kb, Occupant occ, Prop<Function<AttractorSim, IDistributedVal<UnitDouble>>> prop, Function<AttractorSim, IDistributedVal<UnitDouble>> profileSuscp, Collection<AttractorSim> allAttractors, boolean cacheValue) {
        return OccProfileSim.getDistAttractorSusceptibility(kb, prop, profileSuscp, allAttractors, occ.getSeed(prop), cacheValue);
    }

    public static Function<AttractorSim, Double> getDistAttractorSusceptibility(KB kb, Prop<Function<AttractorSim, IDistributedVal<UnitDouble>>> prop, Function<AttractorSim, IDistributedVal<UnitDouble>> profileSuscp, Collection<AttractorSim> allAttractors, long occSeed, boolean cacheValueEnabled) {
        HashSet<Double> uniqueVals = new HashSet<Double>();
        LinkedIdentityHashMap<AttractorSim, Double> vals = new LinkedIdentityHashMap<AttractorSim, Double>();
        boolean cacheValue = true;
        for (AttractorSim attr : allAttractors) {
            double dval;
            IDistributedVal<UnitDouble> curve = profileSuscp.apply(attr);
            cacheValue = cacheValue && curve.isConstant();
            UnitDouble udVal = OccProfileSim.getDistVal(curve, prop.seed, new Random(), occSeed);
            double d = dval = udVal != null ? udVal.get(Unit.ONE) : 0.0;
            if (dval != 0.0) {
                vals.put(attr, dval);
            }
            uniqueVals.add(dval);
        }
        if (uniqueVals.isEmpty()) {
            Function<AttractorSim, Double> function = Occupant.ZERO_SUSCP;
        }
        Function<Object, Object> result = uniqueVals.size() == 1 ? new ConstFunction(uniqueVals.iterator().next()) : new MappedFunction(vals, 0.0);
        if (!cacheValueEnabled || !cacheValue) {
            return result;
        }
        return kb.cacheAttractorSusceptibility(result);
    }

    private static <T> ApplyToOcc<T> applyDirectToOcc(BiConsumer<Occupant, T> setter) {
        return (rgen, prop, value, occ, seed, kb) -> setter.accept(occ, value);
    }

    private static <T, T2 extends IDistributedVal<T>> ApplyToOcc<T2> applyDistToOcc(BiConsumer<Occupant, T> setter) {
        return (rgen, prop, value, occ, seed, kb) -> setter.accept(occ, OccProfileSim.getDistVal(value, prop.seed, rgen, seed));
    }

    private static Function1dProp newFundamentalProp(String name, String desc, String longDesc, IFunction1d defVal, BiConsumer<Occupant, IFunction1d> applyToOcc, Function<Occupant, IFunction1d> getFromOcc) {
        Pair[] predef = new Pair[]{new Pair<String, IFunction1d>("SFPE", OccProfileSim.getSFPEFundamentalCurve(0.15))};
        return new Function1dProp((Object)name, defVal, applyToOcc, getFromOcc, desc, longDesc, new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE), null, null}, predef);
    }

    private static Function1dProp newSlopeProp(String name, String desc, String longDesc, IFunction1d defFunction, BiConsumer<Occupant, IFunction1d> applyToOcc, Function<Occupant, IFunction1d> getFromOcc) {
        Pair[] predefs = new Pair[]{new Pair<String, IFunction1d>("SFPE", defFunction)};
        return new Function1dProp((Object)name, defFunction, applyToOcc, getFromOcc, desc, longDesc, new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), null, new UnitDouble(0.0, Unit.ONE), null}, predefs);
    }

    private static double getComfortDistanceFromDensity(double d, double r) {
        return Math.max(2.0 / (Math.sqrt(d) * Math.pow(12.0, 0.25)) - 2.0 * r, 0.0);
    }

    public static <T> Optional<Prop<T>> toProfProp(IPropertySet.Prop<T> prop) {
        return prop instanceof Prop ? Optional.of((Prop)prop) : Optional.empty();
    }

    public static IFunction1d getSFPEFundamentalCurve(double ymin) {
        double a = 0.266;
        double m = -0.31158486587794304;
        double b = 1.0 - m * 0.55;
        double xmin = (ymin - b) / m;
        double[] x = new double[]{0.55, xmin};
        double[] y = new double[]{1.0, ymin};
        return new PiecewiseFunction1d(x, y, false);
    }

    public double[] getOccWidthRange(boolean forGeometry) {
        IShapeGen shape = this.getProperty(PROP_SHAPE);
        return shape.getWidthRange(forGeometry);
    }

    public void getAllOccWidths(boolean forGeometry, DoubleConsumer allWidths) {
        IShapeGen shape = this.getProperty(PROP_SHAPE);
        shape.getAllWidths(forGeometry, allWidths);
    }

    static {
        Set<IOccProp> props = theUtil.map(theUtil.filter(ALL_PROPS, IOccProp.class), p -> p);
        ALL_OCC_PROPS = new ArrayList<IOccProp>(props);
        OccProfileSim.sortOccProps(ALL_OCC_PROPS);
        PROP_TYPES_MAP = OccProfileSim.getAllPropTypesMap(ALL_PROPS);
        s_curveSeedGen = new Random();
        s_slopeSpeedMap = new WeakHashMap();
    }

    public static final class MappedFunction<ObjT, ResultT>
    implements Function<ObjT, ResultT>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final Map<ObjT, ResultT> objVals;
        public final ResultT defVal;

        public MappedFunction(Map<ObjT, ResultT> val, ResultT defVal) {
            this.objVals = val;
            this.defVal = defVal;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            return Objects.equals(((MappedFunction)obj).defVal, this.defVal) && ((MappedFunction)obj).objVals.equals(this.objVals);
        }

        public int hashCode() {
            return 0x239843F ^ Objects.hash(this.objVals, this.defVal);
        }

        @Override
        public ResultT apply(ObjT t) {
            return this.objVals.getOrDefault(t, this.defVal);
        }

        public String toString() {
            return String.format("Default=%s, values=%s", this.defVal, this.objVals);
        }
    }

    public static final class ConstFunction<ObjT, ResultT>
    implements Function<ObjT, ResultT>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final ResultT val;

        public ConstFunction(ResultT val) {
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            return ((ConstFunction)obj).equals(this.val);
        }

        public int hashCode() {
            return 0xAF9383 ^ theUtil.hashCode(this.val);
        }

        @Override
        public ResultT apply(ObjT t) {
            return this.val;
        }

        public String toString() {
            return this.val != null ? this.val.toString() : "";
        }
    }

    public static class ElevatorWaitTime
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public final double maxWaitTime;
        private double remainingWaitTime;

        public ElevatorWaitTime(double maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            this.remainingWaitTime = maxWaitTime;
        }

        public void decreaseRemainingWaitTime(double dt) {
            this.remainingWaitTime -= dt;
        }

        public boolean canWait() {
            return this.remainingWaitTime > 0.0;
        }

        public void reset() {
            this.remainingWaitTime = this.maxWaitTime;
        }

        public String toString() {
            return "[rem: " + this.remainingWaitTime + " s, max: " + this.maxWaitTime + " s]";
        }
    }

    public static class DynamicCompRestrictions
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Map<IElevator, Set<ANode>> tempElevatorRestrictions;

        public void addTempElevatorRestrictions(Map<IElevator, Set<ANode>> newTempElevatorRestrictions) {
            if (newTempElevatorRestrictions == null) {
                return;
            }
            if (this.tempElevatorRestrictions == null) {
                this.tempElevatorRestrictions = new LinkedHashMap<IElevator, Set<ANode>>(newTempElevatorRestrictions);
            } else {
                for (IElevator el : newTempElevatorRestrictions.keySet()) {
                    this.tempElevatorRestrictions.putIfAbsent(el, newTempElevatorRestrictions.get(el));
                }
            }
        }

        public void clearTempElevatorRestrictions() {
            this.tempElevatorRestrictions = null;
        }

        public Predicate<WingedEdge> getRestrictedDoorsFilter() {
            Predicate<WingedEdge> filter = this.tempElevatorRestrictions != null ? EdgeFilters.restrictElevatorUseToFloor(this.tempElevatorRestrictions) : Predicates.alwaysTrue();
            return filter;
        }
    }

    public static class CompRestrictions
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Set<ANode> nodes;
        public boolean reject;
        public boolean elevatorsFromBehavior;

        public CompRestrictions(Set<ANode> nodes, boolean reject, boolean elevatorsFromBehavior) {
            this.nodes = nodes;
            this.reject = reject;
            this.elevatorsFromBehavior = elevatorsFromBehavior;
        }

        public CompRestrictions() {
            this.nodes = new HashSet<ANode>();
            this.reject = true;
            this.elevatorsFromBehavior = false;
        }

        public Predicate<WingedEdge> getRestrictedDoorsFilter() {
            return EdgeFilters.filterDoors(this.reject ? Filters.reject(this.nodes) : Filters.accept(this.nodes));
        }

        public Predicate<Tri> getRestrictedCompsFilter(IGoal currentGoal) {
            boolean isElevatorGoal = currentGoal instanceof ElevatorGoal;
            if (this.reject) {
                return TriFilters.filterNodes(isElevatorGoal && this.elevatorsFromBehavior ? Filters.reject(this.nodes).or(NodeFilters.acceptElevators()) : Filters.reject(this.nodes));
            }
            return TriFilters.filterNodes(!isElevatorGoal && this.elevatorsFromBehavior ? Filters.accept(this.nodes).and(NodeFilters.rejectElevators()) : Filters.accept(this.nodes));
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompRestrictions)) {
                return false;
            }
            return this.reject == ((CompRestrictions)other).reject && this.elevatorsFromBehavior == ((CompRestrictions)other).elevatorsFromBehavior && this.nodes.equals(((CompRestrictions)other).nodes);
        }

        public int hashCode() {
            return this.nodes.hashCode() + (this.reject ? 1 : 0) + (this.elevatorsFromBehavior ? 10 : 0);
        }

        public void add(CompRestrictions otherCompRestrictions) {
            if (otherCompRestrictions == null) {
                return;
            }
            if (this.reject == otherCompRestrictions.reject) {
                this.nodes.addAll(otherCompRestrictions.nodes);
            } else {
                if (!this.reject) {
                    this.nodes.removeAll(otherCompRestrictions.nodes);
                } else {
                    HashSet<ANode> newNodes = new HashSet<ANode>(otherCompRestrictions.nodes);
                    newNodes.removeAll(this.nodes);
                    this.nodes = newNodes;
                }
                this.reject = false;
            }
            this.elevatorsFromBehavior |= otherCompRestrictions.elevatorsFromBehavior;
        }
    }

    public static class SlopeSpeedProp
    extends OccProp<SlopeSpeed> {
        public static final long serialVersionUID = 1L;
        public final Function1dProp fracUpProp;
        public final ProfileFunctionProp fundUpProp;
        public final Function1dProp fracDownProp;
        public final ProfileFunctionProp fundDownProp;

        public SlopeSpeedProp(Function1dProp upFracProp, ProfileFunctionProp upFundProp, Function1dProp downFracProp, ProfileFunctionProp downFundProp, BiConsumer<Occupant, SlopeSpeed> setter, Function<Occupant, SlopeSpeed> getter) {
            super("", null, SlopeSpeed.class, null, (Random rgen, Prop<T> prop, T value, Occupant occ, long seed, KB kb) -> setter.accept(occ, (SlopeSpeed)value), (KB kb, Occupant occ) -> (SlopeSpeed)getter.apply(occ), PropOption.SKIP_PARAM);
            this.fracUpProp = upFracProp;
            this.fundUpProp = upFundProp;
            this.fracDownProp = downFracProp;
            this.fundDownProp = downFundProp;
        }
    }

    public static class Function1dProp
    extends IPropertySet.Prop<IFunction1d>
    implements IOccProp<IFunction1d> {
        public final String desc;
        public final String longDesc;
        public Pair<String, IFunction1d>[] predef;
        public UnitDouble[] bounds;
        public final BiConsumer<Occupant, IFunction1d> applyToOcc;
        public final Function<Occupant, IFunction1d> getFromOcc;

        public Function1dProp(Object key, IFunction1d defVal, BiConsumer<Occupant, IFunction1d> applyToOcc, Function<Occupant, IFunction1d> getFromOcc, String desc, String longDesc, Pair<String, IFunction1d> ... predef) {
            this(key, defVal, applyToOcc, getFromOcc, desc, longDesc, new UnitDouble[]{null, null, null, null}, predef);
        }

        public Function1dProp(Object key, IFunction1d defVal, BiConsumer<Occupant, IFunction1d> applyToOcc, Function<Occupant, IFunction1d> getFromOcc, String desc, String longDesc, UnitDouble[] bounds, Pair<String, IFunction1d> ... predef) {
            super(key, defVal);
            this.desc = desc;
            this.longDesc = longDesc;
            this.predef = predef;
            this.bounds = bounds;
            this.applyToOcc = applyToOcc;
            this.getFromOcc = getFromOcc;
        }

        @Override
        public EnumSet<PropOption> getOptions() {
            return EnumSet.of(PropOption.SKIP_PARAM);
        }

        @Override
        public Unit getDisplayUnit() {
            return null;
        }

        @Override
        public String getName() {
            return this.key.toString();
        }

        @Override
        public void apply(Occupant occ, Random rgen, long seed, IFunction1d value, KB kb) {
            if (this.applyToOcc != null) {
                this.applyToOcc.accept(occ, value);
            }
        }

        @Override
        public Object getValue(KB kb, Occupant occ) {
            if (this.getFromOcc != null) {
                return this.getFromOcc.apply(occ);
            }
            return null;
        }
    }

    public static class ProfileFunctionProp
    extends IPropertySet.Prop<IProfileFunction> {
        public final Function1dProp fprop;

        public ProfileFunctionProp(Function1dProp fprop) {
            super(fprop.key, FromLevelFundamental.INSTANCE);
            this.fprop = fprop;
        }
    }

    public static class ConstProfileFunction
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IFunction1d function;

        public ConstProfileFunction(IFunction1d fund) {
            this.function = fund;
        }

        @Override
        public IFunction1d apply(OccProfileSim profile) {
            return this.function;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ConstProfileFunction && ((ConstProfileFunction)obj).function.equals(this.function);
        }

        public int hashCode() {
            return 0x1908F3E ^ this.function.hashCode();
        }
    }

    public static class FromLevelFundamental
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final FromLevelFundamental INSTANCE = new FromLevelFundamental();

        private FromLevelFundamental() {
        }

        @Override
        public IFunction1d apply(OccProfileSim profile) {
            return profile.getProperty(PROP_FUNDAMENTAL);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    public static interface IProfileFunction
    extends Function<OccProfileSim, IFunction1d> {
    }

    public static class Spacing
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final SpacingType type;
        public final ICurve val;

        public Spacing(SpacingType type, ICurve val) {
            this.type = type;
            this.val = val;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Spacing && ((Spacing)o).type == this.type && ((Spacing)o).val.equals(this.val);
        }

        public int hashCode() {
            return 0xA234FF3E ^ Objects.hash(new Object[]{this.type, this.val});
        }

        public String toString() {
            String desc = this.type.desc;
            return String.format("%s=%s", desc, this.val.toString());
        }
    }

    public static enum SpacingType {
        COMFORT_DIST("Comfort Distance", (occRadius, cdist) -> cdist),
        DENSITY("From Queue Density", (occRadius, density) -> new UnitDouble(OccProfileSim.getComfortDistanceFromDensity(density.getValue(Unit.ONE.divide(SI.METER.pow(2))), occRadius.getValue(SI.METER)), SI.METER)),
        AREA("From Queue Area", (occRadius, area) -> new UnitDouble(OccProfileSim.getComfortDistanceFromDensity(1.0 / area.getValue(SI.METER.pow(2)), occRadius.getValue(SI.METER)), SI.METER));

        public final String desc;
        public final ComfortDistFunc comfortDist;

        private SpacingType(String desc, ComfortDistFunc gcd) {
            this.desc = desc;
            this.comfortDist = gcd;
        }
    }

    private static interface ComfortDistFunc {
        public UnitDouble get(UnitDouble var1, UnitDouble var2);
    }

    public static class PolyShapeGen
    implements IShapeGen,
    Serializable {
        static final long serialVersionUID = 1L;
        public final VehicleBody shape;

        public PolyShapeGen(VehicleBody shape) {
            this.shape = shape;
        }

        public int hashCode() {
            return 0x77A9F8 ^ this.shape.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PolyShapeGen && ((PolyShapeGen)obj).shape.equals(this.shape);
        }

        @Override
        public IAgentBodyShape generateShape(Occupant occ, Random rgen, long seed, KB kb) {
            return new PolygonShape(occ.loc, occ.orient, occ.id, this.shape);
        }

        @Override
        public double[] getWidthRange(boolean forGeometry) {
            double width = this.shape.radiusUnattached * 2.0;
            return new double[]{width, width};
        }

        @Override
        public double getProjectedArea(boolean isMin, boolean forGeometry) {
            return this.shape.area;
        }

        @Override
        public void getAllShapes(Consumer<? super IAgentBodyShape> shapes) {
            shapes.accept(new PolygonShape(new Point3d(), new Vector3d(1.0, 0.0, 0.0), -1, this.shape));
        }

        @Override
        public void getAllWidths(boolean forGeometry, DoubleConsumer result) {
            result.accept(this.shape.radiusUnattached * 2.0);
        }
    }

    public static class CylShapeGen
    implements IShapeGen,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ICurve shoulderWidth;
        public final UnitDouble geomWidth;
        public final ICurve height;

        public CylShapeGen(ICurve shoulderWidth, UnitDouble geomWidth, ICurve height) {
            this.shoulderWidth = shoulderWidth;
            this.height = height;
            this.geomWidth = geomWidth;
        }

        public int hashCode() {
            return 0xA23BE ^ Objects.hash(this.shoulderWidth, this.geomWidth, this.height);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CylShapeGen)) {
                return false;
            }
            CylShapeGen cyl = (CylShapeGen)obj;
            return this.shoulderWidth.equals(cyl.shoulderWidth) && Objects.equals(this.geomWidth, cyl.geomWidth) && this.height.equals(cyl.height);
        }

        @Override
        public IAgentBodyShape generateShape(Occupant occ, Random rgen, long seed, KB kb) {
            double radius;
            double geomRadius = radius = OccProfileSim.getDistVal(this.shoulderWidth, 70367L, rgen, seed).get(SI.METER) * 0.5;
            if (this.geomWidth != null && kb.getParams().reactive_steering) {
                geomRadius = this.geomWidth.get(SI.METER) * 0.5;
            }
            double height = OccProfileSim.getDistVal(this.height, 4823856332702527L, rgen, seed).get(SI.METER);
            return new CylinderShape(occ.loc, radius, geomRadius, height, occ.orient, occ.id);
        }

        @Override
        public double[] getWidthRange(boolean forGeometry) {
            if (forGeometry && this.geomWidth != null) {
                double width = this.geomWidth.get(SI.METER);
                return new double[]{width, width};
            }
            return new double[]{this.shoulderWidth.getMin().getValue(SI.METER), this.shoulderWidth.getMax().getValue(SI.METER)};
        }

        @Override
        public double getProjectedArea(boolean isMin, boolean forGeometry) {
            double r = forGeometry && this.geomWidth != null ? this.geomWidth.get(SI.METER) * 0.5 : (isMin ? this.shoulderWidth.getMin().get(SI.METER) * 0.5 : this.shoulderWidth.getMax().get(SI.METER) * 0.5);
            return Math.PI * r * r;
        }

        @Override
        public void getAllShapes(Consumer<? super IAgentBodyShape> shapes) {
            double radius = this.shoulderWidth.getMax().get(SI.METER) * 0.5;
            shapes.accept(new CylinderShape(new Point3d(), radius, this.geomWidth != null ? this.geomWidth.get(SI.METER) * 0.5 : radius, this.height.getMax().get(SI.METER), new Vector3d(1.0, 0.0, 0.0), -1));
        }

        @Override
        public void getAllWidths(boolean forGeometry, DoubleConsumer result) {
            if (forGeometry && this.geomWidth != null) {
                result.accept(this.geomWidth.get(SI.METER));
                return;
            }
            double max = this.shoulderWidth.getMax().get(SI.METER);
            double min = this.shoulderWidth.getMin().get(SI.METER);
            double avg = this.shoulderWidth.getAvg().get(SI.METER);
            result.accept(max);
            if (min != max) {
                result.accept(min);
            }
            if (avg != max) {
                result.accept(avg);
            }
        }
    }

    public static interface IShapeGen {
        public IAgentBodyShape generateShape(Occupant var1, Random var2, long var3, KB var5);

        public void getAllShapes(Consumer<? super IAgentBodyShape> var1);

        public void getAllWidths(boolean var1, DoubleConsumer var2);

        public double[] getWidthRange(boolean var1);

        public double getProjectedArea(boolean var1, boolean var2);
    }

    public static enum PropOption {
        SKIP_PARAM,
        GEOMETRY;

    }

    public static interface IOccProp<T> {
        public String getName();

        public void apply(Occupant var1, Random var2, long var3, T var5, KB var6);

        public Object getValue(KB var1, Occupant var2);

        public Unit getDisplayUnit();

        public EnumSet<PropOption> getOptions();

        default public boolean testOption(PropOption option) {
            return this.getOptions().contains((Object)option);
        }
    }

    public static class NullableProp<T>
    extends OccProp<T> {
        public static final long serialVersionUID = 1L;
        public static final String NULL_KEY = "null";
        public final T nullValue;

        public NullableProp(String name, long seed, T defVal, Class<? super T> clazz, Unit displayUnit, ApplyToOcc<T> applyToOcc, GetFromOcc<?> getFromOcc, T nullValue, PropOption ... options) {
            super(name, seed, defVal, clazz, displayUnit, applyToOcc, getFromOcc, options);
            this.nullValue = nullValue;
        }
    }

    public static class UnitDoubleOccProp
    extends OccProp<UnitDouble> {
        public static final long serialVersionUID = 1L;
        public final Unit defaultUnit;

        public UnitDoubleOccProp(String name, long seed, UnitDouble defVal, Class<? super UnitDouble> clazz, ApplyToOcc<UnitDouble> applyToOcc, GetFromOcc<UnitDouble> getFromOcc, Unit defaultUnit, PropOption ... options) {
            super(name, seed, defVal, clazz, defaultUnit, applyToOcc, getFromOcc, options);
            this.defaultUnit = defaultUnit;
        }
    }

    public static class OccProp<T>
    extends Prop<T>
    implements IOccProp<T> {
        static final long serialVersionUID = 1L;
        public final ApplyToOcc<T> applyToOcc;
        public final GetFromOcc<?> getFromOcc;
        public final Unit displayUnit;

        public OccProp(String name, T defVal, Class<? super T> clazz, Unit displayUnit, ApplyToOcc<T> applyToOcc, GetFromOcc<?> getFromOcc, PropOption ... options) {
            this(name, 0L, (T)defVal, clazz, displayUnit, (ApplyToOcc<? super T>)applyToOcc, getFromOcc, options);
        }

        public OccProp(String name, long seed, T defVal, Class<? super T> clazz, Unit displayUnit, ApplyToOcc<T> applyToOcc, GetFromOcc<?> getFromOcc, PropOption ... options) {
            super(name, seed, defVal, clazz, options);
            this.displayUnit = displayUnit;
            this.applyToOcc = applyToOcc;
            this.getFromOcc = getFromOcc;
        }

        @Override
        public String getName() {
            return this.key.toString();
        }

        @Override
        public void apply(Occupant occ, Random rgen, long seed, T value, KB kb) {
            if (this.applyToOcc != null) {
                this.applyToOcc.apply(rgen, this, value, occ, seed, kb);
            }
        }

        @Override
        public Object getValue(KB kb, Occupant occ) {
            return this.getFromOcc != null ? this.getFromOcc.get(kb, occ) : null;
        }

        @Override
        public Unit getDisplayUnit() {
            return this.displayUnit;
        }
    }

    public static class Prop<T>
    extends IPropertySet.Prop<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final long seed;
        public final EnumSet<PropOption> options;
        private Class<? super T> clazz;

        public Prop(String name, T defVal, Class<? super T> clazz, PropOption ... options) {
            this(name, 0L, (T)defVal, clazz, options);
        }

        public Prop(String name, long seed, T defVal, Class<? super T> clazz, PropOption ... options) {
            super(name, defVal);
            this.seed = seed;
            this.clazz = clazz;
            this.options = theUtil.toSet(PropOption.class, (Enum[])options);
        }

        public EnumSet<PropOption> getOptions() {
            return this.options;
        }

        public boolean isDistributed() {
            return this.defVal instanceof IDistributedVal;
        }

        public <T2> IDistributedVal<T2> newDistConstant(T2 val) {
            if (this.defVal instanceof IUrn) {
                return new Urn<T2>(Collections.singleton(val));
            }
            if (this.defVal instanceof ICurve) {
                assert (this.defVal instanceof ICurve && val instanceof UnitDouble);
                return new ConstantCurve((UnitDouble)val);
            }
            return null;
        }

        public String toString() {
            return "[OccProfile.Prop:" + this.key + "]";
        }

        public boolean isAssignableFrom(Class<?> clazz) {
            return this.clazz != null && clazz.isAssignableFrom(this.clazz);
        }
    }

    public static interface GetFromOcc<T> {
        public T get(KB var1, Occupant var2);
    }

    public static interface ApplyToOcc<T> {
        public void apply(Random var1, Prop<T> var2, T var3, Occupant var4, long var5, KB var7);
    }

    public static interface ApplyDoubleToOcc {
        public void accept(Occupant var1, double var2);
    }
}

