/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Occupant;
import inferno.io.fdsout.KbLink;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class OccEnvData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FDS_CO2 = "CARBON DIOXIDE VOLUME FRACTION";
    public static final String FDS_CO = "CARBON MONOXIDE VOLUME FRACTION";
    public static final String FDS_O2 = "OXYGEN VOLUME FRACTION";
    public static final String FDS_SOOT_VIS = "SOOT VISIBILITY";
    public static final String FDS_FED_TOTAL = "*FED_TOTAL*";
    public static final double FED_CRITICAL_DOSE = 0.3;
    private Map<String, QInfo> d_fdsNameToQuantity = new LinkedHashMap<String, QInfo>();
    private Map<Occupant, Map<QInfo, Double>> d_values = new LinkedHashMap<Occupant, Map<QInfo, Double>>();
    private Map<Occupant, Double> d_lastUpdate = new HashMap<Occupant, Double>();
    private Set<Occupant> d_finalized = new HashSet<Occupant>();

    public void init(KB kb) {
        KbLink fdsData = kb.getFdsOutputData();
        if (fdsData == null) {
            return;
        }
        for (KbLink.SensorInfo sensor : fdsData.getSensors()) {
            int index = fdsData.getQuanityIndex(sensor.quantity);
            QInfo qi = new QInfo(index, sensor.quantity.fdsName, sensor.label, sensor.quantity.unit);
            this.d_fdsNameToQuantity.put(sensor.quantity.fdsName, qi);
        }
        if (this.d_fdsNameToQuantity.keySet().containsAll(Arrays.asList(FDS_CO2, FDS_CO, FDS_O2))) {
            QInfo qiFedTotal = new QInfo(-1, FDS_FED_TOTAL, "FED", "");
            this.d_fdsNameToQuantity.put(FDS_FED_TOTAL, qiFedTotal);
        }
        this.d_fdsNameToQuantity = Collections.unmodifiableMap(this.d_fdsNameToQuantity);
        for (OccAgent oa : kb.getAllAgentsEver()) {
            this.addOccupant(oa.getOcc(), kb.getCurrentSimTime());
        }
    }

    public void addOccupant(Occupant occ, double t) {
        HashMap<QInfo, Double> agentValues = new HashMap<QInfo, Double>();
        for (QInfo qi : this.d_fdsNameToQuantity.values()) {
            agentValues.put(qi, 0.0);
        }
        this.d_values.put(occ, agentValues);
        this.d_lastUpdate.put(occ, Double.NaN);
    }

    private void finalizeAgentData(Occupant oa) {
        Map<QInfo, Double> agentValues = this.d_values.get(oa);
        for (QInfo qi : this.d_fdsNameToQuantity.values()) {
            if (qi.index == -1) continue;
            agentValues.put(qi, 0.0);
        }
    }

    public void update(KB kb, double t) {
        KbLink fdsData = kb.getFdsOutputData();
        if (kb.getFdsOutputData() == null || kb.getActiveAgents().isEmpty()) {
            return;
        }
        ArrayList<Occupant> trackedOccs = new ArrayList<Occupant>();
        for (Occupant occupant : this.d_values.keySet()) {
            if (!occupant.isDone()) {
                double d = this.d_lastUpdate.get(occupant);
                if (!Double.isNaN(d) && !theUtil.ge(t, d + (double)occupant.reacTime, 1.0E-6)) continue;
                trackedOccs.add(occupant);
                continue;
            }
            if (this.d_finalized.contains(occupant)) continue;
            this.finalizeAgentData(occupant);
            this.d_finalized.add(occupant);
        }
        if (trackedOccs.isEmpty()) {
            return;
        }
        ArrayList<Point3d> agentPoints = new ArrayList<Point3d>();
        for (Occupant occupant : trackedOccs) {
            Point3d topOfHead = Util3D.add(occupant.loc, (Tuple3d)new Vector3d(0.0, 0.0, 0.9 * occupant.bodyShape.getHeight()));
            agentPoints.add(topOfHead);
        }
        double[][] dArray = fdsData.query(t, agentPoints);
        QInfo qInfo = this.d_fdsNameToQuantity.get(FDS_FED_TOTAL);
        QInfo qiCo = this.d_fdsNameToQuantity.get(FDS_CO);
        QInfo qiCo2 = this.d_fdsNameToQuantity.get(FDS_CO2);
        QInfo qiO2 = this.d_fdsNameToQuantity.get(FDS_O2);
        int i = 0;
        for (Occupant occupant : trackedOccs) {
            double dt;
            Map<QInfo, Double> agentValues = this.d_values.get(occupant);
            for (QInfo qi : this.d_fdsNameToQuantity.values()) {
                if (qi.index == -1) continue;
                agentValues.put(qi, dArray[i][qi.index]);
            }
            double lastUpdate = this.d_lastUpdate.get(occupant);
            double d = dt = Double.isNaN(lastUpdate) ? 0.0 : t - lastUpdate;
            if (qInfo != null) {
                assert (agentValues.containsKey(qiCo));
                assert (agentValues.containsKey(qiCo2));
                assert (agentValues.containsKey(qiO2));
                double coVolFrac = agentValues.get(qiCo);
                double co2VolFrac = agentValues.get(qiCo2);
                double o2VolFrac = agentValues.get(qiO2);
                double fedIncrease = OccEnvData.calcFedIncrease(dt, coVolFrac, co2VolFrac, o2VolFrac, kb.getParams().smvHypoxiaLimit);
                double prevFedCO = agentValues.get(qInfo);
                double currentFedCO = prevFedCO + fedIncrease;
                agentValues.put(qInfo, currentFedCO);
                this.d_lastUpdate.put(occupant, t);
            }
            ++i;
        }
    }

    private static double calcFedIncrease(double dt, double coVolFrac, double co2VolFrac, double o2VolFrac, double o2HypoxiaLimit) {
        if (dt <= 0.0 || Double.isNaN(coVolFrac) || Double.isNaN(co2VolFrac) || Double.isNaN(o2VolFrac)) {
            return 0.0;
        }
        double rmv = 25.0;
        double d = 30.0;
        double dFedCo = 3.317E-5 * Math.pow(OccEnvData.ppm(coVolFrac), 1.036) * 25.0 / 30.0;
        double multFactorCO2 = Math.exp(0.1903 * OccEnvData.pct(co2VolFrac) + 2.0004) / 7.1;
        double addFactorO2 = 0.0;
        if (o2VolFrac < o2HypoxiaLimit) {
            addFactorO2 = 1.0 / Math.exp(8.13 - 0.54 * (20.9 - OccEnvData.pct(o2VolFrac)));
        }
        return (dFedCo * multFactorCO2 + addFactorO2) * OccEnvData.minutes(dt);
    }

    private static double ppm(double volFrac) {
        return volFrac * 1000000.0;
    }

    private static double pct(double x) {
        return x * 100.0;
    }

    private static double minutes(double x) {
        return x / 60.0;
    }

    public Map<String, QInfo> getSupportedQuantities() {
        return this.d_fdsNameToQuantity;
    }

    public Map<QInfo, Double> getValues(Occupant occ) {
        return this.d_values.get(occ);
    }

    public static class QInfo
    implements Serializable {
        private static final long serialVersionUID = 7597824456220467788L;
        public final int index;
        public final String fdsName;
        public final String outputLabel;
        public final String unit;

        public QInfo(int index, String fdsName, String outputLabel, String unit) {
            this.index = index;
            this.fdsName = fdsName;
            this.outputLabel = outputLabel;
            this.unit = unit;
        }
    }
}

