/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.TriPoint;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccProfileSim;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class OccAdder {
    private final List<Occupant> d_occs = new ArrayList<Occupant>();
    private final Mesh d_mesh;

    public OccAdder(Mesh mesh) {
        this.d_mesh = mesh;
    }

    public Occupant add(String name, long seed, long orientSeed, OccProfileSim profile, BehaviorSim behavior, Point3d loc, KB kb) {
        TriPoint meshLoc = this.projectToMeshConsistent(loc);
        if (meshLoc == null || meshLoc.tri == null) {
            System.err.println(String.format("Invalid occupant, \"%s\", being added to simulation at location %s.", name, loc.toString()));
            return null;
        }
        int id = kb.getNextOccId() + this.d_occs.size();
        Occupant occ = new Occupant(id, name, seed, orientSeed, profile, behavior, meshLoc.tri, meshLoc.p, kb.getCurrentSimTime());
        this.d_occs.add(occ);
        return occ;
    }

    private TriPoint projectToMeshConsistent(Point3d loc) {
        TriPoint meshLoc = this.d_mesh.projectToMesh(loc);
        if (meshLoc == null || meshLoc.tri == null) {
            return null;
        }
        if (meshLoc.p.equals(loc)) {
            return meshLoc;
        }
        return this.d_mesh.projectToMesh(meshLoc.p);
    }

    public void finish(KB kb) {
        for (Occupant occ : this.d_occs) {
            kb.addOcc(occ);
            kb.getOccEnvData().addOccupant(occ, kb.getCurrentSimTime());
        }
    }
}

