/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.DoorDir;
import inferno.data2.OccAnim;
import inferno.data2.Occupant;
import inferno.data2.SpeedModifier;
import inferno.elevator.ITimeEstimate;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.ai.IAiCore;
import inferno.sim.output.TsvOutput;
import inferno.sim.steering.Steer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public interface EngineOp
extends Serializable {
    public void run(Engine var1);

    public static class DumpAgentsTsv
    implements EngineOp {
        private static final long serialVersionUID = 1L;

        private String q(String str) {
            return "\"" + str + "\"";
        }

        @Override
        public void run(Engine e) {
            ArrayList<Pair<String, Function<Occupant, Object>>> cols = new ArrayList<Pair<String, Function<Occupant, Object>>>();
            cols.add(new Pair<String, Function<Occupant, Object>>("simid", occ -> this.q(engine.getKB().getParams().input)));
            cols.add(new Pair<String, Function<Occupant, Object>>("id", occ -> String.format("%d", occ.id)));
            cols.add(new Pair<String, Function<Occupant, Object>>("name", occ -> this.q(occ.name)));
            cols.add(new Pair<String, Function<Occupant, Object>>("profile", occ -> this.q(occ.parentProfile.getName())));
            cols.add(new Pair<String, Function<Occupant, Object>>("behavior", occ -> this.q(occ.behavior.name)));
            cols.add(new Pair<String, Function<Occupant, Object>>("maxVel", occ -> String.format("%.2f", Float.valueOf(occ.maxVel))));
            cols.add(new Pair<String, Function<Occupant, Object>>("occupantRadius", occ -> String.format("%.2f", occ.bodyShape.getOccRadius())));
            cols.add(new Pair<String, Function<Occupant, Object>>("geometryRadius", occ -> String.format("%.2f", occ.bodyShape.getGeomRadius())));
            cols.add(new Pair<String, Function<Occupant, Object>>("height", occ -> String.format("%.2f", occ.bodyShape.getHeight())));
            cols.add(new Pair<String, Function<Occupant, Object>>("room", occ -> this.q(occ.curNode.annotatedName)));
            cols.add(new Pair<String, Function<Occupant, Object>>("x", occ -> String.format("%.2f", occ.loc.x)));
            cols.add(new Pair<String, Function<Occupant, Object>>("y", occ -> String.format("%.2f", occ.loc.y)));
            cols.add(new Pair<String, Function<Occupant, Object>>("z", occ -> String.format("%.2f", occ.loc.z)));
            TsvOutput tsv = new TsvOutput();
            tsv.addRow((String[])cols.stream().map(pair -> (String)pair.v1).toArray(String[]::new));
            for (Occupant occ2 : e.getKB().getOccs()) {
                tsv.addRow((String[])cols.stream().map(pair -> ((Function)pair.v2).apply(occ2)).toArray(String[]::new));
            }
            String dest = System.getProperty("ex_print_occupant_params");
            if ("".equals(dest)) {
                System.out.println("ex_print_occupant_params enabled, printing to console");
                System.out.println(tsv.toString());
            } else {
                File f = new File(e.getKB().getParams().dir, dest);
                System.out.println("ex_print_occupant_params enabled, printing to " + this.q(f.getPath()));
                try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    String data = tsv.toString();
                    data = data.trim();
                    if (f.length() == 0L) {
                        pw.println(data);
                    } else {
                        String[] lines = data.split("\n");
                        for (int i = 1; i < lines.length; ++i) {
                            pw.println(lines[i]);
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static class Leave
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final OccAgent occ;
        public final ANode door;

        public Leave(OccAgent occ, ANode door) {
            this.occ = occ;
            this.door = door;
        }

        @Override
        public void run(Engine e) {
            this.occ.setUpdator(new LeaveViaDoorUpdator(this.door));
        }
    }

    public static class LeaveViaDoorUpdator
    implements OccAgent.IUpdator,
    Serializable {
        static final long serialVersionUID = 1L;
        private final ANode d_door;

        public LeaveViaDoorUpdator(ANode door) {
            this.d_door = door;
        }

        @Override
        public OccAgent.UpdatePacket calcUpdate(KB kb, Param p, double dt, OccAgent agent, Steer steer, SeekCurve seekCurve) {
            OccAgent.UpdatePacket packet = new OccAgent.UpdatePacket(agent.getOcc());
            packet.isCollidable = steer.collidable;
            packet.anim = OccAnim.STANDIDLE;
            packet.steer = steer;
            packet.seek = seekCurve;
            DoorQueue queue = this.d_door.doorQueue;
            DoorDir dir = queue.getDir(null);
            packet.crossedDoors.add(new Pair<ANode, DoorDir>(this.d_door, dir));
            return packet;
        }
    }

    public static class PauseEngine
    implements EngineOp {
        private static final long serialVersionUID = 1L;

        @Override
        public void run(Engine e) {
            if (!e.isPaused()) {
                e.pause();
            }
        }
    }

    public static class SetForceIdle
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final boolean d_flag;

        public SetForceIdle(boolean flag) {
            this.d_flag = flag;
        }

        @Override
        public void run(Engine e) {
            e.getKB().setForceIdle(this.d_flag);
        }
    }

    public static class SetSpeedModifier
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final ANode node;
        public final SpeedModifier modifier;

        public SetSpeedModifier(ANode node, SpeedModifier modifier) {
            this.node = node;
            this.modifier = modifier;
        }

        @Override
        public void run(Engine e) {
            boolean modified = !this.node.getSpeedModifier().equals(this.modifier);
            this.node.setSpeedModifier(e.getKB(), this.modifier, true);
            if (modified) {
                e.getKB().markMeshDirty();
            }
        }
    }

    public static class SetDoorState
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final ANode door;
        public final ITimeEstimate est;
        public final Vector2d onewayVec;
        public final DoorDir onewayDir;
        public final boolean openOrClose;
        public final boolean setDirection;

        public static SetDoorState openDoor(ANode door) {
            return new SetDoorState(door, null, null, true, false);
        }

        public static SetDoorState closeDoor(ANode door, ITimeEstimate est) {
            return new SetDoorState(door, est, null, true, false);
        }

        public static SetDoorState openAndSetDirection(ANode door, Vector2d onewayVec) {
            return new SetDoorState(door, null, onewayVec, false, true);
        }

        private SetDoorState(ANode door, ITimeEstimate est, Vector2d onewayVec, boolean openOrClose, boolean setDirection) {
            this.door = door;
            this.est = est;
            this.onewayVec = onewayVec;
            this.onewayDir = onewayVec != null ? DoorDir.get(door, new Vector3d(onewayVec.x, onewayVec.y, 0.0)) : null;
            this.openOrClose = openOrClose;
            this.setDirection = setDirection;
            assert (openOrClose ^ setDirection);
        }

        @Override
        public void run(Engine e) {
            if (this.openOrClose) {
                this.door.setClosed(this.est);
                if (this.est == null) {
                    this.door.setDoorDir(null);
                }
            }
            if (this.setDirection) {
                DoorDir dir = this.onewayDir != null && !this.door.isExitDoor() ? this.onewayDir : null;
                this.door.setDoorDir(dir);
                if (dir != null) {
                    this.door.setClosed(null);
                }
            }
            e.getKB().markMeshDirty();
        }
    }

    public static class SetAttractorInfluence
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final AttractorSim attr;
        public final double influence;

        public SetAttractorInfluence(AttractorSim attr, double influence) {
            this.attr = attr;
            this.influence = influence;
        }

        @Override
        public void run(Engine e) {
            this.attr.setInfluence(this.influence);
        }
    }

    public static class SetAi
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        private final List<OccAgent> d_agents;
        private final Function<OccAgent, ? extends IAiCore> d_getAiCore;

        public SetAi(Function<OccAgent, ? extends IAiCore> newAiCore, List<OccAgent> agents) {
            this.d_agents = agents;
            this.d_getAiCore = newAiCore;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            for (OccAgent agent : this.d_agents) {
                try {
                    IAiCore thoughts = this.d_getAiCore.apply(agent);
                    thoughts.init(kb, agent);
                    agent.setAiCore(thoughts);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static class RemoveRelation
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        OccAgent d_agent;
        IRelation d_relation;

        public RemoveRelation(OccAgent agent, IRelation relation) {
            this.d_agent = agent;
            this.d_relation = relation;
        }

        @Override
        public void run(Engine e) {
            this.d_agent.removeRelation(this.d_relation);
        }
    }

    public static class AddRelation
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        OccAgent d_agent;
        IRelation d_relation;

        public AddRelation(OccAgent agent, IRelation relation) {
            this.d_agent = agent;
            this.d_relation = relation;
        }

        @Override
        public void run(Engine e) {
            this.d_agent.addRelation(this.d_relation);
        }
    }

    public static class AddAgent
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final Occupant occ;
        public final boolean controllable;

        public AddAgent(Occupant occ, boolean controllable) {
            this.occ = occ;
            this.controllable = controllable;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            kb.addOcc(this.occ);
            kb.createAgent(this.occ, false);
        }
    }

    public static class SetBlockageSpeedModifier
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final Blockage b;
        public final SpeedModifier smod;

        public SetBlockageSpeedModifier(Blockage b, SpeedModifier smod) {
            this.b = b;
            this.smod = smod;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            SpeedModifier oldMod = this.b.getSpeedModifier();
            if (!oldMod.equals(this.smod)) {
                this.b.setSpeedModifier(e.getKB(), kb.getMesh(), this.smod);
                if (this.b.isActive()) {
                    kb.markMeshDirty();
                }
            }
        }
    }

    public static class RemoveBlockage
    extends SetBlockageActive {
        private static final long serialVersionUID = 1L;

        public RemoveBlockage(Blockage blkgId) {
            super(blkgId, false);
        }
    }

    public static class AddBlockage
    extends SetBlockageActive {
        private static final long serialVersionUID = 1L;

        public AddBlockage(Blockage blkgId) {
            super(blkgId, true);
        }
    }

    public static class SetBlockageActive
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final Blockage b;
        public final boolean active;

        public SetBlockageActive(Blockage blkgId, boolean active) {
            this.b = blkgId;
            this.active = active;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            this.b.setActive(kb, kb.getMesh(), this.active);
            kb.markMeshDirty();
        }
    }

    public static class MultiOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final List<EngineOp> ops;

        public MultiOp(EngineOp ... ops) {
            this.ops = new ArrayList<EngineOp>(Arrays.asList(ops));
        }

        @Override
        public void run(Engine e) {
            for (int m = 0; m < this.ops.size(); ++m) {
                this.ops.get(m).run(e);
            }
        }
    }
}

