/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class CompositeCollections<T>
extends AbstractCollection<T> {
    private final Collection<? extends T>[] d_collections;
    private transient int d_cachedSize;

    public CompositeCollections(Collection<? extends T> ... collections) {
        this.d_collections = collections;
        this.d_cachedSize = -1;
    }

    public static <T> Collection<? extends T> group(Collection<? extends T> ... collections) {
        if (collections.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (collections.length == 1) {
            return collections[0];
        }
        return new CompositeCollections<T>(collections);
    }

    @Override
    public void clear() {
        for (Collection<T> collection : this.d_collections) {
            collection.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> collection : this.d_collections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> collection : this.d_collections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Collection<T> collection : this.d_collections) {
            modified |= collection.removeAll(c);
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        boolean modified = false;
        for (Collection<T> collection : this.d_collections) {
            modified |= collection.remove(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (Collection<T> collection : this.d_collections) {
            modified |= collection.retainAll(c);
        }
        return modified;
    }

    @Override
    public Iterator<T> iterator() {
        return new CompositeIterator<T>(this.d_collections);
    }

    @Override
    public int size() {
        if (this.d_cachedSize == -1) {
            this.d_cachedSize = 0;
            for (Collection<T> collection : this.d_collections) {
                this.d_cachedSize += collection.size();
            }
        }
        return this.d_cachedSize;
    }

    private static class CompositeIterator<T>
    implements Iterator<T> {
        private final Collection<? extends T>[] d_collections;
        private int d_currColl;
        private Iterator<? extends T> d_currIt;

        public CompositeIterator(Collection<? extends T> ... collections) {
            this.d_collections = collections;
            this.d_currColl = -1;
            this.d_currIt = null;
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.d_currIt != null && this.d_currIt.hasNext();
        }

        @Override
        public T next() {
            this.init();
            T result = null;
            if (this.d_currIt != null) {
                result = this.d_currIt.next();
                this.inc();
            }
            return result;
        }

        @Override
        public void remove() {
            this.init();
            if (this.d_currIt != null) {
                this.d_currIt.remove();
                this.inc();
            }
        }

        protected void inc() {
            while (this.d_currIt != null && !this.d_currIt.hasNext()) {
                ++this.d_currColl;
                if (this.d_currColl < this.d_collections.length) {
                    this.d_currIt = this.d_collections[this.d_currColl].iterator();
                    continue;
                }
                this.d_currIt = null;
            }
        }

        protected void init() {
            if (this.d_currColl == -1) {
                this.d_currColl = 0;
                while (this.d_currColl < this.d_collections.length) {
                    this.d_currIt = this.d_collections[this.d_currColl].iterator();
                    if (this.d_currIt.hasNext()) {
                        return;
                    }
                    ++this.d_currColl;
                }
                this.d_currIt = null;
            }
        }
    }
}

