/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataInquisitor;
import inferno.io.fdsout.VtkLibLoader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;

public class KbLink
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataInquisitor d_inquisitor;
    private List<SensorInfo> d_sensors;
    private List<DataFinder.Quantity> d_quantities;

    public KbLink(DataInquisitor inquisitor) {
        this.d_inquisitor = inquisitor;
        this.d_sensors = new ArrayList<SensorInfo>();
        this.d_quantities = null;
        VtkLibLoader.loadReq();
    }

    public void addSensor(SensorInfo sensor) {
        this.d_sensors.add(sensor);
    }

    public List<SensorInfo> getSensors() {
        return Collections.unmodifiableList(this.d_sensors);
    }

    public int getQuanityIndex(DataFinder.Quantity quantity) {
        if (this.d_quantities == null) {
            this.d_quantities = Arrays.asList(this.d_inquisitor.getQuantities());
        }
        return this.d_quantities.indexOf(quantity);
    }

    public double[][] query(double t, List<Point3d> points) {
        if (points.isEmpty()) {
            return new double[0][0];
        }
        try {
            this.d_inquisitor.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.d_inquisitor.probeInterp((float)t, points);
    }

    public double getEndTime() {
        return this.d_inquisitor.getTimeRange()[1];
    }

    public String toString() {
        return String.format("KbLink[d_inquisitor=%s,d_sensors=%s]", this.d_inquisitor, Arrays.asList(this.d_sensors));
    }

    public static class SensorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final DataFinder.Quantity quantity;
        public final String label;

        public SensorInfo(DataFinder.Quantity quantity, String label) {
            this.quantity = quantity;
            this.label = label;
        }

        public String toString() {
            return String.format("SensorInfo[quantity=%s,label=%s]", this.quantity, this.label);
        }
    }
}

