/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.ElevatorLevel;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

class PrioritySorter
implements Comparator<ElevatorLevel>,
Serializable {
    private static final long serialVersionUID = 8286020726476684997L;
    List<Integer> d_priorityFloors;

    public PrioritySorter(List<Integer> priorityFloors) {
        this.d_priorityFloors = priorityFloors;
    }

    @Override
    public int compare(ElevatorLevel elevLvl1, ElevatorLevel elevLvl2) {
        int priorityIndex1 = this.d_priorityFloors.indexOf(elevLvl1.levelId);
        int priorityIndex2 = this.d_priorityFloors.indexOf(elevLvl2.levelId);
        if (priorityIndex1 != -1 && priorityIndex2 != -1) {
            return priorityIndex1 - priorityIndex2;
        }
        if (priorityIndex1 != -1 && priorityIndex2 == -1) {
            return -1;
        }
        if (priorityIndex1 == -1 && priorityIndex2 != -1) {
            return 1;
        }
        double z1 = elevLvl1.pickupNode.getGeometryBounds().getMinZ();
        double z2 = elevLvl2.pickupNode.getGeometryBounds().getMinZ();
        return -Double.compare(z1, z2);
    }
}

