/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.data2.ANode;
import inferno.data2.ai.IGoal;
import inferno.elevator.ElevatorGoal;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorModel;
import inferno.elevator.EvacElevator;
import inferno.elevator.IElevator;
import inferno.parse2.SimpleParser;
import inferno.sim.Param;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONObject;

public class ElevatorParserTxt {
    public static void parse(Param p, ElevatorModel elevModel, List<ANode> nodes, List<String> elevatorLines, List<String> elevatorDischargeLines, List<String> elevatorLevelDataLines, List<String> elevatorPriorityLines, List<String> elevatorLinkLines) throws IOException {
        for (int i = 0; i < elevatorDischargeLines.size(); ++i) {
            String elevatorLine = !elevatorLines.isEmpty() ? elevatorLines.get(i) : null;
            ElevatorParserTxt.parseElevatorDischarge(p, elevModel, nodes, elevatorDischargeLines.get(i), elevatorLine);
        }
        for (String line : elevatorLevelDataLines) {
            ElevatorParserTxt.parseElevatorLevelData(elevModel, nodes, line);
        }
        for (String line : elevatorPriorityLines) {
            ElevatorParserTxt.parseElevatorPriority(elevModel, line);
        }
        for (String line : elevatorLinkLines) {
            ElevatorParserTxt.parseElevatorLink(elevModel, line);
        }
        for (IElevator elevator : elevModel.getElevators()) {
            elevator.endInit();
        }
    }

    public static void parseElevatorDischarge(Param params, ElevatorModel elevModel, List<ANode> nodes, String line, String elevatorLine) throws IOException {
        String[] tokens = SimpleParser.getTokens(line, true);
        int dischargeNodeId = Integer.parseInt(tokens[0]);
        ANode dischargeNode = nodes.get(dischargeNodeId);
        double openTime = Double.parseDouble(tokens[1]);
        double closeDelay = Double.parseDouble(tokens[2]);
        double szFactor = Double.parseDouble(tokens[3]);
        double maxDensity = Double.parseDouble(tokens[4]);
        String name = "";
        boolean isDoubleDeck = false;
        double callDistance = params.elevator_call_distance;
        ANode initNode = dischargeNode;
        if (elevatorLine != null) {
            try {
                JSONObject json = SimpleParser.getJsonLine(elevatorLine, false);
                name = (String)json.get("name");
                isDoubleDeck = (Boolean)json.get("double_deck");
                callDistance = (Double)json.get("call_distance");
                int initNodeId = (int)((Long)json.get("initial_floor")).longValue();
                initNode = nodes.get(initNodeId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        EvacElevator elev = new EvacElevator(name, dischargeNode, openTime, closeDelay, szFactor, maxDensity, initNode, callDistance, isDoubleDeck);
        elevModel.addElevator(elev);
    }

    public static void parseElevatorLevelData(ElevatorModel elevModel, List<ANode> nodes, String line) throws IOException {
        double closeTime;
        double openTime;
        String[] tokens = SimpleParser.getTokens(line, false);
        int elevatorId = Integer.parseInt(tokens[0]);
        int pickupNodeId = Integer.parseInt(tokens[1]);
        ANode pickupNode = nodes.get(pickupNodeId);
        int levelId = Integer.parseInt(tokens[2]);
        int tokix = 3;
        if (tokens.length >= 7) {
            openTime = Double.parseDouble(tokens[tokix++]);
            closeTime = Double.parseDouble(tokens[tokix++]);
        } else {
            closeTime = 0.0;
            openTime = 0.0;
        }
        double pickupTime = Double.parseDouble(tokens[tokix++]);
        double dischargeTime = Double.parseDouble(tokens[tokix++]);
        double tFirstAvailable = Double.parseDouble(tokens[tokix++]);
        boolean isEnabled = tFirstAvailable != Double.POSITIVE_INFINITY;
        IElevator elev = elevModel.getElevator(elevatorId);
        ElevatorLevel elevLvl = new ElevatorLevel(levelId, pickupNode, openTime, closeTime, pickupTime, dischargeTime, tFirstAvailable, isEnabled);
        elev.addLevel(elevLvl);
    }

    public static void parseElevatorLink(ElevatorModel elevModel, String line) throws IOException {
        String[] tokens = SimpleParser.getTokens(line, false);
        ArrayDeque<IElevator> linkedElevs = new ArrayDeque<IElevator>();
        for (String elevIdStr : tokens) {
            int elevId = Integer.parseInt(elevIdStr);
            IElevator elev = elevModel.getElevator(elevId);
            linkedElevs.add(elev);
        }
        elevModel.linkElevators(linkedElevs);
    }

    public static void parseElevatorPriority(ElevatorModel elevModel, String line) {
        String[] tokens = SimpleParser.getTokens(line, false);
        int elevId = Integer.parseInt(tokens[0]);
        ArrayList<Integer> priorityFloorIds = new ArrayList<Integer>();
        for (int i = 1; i < tokens.length; ++i) {
            String tok = tokens[i];
            priorityFloorIds.add(Integer.parseInt(tok));
        }
        IElevator elev = elevModel.getElevator(elevId);
        elev.setTopPriorityFloors(priorityFloorIds);
    }

    public static IGoal parseElevatorGoal(ElevatorModel elevModel, List<String> tokensOnLine) {
        assert (tokensOnLine.size() > 2);
        assert ("GOTO".equalsIgnoreCase(tokensOnLine.get(0)));
        assert ("ELEVATOR".equalsIgnoreCase(tokensOnLine.get(1)));
        List<String> args = tokensOnLine.subList(2, tokensOnLine.size());
        if ("ANY".equalsIgnoreCase(args.get(0))) {
            return new ElevatorGoal(true, elevModel.getElevators());
        }
        ArrayList<IElevator> goalElevs = new ArrayList<IElevator>();
        for (String elevatorIxStr : args) {
            int elevatorIx = Integer.parseInt(elevatorIxStr);
            assert (0 <= elevatorIx && elevatorIx < elevModel.getNumElevators());
            goalElevs.add(elevModel.getElevator(elevatorIx));
        }
        boolean all = elevModel.getNumElevators() == goalElevs.size();
        return new ElevatorGoal(all, Collections.unmodifiableList(goalElevs));
    }
}

